
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: pdcurses.adb "pdcurses.adb"
--        Date: 5/25/95
-- Description: Package body for the Ada-curses binding.
--    Revision: This is part of total rewrite of the original
--              binding.  This new version should be more
--              portable and maintainable.
------------------------------------------------------------

with c;
package body pdcurses is
--
-- Some of the pseudofunctions (preprocessor macros) behave as 
-- though they have out-mode parameters, which is normally faked
-- in C by using pointers as arguments. These subprograms handle
-- the details of binding the C wrapper functions with pointer 
-- arguments to Ada function calls with out-parameters.
--
   procedure AB_getbegyx (
      w : in     A_WINDOW_T;
      y : access c.signed_int;
      x : access c.signed_int );

   procedure AB_getmaxyx (
      w : in     A_WINDOW_T;
      y : access c.signed_int;
      x : access c.signed_int );

   procedure AB_getparyx (
      w : in     A_WINDOW_T;
      y : access c.signed_int;
      x : access c.signed_int );

   procedure AB_getyx (
      w : in     A_WINDOW_T;
      y : access c.signed_int;
      x : access c.signed_int );

   pragma import (C, AB_getbegyx, "CB_getbegyx");
   pragma import (C, AB_getmaxyx, "CB_getmaxyx");
   pragma import (C, AB_getparyx, "CB_getparyx");
   pragma import (C, AB_getyx, "CB_getyx");

--
-- #define getbegyx(w,y,x)  ( y = (w)->_begy, x = (w)->_begx )
--
   procedure getbegyx (
      w : in     A_WINDOW_T;
      y :    out c.signed_int;
      x :    out c.signed_int )
   is
      x_parm : aliased c.signed_int;
      y_parm : aliased c.signed_int;
   begin
      AB_getbegyx(w, y_parm'access, x_parm'access);
      y := y_parm;
      x := x_parm;
   end getbegyx;

--
-- #define getmaxyx(w,y,x)  ( y = (w)->_maxy, x = (w)->_maxx )
--
   procedure getmaxyx (
      w : in     A_WINDOW_T;
      y :    out c.signed_int;
      x :    out c.signed_int )
   is
      x_parm : aliased c.signed_int;
      y_parm : aliased c.signed_int;
   begin
      AB_getmaxyx(w, y_parm'access, x_parm'access);
      y := y_parm;
      x := x_parm;
   end getmaxyx;

--
-- #define getparyx(w,y,x)  ( y = (w)->_pary, x = (w)->_parx )
--
   procedure getparyx (
      w : in     A_WINDOW_T;
      y :    out c.signed_int;
      x :    out c.signed_int )
   is
      x_parm : aliased c.signed_int;
      y_parm : aliased c.signed_int;
   begin
      AB_getparyx(w, y_parm'access, x_parm'access);
      y := y_parm;
      x := x_parm;
   end getparyx;

--
-- #define getyx(w,y,x)  ( y = (w)->_cury, x = (w)->_curx )
--
   procedure getyx (
      w : in     A_WINDOW_T;
      y :    out c.signed_int;
      x :    out c.signed_int )
   is
      x_parm : aliased c.signed_int;
      y_parm : aliased c.signed_int;
   begin
      AB_getyx(w, y_parm'access, x_parm'access);
      y := y_parm;
      x := x_parm;
   end getyx;

end pdcurses;
