-----------------------------------------------------------------------
--
--  File:        mandelbr.adb
--  Description: An aproximation of the mandelbrot set
--  Rev:         0.7
--  Date:        01-feb-98
--  Author:      Jerry van Dijk
--  Mail:        jdijk@acm.org
--
--  Copyright (c) Jerry van Dijk, 1996, 1997, 1998
--  Billie Holidaystraat 28
--  2324 LK Leiden
--  THE NETHERLANDS
--  tel int + 31 71 531 4365
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------

with Ada.Text_Io;                use Ada.Text_Io;
with Ada.Characters.Latin_1;
with Ada.Numerics.Complex_Types; use Ada.Numerics.Complex_Types;

with PC_Keyboard;  use PC_Keyboard;
with VGA_Graphics; use VGA_Graphics;

procedure Mandelbrot is

   procedure Wait_For_Enter is
   begin
      Write_String(200, 464, White, "Press <Enter> to return to DOS");
      while Get_Char /= Ada.Characters.Latin_1.CR loop
         null;
      end loop;
   end Wait_For_Enter;

   procedure Display(X1, X2, Y1, Y2: in Float) is
      X, Y      : Float;
      C, Z      : Complex;
      Num_Iters : constant := 128;
      Treshold  : constant Float := 2.21;
      Iters     : Natural range 0..Num_Iters;
      Y_Step    : constant Float := (abs(Y1)+abs(Y2)) / Float(Vertical_Size);
      X_Step    : constant Float := (abs(X1)+abs(X2)) / Float(Horizontal_Size);
   begin
      Y := Y1;
      for Y_Pos in Vertical_Location'RANGE loop
         X := X1;
         for X_Pos in Horizontal_Location'RANGE loop
            Z := (X, Y); C:= Z;
            for I in 0..Num_Iters loop
               Iters := I;
               exit when (Z.Re > Treshold) or (Z.Im > Treshold) or
                         (Z.Re < -Treshold) or (Z.Im < -Treshold);
               Z := Z * Z + C;
            end loop;
            Put_Pixel(X_Pos, Y_Pos, Screen_Color'VAL(Iters mod Num_Colors));
            X := X + X_Step;
         end loop;
         Y := Y + Y_Step;
      end loop;
   end Display;

begin
   VGA_Mode;
   Display(-2.2, 1.2, -1.6, 1.6);
   Wait_For_Enter;
   TXT_Mode;
exception
   when No_VGA_Error =>
      Put_Line(Standard_Error, "Couldn't switch to VGA mode");
end Mandelbrot;
