/*
PROJECT OUTLINE
Skipper is a skip searcher designed to find words hidden in text.
The phrase entered is searched for by picking characters at regular intervals
(the skip) from the text.  Skipper systematically scans from a skip of 1 to
a skip of default 10.  The maximum skip can be adjusted.  There is a theoretical
maximum skip that this program can handle (around 20 for the average phrase).
The larger the maximum skip the slower scanning is and the larger the phrase the
slower scanning is.  Skipper is based on a skip searcher shown on a recent
series of the UK TV documentary 'HORIZON' (TM BBC).  A book is available in
the US and Europe describing 'The Bible Code' which has made skip searching
popular.  It has been pointed out however that there is a one in two chance
of finding something historically significant in any book by the work of
Statisticians in London, and the Bible code has been effectively disproved by
this.  Anyway have fun!
This program is (C) and distribd under the GPL. Open Source etc.
This version compiled with lcc - the best free win32 compiler around!
Modify but please quote me! j_wedlake@hotmail.com .
Skipper can scan 8,000 (skip 1-10) characters in under 15 seconds on a 32bit 1Ghz.*/
/* --- Portions of the following code comes from c:\program files\lcc\lib\wizard\textmode.tpl. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include <windowsx.h>
#include <winuser.h>
#include <ctype.h>


HWND hWnd;
char maxskip[2];
int maxskipi;
char msgstr[66];
char phrase[20];
char filetext[256];
char tempstr[256];
char next;
int clo;
int currentskipdistance;
int currentpos;
int readerpos;
int phrasepos;
int firstletter;
int phraselength;
int readerlen;
int spaces;
int reloadbuffer;
int tempindex;
int scanover;
int blanktimeout;
int totalscan;
int totalfinds;
int filesize;
FILE *file_ptr;

void loadfile();
void scancurrentblock();
void calculatereload();

void Usage(char *programName)
{
	fprintf(stderr,"%s usage:\n",programName);
	/* Modify here to add your usage message when the program is
	 * called without arguments */
}

/* returns the index of the first argument that is not an option; i.e.
   does not start with a dash or a slash
*/
int HandleOptions(int argc,char *argv[])
{
	int i,firstnonoption=0;

	for (i=1; i< argc;i++) {
		if (argv[i][0] == '/' || argv[i][0] == '-') {
			switch (argv[i][1]) {
				/* An argument -? means help is requested */
				case '?':
					Usage(argv[0]);
					break;
				case 'h':
				case 'H':
					if (!stricmp(argv[i]+1,"help")) {
						Usage(argv[0]);
						break;
					}
					/* If the option -h means anything else
					 * in your application add code here
					 * Note: this falls through to the default
					 * to print an "unknow option" message
					*/
					MessageBox (hWnd, "Switches :\n\tskipper\n\t\ts[n] sets maximum skip\n\t\tp recognises spaces in processing", "SkipperHelp", MB_OK);
				/* add your option switches here */
				case 's' :
					maxskip[0]=argv[i][2];
					maxskip[1]=argv[i][3];
					clo=1;
					break;
				case 'p' :
					spaces=1;
					break;
				default:
					fprintf(stderr,"unknown option %s\n",argv[i]);
					break;
			}
		}
		else {
			firstnonoption = i;
			break;
		}
	}
	return firstnonoption;
}

int main(int argc,char *argv[])
{
	/* handle the program options */
	HandleOptions(argc,argv);
	/* The code of your application goes here */
	MessageBox (hWnd, "Welcome to Skipper coded by Josh Wedlake\nInspired by Horizon", "LaxStudios and Illuminate present...", MB_OK);
	if (clo==0) {
		strcpy(msgstr,"Assuming data.txt as input file...\nAssuming maximum skip as 10...");
		printf("LOG:maxskip accepted at 10\n");
		maxskipi=10;
		MessageBox (hWnd, msgstr, "Skipper", MB_OK);}
	if (clo==1) {
		strcpy(msgstr,"Assuming data.txt as input file...\nAssuming maximum skip as ");
		msgstr[60]=maxskip[0];
		msgstr[61]=maxskip[1];
		msgstr[62]='.';
		msgstr[63]='.';
		msgstr[64]='.';
		maxskipi=atoi(maxskip);
		printf ("LOG:String converted to %d\n",maxskipi);
		MessageBox (hWnd, msgstr, "Skipper", MB_OK);
	}
	file_ptr=fopen("data.txt","r");
	printf("LOG:data.txt opened for read\n");
	if(file_ptr!=NULL)
		{
			printf("LOG:file open success!\n");
			printf("MESSAGE:enter a phrase to scan: ");
			scanf("%s",&phrase);
			while(1)
				{
				loadfile();
				printf("LOG: parse successful!\n");
				calculatereload();
				printf("LOG: calculation successful!\n");
				scancurrentblock();
				totalscan=totalscan+reloadbuffer;
				printf("LOG: total progress: %d\n",totalscan);
				if(scanover==1)break;
				}
			fclose(file_ptr);
			printf("\n\n\n\tSUMMARY: total [approx] characters scanned: %d\n\tTotal finds: %d\n\tFor phrase %s\n\n",totalscan,totalfinds,phrase);
		}
		else {MessageBox (hWnd, "ERROR: failed to open data.txt!", "Skipper", MB_OK); printf("LOG:Failed!\n");}
	return 0;
}

void loadfile()
{
//load a section of the file
		while(1)
			{
				next=fgetc(file_ptr);
				if(next == '\n')next=fgetc(file_ptr);
				if(spaces==0 && isspace(next)!=0)next=fgetc(file_ptr);
				if(next !=EOF || currentpos<250)filetext[currentpos]=next;
				else break;
				if (currentpos==251)break;
				currentpos=currentpos+1;
			}
		if(next==EOF)
			{
				scanover=1;
				printf("LOG: Scanover:1\n");
			}
}

void scancurrentblock()
{
	phraselength=strlen(phrase);
	readerlen=strlen(filetext);
	printf("LOG:length of phrase %d\n",phraselength);
	readerpos=0;
	firstletter=-1;
	readerpos=0;
	currentskipdistance=0;
	while(1)
		{
			currentskipdistance=0;
			firstletter=firstletter+1;
			while(1)
				{
					phrasepos=0;
					readerpos=firstletter;
					currentskipdistance=currentskipdistance+1;
					while(1)
						{
							printf("Testing at %d, skip %d, char %d\r",firstletter,currentskipdistance,readerpos);
							if(spaces==0 && filetext[readerpos]=='\0')
								{
									readerpos=readerpos+1;
									blanktimeout=blanktimeout+1;
								}
							else
								{
									blanktimeout=0;
								}
							if (phrase[phrasepos]==filetext[readerpos])
								{
									//printf("LOG phrase : %c,%d reader : %c,%d\n",phrase[phrasepos],phrasepos,filetext[readerpos],readerpos);
									phrasepos=phrasepos+1;
									readerpos=readerpos+currentskipdistance;
								}
							else break;
							if (phrasepos==phraselength)
								{
									printf("\nLOG: occurence found at character %d , skip %d !\n",(totalscan+firstletter), currentskipdistance);
									MessageBox (hWnd, "Occurence found!\nView LOG for details.", "Skipper", MB_OK);
									totalfinds=totalfinds+1;
									break;
								}
							if (currentskipdistance>maxskipi || blanktimeout>100 || firstletter>256)
								{
									break;
								}
						}
					if (currentskipdistance==maxskipi || currentskipdistance>maxskipi || blanktimeout > 100 || firstletter>256)
						{
					break;
						}
				}
			if (firstletter>reloadbuffer && scanover!=1)
				{
					//code for adjusting buffers
					printf("\nLOG: Reload buffer at: %d\n",firstletter);
					tempindex=0;
					while(1)
						{
							tempstr[tempindex]=filetext[firstletter];
							tempindex=tempindex+1;
							firstletter=firstletter+1;
							if (firstletter==257)break;
						}
					printf("LOG: remaining buffer transfered [to: %d].\n",firstletter);
					printf("LOG: chars to transfer: %d.\n",tempindex);
					//clear filetext
					currentpos=0;
					while(1)
						{
							filetext[currentpos]='\0';
							currentpos=currentpos+1;
							if(currentpos==257)break;
						}
					//copy back to start of filetext
					currentpos=0;
					while(1)
						{
							filetext[currentpos]=tempstr[currentpos];
							if(currentpos==tempindex)break;
							currentpos=currentpos+1;
						}
					printf("LOG: chars transfered - ready to reload.\n");
					printf("LOG: Reset skip\n");
					currentskipdistance=0;
					break;
				}
			else if(firstletter>256)
				{
					break;
				}
		}
}

void calculatereload()
{
	phraselength=strlen(phrase);
	readerlen=strlen(filetext);
	reloadbuffer=(256-(phraselength*maxskipi))-10;
}
