#include <conio.h>

#include "portio.h"
#include "com.h"

extern void far
setcomm (int port, long baud, int parity, int bits, int stop, int xmode)
{
	register int c;
	short	flags;
	register CCB	near *ccp;

	if (port < 1 || port > 4)
		return;

	flags = comcli ();

	c = baud ? (int)(115200L/baud) : 96 /* 1200 baud */;

	outp (LCR, 0x80);
	outp (DLMSB, c >> 8);
	outp (DLLSB, c & 0xff);

	if ((parity &= 0x5f) == 'O')
		c = 1 << 3;
	else if (parity == 'E')
		c = 3 << 3;
	else
		c = 0;

	c |= (((stop - 1) & 1) << 2) | ((bits - 5) & 3);
	outp (LCR, c & 0x1f);

	ccp = &ccb[port-1];

	ccp->baud   = baud;
	ccp->parity = parity;
	ccp->bits   = bits;
	ccp->stop   = stop;
	ccp->xmode  = xmode;
	comsti (flags);
}

