/* ---------------------- portio.h ------------------------------------------ */
/*									      */

#include <conio.h>

#define COM1BASE	0x3F8      /* COM1 ports */
#define COM2BASE	0x2F8      /* COM2 ports */
#define COM3BASE	0x338      /* COM3 ports */
#define COM4BASE	0x238      /* COM4 ports */
#define COM1IRQ 	4          /* COM1 IRQ */
#define COM2IRQ 	3          /* COM2 IRQ */
#define COM3IRQ 	2          /* COM3 IRQ */
#define COM4IRQ 	5          /* COM4 IRQ */
#define ICR		0x20       /* 8259 command port */
#define IMR		0x21       /* 8259 status & control port */

/* COMi ports & functions */

#define TX		(portbase[port] + 0)
#define RX 		(portbase[port] + 0)
#define IER		(portbase[port] + 1)
#define IIR		(portbase[port] + 2)
#define LCR		(portbase[port] + 3)
#define MCR		(portbase[port] + 4)
#define LSR		(portbase[port] + 5)
#define MSR		(portbase[port] + 6)
#define DLLSB		(portbase[port] + 0)
#define DLMSB		(portbase[port] + 1)

		/* LSR */
#define RCVRDY		1		/* RVR reg full */
#define OVRERR		2
#define PRTYERR 	4
#define FRMERR		8
#define BRKINT		0x10
#define XMTRDY		0x20		/* XTR buffer empty */
#define XMTIDLE		0x40		/* XTR reg empty */

		/* MSR */
#define CTS		0x10
#define DSR		0x20
#define RI		0x40
#define CD		0x80

		/* MCR */
#define DTR		1
#define RTS		2

		/* IER */
#define RX_INT		1
#define TX_INT		2
#define ER_INT		4
#define MC_INT		8

		/* IIR */
#define ANY_ID		1
#define RX_MASK		7
#define MD_ID		0
#define TX_ID		2
#define RX_ID		4
#define LN_ID		6

		/* 8259 functions */
#define EOI		0x20     /* end of interrupt comand */

#define	XON		17
#define	XOFF		19

/* globals and functions */

extern void far com1_int (), far com2_int (), far com3_int (), far com4_int ();
extern int	near portbase[];	/* used by service routines! */

typedef struct circbuff	CCB;
struct circbuff {
	int		flags;
#define	On		0x0001
#define	XinOff		0x0002		/* XOFF sent */
#define	XoutOff		0x0004		/* XOFF seen, block xmit */
#define	XoffPend	0x0008		/* urgent: send XOFF */
#define	XonPend		0x0010		/* urgent: send XON */
#define	AnyPend		(XoffPend|XonPend)
#define	Idle		0x0020		/* Xmtr idle */
	int		irq;		/* irq number */
	void (far *intserv)();		/* interrupt service routine */
	long		baud;
	int		parity;
	int		bits;
	int		stop;
	int		xmode;
	int		isize;
	int		osize;		/* zero for no output buffering */
	unsigned char	*idata;
	unsigned char	*ihead;		/* next pos out */
	unsigned char	*itail;		/* next pos in */
	unsigned char	*iend;
	int		icnt;
	int		himark;		/* when to send XOFF */
	int		lowmark;	/* when to send XON */
	unsigned char	*odata;
	unsigned char	*ohead;		/* next pos out */
	unsigned char	*otail;		/* next pos in */
	unsigned char	*oend;
	int		ocnt;
};
extern CCB	near ccb[4];

extern short	far comcli (void);
extern void	far comsti (short i);
extern int	far port_set (int port, int isize, int osize, int irq,
		int base);
extern int	far initccb (int port);
extern void	far termccb (int port);
extern int	far drainccb (int port);
extern void	far i_enable (int port);
extern void	far i_disable (int port);

