/* --------------------------------- util.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* General purpose utility functions.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fly.h"

extern int FAR
opt36 (int c)
{
	if (c >= '0' && c <= '9')
		return (c - '0');
	if (c >= 'a' && c <= 'z')	/* Warning: ASCII only !!! */
		return (c - 'a' + 10);
	if (c >= 'A' && c <= 'Z')
		return (c - 'A' + 10);
	return (-1);
}

/*
 * The following functions are used by the drivers to retrieve user options.
 *
 * The general format is ":[opt]:[opt]:[opt]..."
 *	un-specified options are left out. Trailing ':::' not needed.
 * an option is either "NameValue" or "Value". The first two functions
 * use the Name and return the Value (either a pointer[non-terminated] or
 * a long) while the last two (get_i*) return the Value for the i-th (first
 * is zero) option (no Name expected). NULL/-1L pointer means not present.
 *	get_arg() returns a pointer to the option Value
 *	get_narg() returns the Value as a long
 *	get_iarg() returns a pointer to the i-th option Value
 *	get_inarg() returnd the i-th option  Value as a long
*/

extern char * FAR
get_arg (char *options, char *argname)
{
	char	*p;
	int	len;

	len = strlen (argname);

	for (p = options;p ; p = strchr (p, ':')) {
		++p;
		if (!strnicmp (p, argname, len)) {
			p += len;
			break;
		}
	}
	return (p);
}

extern long FAR
get_narg (char *options, char *argname)
{
	char	*p;
	long	l;

	if (!(p = get_arg (options, argname)))
		l = -1L;
	else if (p[0] == '0')
		if (p[1] == 'x' || p[1] == 'X')
			if (1 != sscanf (p+2, "%lx", &l))
				l = -1L;
			else
				{}
		else if (1 != sscanf (p, "%lo", &l))
			l = -1L;
		else
			{}
	else if (1 != sscanf (p, "%ld", &l))
		l = -1L;
	else
		{}
	return (l);
}

extern char * FAR
get_iarg (char *options, int argno)
{
	char	*p;
	int	i;

	for (i = 0, p = options;p ; p = strchr (p, ':'), ++i) {
		++p;
		if (i == argno)
			break;
	}
	return (p);
}

extern char * FAR
get_parg (char *options, int argno)
{
	char	*p, *q;
	int	t;

	if (!(p = get_iarg (options, argno)))
		return (0);
	q = strchr (p, ':');
	if (!q)
		p = strdup (p);
	else {
		t = *q;
		*q = '\0';
		p = strdup (p);
		*q = (char)t;
	}
	return (p);
}

extern long FAR
get_inarg (char *options, int argno)
{
	char	*p;
	long	l;

	if (!(p = get_iarg (options, argno)))
		l = -1L;
	else if (p[0] == '0')
		if (p[1] == 'x' || p[1] == 'X')
			if (1 != sscanf (p+2, "%lx", &l))
				l = -1L;
			else
				{}
		else if (1 != sscanf (p, "%lo", &l))
			l = -1L;
		else
			{}
	else if (1 != sscanf (p, "%ld", &l))
		l = -1L;
	else
		{}
	return (l);
}

extern void FAR
randomize (void)
{
	srand (Tm->Hires ());
}
