/* --------------------------------- tunes.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Tunes.
 * NOTE: a tune cannot start with a command. Duration must be greater that 4!
*/

#include "fly.h"
#include "notes.h"

#include "keyofc.h"

int FAR TnHello[] = {
	PL(K,C,T16),
	PL(K,D,T16),
	PL(K,E,T16),
	PL(K,F,T16),
	PL(K,G,T16),
	PL(K,A,T16),
	PL(K,B,T8),
	PL(L,C,T8),
	END
};

int FAR TnGone[] = {
	R(T64),
	PL(L,C,32*4),
	PL(K,B,32*4),
	PL(K,A,32*4),
	PL(K,G,32*4),
	PL(K,F,32*4),
	PL(K,E,32*4),
	PL(K,D,32*4),
	PL(K,C,32*4),
	GOTO(-8*2-1),
	END
};

int FAR TnHit[] = {
	PL(L,C,32*4),
	PL(K,B,32*4),
	PL(K,A,32*4),
	PL(K,G,32*4),
	PL(K,F,32*4),
	PL(K,E,32*4),
	PL(K,D,32*4),
	PL(K,C,32*4),
	PL(K,D,32*4),
	PL(K,E,32*4),
	PL(K,F,32*4),
	PL(K,G,32*4),
	PL(K,A,32*4),
	PL(K,B,32*4),
	REPEAT(-14*2,3000/(14*32)),	/* 3 seconds */
	END
};

int FAR TnEngine[] = {
	R(10),
	R(10),
	GOTO(-2),
	END
};

int FAR TnAlarm[] = {
	R(4),
	P(N,A,T32),
	P(N,G,T32),
	GOTO(-3),
	END
};

int FAR TnWarn[] = {
	R(4),
	PL(I,G,T32),
	R(T32),
	GOTO(-(1*2+2)),
	END
};

int FAR TnNotice[] = {
	P(M,G,T16),
	END
};

int FAR TnGear[] = {
	P(I,G,T2),
	END
};

int FAR TnLand[] = {
	P(H,G,T4),
	END
};

int FAR TnFly[] = {
	P(H,G,T8),
	END
};

int FAR TnDamage[] = {
	P(M,A,T64),
	P(M,G,T64),
	REPEAT(-2,1),
	END
};

#define	BG \
	PL(J,G,TT4), \
	PL(J,G,TT8), \
	PL(J,B,TT4), \
	PL(J,B,TT8), \
	PL(K,D,TT4), \
	PL(K,D,TT8), \
	PL(K,F,TT8), \
	PL(K,E,TT8), \
	PL(K,D,TT8) \

#define	BC \
	PL(K,C,TT4), \
	PL(K,C,TT8), \
	PL(K,E,TT4), \
	PL(K,E,TT8), \
	PL(K,G,TT4), \
	PL(K,G,TT8), \
	PL(K,ASH,TT8), \
	PL(K,A,TT8), \
	PL(K,G,TT8)

#define	BD \
	PL(K,D,TT4), \
	PL(K,D,TT8), \
	PL(K,FSH,TT4), \
	PL(K,FSH,TT8), \
	PL(K,A,TT4), \
	PL(K,A,TT8), \
	PL(L,C,TT8), \
	PL(K,B,TT8), \
	PL(K,A,TT8)

int FAR TnTune4[] = {
	BG,
	BG,
	BG,
	BG,

	BC,
	BC,
	BG,
	BG,

	BD,
	BC,

	PL(J,G,TT4),
	PL(J,G,TT8),
	PL(J,B,TT4),
	PL(J,B,TT8),
	PL(K,C,TT4),
	PL(K,C,TT8),
	PL(K,CSH,TT4),
	PL(K,CSH,TT8),
	PL(K,D,T4),
	PL(J,B,TT4),
	PL(J,G,TT4),
	R(TT4),
	R(T4),
	END
};
