/* --------------------------------- ogtarget.c ----------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* object: ground target.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fly.h"

static SHAPE shape_gtarget = {
	0,
	0,
	SH_BEHIT,
	10000*1000L,	/* weight */
	0		/* drag */
};

static int FAR
init_gtarget (BODY *b)
{
	if (shape_read (&shape_gtarget, "gtarget.vxx"))
		return (1);
	return (0);
}

static void FAR
term_gtarget (BODY *b)
{
	shape_free (shape_gtarget.v);
}

static int FAR
create_gtarget (OBJECT *p)
{
	p->color = st.white;
	p->time = FOREVER;
	p->damage = 10;
	p->damaging = 1;
	p->flags |= F_VISIBLE|F_EXPORTED;
	p->R[X] = (rand () % 10000 - 5000)*(long)VONE;
	p->R[Y] = (rand () % 10000 - 5000)*(long)VONE;
	Mident (p->T);
	return (0);
}

BODY BoGtarget = {
	0,
	0,
	"GT",			/* Ross likes it short */
	&shape_gtarget,
	init_gtarget,
	term_gtarget,
	create_gtarget,
	body_delete,
	body_dynamics,
	body_hit
};
