/* --------------------------------- keypad.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handler for the keyboard as a pointing device.
*/

#include "fly.h"

#define PO	p->opt

static void FAR
key (POINTER *p, int key)
{
	switch (key) {
	case KF_UP:			/* counter clockwise */
		if (p->a[PO[3]] < 100)
			p->a[PO[3]] += 10;
		break;
	case KF_DOWN:			/* clockwise */
		if (p->a[PO[3]] > -100)
			p->a[PO[3]] -= 10;
		break;

	case KF_RIGHT_TURN:		/* clockwise */
		if (p->a[PO[1]] > -100)
			p->a[PO[1]] -= 10;
		break;
	case KF_LEFT_TURN:		/* counter clockwise */
		if (p->a[PO[1]] < 100)
			p->a[PO[1]] += 10;
		break;

	default:
		std_key (p, key);
		break;
	}
}

static int FAR
cal (POINTER *p)
{
	p->a[PO[1]] = 0;
	p->a[PO[3]] = 0;
	return (0);
}

static int FAR
read (POINTER *p)
{
	return (0);
}

static void FAR
term (POINTER *p)
{
	return;
}

struct PtrDriver PtrKeypad = {
	"KEYPAD",
	0,
	cal,			/* init */
	term,
	cal,
	cal,			/* center */
	read,
	key
};
