/* --------------------------------- hud.h ---------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Head Up Display header
*/

struct hud {
	short	maxx;		/* window size */
	short	maxy;
	short	orgx;		/* hud center */
	short	orgy;
	short	sx;		/* hud size */
	short	sy;
	short	tx;
	short	ty;
	short	ttx;
	short	tty;
	short	shifty;
	short	clipr;		/* bounding rectangle */
	short	clipl;
	short	clipt;
	short	clipb;
	ANGLE	width;		/* horizontal aperture */
	ANGLE	height;		/* vertical aperture */
	short	ss;		/* stroke size */
	short	fg;		/* color (normal) */
	short	fgi;		/* color (intensified) */
};

struct ils {
	char	*name;
	LVECT	R;		/* runway position */
	short	l[2];		/* localizer relative x/y */
	short	g[2];		/* glide-path relative x/y */
	ANGLE	localizer;	/* heading of forward beam */
	ANGLE	glidepath;	/* pitch of beam */
};

#define	VVPERIOD	2000			/* delay milliseconds */
#define VVDELAY		EE(p)->misc[9]		/* temp storage */

/*
 * For huds, the following are sizes measured in fraction of HUD size
 * (length from center to edge).
*/

#define MAPBOX	((int)(FONE*22L/140))		/* intel mode box size */

/*
 * These are for all
*/

#define HUDFONT	FCON(0.06)			/* hud font size */

#define RSELECT3  ((int)(FONE*22L/140))		/* target selection radius */
#define RSELECT20 ((int)(FONE*140L/140))	/* target selection radius */
#define RSELECT5 ((int)(FONE*35L/140))		/* target selection radius */

#define SVV	((int)(FONE*15L/140))		/* vv size */
#define RVV	((int)(FONE*9L/280))		/* vv radius */

#define PULLUPCUE	SVV
#define PULLUPCUEGAP	(SVV/3)
#define PULLUPCUETIP	(SVV+SVV/4)

#define IPDIAMOND	FCON(0.03)

/*
 * These are for the fa18
*/

#define F18HEAD	((int)(FONE*45L/140))		/* heading scale height */
#define F18HEADG ((int)(FONE*25L/140))		/* -"- when gear down */
#define F18HEADS ((int)(FONE*61L/140))		/* -"- size */

#define F18ALT	((int)(FONE*52L/140))		/* altitude box position */
#define F18SPD	((int)(FONE*62L/140))		/* speed box position */

#define F18STEP	((int)(FONE*32L/140))		/* small ladder step */
#define F18STEP0 ((int)(FONE*48L/140))		/* zero ladder step */
#define F18STEPG ((int)(FONE*135L/140))		/* -"- gear down */
#define F18GAP	((int)(FONE*15L/140))		/* ladder step gap */

#define F18RAIM	((int)(FONE*22L/140))		/* aiming reticule radius */
#define F18RAIMC ((int)(FONE*50L/60))		/* -"- circle radius ratio */
#define F18TBOX	((int)(FONE*8L/140))		/* target designator size */

#define PENSIZE	((int)(FONE*145L/140))		/* pendulum size */

#define F18WEAPON ((int)(FONE*100L/140))	/* weapon name position */

#define F18LINE0 ((int)(FONE*55L/140))		/* base of first text line */
#define F18LINE	((int)(FONE*12L/140))		/* text line spacing */

/*
 * These are for the f16
*/

#define F16HEAD	((int)(FONE*90L/140))		/* heading scale height */
#define F16HEADS ((int)(FONE*80L/140))		/* -"-  -"- size */

#define F16ALT	((int)(FONE*3L/4))		/* altitude scale position */
#define F16SPD	((int)(FONE*3L/4))		/* speed scale position */

/*
 * These are for the f15
*/

#define F15HEADL ((int)(FONE*10L/30))		/* heading scale height */
#define F15HEADH ((int)(FONE*9L/15))		/* -"- in high position */
#define F15HEADS ((int)(FONE*185L/260))		/* -"-  -"- size */

#define F15ALT	((int)(FONE*170L/250))		/* altitude scale position */
#define F15SPD	((int)(FONE*170L/250))		/* speed scale position */
#define F15RDR	((int)(FONE*145L/250))		/* radar scale position */

/*
 * These are for the f15/f16
*/

#define F15STEP	((int)(FONE*75L/250))		/* small ladder step */
#define F15STEP0 ((int)(FONE*120L/250))		/* zero ladder step */
#define F15GAP	((int)(FONE*25L/250))		/* ladder step gap */

#define F15RAIM	((int)(FONE*45L/250))		/* aiming reticule radius */
#define F15RAIMC ((int)(FONE*82L/90))		/* -"- circle radius ratio */
#define F15TBOX	((int)(FONE*20L/250))		/* target designator size */


extern void FAR show_radar (VIEW *view, OBJECT *p, OBJECT *pov, int orgx,
	int orgy, int maxx, int maxy, int tx, int ty, int ss, int clipx,
	int clipy, int sx, int sy, int shifty, int VVD[2], int mode, int hon);
extern void FAR show_heading (VIEW *view, OBJECT *p, int sx, int sy, int maxx,
	int maxy, int orgx, int orgy, int ttx, int tty, int tx, int ty, int ss,
	int shifty);
extern void FAR show_altitude (VIEW *view, OBJECT *p, int sx, int sy,
	int maxx, int maxy, int orgx, int orgy, int ttx, int tty, int tx,
	int ty, int ss);
extern void FAR	show_speed (VIEW *view, OBJECT *p, int sx, int sy, int maxx,
	int maxy, int orgx, int orgy, int ttx, int tty, int tx, int ty, int ss);
extern void FAR show_pitch (VIEW *view, OBJECT *p, int sx, int sy, int maxx,
	int maxy, int orgx, int orgy, int ttx, int tty, int tx, int ty, int ss,
	int shifty, int mode);

extern void FAR	show_num (int x, int y, long t, int s, int c, int orgx,
	int orgy, int maxx, int maxy, int shifty);
extern void FAR	add_segment (int x1, int y1, int x2, int y2, int c,
	int orgx, int orgy, int sx, int sy, int shifty);
extern void FAR	add_dash (int x1, int y1, int x2, int y2, int ndash,
	int ratio, int c);
extern void FAR	screen_coords (VIEW *view, VECT RR);
extern int FAR	clip_to_screen (int D[2], VECT RR, int maxx, int maxy,
	int dx, int dy, int clipx, int clipy, int shifty);
extern void FAR show_hud (VIEW *view, OBJECT *pov, OBJECT *p, int shift,
	int orgx, int orgy, int maxx, int maxy, int mode);
extern void FAR show_misc (VIEW *view, OBJECT *p, int maxx, int maxy, int orgx,
	int orgy, int ss);
extern int FAR hdd_menu (VIEW *view, int orgx, int orgy, int maxx, int maxy);
extern char * FAR get_wname (OBJECT *p);
extern void	FAR hud_setup (OBJECT *p);
extern void	FAR show_data (OBJECT *obj, int datax, int datay, int detail,
	int knots, int dist, int closure, char *name, int tti, int mode,
	int ss);
extern char *	FAR get_name (OBJECT *obj, OBJECT *target, int mode);
extern void	FAR show_piper (OBJECT *obj, OBJECT *target, int x, int y,
	int dx, int dy, int ds, int mode, int off_screen, int dist, int tti,
	int closure, int orgx, int orgy, int clipx, int clipy, int hbottom,
	int hleft, VECT TA, int ss, int shifty);

/* ils.c */
extern void FAR show_ils (OBJECT *p, int sx, int sy, int orgx, int orgy,
	int ss, int shifty);
extern int	FAR menu_ils (void);
extern struct ils ils[];

