/* --------------------------------- amigados.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* general system-specific stuff for AMIGADOS.
*/

#include <stdio.h>
#include <stdlib.h>

#include "amigainc.h"

#include "fly.h"

#ifndef _DCC
struct IntuitionBase *IntuitionBase=NULL;
#endif

static int far
init (void)
{
#ifndef _DCC
 	/* open the intuition library */
	IntuitionBase = (struct IntuitionBase *)
		OpenLibrary("intuition.library", 33L);
 	if (IntuitionBase == NULL) {
		printf("Error: Cannot open Intuition library\n");
	    	exit(ERROR_INVALID_RESIDENT_LIBRARY);
    	}
#endif
	return (0);
}

static void far
term (void)
{
#ifndef _DCC
	if (IntuitionBase)
	    CloseLibrary((struct Library *)IntuitionBase);
#endif
	return;
}

static void far
poll (void)
{}

static short far
disable (void)
{
	return (0);
}

static void far
enable (short flags)
{
}

static void FAR
shell (void)
{
	MsgWPrintf (20, "shell not implemented");
}

struct SysDriver SysDriver = {
	"AMIGADOS",
	0,
	init,
	term,
	poll,
	disable,
	enable,
	shell
};
