# include <stdio.h>
# include <malloc.h>
# include "sound.h"
# include "dgetbuf.h"
# include "csrbase.h"

# include "csrcmps.h"

extern	INFO_STRING IS;
extern	INFO_BOX IB;
/*
 *	This routine allocates as many sets of SNDHDR and SOUND structures,
 *	and memory for the sound data.  It grabs all the memory it can, so
 *	be sure that sound library buffers are already allocated before
 *	calling this routine.
 */

SNDHDR	far * sndheaders[MAXBUFFERS];	/* list of SNDHDR structures */
SOUND	far * sndstructs[MAXBUFFERS];	/* list of SOUND structures */

/*
 *	actually, we can't possibly get 10 64k buffers.  (64k * 10 = 640k,
 *	and that doesn't include the SNDHDR and SOUND structs, or the program,
 *	or MS-DOS).  On a 640k machine, you can often get 7.
 */
int	numbuffers = 0;		/* number of buffers actually allocated */

# ifdef __STDC__
void set_up_buffers(void)
# else
void set_up_buffers()
# endif
{
	SNDHDR far *shp;
	SOUND far *stp;
	char far *bp;
	char	msg_buff[90];

	/*
	 * Allocate as many BUFFERSIZE-byte buffers, and associated
	 * SNDHDR and SOUND structs, as possible.
	 */
	for (numbuffers = 0; numbuffers < MAXBUFFERS; numbuffers++)
	{
		bp = (char far *)halloc((long)BUFFERSIZE,sizeof(char));
		shp = (SNDHDR far *) halloc(1L,sizeof(SNDHDR));
		stp = (SOUND far *) halloc(1L,sizeof(SOUND));
		/* check if any allocations failed */
		if (bp == 0 || shp == 0 || stp == 0)
		{
			/* an allocation failed - free any pieces that */
			/* were allocated and can't be used */
			if (bp != 0)
				hfree(bp);
			if (shp != 0)
				hfree(shp);
			if (stp != 0)
				hfree(stp);
			sprintf(msg_buff,"Allocated %d %dK buffers",
				numbuffers, (BUFFERSIZE+512)/1024);
			IS.pString = msg_buff;
			info_draw( &IB );
			return;
		}
		/* fill in the SNDHDR structure */
		shp->sndp = stp;	/* fill in pointer to SOUND */
		shp->start = 0;		/* fill in start/end */
		shp->end = 0;		/* 0 for both indicates the entire */
					/* sound should be played */
		shp->rate = R11000;	/* Sampling rate is one of */
					/* R5500, R11000, or R22000 */

		/* fill in SOUND structure */
		stp->buffer = bp;	/* fill in buffer address */
		stp->sndlen = 0;	/* initially no sound recorded */

		/* Lie about the buffer size, so there is enough slop */
		/* at the end of the buffer so snd_decompress_part can */
		/* decompress a full buffer back into the same-sized */
		/* buffer without running off of the end. */

		stp->buflen = BUFFERSIZE - 2; /* fill in buffer length */

		/* save addresses so we remember where they are */
		sndheaders[numbuffers] = shp;
		sndstructs[numbuffers] = stp;
	}
}
