/*
	SOUND.H -	Include file for use with PSSJ digital sound toolkit
			as of Version 3(39)

	SOUND.H is part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
 */

typedef unsigned long	u_long;
typedef unsigned int	u_int;
typedef unsigned short	u_short;
typedef unsigned char	u_char;

typedef char far *	saddr;


typedef struct sound {
	saddr		buffer;		/*The sound buffer itself */
	u_long		sndlen;		/*Length of the sound in the buffer */
	u_long		buflen;		/*Length of the buffer itself */
	u_char		rate;		/*Rate the sound was recoreded at */
	u_char		system;		/*Sound source (see defines below) */
	u_long		reserved[4];	/*Reserved for internal use */
} SOUND;

typedef struct sndhdr {
/*	The following items, except "ticket", "reserved1",
	and "reserved2" are to be filled in by the caller*/
	SOUND	far	*sndp;		/*The sound structure */
	u_long		start;		/*Where to start playing (0 == ALL) */
	u_long		end;		/*Where to stop playing (0 == end) */
	u_short		ticket;		/*When buffer was/is-to-be played */
	u_char		rate;		/*Rate the sound is to be played at */
	u_char		reserved1;	/*Reserved for internal use */
	u_long		reserved2[4];	/*Also reserved for internal use */
} SNDHDR;

/*	Machine sound came from */
#define B_SYNTH	0			/*Sound was synthetically produced */
#define B_MAC	0			/*Sound came from a Macintosh(R) */
#define B_AT8	1			/*Recorded on a 8mhz AT compatible */
#define B_SL	2			/*Sound was recorded on a 1000-SL */
#define B_TL	3			/*Sound was recorded on a 1000-TL */
#define B_SLTL2	4			/*Sound came from sys with DB chip */

/*	Sampling rate defines */
#define R5500	1			/*5.5khz sample rate */
#define R11000	2			/*11khz sample rate */
#define R22000	3			/*22khz sample rate */
#define R32500	4			/*<27>32.5 Khz sample rate */
#define R39800	5			/*<27>39.8 Khz sample rate */

/*	Defines for snd_file_record	*/

#define CLOSEFILE	0x0001		/*When set the file will be closed
					  at EOF error, stop or length match*/
#define RECORDLENGTH	0x0002		/*Length for recording is specified*/
#define VOXSTARTOFF	0x0004		/*Recorder waits for sounds before
					  it starts saving data*/


typedef struct versioninfo {		/*Version format: Major[Minor](Edit)*/
	char far *	version;	/*String containing version message
					  that can be displayed via printf()*/
	u_char		major;		/*Major version number*/
	u_char		minor;		/*Minor version number 0=no character,
					  1=A, 2=B, 3=C...*/
	u_short		edit;		/*Edit number*/
	u_short		reserved1;	/*Reserved for future use*/
	u_long		reserved2;	/*Reserved for future use*/
	u_long		reserved3;	/*Reserved for future use*/
} VERSIONINFO;

/*	Scratch area for internal use of compress/decompress routines */
typedef struct {
	u_long	scratch[25];		/*Scratch area */
} COMPINFO;


/*	Defines for compress "type" parameter */
#define CTYPE_DESKMATE88	0

/*	pParam structure for compressing with type=CTYPE_DESKMATE88 */
typedef struct compparam
{
	COMPINFO far *pinfo;		/*compress/decompress work area */
	u_long	start;			/*start position in sound */
	u_long	end;			/*end position in sound (0=to end) */
	u_short	compress_mode;		/*what kind of compression to do */

/*	following parameters used only by  */
/*	compress_mode = DESKMATE88_ADJUSTABLE */

	u_short	threshhold_length;	/*minimum length of "silence" */
	u_char	threshhold;		/*amplitude of "silence" */
	u_char	precision;		/*how accurate to make deltas */
} COMPPARAM;

/*	Defines for compparam "mode" parameter */
#define DESKMATE88_MUSIC	1	/*music compression */
#define DESKMATE88_SPEECH	2	/*speech compression */
#define DESKMATE88_ADJUSTABLE	3	/*roll-your-own compress mode */

/*	defines for snd_cue() "mode" parameter */
#define TOPLAY		1		/*prepare to play */
#define	TORECORD	2		/*prepare to record */

/*	defines for snd_init() "options" parameter */
#define FASTRAMP	0x0001		/*fast change between record and play */
/*	Misc defines */
#define TRUE	1
#define	FALSE	0
#ifndef NULL
#  define NULL	0
#endif /*NULL*/


/*	Error codes */
#define BADFMT	-3			/*Decompress called with corrupted
					  data or sound compressed with
					  unsupported algorithm */
#define BADPARM	-2			/*Compress called with bad type or
					  compress_mode */
#define INVALID  -1			/*Call made when driver uninitialized
					  or call not legal at this time */
#define NOERROR	 0
#define INITBUF	 1			/*Insufficient buffers were allocated
					  before snd_init() was called */
#define INIT64K	 2			/*All buffers spanned 64K physical
					  addresses - player cannot
					  initialize */
#define BADDMA	 3			/*DMA Channel requested is invalid */
#define BADIRQ	 4			/*The IRQ number requested is
					  invalid */
#define NOIRON	 5			/*Can't find our hardware */
#define BADSIZE	 6			/*Record buffer is too small or
					  too small for the requested time. */
#define WOULDBLOCK 7			/*snd_record() failed because two
					  buffers are already queued and
					  block was set to FALSE */

/*	The following are the error codes returned by the Deathmate
	resource which for some unknown reason has to return ASCII codes.*/

#define RESOK		'0'		/*Command accepted*/
#define	RESNOTINIT	'U'		/*Not initialized - signals earlier*/
					/*failure that was ignored.*/
#define RESBUSY		'B'		/*Another file is being played*/
					/*or recorded.*/
#define RESFNF		'F'		/*Specified file was not found*/
#define RESNOTTIME	'W'		/*Specified point in time has not*/
					/*arrived*/
#define RESISTIM	'G'		/*Specified point in time has arrived*/
#define RESMEM		'M'		/*Could not allocate or free memory*/

#define RESBADCMD	'X'		/*Unknown command code*/
#define RESYES		'Y'		/*Yes to the question*/
#define RESNO		'N'		/*No to the question*/


/*	Compression-precision default defines */
#define SND_PRECIS	1		/*"precision" compression default */
#define SND_SPEECH_THR	12		/*"threshold" speech comp. default */
#define	SND_MUSIC_THR	0		/*"threshold" music comp. default */
#define SND_THRESH_LEN	60		/*"threshold_length" default */


/*	Prototypes for routines */
/*	__STDC__ is automatically defined for compilers supporting ANSI
	function prototypes, and undefined for compilers that don't.  An
	ANSI and non-ANSI prototype is given for each function.
*/

#ifdef __STDC__
short far snd_addbuf(saddr mem, u_short nr_bufs);
short far snd_init(u_short trigger, u_short dma_ch, u_short irq, 
	u_short options);
short far snd_exit(void);
short far snd_play(SNDHDR far *pSound);
void far snd_volume(u_short volume);
short far snd_flush(void);
short far snd_record(SOUND far *pSound, u_short maxTime, u_short rate,
	u_char far *adj_table, u_short block, u_short limit,
	u_short threshold, u_short silence_len);
short far snd_buf_wait(SNDHDR far *pSound, u_short wait);
short far snd_wait(u_short option, u_short zero, u_short wait);
void far snd_buf_stop(SNDHDR far *pSound);
void far snd_stop(u_short time, u_short zero);
void far snd_amplify(u_short factor, u_char far *output);
void far snd_apply_func(SOUND far *pSound, 
	u_long start, u_long end,
	u_char far *table);
long far snd_compress_part(SOUND far *psound, u_char far *dest, 
	u_short dest_size, u_short type, COMPPARAM far *pParam);
short far snd_decompress_part(SOUND far *psound, COMPINFO far *pinfo, 
	u_char far *src, u_short src_len);
short far snd_compensate(u_char far * adj_table);
short far snd_cue(u_short mode);
short far snd_file_play(u_short filehandle,u_short option);	/*<25>*/
 short far snd_file_record(u_short filehandle,u_short rate,u_short option,
	u_char far * adj_table, u_short rec_len, u_short silence_len,
 	u_short threshold, u_short compress_opt);	/*<25>*/
VERSIONINFO far * far snd_version(void);
#else /*__STDC__*/
short far snd_addbuf();
short far snd_init();
short far snd_exit();
short far snd_play();
void far snd_volume();
short far snd_flush();
short far snd_record();
short far snd_buf_wait();
short far snd_wait();
void far snd_buf_stop();
void far snd_stop();
void far snd_amplify();
void far snd_apply_func();
long far snd_compress_part();
short far snd_decompress_part();
short far snd_compensate();
short far snd_cue();
short far snd_file_play();		/*<25>*/
short far snd_file_record();		/*<25>*/
VERSIONINFO far *  far snd_version();
#endif /*__STDC__*/

/*	Mode word equates*/

#define	INPLAY		0x0001		/*Player DMA is running*/
#define	INRECORD	0x0002		/*Recorder DMA is running*/
#define	UNINITIALIZED	0x0004		/*Are we initialized*/
#define	STOPDMA		0x0008		/*Signal to ISR to abort DMA*/
#define	RAMPUP		0x0010		/*State of playback hardware*/
#define	BIAS		0x0020		/*Indicates if bias info is set*/
#define	RECORDNEXT	0x0040		/*An additional record buffer is*/
					/*available to use after current one*/
#define	modesp1		0x0080

#define	DISKPLAY	0x0100		/*Disk play is in operation*/
#define	DISKRECORD	0x0200		/*Disk record is active*/
#define	DISKABORT	0x0400		/*Wrapping up some disk operation*/
#define	DOS_HOOKED	0x0800
#define	COMPRESS	0x1000		/*<24>File on disk is/will compressed*/
#define	HAVEBLK		0x2000		/*<24>*/
#define	EXPBUSY		0x4000
#define	DISKBUSY	0x8000		/*<18>Can't interrupt this*/

