	page	60,132
;-----------------------------------------------------------------------------
;	Misc.Asm     - Buffer management routines and other shared routines
;	MISC.ASM is part of the PSSJ Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
sndseg	segment public	'CODE'
	assume cs:sndseg
	include	sound.inc

	public	snd_xfer_buf,snd_append_buf
	public	round_dssi,round_esdi,round_esbx,roundup,rnd_dssi_m

;------------------------------------------------------------------------------
;	This function attempts to take a buffer off the top of one chain
;	and adds it to the top of a target chain.
;	head of Source string is pointed to by ds:si
;	Target string is pointed to by ds:di

;	This routine MUST be protected from changes in the source and target
;	chains while it is running, either by knowledge or disabled
;	interrupts!

;	Returns NZ and AX <> 0 if the source pointer was NULL.
;	Returns Z and AX==0 otherwise.
;	ES:DI points at buffer that was copied.
;	All data registers altered.

;	This function is not meant to be used by external programs.
;------------------------------------------------------------------------------

snd_xfer_buf	proc	near
	push	ds
	les	bx,[si]			;Load head pointer
	mov	ax,es
	or	ax,bx			;Does it point to anything?
	jnz	$xfer1			;Yes

;	No buffers on source chain, abort.

	pop	ds
	or	al,1
	ret
	page
;	ds:si points at source head pointer
;	es:bx points at first buffer on source chain

$xfer1:	push	es			;Save first buffer segment
	les	cx,es:[bx]		;Get pointer to second buffer
					;(or NULL)
	
;	ds:si points at head pointer
;	es:cx points at 2nd buffer

	mov	[si],cx			;Make second buffer the first
	mov	[si+2],es
	pop	es

;	es:di points at head of target chain

	mov	cx,[di]			;Get offset of first block
	mov	es:[bx],cx
	mov	cx,[di+2]		;Get segment of first block
	mov	es:[bx+2],cx
	mov	[di],bx			;Point target chain at new buf
	mov	[di+2],es		;and the segment
	mov	di,bx

;	Address of "Copied buffer" is now in es:di

	pop	ds			;Put DS back to normal
	xor	ax,ax
	ret				;Return

snd_xfer_buf	endp
	page	

;------------------------------------------------------------------------------
;	snd_cat_chain

;	This function takes one chain of buffers (none or more) 
;	and adds it to the end of a target chain.

;	head of Source chain is pointed to by ds:si (no struct at this loc)
;	head of Target chain is pointed to by ds:di (no struct at this loc)

;	This routine MUST be protected from changes in the source and target
;	chains while it is running, either by knowledge or disabled
;	interrupts!

;	Returns NZ and AX <> 0 if the source pointer was NULL.
;	Returns Z and AX==0 otherwise.

;	All data registers altered.

;	This function is not meant to be used by external programs.
;------------------------------------------------------------------------------
	public	snd_cat_chain
snd_cat_chain	proc	near
	mov	dl,1
	jmp	snd_chain_com		;We share a little code here...
snd_cat_chain	endp

;------------------------------------------------------------------------------
;	snd_cat_buf

;	This function attempts to take a buffer off the top of one chain
;	and adds it to the end of a target chain.

;	head of Source chain is pointed to by ds:si (no struct at this loc)
;	head of Target chain is pointed to by ds:di (no struct at this loc)

;	This routine MUST be protected from changes in the source and target
;	chains while it is running, either by knowledge or disabled
;	interrupts!

;	Returns NZ and AX <> 0 if the source pointer was NULL.
;	Returns Z and AX==0 otherwise.
;	CX:BX points to the buffer that was just appended onto the chain

;	All data registers altered.

;	This function is not meant to be used by external programs.
;------------------------------------------------------------------------------

	public	snd_cat_buf
snd_cat_buf	proc	near

	xor	dl,dl			;Do a lone chain
snd_chain_com:
	push	ds
	les	bx,[si]			;Load head pointer
	mov	ax,es
	or	ax,bx			;Does it point to anything?
	jnz	$$xfer1			;Yes

;	No buffers on source chain, abort.

	pop	ds
	or	al,1			;No source buffer to copy
	ret
	page
;	ds:si points at source head pointer
;	es:bx points at first buffer on source chain

$$xfer1:push	es			;Save first buffer segment
	les	cx,es:[bx]		;Get pointer to second buffer
					;(or NULL)
	
;	ds:si points at head pointer
;	es:cx points at 2nd buffer

	xor	ax,ax			;Get a NULL ready - someone will use it
	or	dl,dl			;If dealing with lone buffer,
	jnz	$bchain			;must fix-up source chain.

	mov	[si],cx			;Make second buffer the first
	mov	[si+2],es
	jmp	$cchain

$bchain:mov	[si],ax			;Disconnect entire source chain
	mov	[si+2],ax

$cchain:pop	es

;	es:bx points at buffer to add

	or	dl,dl			;Are we doing a buffer or a chain?
	jnz	$achain			;Don't disconnect this
	mov	word ptr es:[bx].play_buf_next,ax	;lone buffer
	mov	word ptr es:[bx+2].play_buf_next,ax	;needs NULL fwd ptr

;	Now, find the end of the target chain

$achain:push	es
	push	bx
	mov	ax,ds
	mov	es,ax			;es:di now points at head of target

$$next:	mov	bx,word ptr es:[di].play_buf_next	;Read next pointer
	mov	cx,word ptr es:[di+2].play_buf_next
	mov	ax,bx			;Is it NULL?
	or	ax,cx
	jz	$$addend		;Found the end
	mov	di,bx
	mov	es,cx
	jmp	$$next			;Advance to next buffer (or NULL)

;	Now, ES:DI points to last buffer in target chain

$$addend:
	pop	bx			;Offset of source buffer
	pop	cx			;segment of source buffer

	mov	word ptr es:[di].play_buf_next,bx
	mov	word ptr es:[di+2].play_buf_next,cx	;Chain new buffer on

;	mov	es,cx			;Return with es:di pointing at new buf
;	mov	di,bx

	pop	ds
	xor	ax,ax
	ret				;Return

snd_cat_buf	endp
	page	
;------------------------------------------------------------------------------
;	Adds the specified buffer to a target chain
;	UNLIKE snd_xfer_buf, the buffer is added to the chain which
;	takes longer but maintains queuing order.

;	Pointer to sole buffer to add in dx:si - NO CHAIN ALLOWED
;	Target string is pointed to by es:di

;	This routine MUST be protected from changes in the target
;	chain while it is running, either by knowledge or disabled
;	interrupts!

;	ALSO not for public consumption
;------------------------------------------------------------------------------

snd_append_buf	proc	near

	xor	bx,bx
	push	es
	mov	es,dx
	mov	word ptr es:[si].play_buf_next,bx	;Null next pointer
	mov	word ptr es:[si+2].play_buf_next,bx
	pop	es

$addnxt:
	mov	bx,es:[di]		;Get offset
	mov	cx,es:[di+2]
	mov	ax,bx
	or	ax,cx
	jz	$addend			;Found the end
	mov	di,bx
	mov	es,cx
	jmp	short	$addnxt		;Keep looking

;	Here, es:di points at last item (or head pointer)
;	dx:si points to buffer to add

$addend:
	mov	word ptr es:[di].play_buf_next,si	;Point at new buf
	mov	word ptr es:[di+2].play_buf_next,dx	;and segment

;	All done

	ret

snd_append_buf	endp
	page
;------------------------------------------------------------------------------
;	Takes the offset in SI and segment in DS and makes the offset
;	a number between 0 and 15.
;	Only SI and DS are altered.
;------------------------------------------------------------------------------

rnd_dssi_m	proc near
	push	ax			;<13>
	mov	ax,si			;<13>
	and	ah,0f0h			;<13>and it off
	cmp	ah,0f0h			;<14>Wait until in 61000 neighborhood
	jz	$round_dszi		;<14>Go ahead and perform roll-over
	pop	ax			;<14>when you get REAL close
	ret				;It will keep until next buffer
rnd_dssi_m	endp

round_dssi	proc near
	push	ax
$round_dszi:				;I *KNOW* I AM JUMPING FROM A
					;DIFFERENT FUNCTION!  IT'S EFFICIENT!
	push	si
	shr	si,1
	shr	si,1
	shr	si,1
	shr	si,1
	mov	ax,ds
	add	ax,si
	mov	ds,ax
	pop	si
	and	si,0fh
	pop	ax
	ret
round_dssi	endp
	page
;------------------------------------------------------------------------------
;	Takes the offset in DI and segment in ES and makes the offset
;	a number between 0 and 15.
;	Only DI and ES are altered.
;------------------------------------------------------------------------------

round_esdi	proc	near
	push	ax
	push	di
	shr	di,1
	shr	di,1
	shr	di,1
	shr	di,1
	mov	ax,es
	add	ax,di
	mov	es,ax
	pop	di
	and	di,0fh
	pop	ax
	ret
round_esdi	endp

;------------------------------------------------------------------------------
;<13>	Takes the offset in BX and segment in ES and makes the offset
;<13>	a number between 0 and 15.
;<13>	Only BX and ES are altered.
;------------------------------------------------------------------------------

round_esbx	proc	near		;<13>
	push	ax			;<13>
	push	bx			;<13>
	shr	bx,1			;<13>
	shr	bx,1			;<13>
	shr	bx,1			;<13>
	shr	bx,1			;<13>
	mov	ax,es			;<13>
	add	ax,bx			;<13>
	mov	es,ax			;<13>
	pop	bx			;<13>
	and	bx,0fh			;<13>
	pop	ax			;<13>
	ret				;<13>
round_esbx	endp			;<13>
	page
;------------------------------------------------------------------------------
;	Takes the offset in AX and segment in BX and makes the offset
;	a number between 0 and 15.
;------------------------------------------------------------------------------

roundup	proc	near
	push	ax
	shr	ax,1
	shr	ax,1
	shr	ax,1
	shr	ax,1
	add	bx,ax
	pop	ax
	and	ax,0fh
	ret
roundup	endp

sndseg	ends
	end

