	page	60,132
;-----------------------------------------------------------------------------
;	Fpdecomp.Asm - File-Play Decompression - WORK in PROGRESS
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	.lall
	extrn	round_esdi:near


;	Compression coding

;	Header:
;	1 byte of compression type
;	1 byte of threshhold
;	2 bytes (LSB/MSB) of threshhold length
;	BOF code

;	<Prefix code> = one of { fb, fc, fd, fe }
;	<Ordinary code> = any 8-bit value besides a prefix code

;	<Ordinary code> 		represents one sample
;	<Prefix code> <Ordinary code> represents a special 2-byte sequence
;	<Prefix code> <Prefix code> 	is an illegal combination
;	No triple-byte or longer sequences are allowed.

;	<00-fa,ff>		represents one sample
;	<fb><00-fa,ff>		reserved (currently ignored)
;	<fc><00>		eof
;	<fc><01>		BOF
;	<fc><02>		represents an fe sample
;	<fc><03>		represents an fd sample
;	<fc><04>		represents an fc sample
;	<fc><05>		represents an fb sample
;	<fc><06-fa,ff>		reserved (currently represents sample 256-N)
;	<80>			represents one byte of silence
;	<80><80>		represents two bytes of silence
;	<fd><00-fa>		represents N+3 bytes of silence (3-253)
;	<fd><ff>		reserved
;	<fe><00-fa>		represents (N+1)*254 bytes of silence
;	<fe><ff>		reserved

	public	state_init

sndseg	segment	public	'CODE'
	assume	cs:sndseg

;	Yes, this block of data really belongs in the CODE
;	segment, so I can save a segment register.  Eccch!

eof_flag	dw	0		;eof flag
curbufcount	dw	0		;current buffer count
curbufptr	dd	0		;current buffer pointer
stateptr	dw	?		;code pointer to current state
blanks		dw	?		;remaining blanks to deliver
count		dw	?		;bytes output
c		db	?		;temporary char storage


;	_st_decompress_start()
;	Initializes a decompression

	public _st_decompress_start
_st_decompress_start proc far
	assume	cs:sndseg
	mov	ax,0
	mov	eof_flag,ax		;clear eof flag
	mov	curbufcount,ax		;clear current buffer count
	mov	word ptr (curbufptr),ax	;clear current buffer pointer
	mov	word ptr (curbufptr+2),ax
	mov	stateptr,offset state_init ;initialize state
	mov	blanks,ax		;blank count
	ret
_st_decompress_start endp


;	_st_decompress_supply_buffer(src, srclen)

@codesize	equ	1

;	Argument template

supbuf	struc		;_st_decompress_supply_buffer(src,srclen)
	dw	?
	dw	(@codesize+1) dup (?)
src	dd	?
srclen	dw	?
supbuf	ends

	public	_st_decompress_supply_buffer
_st_decompress_supply_buffer proc far	;uses ds es di, src:far ptr, srclen:word
	assume	cs:sndseg
	push	bp
	mov	bp,sp
	push	es
	push	di

	mov	ax,curbufcount		;Still working on buffer?
	or	ax,ax			;fe
	jnz	reterror		;Yes, error.

	mov	ax,[bp].srclen		;Is this an eof?
	or	ax,ax			;fe
	jnz	noteof			;No.

					;Yes.
	mov	eof_flag,1		;eof_flag = 1
	xor	ax,ax			;fe return 0
	jmp	exit
noteof:	les	di,[bp].src		;get current buffer pointer
	call	round_esdi		;fe
	mov	word ptr curbufptr,di	;fe set current buffer pointer
	mov	word ptr curbufptr+2,es	;fe
	mov	ax,[bp].srclen
	mov	curbufcount,ax		;set count
	xor	ax,ax			;fe return 0
		
exit:	pop	di
	pop	es
	pop	bp
	ret

reterror:
	mov	ax,-1			;return error
	jmp	exit
_st_decompress_supply_buffer endp

;	Argument template

getdat	struc		;_st_decompress_supply_buffer(src,srclen)
	dw	?
	dw	(1+1) dup (?)
dest	dd	?
destlen	dw	?
getdat	ends

	public	_st_decompress_get_data
_st_decompress_get_data	proc far 	;uses ds es si di cx


;	Register usage
;	ds:si/cs:curbufptr	Source pointer
;	cx/cs:curbufcount	count of source bytes left
;	es:di/ss:dest		Destination pointer
;	ss:destlen		count of destination bytes left
;	ax			sample data for getbyte/putbyte
;	bx/cs:stateptr		continuation location
;	dx/cs:blanks		silence counter

getbyte	macro
	local	foo,foo2
	sub	cx,1			;decrement remaining count
	jnc	foo2
	jmp	bufempty
foo2:	lods	byte ptr [si]		;get the byte
	endm
putbyte	macro
	local	foo3,foo4
	sub	[bp].destlen,1		;decrement remaining count
	jnc	foo3
	jmp	buffull
foo3:	stosb				;store byte, advance pointer
	inc	count			;advance output count
	endm

	push	bp			;set up subroutine linkage
	mov	bp,sp
	sub	sp,2
	push	ds
	push	es
	push	si
	push	di
	pushf

	lds	si,curbufptr		;ds:si = source pointer
	les	di,[bp].dest		;es:di = destination pointer
	mov	cx,curbufcount		;cx = source count
	xor	ax,ax
	mov	count,ax		;clear output count
	mov	bx,stateptr		;state pointer
	cld				;direction flag forward
	jmp	bx			;go to state handling routine

set_init:
	mov	bx,offset state_init
state_init	label	near
	getbyte				;read & ignore ID byte
set_in2:mov	bx,offset state_in2
state_in2:
	getbyte				;read & ignore threshhold byte
set_in3:mov	bx,offset state_in3
state_in3:
	getbyte				;read & ignore threshhold length LSB
set_in4:mov	bx,offset state_in4
state_in4:
	getbyte				;read & ignore threshhold length MSB
	jmp	enter_norm

enter_normp:
	mov	al,c			;character
	mov	bx,count		;output count
	mov	dx,[bp].destlen		;destination count
	jmp	state_normp
enter_norm:
	mov	al,c			;character
	mov	bx,count		;output count
	mov	dx,[bp].destlen		;destination count

;	Register use inside this loop

;	ds:si/cs:curbufptr	Source pointer
;	cx/cs:curbufcount	count of source bytes left
;	es:di/ss:dest		Destination pointer
;*	dx/ss:destlen		count of destination bytes left
;*	ax/cs:c			sample data for getbyte/putbyte
;*	bx/cs:count		count of bytes output
;* These values need saving/restoring on entry/exit from the loop.

state_norm:
	sub	cx,1			;decrement remaining count
	jc	bufempty2		;input buffer empty
	lods	byte ptr [si]		;get a byte
	cmp	al,0fbh			;prefix byte?
	jae	prefix			;yes.
state_normp:
	sub	dx,1			;decrement remaining count
	jc	buffull2		;output buffer full
	stosb				;store byte, advance pointer
	inc	bx			;advance output count
	jmp	state_norm		;loop for another

;	Check if it's a prefix, and handle it

prefix:	mov	c,al			;save character
	mov	[bp].destlen,dx		;save dest buffer length left
	mov	count,bx		;save output count
	mov	bx,offset enter_normp	;set state to return
	jz	set_fba
	cmp	al,0ffh
	jz	enter_normp		;ff sample, go back into loop
	cmp	al,0fch			;BOF/eof and quoted samples prefix
	jz	set_fc
	cmp	al,0fdh			;short silence prefix
	jz	set_fd
	jmp	set_fe			;At this point, everything eliminated
					;but fe, the long silence prefix
bufempty2:
	mov	c,al			;save character
	mov	[bp].destlen,dx		;save dest buffer length left
	mov	count,bx		;save output count
	mov	bx,offset enter_norm	;set state to return
	jmp	bufempty
buffull2:
	mov	c,al			;save character
	mov	[bp].destlen,dx		;save dest buffer length left
	mov	count,bx		;save output count
	mov	bx,offset enter_normp	;set state to return
	jmp	buffull
set_fba:jmp	set_fb
set_fea:jmp	set_fe

;	fc prefix seen
;	bof/eof or quoted samples

set_fc:	mov	bx,offset state_fc
state_fc:
	getbyte
	mov	bx,offset state_norm
	cmp	al,0			;fc 00 (eof)
	jz	reteofa
	cmp	al,1
	jz	enter_normb		;fc 01 (BOF) ignore
	neg	al			;else return two's comp (quoted sample)
	mov	c,al			;save sample
set_fcp:mov	bx,offset state_fcp
state_fcp:
	mov	al,c			;get sample
	putbyte				;output quoted sample
enter_normb:
	jmp	enter_norm		;loop for another sample
reteofa:mov	ax,1
	mov	eof_flag,ax
	jmp	set_eof


;	fd prefix seen (short sequence of blanks)

set_fd:	mov	bx,offset state_fd
state_fd:
	getbyte				;get blank count N
	mov	ah,0
	add	ax,3			;output N+3 blanks
	mov	blanks,ax		;set blank count
	jmp	set_blk			;go to output silence

;	fb prefix seen (reserved prefix)

set_fb:	mov	bx, offset state_fb
state_fb:
	getbyte				;throw byte away
enter_norma:
	jmp	enter_norm		;go back for another sample

;	fe prefix seen (long blank sequence)

set_fe:	mov	bx,offset state_fe
state_fe:
	getbyte				;get blank count N
	inc	al
	mov	ah,254
	mul	ah			;(N+1)*254 blanks
 	mov	blanks,ax		;set blank count
	jmp	set_blk			;go output silence

set_eof:mov	bx,offset state_eof
state_eof:
bufempty:
	xor	cx,cx			;fe empty buffer
buffull:mov	ax,count		;get count
	or	ax,ax			;test if nonzero
	jnz	return			;output some bytes
	mov	ax,-2			;MOREDATA
	add	ax,eof_flag		;eof if eof_flag set to 1
	jmp	return

return:	mov	curbufcount,cx
	mov	word ptr (curbufptr),si
	mov	word ptr (curbufptr+2),ds
	mov	stateptr,bx

	popf
	pop	di
	pop	si
	pop	es
	pop	ds
	mov	sp,bp
	pop	bp
	ret


;	Outputting silence

set_blk:mov	bx,offset state_blk
state_blk:
	mov	ax,080h			;silence
	mov	dx,blanks		;decrement silence counter
	sub	dx,1
	jc	enter_norma		;all done; get next code
	putbyte
	dec	blanks			;decrement silence counter
	jmp	state_blk		;loop to output more blanks


_st_decompress_get_data endp
sndseg	ends
	end

