	page	60,132
;-----------------------------------------------------------------------------
;	Flush.Asm - Snd_Flush()  Forces the player to start playing any
;			  material it has acculumated.  The last buffer
;			  is filled-out and added to the queue as well.
;	Snd_Flush is part of the PSSJ Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	extrn	duo_art:NEAR
	extrn	snd_queue:NEAR

	include external.inc

	include	sound.inc
snddata	segment public	'DATA'
snddata	ends
	page
sndseg	segment	public	'CODE'
	assume	cs:sndseg,ds:snddata
	public	_snd_flush
_snd_flush	proc far

	push	ds
	mov	ax,snddata
	mov	ds,ax		;==============================================
	assume	DS:snddata

	mov	al,byte ptr snd_mode	;<22>Are we in play
	test	al,BIAS			;Will be high it snd_play
	jnz	$mayplay		;May be able to play

	mov	ax,INVALID
	or	ax,ax
	pop	ds	;======================================================
	ret				;FAR

$mayplay:
	push	di
	push	es
	pushf
	cli	;--------------------------------------------------------------
;Now I do.  What if they queue n bytes where n is a multiple of the queue
;size.  Nothing in ld_buf, but stuff on the play queue.
	les	di,queue_play	;::::::::Anything in the queue::::::::::::::
	mov	ax,es
	or	ax,di
	jnz	$valid

	les	di,ld_buf	;::::::::::::::::::::::::::::::::::::::::::::::
	mov	ax,es
	or	ax,di
	jnz	$valid
	

;	There is nothing in the queue (must have drained on its own)

$diexit:popf	;--------------------------------------------------------------
	pop	es	;::::::::::::::::::::::::::::::::::::::::::::::::::::::
	pop	di
	xor	ax,ax
	pop	ds	;======================================================
	ret				;FAR
	page
;	First, force any material left in the ld buffer onto the play queue.

$valid:	les	di,ld_buf_ptr	;::::::::::::::::::::::::::::::::::::::::::::::
	mov	cx,ld_buf_len
	or	cx,cx
	jz	$nold			;Was already done
	cmp	cx,MERRYGO_SIZE_BYTES	;Is buffer full?
	jz	$nold			;Full, don't play it


;	Here there are cx bytes left in the buffer uninitialized.
;	We will fill them with copies of the last sample.

	mov	al,ld_last_sample
	rep	stosb			;Store it


;	Now take that buffer and add it onto the play queue.

	call	snd_queue		;Note that doing
					;this may start the
					;player for us.
	xor	cx,cx			;Get a zero
	mov	ld_buf_len,cx
	mov	word ptr ld_buf,cx	;Reset ld_buf and length
	mov	word ptr ld_buf[2],cx


;	Now see if the player is running

$nold:	mov	al,byte ptr snd_mode	;<22>
	test	al,INPLAY		;Did the player start?
	jnz	$diexit			;<13>Was$running


;	No, we have to do it ourselves

	call	duo_art			;Start that sucker
	jmp	short $diexit		;All done, sucker
_snd_flush	endp
sndseg		ends
		end

