.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH SND_VERSION PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_VERSION troff documentation \- Version 1(15) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.SH Name
.br
snd_version \- Returns version and capability information.

.SH Syntax
.br
.B VERSIONINFO far * far snd_version(\ );
.br

.SH Description
\fISnd_version\fR allows an application that utilizes the PSSJ
Digital Sound Toolkit to determine what version of the library module was
linked into the application.  This also helps determine  
which features or options are available.
\fISnd_version\fR may be called 
at any time, even prior to calling \fIsnd_init\fR(PSSJ).

.SH Return Values

\fISnd_version\fR returns a far pointer to the following read-only
structure:

.nf
typedef struct versioninfo {
	char far *version;              /* String containing version
.if n \                                                    message that can be displayed
.if n \                                                    via printf(\ ) */
.if t \                                            message that can be displayed
.it t \                                            via printf(\ ) */
	char far *copyright;            /* Displayable copyright string*/
.if t \         unsigned char   major;          /* Major version number */
.if t \         unsigned char   minor;          /* Minor version number
.if n \         unsigned char   major;  /* Major version number */
.if n \         unsigned char   minor;  /* Minor version number
.if n \                                                    0 = no character, 1 = A,
.if n \                                                    2 = B, 3 = C... */
.if t \                                            0 = no character, 1 = A,
.if t \                                            2 = B, 3 = C... */
.if t \         unsigned short  edit;           /* Edit number */
.if n \         unsigned short  edit;           /* Edit number */
.if t \         unsigned short  reserved1;      /* Reserved for future use */
.if n \         unsigned short  reserved1;      /* Reserved for future use */
.if t \         unsigned long   reserved2;      /* Reserved for future use */
.if n \         unsigned long   reserved2;      /* Reserved for future use */
.if t \         unsigned long   reserved3;      /* Reserved for future use */
.if n \         unsigned long   reserved3;      /* Reserved for future use */
} VERSIONINFO;
.fi

.SH Notes
When writing code that determines if an option is available, use the 
\fImajor\fR and \fIminor\fR version fields.  The \fIedit\fR number should
not be used for this purpose.

.SH Credit
\fISnd_version\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
410185

