.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH SND_RECORD PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_RECORD troff documentation \- Version 1(12) 18\-Oct\-94
Copyright 1994 Frank Durda IV, See intro(PSSJ) for restrictions.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.5i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.5i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.5i
.if n  .ti -1.2i
..
.SH \fBName\fR
.br
snd_record \ - Records sound and stores the data in RAM buffers.
.br

.SH \fBSyntax\fR
.br
\fBshort far snd_record(pSound, maxTime, rate, adj_table, block, threshold, silence_len);\fR
.br
.B SOUND far *pSound;
.br
.B unsigned short maxTime;
.br
.B unsigned short rate;
.br
.B unsigned char far *adj_table;
.br
.B unsigned short block;
.br
.B unsigned short threshold;
.br
.B unsigned short silence_len;
.br

.SH Description
\fISnd_record\fR places the hardware into record mode at the
sampling rate specified by \fIrate\fR and fills the buffer described by
\fIpSound\fR until \fImaxTime\fR milliseconds have passed or the
buffer is full.  Recording buffers must be at least 100 bytes long,
although less than that amount can be used by setting \fImaxTime\fR
appropriately.

If \fImaxTime\fR is \fB0\fR the buffer will be filled to the size specified
by \fIbuflen\fR in the \fISOUND\fR structure.  When \fImaxTime\fR is non-zero,
the value is converted to a number of samples to record.  \fIBuflen\fR
is then checked to see if that number of bytes are available in the
buffer.  If not, an error is returned.  The number of bytes per
millisecond for each sampling rate is as follows:

.IN
Sampling Rate   Bytes per millisecond
.br
22  KHz         22
.br
11  KHz         11
.br
5.5 KHz         5.5
.br
.OU

Note that \fIsnd_record\fR will round \fImaxTime\fR up to the nearest
number of even milliseconds.  So, if \fImaxTime\fR is odd, and the buffer
is unable to hold the extra bytes required for the additional millisecond
of recording time, \fIsnd_record\fR will return \fBBADSIZE\fR.

\fIAdj_table\fR points to a translation table that will be used on each
sample that is recorded.  It is identical to the table filled in by such
functions as \fIsnd_amplify\fR(PSSJ).  The table must be filled in by
calling \fIsnd_compensate\fR(PSSJ) before recording begins.  If this
translation is not desired, call \fIsnd_record\fR with \fIadj_table\fR
equal to "(unsigned char far *)\fBNULL\fR".
.if n .bp
.if t .sp
Once the recording process begins, \fIsnd_record\fR returns so that
additional buffers can be prepared and \fIsnd_record\fR can be called
again.  If a second or third call to \fIsnd_record\fR is made before the first
buffer has been filled, \fIsnd_record\fR will return, and the second
buffer will be used after the first one is filled.  If a fourth call is
made before the first buffer is filled, \fIsnd_record\fR will wait
until the recorder starts using the second buffer before returning or
return an error, based on the setting of \fIblock\fR (described below).
If there is always an extra two buffers available to
the recorder (except at the end of recording), the group of buffers
represent a continuous recording.  The sampling rate specified in the
first of a series of calls to \fIsnd_record\fR will be the rate used
throughout the recording.
.if t .bp
.if n .sp
\fIBlock\fR allows the user to choose to wait until the buffer that is
specified in the call can be queued or to return immediately.  If
\fIblock\fR is set to \fBTRUE\fR, \fIsnd_record\fR will wait until the
active buffer is filled.  Then, \fIsnd_record\fR will return.  If
\fIblock\fR is \fBFALSE\fR and \fIsnd_record\fR already 
has stand-by buffers queued, it will return immediately with an error. 
The calling program can then scan the keyboard or perform other actions, 
and then call \fIsnd_record\fR with the same buffer.  This can be
done repeatedly until the buffer is accepted.

Recording stops when \fIsnd_record\fR has filled the buffers supplied in
one or more calls, \fIsnd_stop\fR(PSSJ) or \fIsnd_exit\fR(PSSJ)
is called, or \fImaxTime\fR is reached.  After recording stops, the next
call to \fIsnd_record\fR will set a new sampling rate.

As each buffer is used, the recording \fIrate\fR and \fIbias\fR fields in
each \fIsound\fR structure are updated.  This information should never be
changed or discarded, otherwise the sound may play back at the wrong
speed or pitch.

When \fIthreshold\fR is non-zero, it enables a mode where the recorder
will only record when the sound amplitude exceeds the specified value.
When the sound amplitude drops below and remains below the specified level,
the recorder will continue to "listen" but will not provide the
digital data for these quiet periods.  Any single sample that exceeds the
threshold will cause sound data delivery to resume, which will include
the sample that caused "recording" to resume.  The \fIthreshold\fR must be
a value between 0x0001 and 0x007e.  0x0000 disables this feature.

The \fIsilence_len\fR parameter informs the recorder as to how long it
should wait after sound levels fall below the \fIthreshold\fR before the
recording process is suspended.  This allows you to avoid "deleting" the
breaks between words or syllables in normal conversation.  \fISilence_len\fR
is specified in 100 msec intervals.  If \fIsilence_len\fR is zero
and the \fIthreshold\fR parameter is non-zero, a default minimum will be
enforced.
.if t .sp
.if n .bp
The combination of the \fIthreshold\fR and \fIsilence_len\fR parameters
allow you to emulate the actions of a voice-activated recorder (also
known as VOX), which will result in smaller recordings.  

.SH Notes
Thresholding should be used with the \fIadj_table\fR parameter, particularly
when low threshold values are selected.  (See \fIsnd_compensate\fR() for
more information.)  If the hardware centerline is not adjusted, thresholding
may not work as expected.

When recording resumes after a period of silence, some silence may be
included in front of the first sample that exceeds the value \fIthreshold\fR.
The amount of "silence" will never exceed 2,100 samples.

Note that if the \fIblock\fR parameter is TRUE, \fIsnd_record\fR may not
return for indefinite periods of time when using \fIthreshold\fR mode.
It is suggested that \fIblock\fR be set to FALSE so that your code can
remain in control as much as possible.

If you are using \fIsnd_wait\fR(PSSJ) to determine the elapsed time of the
recording and thresholding being used, the elapsed time will not
increase during periods of silence.  The time reported by
\fIsnd_wait\fR(PSSJ) is the length of the furnished recording, after the
silence has been edited-out.

.SH Return Values
.IZ
.TZ
NOERROR Call succeeded.
.br
.TZ
INVALID Call not valid at this point (\fIsnd_init\fR(PSSJ) has
not been called).
.br
.TZ
BADSIZE The buffer was smaller than 100 bytes or it was too small to 
hold the requested time.
.br
.TZ
WOULDBLOCK      Three buffers are already queued and block was set
to \fBFALSE\fR.
.br
.OZ
.if t .bp
.if n .sp
.SH See Also
snd_init(PSSJ), snd_compensate(PSSJ), snd_amplify(PSSJ),
snd_file_record(PSSJ), snd_stop(PSSJ), snd_exit(PSSJ), snd_wait(PSSJ)

.SH Credit
\fISnd_record\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
410182

