.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH SND_PLAY PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_PLAY troff documentation \- Version 1(9) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.SH Name
.br
snd_play \- Plays a sound stored in RAM buffers.

.SH \fBSyntax\fR
.br
.B short far snd_play(pSound);
.br
.B SNDHDR far *pSound;
.br

.SH Description
\fISnd_play\fR queues a buffer containing sound specified by
\fIpSound\fR to be played.
The sound is expanded and stored in the buffers supplied to
\fIsnd_addbuf\fR(PSSJ).  The sound will not begin to play until the number
of buffers containing sounds that have been accumulated thus far is equal
to or greater than the \fItrigger\fR
parameter supplied to \fIsnd_init\fR(PSSJ).  \fISnd_play\fR returns
immediately unless there are no more buffers
available to queue the sound in.  If no buffers are available and
\fIsnd_play\fR has not finished expanding the specified sound, the player
is started regardless of the setting of \fItrigger\fR.

\fISnd_play\fR can be called repeatedly to output a series of sounds
contiguously. Sounds recorded at different sampling rates (5.5, 11 or
22KHz) can be played
together because the differences in the playback rates are handled
automatically by the player.

Once the player has started, it is up to the caller to make any additional 
calls to \fIsnd_play\fR at a rate that is greater than the rate that the
previously-supplied sounds are being played to keep sound output going
continuously.  If the caller cannot keep ahead of the player, periods of
silence will be inserted between sounds, each of which should not exceed
200 milliseconds.  The amount of silence depends on the given situation;
but could be infinite if the application fails to make a call to
\fIsnd_wait\fR(PSSJ), \fIsnd_flush\fR(PSSJ), \fIsnd_stop\fR(PSSJ) or
\fIsnd_exit\fR(PSSJ) before accepting keyboard input or performing a
lengthy non-sound related activity.

.SH Return Values

.IZ
.TZ
NOERROR Call succeeded.
.br
.TZ
INVALID Call not valid at this point (\fIsnd_init\fR(PSSJ) has
not been called).
.br
.OZ
.if t .sp
.if n .sp
.SH Notes
If the recorder is active when \fIsnd_play\fR is called, the recorder
will finish filling the specified buffers before \fIsnd_play\fR processes
a request. To stop the recorder immediately, call \fIsnd_stop\fR(PSSJ).
.if n .bp
.if t .sp
After all sounds in a group have been passed to \fIsnd_play\fR, a call to 
\fIsnd_flush\fR(PSSJ) or to \fIsnd_wait\fR(PSSJ) with the \fIwait\fR option
equal to TRUE must be made, or a maximum of 100 milliseconds of the end of
the combined sound provided to \fIsnd_play\fR will not be output.  
The remaining sound will be played at the beginning of the next sound
passed to \fIsnd_play\fR.

.SH See Also
snd_file_play(PSSJ), snd_stop(PSSJ), snd_cue(PSSJ),
snd_flush(PSSJ), snd_wait(PSSJ)

.SH Credit
\fISnd_play\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
410189

