.if t  .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH SND_INIT PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_INIT troff documentation \- Version 1(4) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.de IX
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 1.0i 1.5i 2.5i 3.5i 4.5i 5.5i
.if t  .in +0.5i
.if n  .in +1.0i
..
.de OX
.if t  .in -0.5i
.if n  .in -1.0i
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
..
.de TX
.if t  .ti -0.5i
.if n  .ti -1.0i
..
.de IR
.if t  .ta 2.0i
.if n  .ta 2.4i
.if t  .in +2.0i
.if n  .in +2.4i
..
.de OR
.if t  .in -2.0i
.if n  .in -2.4i
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
..
.SH \fBName\fR
.br
snd_init \- Initializes the sound chip, disables the joysticks, sets
options, and prepares to play or record.

.SH Syntax
.B short far snd_init(trigger, dma_channel, irq, options);
.br
.B u_short trigger;
.br
.B u_short dma_channel;
.br
.B u_short irq;
.br
.B u_short options;
.br

.SH Description

\fISnd_init\fR uses the provided parameters to initialize the
drivers within the PSSJ Digital Sound Toolkit. \fISnd_init\fR also
initializes variables and memory that the toolkit uses.

The buffers that are used by the PSSJ Digital Sound Toolkit are provided
to the toolkit prior to calling \fIsnd_init\fR by passing pointers to
one or more blocks of memory to the \fIsnd_addbuf\fR(PSSJ) call.

The \fItrigger\fR parameter is used to indicate the number of buffers that
will be allowed to accumulate before the player is forced to start playing
the sound.  A call to \fIsnd_flush\fR(PSSJ) or a call to \fIsnd_wait\fR(PSSJ)
or to \fIsnd_buf_wait\fR(PSSJ) with the \fIwait\fR option set to \fBTRUE\fR
will force the player to start before reaching the limit.  Setting
\fItrigger\fR to 0 causes the player to fill all the supplied buffers before
starting.  A minimum of two buffers must accumulate before the player starts.
If the \fItrigger\fR value is too low or there are not enough buffers
to sustain continuous playing, the resulting sound will be broken or
chopped.  If this occurs, increase the number of buffers and/or set
\fItrigger\fR to a higher value (or to zero).

A \fItrigger\fR value that is greater than the number of available buffers 
is treated as a zero, ie, the player will wait until all buffers are full 
before starting, unless \fIsnd_wait\fR(PSSJ) or \fIsnd_flush\fR(PSSJ) are called
first.  The number of available buffers at any instant can be up to three
less than the number that were created by calls to \fIsnd_addbuf\fR(PSSJ).

The \fIdma_channel\fR parameter tells the toolkit which DMA channel to use.
Supplying a 0 will default to DMA channel 1.  Due to various hardware
restrictions, only channels 1 and 3 can be used for sound.  On the Tandy
machines with built-in PSSJ sound hardware, the PSSJ chip can only use
channel 1.

\fIIrq\fR indicates which interrupt channel the sound hardware is set for. 
On the Tandy machines with built-in PSSJ sound hardware, the PSSJ chip can
only use interrupt number 7. Supplying a 0 will default to interrupt 7.

\fIOptions\fR presets various functions in the sound toolkit.  Once 
set, they will remain in effect until \fIsnd_exit\fR(PSSJ) is called.  These
are bit fields and all undefined bits should be set to zero.

.IZ
.TZ
FASTRAMP        Causes the switch to record from play, and from play to record 
to be performed instantly.  When this option is selected, a "click" will 
be produced at the output port each time operating modes are changed.

When this bit is set to zero, the change between operating modes is 
done as quietly as possible, but at the expense of time.  All other bits 
are reserved for future use and should be set to zero.
.OZ
.if t .bp
.if n .sp
Once \fIsnd_init\fR is called successfully, any interrupts received on the 
specified number are checked to see if they were generated by the sound 
hardware.  If this is not the case, control is transferred to the routine 
that previously handled this interrupt.  If this other routine is a transient
function, it must not delete the interrupt vector that the toolkit installed,
mask the interrupt, or remove itself from memory without first calling
\fIsnd_exit\fR(PSSJ).

.SH Return Values
.IZ
.TZ
NOERROR Call succeeded.  The toolkit functions are ready for use.
.br
.TZ
INITBUF Insufficient buffers were added before \fIsnd_init\fR was
called.
.br
.TZ
INIT64K All buffers spanned 64k addresses.  At least one buffer
provided to \fIsnd_addbuf\fR(PSSJ) needs to located where it does not span
a physical 64K boundary.
.br
.TZ
BADDMA  The DMA Channel requested is invalid.
.br
.TZ
BADIRQ  The IRQ number requested is invalid.
.br
.TZ
NOIRON  The sound hardware was not found.
.br
.OZ

.SH Special Notes
There is no way for \fIsnd_init\fR to check and confirm that the correct DMA
and interrupt channel have been specified.  Incorrect values will cause the
sound driver to malfunction and could crash the computer.

.SH \fBSee Also\fR
snd_exit(PSSJ), snd_addbuf(PSSJ)

.SH \fBCredit\fR
\fISnd_init\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
410184

