/*-------------------------------------------------------------------------*/
/*                                                                         */
/* DMEXEC.H - C version of the include file used by both the executive     */
/*            and exec users (both application and resources) to insure    */
/*            correct communication.                                       */
/*                                                                         */
/* This file is very general so that only one file must be included for    */
/* any program that uses the exec.                                         */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#ifndef DMEXEC_INCLUDED
#define DMEXEC_INCLUDED 1

/*-------------------------------------------------------------------------*/
/*                                                                         */
/* The following are the defines that define function parameter constants  */
/* and return values used in calls to the exec.                            */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#define DM_OK           1   /* value returned when exec request was succesful */
#define DM_ERROR       -1   /* value returned when an error in exec occured */
#define DM_NOT_ALLOWED -2   /* value returned when an illegal task sw call */
#define DM_DEFAULT      2   /* from DM_EXEC_INQ_DMCONFIG means DESK assigned */
#define DM_EXISTS      -2   /* value returned when trying to load a resource */
                            /* that already existed in 1988 deskmate system.*/

/* Bits set by DM_EXEC_INQ_PRODUCT */
#define DM_RUN_FLAG      4      /* This is the runtime version */
#define DM_COMPAT_FLAG   8      /* 1989 Runtime running with 1988 deskmate */
#define DM_SHELL_FLAG    10h    /* Desktop only "shell" product */
#define DM_DESKLINK      0x100  /* DeskLink active */
#define DM_TASKSWITCHING 0x200  /* Task switching is active */
#define DM_VERSION       0x8000 /* DM_EXEC_INQ_VERSION call available */

#define CLIP_EMPTY      0 /* These are the different clipboard type */
#define CLIP_TEXT       1 /* available to the applications. */
#define CLIP_BITMAP     2
#define CLIP_WORKSHEET  3
#define CLIP_FILER      4
#define CLIP_PAINT      5
#define CLIP_DRAW       6
#define CLIP_DRAW_TEXT  7
#define CLIP_MUSIC      8
#define CLIP_CALENDAR   9

#define ACC_BY_NAME  0xff /* to give the name of the accessory */

#endif

/* end of DMEXEC.H */
