/*----------------------------------------------------*/
/*                                                    */
/* DMDECL.H contains the DeskMate function prototypes */
/*                                                    */
/*----------------------------------------------------*/

    /* ----------------- *
     * Autoload Resource *
     * ----------------- */

#ifdef AUTOLOAD_INCLUDED
extern  void  autoload_bind_end( void );
extern  int   autoload_bind_init( void );
extern  int   autoload_set( AUTOLOAD *pAUTOLOAD );
#endif

    /* ----------------- *
     * Clipboard Manager *
     * ----------------- */

extern  void  dm_clear_clipboard( void );
extern  int   dm_clipboard_size( void );
extern  void  dm_free_clip_buffer( void );
extern  int   dm_get_clip_buffer( int far *lpLength,
                                  char far * far *lpBuffer );
extern  void  dm_get_clipboard_info( int far *lpType,
                                     int far *lpLength,
                                     char far * far *lpBuffer );
extern  int   dm_set_clipboard_info( int Type, int Length );

    /* ---------------------- *
     * Communications Manager *
     * ---------------------- */

#ifdef CSRCFG_INCLUDED
extern  int   com_call( char *pString, int Type );
extern  int   com_close( CPARMS *pCPARMS );
extern  void  com_disc( void );
extern  void  com_get_buffer_info( COM_BUFFER_INFO **pCOM_BUFFER_INFO );
extern  int   com_get_line_states( void );
extern  void  com_get_parms( CPARMS *pCPARMS );
extern  int   com_open( CPARMS *pCPARMS );
extern  int   com_put_char( char Character );
extern  int   com_put_string( char *pString );
extern  void  com_send_break( void );
extern  void  com_set_parms( CPARMS *pCPARMS );
extern  int   com_test_carrier( void );
#endif

    /* ----------------- *
     * Component Manager *
     * ----------------- */

#ifdef CSRCMPS_INCLUDED
extern  int   cmp_add( CMP_ROUTINES *pCMP_ROUTINES );
extern  int   cmp_close( int Handle, void *pCmp );
extern  void  cmp_delete( int Handle);
extern  void  cmp_draw( int Handle, void *pCmp );
extern  int   cmp_open( void *pCmp );
extern  int   cmp_run( int handle, void *pCmp );

extern  void  edt_clear( EDITFIELD *pEDITFIELD );
extern  void  edt_copy( EDITFIELD *pEDITFIELD );
extern  void  edt_cut( EDITFIELD *pEDITFIELD );
extern  void  edt_format_multi( EDITFIELD *pEDITFIELD );
#ifdef CSRFORM_INCLUDED
extern  void  edt_form_draw( FORM_HDR *pFORM_HDR, EDITFIELD *pEDITFIELD,
                             char CharXext, char CharYext );
#endif
extern  int   edt_paste( EDITFIELD *pEDITFIELD );
extern  int   edt_replace( EDITFIELD *pEDITFIELD, char far *pText,
                                   unsigned int Length);
extern  void  lb_sort_list( LISTBOX *pLISTBOX );
#endif

    /* --------------------- *
     * Configuration Manager *
     * --------------------- */

#ifdef CSRCFG_INCLUDED
extern  void  cfg_get_com_data( COM_STATE *pCOM_STATE );
extern  void  cfg_get_com_parms( CPARMS *pCPARMS );
extern  int   cfg_get_moreaccs( void );
extern  void  cfg_get_ms_data( MOUSE_CFG *pMOUSE_CFG );
extern  void  cfg_get_prt_data( PRINTER_CFG *pPRINTER_CFG );
#ifdef CSRVID_INCLUDED
extern  int   cfg_get_vid_color( VID_PALETTE *pVID_PALETTE );
#endif
extern  void  cfg_get_vid_driver( char *pVideoDriver );
extern  void  cfg_reset_temp_config( void );
extern  void  cfg_restore_cpi( void );
extern  int   cfg_set_com_data( COM_STATE *pCOM_STATE );
extern  int   cfg_set_com_parms(CPARMS *pCPARMS );
extern  void  cfg_set_dbl_click( int DoubleClickSpeed );
extern  void  cfg_set_moreaccs( int bAction );
extern  int   cfg_set_ms_data( MOUSE_CFG *pMOUSE_CFG );
extern  int   cfg_set_prt_data( PRINTER_CFG *pPRINTER_CFG );
extern  void  cfg_set_temp_config( void );
extern  void  cfg_set_temp_cpi( int NewCPI );
#ifdef CSRVID_INCLUDED
extern  int   cfg_set_vid_color( VID_PALETTE *pVID_PALETTE );
#endif
extern  int   cfg_write( void );
#endif

    /* ----------------- *
     * Database Resource *
     * ----------------- */

#ifdef DMDB_INCLUDED
extern  void  db_bind_end( void );
extern  int   db_bind_init( void );
extern  int   db_bind_read( int ReadFlag );
extern  void  db_end_read( void );
extern  int   db_mgr( int, ... );
#endif

    /* -------------- *
     * Desk Executive *
     * -------------- */

#ifdef DMEXEC_INCLUDED
extern  void          csr_access_end( void );
extern  int           csr_access_init( void );
extern  void          csr_end( void );
extern  int           csr_form_bind_end( void );
extern  int           csr_form_bind_init( void );
extern  int           csr_get_version( void );
extern  int           csr_init( void );
extern  int           csr_load_video_driver( char *pVidName );
extern  void          dm_acc_run( int, ... );
extern  int           dm_bind_resource( char *pResName, char *pResEntry );
extern  int           dm_clear_resource( char *pResName );
extern  int           dm_compat( char *pName );
extern  int           dm_dir_isithere( char *pName );
extern  void          dm_exec_dont_shed( void );
extern  int           dm_file_search( char *pFilename, char *pPathbuffer,
                                        int bFloppySearch);
extern  unsigned int  dm_get_mem( int nParagraphs );
extern  int           dm_inquire_critical_err( void );
extern  int           dm_inquire_desk_ver( void );
extern  int           dm_inquire_dmconfig( char far *pFarString );
extern  int           dm_inquire_floppy( int Drive );
extern  int           dm_inquire_product( void );
extern  void          dm_inquire_program( char *pName );
extern  int           dm_inquire_res( char *pBuffer );
extern  int           dm_inquire_res_ver( char *pResName );
extern  int           dm_inquire_taskid( void );
extern  void          dm_SetNextApp( char far *pName, char far *pParam );
extern  void          dm_SetOtherTask( char far *pName, char far *pParam );
extern  int           dm_task_count( void );
extern  int           dm_temp_resource( char *pResName, char *pResEntry );
extern  int           dm_yield( void );
extern  void          dmcsr_bind_end( void );
extern  void          dmcsr_bind_init( void );
extern  void          guf_bind_end( void );
extern  int           guf_bind_init( void );
extern  void          prguf_bind_end( void );
extern  int           prguf_bind_init( void );

#endif

    /* ------------------ *
     * Dialog Box Manager *
     * ------------------ */

#ifdef CSRCMPS_INCLUDED
extern  void  dlg_draw( DIALOG_BOX *pDIALOG_BOX );
extern  void  dlg_draw_frame( FRAME *pFRAME );
extern  int   dlg_run( DIALOG_BOX *pDIALOG_BOX );
#endif

    /* ------------------ *
     * Envronment Manager *
     * ------------------ */

#ifdef DMGUF_INCLUDED
extern int  env_open( struct env_defn *pEnvData );
extern int  env_get( struct env_defn *pEnvData );
extern int  env_add( struct env_defn *pEnvData );
extern int  env_replace( struct env_defn *pEnvData );
extern int  env_delete( struct env_defn *pEnvData );
extern int  env_write( struct env_defn *pEnvData );
extern int  env_close( struct env_defn *pEnvData );
#endif

    /* ------------- *
     * Event Manager *
     * ------------- */

#ifdef CSRBASE_INCLUDED
extern  int   event_add_edriver( EDRIVER *pEDRIVER );
extern  int   event_add_interp( INTERP *pEDRIVER );
extern  void  event_delete_edriver( int Handle );
extern  void  event_delete_interp( int Handle );
extern  void  event_get_uninterp( EVENT *pEVENT );
extern  void  event_purge( void );
extern  void  event_read( EVENT *pEVENT );
extern  void  event_scan( EVENT *pEVENT );
extern  void  event_write( EVENT *pEVENT );
#endif

    /* ---------------- *
     * File I/O Manager *
     * ---------------- */

#ifdef DMGUF_INCLUDED
extern  int  dmerrno;

extern  int          Current_Disk( void );
extern  int          Delete_File( char *Pathname );
extern  int          dlgbox_SaveAs( struct datafile_defn *pDataFile,
                                    char *saveas_bufr );
extern  int          dlgbox_Generic( char *pExtension, char *input_buf,
                                     int load_flag );
extern  int          dlgbox_Run( void );
extern  int          dlgbox_Run_this( char *pFilename, char *pDatafile );
extern  int          dm_file_search( char *pFilename, char *Pathbuffer,
                                     int bOnlyFlop );
extern  void         dosENDFIND( void );
extern  int          dosFINDFIRST( char *pPathname, int Attribute );
extern  int          dosFINDNEXT( void );
extern  void         dosSTARTFIND( char *pDTA );
extern  int          fil_force_close( int handle );
extern  int          FillWithDir( char *pPath, char *ppIndex[], char *pFiles,
                                                          int max, int swi );
extern  int          fil_access( char *pfilename );
extern  int          fil_close( int handle );
extern  int          fil_close_error_msg( void );
extern  void         fil_commit( int *pdmerrno, int FileHandle );
extern  int          fil_create( char *pFilename );
extern  int          fil_create_error_msg( void );
extern  int          fil_dup( int Handle );
extern  int          fil_lock_bytes( int Handle, long Offset, long Length );
extern  long         fil_lseek( int Handle, long Offset, int Flag );
extern  int          fil_lseek_error_msg( void );
extern  unsigned int fil_menu_merge( struct datafile_defn *pDataFile,
                                     int InFlag );
extern  int          fil_menu_new( struct datafile_defn *pDataFile );
extern  unsigned int fil_menu_open( struct datafile_defn *pDataFile,
                                    int OpenBox);
extern  void         fil_menu_page( void );
extern  int          fil_menu_quit( struct datafile_defn *pDataFile );
extern  int          fil_menu_run( struct datafile_defn *pDataFile );
extern  int          fil_menu_save( struct datafile_defn *pDataFile );
extern  int          fil_menu_saveas( struct datafile_defn *pDataFile );
extern  int          fil_open( char *pBuffer, int Attr );
extern  int          fil_open_error_msg( void );
extern  unsigned int fil_read( int Handle, char *pBuffer, unsigned int Length );
extern  int          fil_read_error_msg( void );
extern  unsigned int fil_read_far( int FileHandle, char *pDataBuffer,
                                unsigned int Length, unsigned int ReadSegment );
extern  int          fil_unlock_bytes( int Handle, long Offset, long Length );
extern  unsigned int fil_write( int Handle, char *pBuffer,
                                unsigned int Length );
extern  int          fil_write_error_msg( void );
extern  unsigned int fil_write_far( int FileHandle, char *pDataBuffer,
                               unsigned int Length, unsigned int WriteSegment );
extern  int          file_already_exists( char *pPath );
extern  long         get_free_space( int Drive );
extern  int          Get_Directory( char Drive, char *pPath );
extern  long         get_drive_map( void );
extern  int          is_floppy( unsigned char Drive );
extern  int          msgbox_SaveChanges( void );
extern  int          Path_Expand( char *pSource, char *pOutPath );
extern  int          qfn( char *pSource, char *pExpPath );
extern  int          Rename_File( char *pOldPathname, char *pNewPathname );
extern  int          Select_Disk( char Disk );
extern  int          Set_CPU_Speed( char Speed );
extern  int          Set_Directory(  char *pString );
extern  int          valid_drive( char *pDriveBuf );
extern  int          valid_filename( char *pFilename, char *pExtension );
extern  int          valid_filename_wild( char *pFilename,char *pExtension );
#endif

    /* ------------- *
     * Form Resource *
     * ------------- */

#ifdef CSRFORM_INCLUDED
extern  int       form_add_element( FORM_HDR *pFORM_HDR, void *pElement );
extern  int       form_add_stroke( FORM_HDR *pFORM_HDR,
                                  char *pStrokeDefinition);
extern  int       form_break_object( FORM_HDR *pFORM_HDR, int ElementTag );
extern  void      form_clear( FORM_HDR *pFORM_HDR );
extern  void      form_compress( FORM_HDR *pFORM_HDR );
extern  int       form_copy_element( FORM_HDR *pFORM_HDR, int ElementTag );
extern  int       form_copy_group( FORM_HDR *pFORM_HDR );
extern  int       form_cut_element( FORM_HDR *pFORM_HDR, int ElementTag );
extern  int       form_cut_group( FORM_HDR *pFORM_HDR );
extern  int       form_define_group( FORM_HDR *pFORM_HDR, FORM_DST *pFORM_DST );
extern  int       form_delete_element( FORM_HDR *pFORM_HDR, int ElementTag);
extern  int       form_delete_group( FORM_HDR *pFORM_HDR );
extern  int       form_delete_stroke( FORM_HDR *pFORM_HDR, int StrokeID );
extern  void      form_delete_unused_strokes( FORM_HDR *pFORM_HDR );
#ifdef CSRBASE_INCLUDED
extern  void      form_display_region( FORM_HDR *pFORM_HDR, MAPRECT *pMAPRECT );
#endif
extern  int       form_dup_element( FORM_HDR *pFORM_HDR, int ElementTag,
                                    FORM_DST *pFORM_DST );
extern  int       form_dup_group( FORM_HDR *pFORM_HDR, FORM_DST *pFORM_DST );
extern  int       form_element_to_bottom( FORM_HDR *pFORM_HDR, int ElementTag );
extern  int       form_element_to_top( FORM_HDR *pFORM_HDR, int ElementTag );
extern  void      form_expand( FORM_HDR *pFORM_HDR, int HowMuchList,
                               int HowMuchStroke );
extern  int       form_find_element( FORM_HDR *pFORM_HDR, int x, int y, int n );
extern  char     *form_find_stroke( FORM_HDR *pFORM_HDR, int StrokeID );
extern  ELEMENT  *form_get_pointer( FORM_HDR *pFORM_HDR, int ElementTag );
extern  long      form_get_xy_extents( FORM_HDR *pFORM_HDR );
extern  int       form_group_to_bottom( FORM_HDR *pFORM_HDR );
extern  int       form_group_to_top( FORM_HDR *pFORM_HDR );
extern  int       form_make_object( FORM_HDR *pFORM_HDR );
extern  int       form_mod_attr( FORM_HDR *pFORM_HDR, int element,
                                 FORM_ATTR *pFORM_ATTR );
extern  int       form_mod_grp_attr( FORM_HDR *pFORM_HDR,
                                     FORM_LINE *pFORM_LINE );
extern  int       form_move_element( FORM_HDR *pFORM_HDR, int ElementTag,
                                     FORM_DST *pFORM_DST );
extern  int       form_move_group( FORM_HDR *pFORM_HDR, FORM_DST *pFORM_DST );
extern  void      form_open( FORM_HDR *pFORM_HDR );
extern  int       form_paste( FORM_HDR *pFORM_HDR );
#ifdef CSRBASE_INCLUDED
extern  int       form_region_empty( FORM_HDR *pFORM_HDR, MAPRECT *pMAPRECT );
#endif
extern  int       form_replace_element( FORM_HDR *pFORM_HDR, int ElementTag,
                                        FORM_LINE *pFORM_LINE );
extern  void      form_scroll_down( FORM_HDR *pFORM_HDR, int x );
extern  void      form_scroll_left( FORM_HDR *pFORM_HDR, int x );
extern  void      form_scroll_right( FORM_HDR *pFORM_HDR, int x );
extern  void      form_scroll_up( FORM_HDR *pFORM_HDR, int x );
extern  int       form_specify_group( FORM_HDR *pFORM_HDR, int *pTags,
                                                           int nTags );
extern  void      form_update( FORM_HDR *pFORM_HDR, int ClearScreen );
#endif

    /* ----------------- *
     * Far Form Resource *
     * ----------------- */

#ifdef CSRFORM_INCLUDED
extern  int       fform_add_element( FORM_HDR far *pFORM_HDR,
                                     void far *pElement );
extern  int       fform_add_stroke( FORM_HDR *pFORM_HDR,
                                    char far *pStrokeDefinition);
extern  int       fform_break_object( FORM_HDR far *pFORM_HDR, int ElementTag );
extern  void      fform_clear( FORM_HDR far *pFORM_HDR );
extern  void      fform_compress( FORM_HDR far *pFORM_HDR );
extern  int       fform_copy_element( FORM_HDR far *pFORM_HDR, int ElementTag );
extern  int       fform_copy_group( FORM_HDR far *pFORM_HDR );
extern  int       fform_cut_element( FORM_HDR far *pFORM_HDR, int ElementTag );
extern  int       fform_cut_group( FORM_HDR far *pFORM_HDR );
extern  int       fform_define_group( FORM_HDR far *pFORM_HDR,
                                      FORM_DST far *pFORM_DST );
extern  int       fform_delete_element( FORM_HDR far *pFORM_HDR,
                                        int ElementTag);
extern  int       fform_delete_group( FORM_HDR far *pFORM_HDR );
extern  int       fform_delete_stroke( FORM_HDR far *pFORM_HDR, int StrokeID );
extern  void      fform_delete_unused_strokes( FORM_HDR far *pFORM_HDR );
#ifdef CSRBASE_INCLUDED
extern  void      fform_display_region( FORM_HDR far *pFORM_HDR,
                                        MAPRECT far *pMAPRECT );
#endif
extern  int       fform_dup_element( FORM_HDR far *pFORM_HDR, int ElementTag,
                                    FORM_DST far *pFORM_DST );
extern  int       fform_dup_group( FORM_HDR far *pFORM_HDR,
                                   FORM_DST far *pFORM_DST );
extern  int       fform_element_to_bottom( FORM_HDR far *pFORM_HDR,
                                           int ElementTag );
extern  int       fform_element_to_top( FORM_HDR far *pFORM_HDR,
                                        int ElementTag );
extern  void      fform_expand( FORM_HDR far *pFORM_HDR, int HowMuchList,
                               int HowMuchStroke );
extern  int       fform_find_element( FORM_HDR far *pFORM_HDR, int x, int y,
                                      int n );
extern  char     *fform_find_stroke( FORM_HDR far *pFORM_HDR, int StrokeID );
extern  long      fform_get_extents( FORM_HDR far *pFORM_HDR );
extern  ELEMENT  *fform_get_pointer( FORM_HDR far *pFORM_HDR, int ElementTag );
extern  int       fform_group_to_bottom( FORM_HDR far *pFORM_HDR );
extern  int       fform_group_to_top( FORM_HDR far *pFORM_HDR );
extern  int       fform_make_object( FORM_HDR far *pFORM_HDR );
extern  int       fform_mod_attr( FORM_HDR far *pFORM_HDR, int element,
                                 FORM_ATTR far *pFORM_ATTR );
extern  int       fform_mod_grp_attr( FORM_HDR far *pFORM_HDR,
                                     FORM_LINE far *pFORM_LINE );
extern  int       fform_move_element( FORM_HDR far *pFORM_HDR, int ElementTag,
                                     FORM_DST far *pFORM_DST );
extern  int       fform_move_group( FORM_HDR far *pFORM_HDR,
                                    FORM_DST far *pFORM_DST );
extern  void      fform_open( FORM_HDR far *pFORM_HDR );
extern  int       fform_paste( FORM_HDR far *pFORM_HDR );
#ifdef CSRBASE_INCLUDED
extern  int       fform_region_empty( FORM_HDR far *pFORM_HDR,
                                      MAPRECT far *pMAPRECT );
#endif
extern  int       fform_replace_element( FORM_HDR far *pFORM_HDR,
                                         int ElementTag,
                                         FORM_LINE far *pFORM_LINE );
extern  void      fform_scroll_down( FORM_HDR far *pFORM_HDR, int x );
extern  void      fform_scroll_left( FORM_HDR far *pFORM_HDR, int x );
extern  void      fform_scroll_right( FORM_HDR far *pFORM_HDR, int x );
extern  void      fform_scroll_up( FORM_HDR far *pFORM_HDR, int x );
extern  int       fform_specify_group( FORM_HDR far *pFORM_HDR, int *pTags,
                                                           int nTags );
extern  void      fform_update( FORM_HDR far *pFORM_HDR, int ClearScreen );
#endif

    /* ------------------------ *
     * Intellegent Help Manager *
     * ------------------------ */

extern  void            help_disable_high( void );
extern  void            help_enable_high( void );
#ifdef DMGUF_INCLUDED
extern  int             hlp_notify( NOTIFY *pNOTIFY );
#endif
extern  void            hlp_stop_notify( void );
extern  int             ihm_add_state( int StateNum, char *pBuffer );
extern  int             ihm_delete_state( int StateNum );
extern  void            ihm_new_entry( int Type, char *pCMP );
extern  int             ihm_status( void );

    /* ----------------------- *
     * Information Box Manager *
     * ----------------------- */

#ifdef CSRCMPS_INCLUDED
extern  void  info_draw( INFO_BOX *pINFO_BOX );
extern  void  info_draw_icon( INFO_ICON *pINFO_ICON );
extern  void  info_put_string( INFO_STRING *pINFO_STRING );
#endif

    /* ---------------- *
     * Keyboard Manager *
     * ---------------- */

extern  void            kbd_flush( void );
extern  unsigned int    kbd_read( void );
extern  unsigned int    kbd_scan( void );

    /* ---------------- *
     * Library routines *
     * ---------------- */

#ifdef DMGUF_INCLUDED
extern  void           about_versions( APPL_VERSION *pAPPL_VERSION );
extern  int            cnvrt_to_julian( char *pDate, char *pBuf,
                                        PDMINTL *pPDMINTL );
extern  int            cnvrt_to_std( char *pDate, char *pBuf,
                                     PDMINTL *pPDMINTL );
#endif
extern  int            compare_chars( unsigned char c1, unsigned char c2 );
extern  int            comp_chars_ins( unsigned char c1, unsigned char c2 );
extern  int            get_intl( struct pdmintl_desc *pIntl );
extern  int            get_month_strings( void );
extern  int            get_lang_code( void );
extern  int            str_upper( char *pString );
extern  unsigned char  to_upper( unsigned char Character );
extern  void           waitloop(int xsshh);

    /* --------------- *
     * Menubar Manager *
     * --------------- */

#ifdef CSRBASE_INCLUDED
extern  int   mb_add_alarm( ALARM *pALARM );
extern  int   mb_delete_alarm( ALARM *pALARM );
#endif
extern  void  mb_disable( void );
#ifdef CSRCMPS_INCLUDED
extern  int   mb_draw( MENUBAR *pMENUBAR );
#endif
extern  void  mb_enable( void );
extern  void  mb_erase( void );
extern  int   mb_get_status( void );

    /* ------------------- *
     * Message Box Manager *
     * ------------------- */

#ifdef CSRCMPS_INCLUDED
extern  void          msg_draw( MSGBOX *pMSGBOX );
extern  unsigned int  msg_run( MSGBOX *pMSGBOX );
#endif

    /* ------------- *
     * Mouse Manager *
     * ------------- */

#ifdef CSRBASE_INCLUDED
extern  int  ms_add_region( PTR_REGION *pPTR_REGION );
#endif
extern  int  ms_default_pointer( void );
extern  int  ms_define_pointer( char FocalX, char FocalY, char *pImage );
extern  int  ms_delete_region( char id );
extern  int  ms_disable_driver( void );
extern  int  ms_disable_regions( void );
extern  int  ms_draw_pointer( void );
extern  int  ms_enable_driver( void );
extern  int  ms_enable_regions( void );
extern  int  ms_erase_pointer( void );
#ifdef CSRBASE_INCLUDED
extern  int  ms_get_status( MOUSE_STAT *pMOUSE_STAT );
#endif

    /* --------------------------------- *
     * Print Manager (Device and Direct) *
     * --------------------------------- */

extern  int             ptd_close(void);
#ifdef CSRPRT_INCLUDED
#ifdef CSRFORM_INCLUDED
extern  int           ptd_draw_list( FORM_HDR *pFORM_HDR, char Column,
                                      char CPIMode );
#endif
extern  void          ptd_get_page( PGSETUP *pSetup, PGMODE *pMode );
#endif
extern  int           ptd_new_line( void );
extern  int           ptd_open( int Devices );
extern  int           ptd_preload( void );
extern  int           ptd_print_far_page( const char bLastPage,
                                           const int Segment );
extern  int           ptd_print_page( const char bLastPage );
extern  int           ptd_put_nchars( const char *pStr, const int Len );
extern  int           ptd_put_nchars_x( const char *pStr, const int Len,
                                         const int Margin );
extern  int           ptd_select( const int DevTyp, const int FileHandle );
#ifdef CSRPRT_INCLUDED
extern  void          ptd_set_page( PGSETUP *pSetup, PGMODE *pMode );
#endif
extern  void          ptd_start_page( const char AttrOverride );
extern  void          prt_close( void );
#ifdef CSRPRT_INCLUDED
extern  int           prt_get_printer( PRINTER *pPRINTER );
#endif
extern  int           prt_open( void );
extern  int           prt_put_char( const char Character );
extern  unsigned int  prt_put_nchars( const char *pStr, const int Len );
extern  int           prt_put_tty( const char Character );

    /* -------------- *
     * Spell Resource *
     * -------------- */

extern  void  spell_bind_end( void );
extern  int   spell_bind_init( void );
extern  int   spl_add_cache_word( char *pWord );
extern  int   spl_add_user_word( char *pWord );
#ifdef CSRCMPS_INCLUDED
extern  int   spl_check_edit( EDITFIELD *pEDITFIELD );
#endif
#ifdef SPELL_INCLUDED
extern  int   spl_check_text( SPELL *pSPELL );
#endif
extern  int   spl_check_word( char *pWord );
extern  int   spl_delete_user_word( char *pWord );
extern  int   spl_get_alternates( char *pWord, char *pBuffer );
extern  int   spl_init_cache( void );
extern  int   spl_init_user_dict( void );
extern  void  spl_update_user_dict( void );

    /* ------------------ *
     * Thesaurus Resource *
     * ------------------ */

extern  void  thes_bind_end( void );
extern  int   thes_bind_init( void );
extern  int   thes_get_syn( char *pWordBuffer );
#ifdef DMTHES_INCLUDED
extern  int   thes_get_text_syn( THES *pTHES );
#endif

    /* ----------------- *
     * Titleline Manager *
     * ----------------- */

extern  void  ttl_disable_update( void );
extern  void  ttl_enable_update( void );
extern  void  ttl_put_app_name( char *pString );
extern  void  ttl_put_data_name( char *pString );

    /* ------------- *
     * Video Manager *
     * ------------- */

#ifdef CSRFORM_INCLUDED
extern  void            fvid_draw_form( FORM_HDR far *fpFORM_HDR,
                                                  int Xorg, int Yorg );
extern  int             fvid_draw_form_element( FORM_HDR far *fpFORM_HDR,
                                                  int ElementTag );
extern  void            fvid_get_bounding_box( FORM_U_ARC far *fpFORM_U_ARC );
#endif
extern  void            vid_busy_disable( void );
extern  void            vid_busy_enable( void );
extern  void            vid_clear_block( int XOrg, int YOrg,
                                         int XExt, int YExt);
extern  void            vid_clear_screen( void );
extern  void            vid_clear_to_bot( void );
extern  void            vid_clear_to_eol( void );
extern  int             vid_dcx_to_wcx( int DcX );
extern  int             vid_dcy_to_wcy( int DcY );
extern  void            vid_delete_line( int YOrg );
extern  void            vid_delete_nchars( const int NumChars );
#ifdef CSRBASE_INCLUDED
extern  void            vid_draw_arc( ARC *pARC );
#endif
extern  void            vid_draw_bev_rect( int wcx1, int wcy1, int wcx2,
                                           int wcy2, char Bevel, char bFill );
extern  void            vid_draw_busy_icon( void );
extern  void            vid_draw_cursor( void );
extern  void            vid_draw_ellipse( int wcXOrg, int wcYOrg, int wcXRad,
                                          int xcYRad, char bFill );
#ifdef CSRFORM_INCLUDED
extern  void            vid_draw_form( FORM_HDR *pFORM_HDR,
                                       int XOrg, int YOrg );
extern  int             vid_draw_form_element( FORM_HDR *pFORM_HDR,
                                               int ElementTag );
#endif
#ifdef CSRBASE_INCLUDED
extern  void            vid_draw_frame( STATIC_BOX *pSTATIC_BOX );
#endif
extern  void            vid_draw_line( int wcX1, int wcY1, int wcX2, int wcY2 );
extern  void            vid_draw_point( int wcX, int wcY );
extern  void            vid_draw_polygon( char *pPointList, int Num );
extern  void            vid_draw_polyline( char *pPointList, int Num );
extern  void            vid_draw_rect( int wcX1, int wcY1, int wcX2, int wcY2,
                                       char bFill);
#ifdef CSRBASE_INCLUDED
extern  void            vid_draw_stroke( char *pStroke, MAPRECT *pMapRect,
                                         char Rotate );
#endif
extern  void            vid_erase_cursor( void );
extern  void            vid_fill_block(int wcX1, int wcY1, int wcX2, int wcY2,
                                       char Pattern );
#ifdef CSRVID_INCLUDED
extern  void            vid_get_attrs( VID_ATTRS *pVID_ATTRS );
#endif
#ifdef CSRFORM_INCLUDED
extern  void            vid_get_bounding_box( FORM_U_ARC *pFORM_U_ARC );
#endif
extern  unsigned int    vid_get_buffer_size( int XOrg, int YOrg, int XExt,
                                             int YExt );
#ifdef CSRBASE_INCLUDED
extern  void            vid_get_clip( MAPRECT *pMAPRECT );
#endif
extern  char *          vid_get_far_screen( int XOrg, int YOrg,
                                            int XExt, int YExt);
#ifdef CSRVID_INCLUDED
extern  void            vid_get_palette( VID_PALETTE *pVID_PALETTE );
#endif
extern  void            vid_get_screen( int XOrg, int YOrg, int XExt, int YExt,
                                        char *pBuffer);
#ifdef CSRBASE_INCLUDED
extern  void            vid_get_viewport( MAPRECT *pMaprect );
extern  void            vid_get_world( MAPRECT * pMaprect );
#endif
#ifdef CSRVID_INCLUDED
extern  void            vid_inquire_colors( VID_COLORS *pVID_COLORS );
extern  void            vid_inquire_device( VID_DEVICE *pVID_DEVICE );
#endif
extern  void            vid_insert_char( const unsigned char Character );
extern  void            vid_insert_line( int YOrg );
extern  void            vid_invert_block(int XOrg, int YOrg, int XExt,
                                         int YExt);
#ifdef CSRVID_INCLUDED
extern  int             vid_loadable_drivers( VID_SWAP_INFO *pVID_SWAP_INFO );
#endif
extern  int             vid_memory_free( void );
#ifdef CSRVID_INCLUDED
extern  int             vid_memory_info( VID_MEMORY *pVID_MEMORY );
#endif
extern  int             vid_memory_inuse( void );
extern  void            vid_move_cursor( int wcx, int wcy );
extern  int             vid_next_nwcx( int wcx );
extern  int             vid_next_nwcy( int wcy );
extern  int             vid_nextn_nwcx( int wcx, int n );
extern  int             vid_nextn_nwcy( int wcy, int n );
extern  int             vid_prev_nwcx( int wcx );
extern  int             vid_prev_nwcy( int wcy );
extern  int             vid_prevn_nwcx( int wcx, int n );
extern  int             vid_prevn_nwcy( int wcy, int n );
extern  void            vid_put_attr_nchars( const char *pString,
                                             const int Length );
extern  void            vid_put_char( const unsigned char Character );
extern  void            vid_put_far_screen( int XOrg, int YOrg,
                                            int XExt, int YExt, char *pBuffer);
#ifdef CSRVID_INCLUDED
extern  void            vid_put_image( IMAGE *pIMAGE );
#endif
extern  void            vid_put_nchars( const char *pString, const int Length );
extern  void            vid_put_screen( int XOrg, int YOrg, int XExt, int YExt,
                                        char *pBuffer);
extern  void            vid_put_string( const unsigned char *pString );
extern  void            vid_put_tty( const unsigned char Character );
extern  void            vid_read_cursor( int *pWcX, int *pWcY );
extern  void            vid_restore_screen( void );
extern  void            vid_save_screen( int XOrg, int YOrg,
                                         int XExt, int YExt );
extern  void            vid_scroll_down( int YExt );
extern  void            vid_scroll_down_no_clear( int YExt );
extern  void            vid_scroll_left( int XExt );
extern  void            vid_scroll_left_no_clear( int XExt );
extern  void            vid_scroll_right( int XExt );
extern  void            vid_scroll_right_no_clear( int XExt );
extern  void            vid_scroll_up( int YExt );
extern  void            vid_scroll_up_no_clear( int YExt );
#ifdef CSRVID_INCLUDED
extern  void            vid_set_attrs( VID_ATTRS *pVID_ATTRS );
#endif
extern  void            vid_set_char_attr( char CharAttr );
extern  void            vid_set_char_size( int XExt, int YExt );
#ifdef CSRBASE_INCLUDED
extern  void            vid_set_clip( MAPRECT *pMaprect );
#endif
extern  void            vid_set_clip_to_window( void );
extern  void            vid_set_colors( int Background, int Foreground );
extern  void            vid_set_cursor_type( char Type, int Extent, char Color,
                                            ... );
extern  void            vid_set_line_attr( char, int, char, ... );
#ifdef CSRVID_INCLUDED
extern  int             vid_set_palette( VID_PALETTE *pVID_PALETTE );
#endif
extern  void            vid_set_pattern( char Pattern );
#ifdef CSRBASE_INCLUDED
extern  void            vid_set_viewport( MAPRECT *pMAPRECT );
extern  void            vid_set_world( MAPRECT *pMAPRECT );
#endif
extern  int             vid_wcx_to_dcx( int wcx );
extern  int             vid_wcy_to_dcy( int wcy );
extern  int             vid_wcx_to_nwcx( int wcx );
extern  int             vid_wcy_to_nwcy( int wcy );

    /* -------------- *
     * Window Manager *
     * -------------- */

extern  int   win_activate( int Handle );
extern  void  win_close( int Handle );
extern  int   win_get_active( void );
extern  void  win_group_end( void );
extern  int   win_group_init( void );
#ifdef CSRBASE_INCLUDED
extern  int   win_open( MAPRECT *pMAPRECT );
#endif
