/*------------------------------------------------------------------------*/
/*                                                                        */
/* CSRCFG.H Configuration Include File for DMCSR                          */
/*                                                                        */
/* Last update: 10/25/89                                                  */
/*                                                                        */
/*------------------------------------------------------------------------*/

#ifndef CSRCFG_INCLUDED
#define CSRCFG_INCLUDED 1

#define DRIVER_NAME_SIZE   13  /* size of driver names in bytes */

/* Printer configuration */
struct printer_cfg_defn
{
    char    bAutoLF;                   /* CR_ONLY or CR_WITH_LF */
    char    port;                      /* selected port */
    char    driver[DRIVER_NAME_SIZE];  /* driver filename */
    char    id;                        /* driver sub-id */
    char    cpi;                       /* characters per inch */
    char    bPause;                    /* pause between pages flag */
};
typedef struct printer_cfg_defn PRINTER_CFG;

#define PRT_LPT1    0
#define PRT_LPT2    1
#define PRT_LPT3    2

#define PRT_10_CPI  0
#define PRT_12_CPI  1
#define PRT_16_CPI  2

/* Mouse */
struct mouse_cfg_defn
{
    char    bSelected;                 /* indicates if user wants a mouse */
    char    click_speed;               /* double click timeout value */
    char    port;                      /* mouse driver port */
    char    driver[DRIVER_NAME_SIZE];  /* filename of the mouse driver */
};
typedef struct mouse_cfg_defn MOUSE_CFG;

#define MS_MAX_CLICK_SPEED  4

#define MS_COMPORT1 0
#define MS_COMPORT2 1

/* Communications */
struct cparms_defn
{
    char    bXon;           /* Xon/Xoff enable flag */
    char    bASCfilter;     /* ASCII filter enable flag */
    char    bLFfilter;      /* line filter enable flag */
    char    bStatus;        /* com port status flag (OPEN or CLOSED) */
    char    bCarrier;       /* carrier det stat flag (CARRY/NO_CARRY) */
    int     baud_rate;      /* line speed setting */
    char    word_size;      /* 7 or 8 */
    char    parity;         /* EVEN_PARITY, ODD_PARITY or NO_ PARITY */
    char    stop_bits;      /* 1 or 2 */
};
typedef struct cparms_defn CPARMS;

struct com_buffer_info_defn
{
    char    far   *rs232_start_ptr;
    char    far   *rs232_end_ptr;
    char    far   *input_ptr;
    char    far   *output_ptr;
    int	    		rs232_buf_size;
    int           count_num;
    char          xon_xoff_flag;
};
typedef struct com_buffer_info_defn COM_BUFFER_INFO;

struct com_state_defn
{
    char    com_port;     /* COM1 or COM2 */
    char    line_type1;   /* DIRECT or MODEM */
    char    modem1;       /* modem name index */
    char    line_type2;   /* DIRECT or MODEM */
    char    modem2;       /* modem name index */
};
typedef struct com_state_defn COM_STATE;

/* Parity settings */
#define NO_PARITY       0
#define ODD_PARITY      1
#define EVEN_PARITY     2

/* Port addresses */
#define COM1            0
#define COM2            1

/* Line types */
#define MODEM           1           /* modem is attatched to line */
#define DIRECT          0           /* direct connect line */

/* Port status */
#define PORT_OPEN       1           /* terminal active - dtr and rts */
#define PORT_CLOSED     0           /* terminal not ready - no dtr or rts */

/* Carrier state */
#define CARRY           1
#define NO_CARRY        0

/* Help Level values */
#define CFG_NEW_USER          0
#define CFG_BEGINNING_USER    1
#define CFG_INTERMEDIATE_USER 2
#define CFG_EXPERT_USER       3

#endif

/* end of CSRCFG.H */
