; T1KKEY A program to change F11 and F12 into the IBM PC's
;  GREY - and GREY + keys
; Author: Charles McGuinness
;  CompuServe, Incorporated
; Adapted by John Kendall, Denver
;  so that F11 and F12 behave normally if NumLock is ON

intip equ 58h
intcs equ 5ah ; our vectors!

 assume cs:cseg,ds:cseg

cseg segment para public 'CODE'
 org 100h
start proc far
 push ds
 mov ax,0
 push ax  ; set up return address
 mov es,ax  ; Zero the ES to get to low mem
 mov ax,cs
 mov ax,es:intip
 mov oldip,ax
 mov ax,es:intcs
 mov oldcs,ax
 mov word ptr es:intip,offset myint
 mov ax,cs
 mov word ptr es:intcs,ax
 mov dx,offset theend
 int 27h  ; stick around....
start endp

myint proc far
 cmp ah,0
 je simint
 jmp cs:dword ptr oldip

simint:
 pushf
 call cs:dword ptr oldip
 cmp al,98h    ; if it's under 98, can't be F11 or F12
 jl  endmyint  ; so leave early
 push ax       ; begin test
 mov ah,2      ; read status bit
 int 16h
 and al,20h    ;test bit 5 
 pop ax        ;get code info back
 jnz endmyint  ;numlock is on - don't process
 cmp ax,9800h  ;else continue
 je gotf11
 cmp ax,9900h
 jne endmyint
 mov ax,4e2bh
 jmp endmyint
gotf11: mov ax,4a2dh
endmyint:
 iret
myint endp

oldip: dw
oldcs: dw

theend equ $
cseg ends
 end start

