;********************** TRANSIENT INSTALLATION DATA
;
; End of resident code.
;
END_RESIDENT	EQU	$
		;
		; Quickcheck flag.  0 = long check, 0FFh = quick check
		;
QUICKCHECK	DB	0		; initially do long check
		;
		; Message displayed at start up.
		;
STARTMSG	DB	0Dh,0Ah
		DB	"LIM EMS 4.1 driver for Micro Mainframe 5150 "
		DB	"EMS cards"
		DB	0Dh,0Ah
		DB	"  - freeware by J.L. Hayes"
		DB	0Dh,0Ah,"$"
		;
		; Message displayed if no EMS cards are installed.
		;
NOBOARDSMSG	DB	"No EMS cards found, driver not installed."
		DB	0Dh,0Ah,"$"
		;
		; Messages for memory check display.
		;
BOARDMSG1	DB	0Dh,0Ah,"Board $"
BOARDMSG2	DB	":",0Dh,0Ah,0Dh,0Ah
		DB	"  Bank    16k Pages    (* = good, X = bad)"
		DB	0Dh,0Ah,"$"
BANKMSG1	DB	"    $"
BANKMSG2	DB	"  $"
		;
		; Carriage return/line feed, general purpose.
		;
CRLFMSG		DB	0Dh,0Ah,"$"
		;
		; Boards installed/number of EMS pages messages.
		;
BDSINSTLDMSG	DB	" boards installed      $"
EMSPAGESMSG	DB	" 16k EMS pages",0Dh,0Ah,"$"
		;
		; Compatibility mode messages.
		;
COMPATMSG1	DB	"Compatibility mode $"
COMPATMSG2	DB	"not set",0Dh,0Ah,"$"
COMPATMSG3	DB	"set",0Dh,0Ah,"$"

;*********************** TRANSIENT INSTALLATION CODE            
;
; Request structure for INIT routine.
;
INITREQ		STRUC 	[BX]
		DB	2 DUP (?)
COMMANDCODE	DB	?
REQSTATUS	DW	?
		DB	8 DUP (?)
NUMUNITS	DB	?
FREEMEMOFFS	DW	?
FREEMEMSEG	DW	?
CONFIGPTR	DD	?
		ENDS
;
; Init routine.  This routine must process the command line parameters, 
; determine the installation status of the memory boards and test them, 
; and set the following variables:
;	TRANSLATEARRAY
;	COMPATIBILITY
;	DRIVERSEG
;	NUMBOARDS
;	UNALLOCPAGES
;	TOTALPAGES
;       INSTALLED
;	PAGEALLOC
;
INIT:		LDS	BX,CS:REQUESTPTR
		;
		; Check command line for /Q or /C.  Set flags if present.
		;
		CLD
		LDS	SI,CONFIGPTR
		MOV	CX,80
INIT_CMDLOOP:	LODSB
		CMP	AL,0Dh
		JE	INIT_UNMAP_ALL
		CMP	AL,0Ah
		JE	INIT_UNMAP_ALL
		CMP	AL,'/'
		LOOPNE	INIT_CMDLOOP
		;
		; Option found, or 80 chars done.
		;
L0:		JCXZ	INIT_UNMAP_ALL
		;
		; Option found.
		;
		LODSB
		CMP	AL,'C'
		JNE	>L1
		MOV	CS:COMPATIBILITY,0FFh
		DEC	CX
		JMP	L0
L1:		CMP	AL,'Q'
		LOOPNE	INIT_CMDLOOP
		MOV	CS:QUICKCHECK,0FFh
		JMP	L0
                ;                                                               
                ; Unmap all pages.                                              
                ;                                                               
INIT_UNMAP_ALL: MOV     DX,208h                                               
		MOV     AL,0                                                 
		MOV     CX,4                                               
L0:		PUSH    CX                                                      
		PUSH    DX                                                      
		MOV     CX,4                                               
L1:		OUT     DX,AL                                                   
		ADD     DX,2                                                 
		LOOP    L1                                                  
		POP     DX                                                      
		POP     CX                                                      
		ADD     DX,4000h                                                
		LOOP    L0                                                  
		;
		; (DS addresses driver segment.)
		;
		PUSH	CS
		POP	DS
		;
		; Display startup message.
		;
		MOV	DX,OFFSET STARTMSG
		MOV	AH,9
		INT	21h
		;
		; Determine which cards (0-3) are installed:
		;
		; Check for I/O ports at 208h, 20Ah, 20Ch, and 20Eh.  Write
		; the low 8 bits of the port number to each port.
		;
		MOV     CX,4
		MOV     DX,208h
L0:		MOV     AL,DL
		OUT     DX,AL
		ADD     DX,2
		LOOP    L0
		;
		; Read back from each port.  BX is the card number.
		; 
		MOV     BX,0
		MOV     CX,4
		MOV     DX,208h
INIT_CHECK_BDS_LOOP:		
		IN      AL,DX
		;
		; If the value read back does not equal the low 8 bits of the
		; port number, there's no EMS card here.  Continue to next
		; port.
		; 
		CMP     AL,DL
		JNZ     >L1
		; 
		; Make sure:  write 55h, read it back.  If not read back,
		; continue to next port.
		; 
		MOV     AL,55h
		OUT     DX,AL
		IN      AL,DX
		CMP     AL,55h
		JNZ     >L1
		; 
		; Write 0AAh, read it back.  If not read back, continue to
		; next port.
		; 
		MOV     AL,0AAh
		OUT     DX,AL
		IN      AL,DX
		CMP     AL,0AAh
		JNZ     >L1
		;
		; Mark board as present, add to number of boards installed.
		;
		MOV	INSTALLED[BX],0
		INC	NUMBOARDS
		; 
		; Write 0 to the port to unmap the page we just mapped.
		; (Writing 0AAh to port 208h maps hardware page 42 into
		; physical page one, for example.)
		; 
L1:		MOV     AL,0
		OUT     DX,AL
		;
		; Check next board.
		;
		INC     BX
		ADD     DX,2
		LOOP    INIT_CHECK_BDS_LOOP
		;
		; If no cards installed, abort installation.
		;
		CMP	NUMBOARDS,0
		JNE	INIT_CONTINUE
		MOV	DX,OFFSET NOBOARDSMSG
		MOV	AH,9
		INT	21h
		MOV	DEVICEATTRIB,0
		LDS	BX,REQUESTPTR
		MOV	FREEMEMOFFS,0
		MOV	FREEMEMSEG,CS
		MOV	NUMUNITS,0
		RET
		;
		; For each board, 0-3:
		;
INIT_CONTINUE:	XOR	BX,BX
		;
		; If board installed:
		;
INIT_TESTLOOP:	CMP	INSTALLED[BX],0
		JNE	>L1
		;
		; Test each hardware page on the board, 0-127.
		;
		CALL	SHOWBOARDMSG
		XOR	AX,AX
		MOV	CX,128
L0:		CALL	TESTPAGE
		INC	AX
		LOOP	L0
L1:		INC	BX
		CMP	BX,4
		JB	INIT_TESTLOOP
		;
		; Display number of boards installed, number of EMS pages.
		;
		MOV	DX,OFFSET CRLFMSG
		MOV	AH,9
		INT	21h
		MOV	DX,NUMBOARDS
		ADD	DL,'0'
		MOV	AH,2
		INT	21h
		MOV	DX,OFFSET BDSINSTLDMSG
		MOV	AH,9
		INT	21h
		MOV	AX,TOTALPAGES
		CALL	SHOWDIGITS
		MOV	DX,OFFSET EMSPAGESMSG
		MOV	AH,9
		INT	21h
		;
		; Display whether or not compatibility mode.
		;
		MOV	DX,OFFSET COMPATMSG1
		MOV	AH,9
		INT	21h
		CMP	COMPATIBILITY,0
		JNE	>L0
		MOV	DX,OFFSET COMPATMSG2
		JMP	>L1
L0:		MOV	DX,OFFSET COMPATMSG3
L1:		MOV	AH,9
		INT	21h
		;
		; Set DRIVERSEG, hook Int 67h, set request header fields,
		; and exit.
		;
		MOV	DRIVERSEG,CS
		MOV	DX,OFFSET INT67HDLR
		MOV	AX,2567h
		INT	21h
		LDS	BX,CS:REQUESTPTR
		MOV	FREEMEMOFFS,END_RESIDENT
		MOV	FREEMEMSEG,CS
		RET
;
; Subroutine, tests a hardware page, displays results.  AX = page (0-127),
; BX = board (0-3).
;
TESTPAGE:	PUSH	BX
		;
		; If long check, then ...
		;
		CMP	QUICKCHECK,0
		JNE	>L1
		CALL	SHOWBANKMSG	
L0:		CALL	LTEST
		PUSHF
		CALL	SHOWPAGEMSG
		POPF
		JMP	>L2
		;
		; If quick check, then ...
		;
L1:		CALL	QTEST
L2:		JC	>L3
		INC	TOTALPAGES
		INC	UNALLOCPAGES
		MOV	BH,BL
		XOR	BL,BL
		SHR	BX,1
		ADD	BX,AX
		MOV	PAGEALLOC[BX],0FFh
		SHL	BX,1
		MOV	TRANSLATEARRAY[BX],0
L3:		POP	BX
		RET
;
; Subroutine, displays header for board memory check.
;
SHOWBOARDMSG:	CMP	QUICKCHECK,0
		JNE	>L0
		PUSH	AX
		PUSH	DX
		MOV	DX,OFFSET BOARDMSG1
		MOV	AH,9
		INT	21h
		MOV	DL,BL
		ADD	DL,'0'
		MOV	AH,2
		INT	21h
		MOV	DX,OFFSET BOARDMSG2
		MOV	AH,9
		INT	21h
		POP	DX
		POP	AX
L0:		RET
;
; Subroutine, displays bank number, given hardware page 0-127 in AL, only
; if this is the first page of a bank.
;
SHOWBANKMSG:	TEST	AL,0Fh
		JNZ	>L0
		PUSH	AX
		PUSH	CX
		PUSH	DX
		MOV	CL,AL
		MOV	DX,OFFSET BANKMSG1
		MOV	AH,9
		INT	21h
		MOV	DL,CL
		MOV	CL,4
		SHR	DL,CL
		ADD	DL,'0'
		MOV	AH,2
		INT	21h
		MOV	DX,OFFSET BANKMSG2
		MOV	AH,9
		INT	21h
		POP	DX
		POP	CX
		POP	AX
L0:		RET
;
; Subroutine, displays a 'X' if carry is set, '*' if carry is clear.  Also
; displays CR/LF if AL mod 16 = 15.
;
SHOWPAGEMSG:	PUSH	AX
		PUSH	DX
		PUSH	AX
		JC	>L0
		MOV	DL,'*'
		JMP	>L1
L0:		MOV	DL,'X'		
L1:		MOV	AH,2
		INT	21h
		POP	AX
		AND	AL,0Fh
		CMP	AL,0Fh
		JNE	>L2
		MOV	DX,OFFSET CRLFMSG
		MOV	AH,9
		INT	21h
L2:		POP	DX
		POP	AX
		RET
;
; Subroutine, performs a long test on hardware page AX on board BX.  Returns
; carry clear if OK, carry set if not installed or bad.
;
LTEST:		PUSH	AX
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	DI
		PUSH	ES
		;
		; Push flags (to preserve old direction flag) and set
		; direction up.
		;
		PUSHF
		CLD
		;
		; Map into physical page 0.
		;
		MOV	DX,BX
		SHL	DX,1
		ADD	DX,208h
		OR	AL,80h
		OUT	DX,AL	
		;
		; Save hardware page in BL.  ES addresses page frame.
		;
		MOV	BL,AL
		MOV	AX,0D000h
		MOV	ES,AX
		;
		; Fill physical page 0 with first test pattern.
		;
		XOR	DI,DI
		MOV	CX,8192
		MOV	AX,55AAh
		REP	STOSW
		;
		; Reads back OK?
		;
		XOR	DI,DI
		MOV	CX,8192
		REPE	SCASW
		JNE	LTEST_BAD
		;
		; Fill physical page 0 with second test pattern.
		;
		XOR	DI,DI
		MOV	CX,8192
		MOV	AX,0AA55h
		REP	STOSW
		;
		; Reads back OK?
		;
		XOR	DI,DI
		MOV	CX,8192
		REPE	SCASW
		JNE	LTEST_BAD
		;
		; Write the hardware page number into the first byte.
		;
		MOV	AL,BL
		MOV	ES:[0],AL
		;
		; Map this page out, another one in.
		;
		XOR	AL,1
		OUT	DX,AL
		;
		; Write something different into the first byte of the other
		; page.
		;
		MOV	ES:[0],AL
		;
		; Map the original page back in.
		;
		XOR	AL,1
		OUT	DX,AL
		;
		; Can read what was written?
		;
		CMP	AL,ES:[0]
		JNE	LTEST_BAD
		;
		; All OK - clear carry.
		;
		POPF
		CLC
		JMP	LTEST_EXIT
		;
		; Bad page - set carry.
		;
LTEST_BAD:	POPF
		STC
		;
		; Unmap physical page 0 and return.
		;
LTEST_EXIT:	MOV	AL,0
		OUT	DX,AL
		POP	ES
		POP	DI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		RET
;
; Subroutine, performs a short test on hardware page AX on board BX.  Returns
; carry clear if OK, carry set if not installed or bad.
;
QTEST:		PUSH	AX
		PUSH	BX
		PUSH	DX
		PUSH	DS
		;
		; Map into physical page 0.
		;
		MOV	DX,BX
		SHL	DX,1
		ADD	DX,208h
		OR	AL,80h
		OUT	DX,AL
		;
		; DS addresses page frame.
		;
		MOV	AX,0D000h
		MOV	DS,AX
		;
		; Save first word on page in BX.  Write and read back first
		; test pattern.
		;
		MOV	BX,[0]
		MOV	AX,55AAh
		MOV	[0],AX
		MOV	AX,[0]
		MOV	[0],BX
		CMP	AX,55AAh
		JNE	QTEST_BAD		
		;
		; Write and read back second test pattern, then restore first
		; word from BX.
		;
		MOV	AX,0AA55h
		MOV	[0],AX
		MOV	AX,[0]
		MOV	[0],BX
		CMP	AX,0AA55h
		JNE	QTEST_BAD
		;
		; Clear carry if good.
		;
		CLC
		JMP	QTEST_EXIT
		;
		; Set carry if bad.
		;
QTEST_BAD:	STC
		;
		; Unmap physical page 0 and return.
		;
QTEST_EXIT:	MOV	AL,0
		OUT	DX,AL
		POP	DS
		POP	DX
		POP	BX
		POP	AX
		RET
;
; Subroutine, displays a number in decimal.  Number in AX.
;
SHOWDIGITS:	PUSH	AX
		PUSH	BX
		PUSH	CX
		PUSH	DX
		MOV	BX,10
		XOR	CX,CX
L0:		XOR	DX,DX
		DIV	BX
		MOV	DH,DL
		PUSH	DX
		INC	SP
		INC	CX
		OR	AX,AX
		JNE	L0
L1:		DEC	SP
		POP	DX
		MOV	DL,DH
		ADD	DL,'0'
		MOV	AH,2
		INT	21h
		LOOP	L1
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		RET
