; MULTBL2.ASM
;
; This is the second part of the multiplication table for the 8086 version,
; used in the resampler to multiply the sample by the volume.  The 286 can
; multiply fast enough and does not need a precomputed multiplication table
; like this one.
;
; This table is too long to fit into a single 64k-or-less source file, but
; the A86 assembler will assemble a sequence of source files into a single
; object file.
;

		; volume 29
		DW	    0,    29,    58,    87,   116,   145,   174,   203
		DW	  232,   261,   290,   319,   348,   377,   406,   435
		DW	  464,   493,   522,   551,   580,   609,   638,   667
		DW	  696,   725,   754,   783,   812,   841,   870,   899
		DW	  928,   957,   986,  1015,  1044,  1073,  1102,  1131
		DW	 1160,  1189,  1218,  1247,  1276,  1305,  1334,  1363
		DW	 1392,  1421,  1450,  1479,  1508,  1537,  1566,  1595
		DW	 1624,  1653,  1682,  1711,  1740,  1769,  1798,  1827
		DW	 1856,  1885,  1914,  1943,  1972,  2001,  2030,  2059
		DW	 2088,  2117,  2146,  2175,  2204,  2233,  2262,  2291
		DW	 2320,  2349,  2378,  2407,  2436,  2465,  2494,  2523
		DW	 2552,  2581,  2610,  2639,  2668,  2697,  2726,  2755
		DW	 2784,  2813,  2842,  2871,  2900,  2929,  2958,  2987
		DW	 3016,  3045,  3074,  3103,  3132,  3161,  3190,  3219
		DW	 3248,  3277,  3306,  3335,  3364,  3393,  3422,  3451
		DW	 3480,  3509,  3538,  3567,  3596,  3625,  3654,  3683
		DW	-3712, -3683, -3654, -3625, -3596, -3567, -3538, -3509
		DW	-3480, -3451, -3422, -3393, -3364, -3335, -3306, -3277
		DW	-3248, -3219, -3190, -3161, -3132, -3103, -3074, -3045
		DW	-3016, -2987, -2958, -2929, -2900, -2871, -2842, -2813
		DW	-2784, -2755, -2726, -2697, -2668, -2639, -2610, -2581
		DW	-2552, -2523, -2494, -2465, -2436, -2407, -2378, -2349
		DW	-2320, -2291, -2262, -2233, -2204, -2175, -2146, -2117
		DW	-2088, -2059, -2030, -2001, -1972, -1943, -1914, -1885
		DW	-1856, -1827, -1798, -1769, -1740, -1711, -1682, -1653
		DW	-1624, -1595, -1566, -1537, -1508, -1479, -1450, -1421
		DW	-1392, -1363, -1334, -1305, -1276, -1247, -1218, -1189
		DW	-1160, -1131, -1102, -1073, -1044, -1015,  -986,  -957
		DW	 -928,  -899,  -870,  -841,  -812,  -783,  -754,  -725
		DW	 -696,  -667,  -638,  -609,  -580,  -551,  -522,  -493
		DW	 -464,  -435,  -406,  -377,  -348,  -319,  -290,  -261
		DW	 -232,  -203,  -174,  -145,  -116,   -87,   -58,   -29
		; volume 30
		DW	    0,    30,    60,    90,   120,   150,   180,   210
		DW	  240,   270,   300,   330,   360,   390,   420,   450
		DW	  480,   510,   540,   570,   600,   630,   660,   690
		DW	  720,   750,   780,   810,   840,   870,   900,   930
		DW	  960,   990,  1020,  1050,  1080,  1110,  1140,  1170
		DW	 1200,  1230,  1260,  1290,  1320,  1350,  1380,  1410
		DW	 1440,  1470,  1500,  1530,  1560,  1590,  1620,  1650
		DW	 1680,  1710,  1740,  1770,  1800,  1830,  1860,  1890
		DW	 1920,  1950,  1980,  2010,  2040,  2070,  2100,  2130
		DW	 2160,  2190,  2220,  2250,  2280,  2310,  2340,  2370
		DW	 2400,  2430,  2460,  2490,  2520,  2550,  2580,  2610
		DW	 2640,  2670,  2700,  2730,  2760,  2790,  2820,  2850
		DW	 2880,  2910,  2940,  2970,  3000,  3030,  3060,  3090
		DW	 3120,  3150,  3180,  3210,  3240,  3270,  3300,  3330
		DW	 3360,  3390,  3420,  3450,  3480,  3510,  3540,  3570
		DW	 3600,  3630,  3660,  3690,  3720,  3750,  3780,  3810
		DW	-3840, -3810, -3780, -3750, -3720, -3690, -3660, -3630
		DW	-3600, -3570, -3540, -3510, -3480, -3450, -3420, -3390
		DW	-3360, -3330, -3300, -3270, -3240, -3210, -3180, -3150
		DW	-3120, -3090, -3060, -3030, -3000, -2970, -2940, -2910
		DW	-2880, -2850, -2820, -2790, -2760, -2730, -2700, -2670
		DW	-2640, -2610, -2580, -2550, -2520, -2490, -2460, -2430
		DW	-2400, -2370, -2340, -2310, -2280, -2250, -2220, -2190
		DW	-2160, -2130, -2100, -2070, -2040, -2010, -1980, -1950
		DW	-1920, -1890, -1860, -1830, -1800, -1770, -1740, -1710
		DW	-1680, -1650, -1620, -1590, -1560, -1530, -1500, -1470
		DW	-1440, -1410, -1380, -1350, -1320, -1290, -1260, -1230
		DW	-1200, -1170, -1140, -1110, -1080, -1050, -1020,  -990
		DW	 -960,  -930,  -900,  -870,  -840,  -810,  -780,  -750
		DW	 -720,  -690,  -660,  -630,  -600,  -570,  -540,  -510
		DW	 -480,  -450,  -420,  -390,  -360,  -330,  -300,  -270
		DW	 -240,  -210,  -180,  -150,  -120,   -90,   -60,   -30
		; volume 31
		DW	    0,    31,    62,    93,   124,   155,   186,   217
		DW	  248,   279,   310,   341,   372,   403,   434,   465
		DW	  496,   527,   558,   589,   620,   651,   682,   713
		DW	  744,   775,   806,   837,   868,   899,   930,   961
		DW	  992,  1023,  1054,  1085,  1116,  1147,  1178,  1209
		DW	 1240,  1271,  1302,  1333,  1364,  1395,  1426,  1457
		DW	 1488,  1519,  1550,  1581,  1612,  1643,  1674,  1705
		DW	 1736,  1767,  1798,  1829,  1860,  1891,  1922,  1953
		DW	 1984,  2015,  2046,  2077,  2108,  2139,  2170,  2201
		DW	 2232,  2263,  2294,  2325,  2356,  2387,  2418,  2449
		DW	 2480,  2511,  2542,  2573,  2604,  2635,  2666,  2697
		DW	 2728,  2759,  2790,  2821,  2852,  2883,  2914,  2945
		DW	 2976,  3007,  3038,  3069,  3100,  3131,  3162,  3193
		DW	 3224,  3255,  3286,  3317,  3348,  3379,  3410,  3441
		DW	 3472,  3503,  3534,  3565,  3596,  3627,  3658,  3689
		DW	 3720,  3751,  3782,  3813,  3844,  3875,  3906,  3937
		DW	-3968, -3937, -3906, -3875, -3844, -3813, -3782, -3751
		DW	-3720, -3689, -3658, -3627, -3596, -3565, -3534, -3503
		DW	-3472, -3441, -3410, -3379, -3348, -3317, -3286, -3255
		DW	-3224, -3193, -3162, -3131, -3100, -3069, -3038, -3007
		DW	-2976, -2945, -2914, -2883, -2852, -2821, -2790, -2759
		DW	-2728, -2697, -2666, -2635, -2604, -2573, -2542, -2511
		DW	-2480, -2449, -2418, -2387, -2356, -2325, -2294, -2263
		DW	-2232, -2201, -2170, -2139, -2108, -2077, -2046, -2015
		DW	-1984, -1953, -1922, -1891, -1860, -1829, -1798, -1767
		DW	-1736, -1705, -1674, -1643, -1612, -1581, -1550, -1519
		DW	-1488, -1457, -1426, -1395, -1364, -1333, -1302, -1271
		DW	-1240, -1209, -1178, -1147, -1116, -1085, -1054, -1023
		DW	 -992,  -961,  -930,  -899,  -868,  -837,  -806,  -775
		DW	 -744,  -713,  -682,  -651,  -620,  -589,  -558,  -527
		DW	 -496,  -465,  -434,  -403,  -372,  -341,  -310,  -279
		DW	 -248,  -217,  -186,  -155,  -124,   -93,   -62,   -31
		; volume 32
		DW	    0,    32,    64,    96,   128,   160,   192,   224
		DW	  256,   288,   320,   352,   384,   416,   448,   480
		DW	  512,   544,   576,   608,   640,   672,   704,   736
		DW	  768,   800,   832,   864,   896,   928,   960,   992
		DW	 1024,  1056,  1088,  1120,  1152,  1184,  1216,  1248
		DW	 1280,  1312,  1344,  1376,  1408,  1440,  1472,  1504
		DW	 1536,  1568,  1600,  1632,  1664,  1696,  1728,  1760
		DW	 1792,  1824,  1856,  1888,  1920,  1952,  1984,  2016
		DW	 2048,  2080,  2112,  2144,  2176,  2208,  2240,  2272
		DW	 2304,  2336,  2368,  2400,  2432,  2464,  2496,  2528
		DW	 2560,  2592,  2624,  2656,  2688,  2720,  2752,  2784
		DW	 2816,  2848,  2880,  2912,  2944,  2976,  3008,  3040
		DW	 3072,  3104,  3136,  3168,  3200,  3232,  3264,  3296
		DW	 3328,  3360,  3392,  3424,  3456,  3488,  3520,  3552
		DW	 3584,  3616,  3648,  3680,  3712,  3744,  3776,  3808
		DW	 3840,  3872,  3904,  3936,  3968,  4000,  4032,  4064
		DW	-4096, -4064, -4032, -4000, -3968, -3936, -3904, -3872
		DW	-3840, -3808, -3776, -3744, -3712, -3680, -3648, -3616
		DW	-3584, -3552, -3520, -3488, -3456, -3424, -3392, -3360
		DW	-3328, -3296, -3264, -3232, -3200, -3168, -3136, -3104
		DW	-3072, -3040, -3008, -2976, -2944, -2912, -2880, -2848
		DW	-2816, -2784, -2752, -2720, -2688, -2656, -2624, -2592
		DW	-2560, -2528, -2496, -2464, -2432, -2400, -2368, -2336
		DW	-2304, -2272, -2240, -2208, -2176, -2144, -2112, -2080
		DW	-2048, -2016, -1984, -1952, -1920, -1888, -1856, -1824
		DW	-1792, -1760, -1728, -1696, -1664, -1632, -1600, -1568
		DW	-1536, -1504, -1472, -1440, -1408, -1376, -1344, -1312
		DW	-1280, -1248, -1216, -1184, -1152, -1120, -1088, -1056
		DW	-1024,  -992,  -960,  -928,  -896,  -864,  -832,  -800
		DW	 -768,  -736,  -704,  -672,  -640,  -608,  -576,  -544
		DW	 -512,  -480,  -448,  -416,  -384,  -352,  -320,  -288
		DW	 -256,  -224,  -192,  -160,  -128,   -96,   -64,   -32
		; volume 33
		DW	    0,    33,    66,    99,   132,   165,   198,   231
		DW	  264,   297,   330,   363,   396,   429,   462,   495
		DW	  528,   561,   594,   627,   660,   693,   726,   759
		DW	  792,   825,   858,   891,   924,   957,   990,  1023
		DW	 1056,  1089,  1122,  1155,  1188,  1221,  1254,  1287
		DW	 1320,  1353,  1386,  1419,  1452,  1485,  1518,  1551
		DW	 1584,  1617,  1650,  1683,  1716,  1749,  1782,  1815
		DW	 1848,  1881,  1914,  1947,  1980,  2013,  2046,  2079
		DW	 2112,  2145,  2178,  2211,  2244,  2277,  2310,  2343
		DW	 2376,  2409,  2442,  2475,  2508,  2541,  2574,  2607
		DW	 2640,  2673,  2706,  2739,  2772,  2805,  2838,  2871
		DW	 2904,  2937,  2970,  3003,  3036,  3069,  3102,  3135
		DW	 3168,  3201,  3234,  3267,  3300,  3333,  3366,  3399
		DW	 3432,  3465,  3498,  3531,  3564,  3597,  3630,  3663
		DW	 3696,  3729,  3762,  3795,  3828,  3861,  3894,  3927
		DW	 3960,  3993,  4026,  4059,  4092,  4125,  4158,  4191
		DW	-4224, -4191, -4158, -4125, -4092, -4059, -4026, -3993
		DW	-3960, -3927, -3894, -3861, -3828, -3795, -3762, -3729
		DW	-3696, -3663, -3630, -3597, -3564, -3531, -3498, -3465
		DW	-3432, -3399, -3366, -3333, -3300, -3267, -3234, -3201
		DW	-3168, -3135, -3102, -3069, -3036, -3003, -2970, -2937
		DW	-2904, -2871, -2838, -2805, -2772, -2739, -2706, -2673
		DW	-2640, -2607, -2574, -2541, -2508, -2475, -2442, -2409
		DW	-2376, -2343, -2310, -2277, -2244, -2211, -2178, -2145
		DW	-2112, -2079, -2046, -2013, -1980, -1947, -1914, -1881
		DW	-1848, -1815, -1782, -1749, -1716, -1683, -1650, -1617
		DW	-1584, -1551, -1518, -1485, -1452, -1419, -1386, -1353
		DW	-1320, -1287, -1254, -1221, -1188, -1155, -1122, -1089
		DW	-1056, -1023,  -990,  -957,  -924,  -891,  -858,  -825
		DW	 -792,  -759,  -726,  -693,  -660,  -627,  -594,  -561
		DW	 -528,  -495,  -462,  -429,  -396,  -363,  -330,  -297
		DW	 -264,  -231,  -198,  -165,  -132,   -99,   -66,   -33
		; volume 34
		DW	    0,    34,    68,   102,   136,   170,   204,   238
		DW	  272,   306,   340,   374,   408,   442,   476,   510
		DW	  544,   578,   612,   646,   680,   714,   748,   782
		DW	  816,   850,   884,   918,   952,   986,  1020,  1054
		DW	 1088,  1122,  1156,  1190,  1224,  1258,  1292,  1326
		DW	 1360,  1394,  1428,  1462,  1496,  1530,  1564,  1598
		DW	 1632,  1666,  1700,  1734,  1768,  1802,  1836,  1870
		DW	 1904,  1938,  1972,  2006,  2040,  2074,  2108,  2142
		DW	 2176,  2210,  2244,  2278,  2312,  2346,  2380,  2414
		DW	 2448,  2482,  2516,  2550,  2584,  2618,  2652,  2686
		DW	 2720,  2754,  2788,  2822,  2856,  2890,  2924,  2958
		DW	 2992,  3026,  3060,  3094,  3128,  3162,  3196,  3230
		DW	 3264,  3298,  3332,  3366,  3400,  3434,  3468,  3502
		DW	 3536,  3570,  3604,  3638,  3672,  3706,  3740,  3774
		DW	 3808,  3842,  3876,  3910,  3944,  3978,  4012,  4046
		DW	 4080,  4114,  4148,  4182,  4216,  4250,  4284,  4318
		DW	-4352, -4318, -4284, -4250, -4216, -4182, -4148, -4114
		DW	-4080, -4046, -4012, -3978, -3944, -3910, -3876, -3842
		DW	-3808, -3774, -3740, -3706, -3672, -3638, -3604, -3570
		DW	-3536, -3502, -3468, -3434, -3400, -3366, -3332, -3298
		DW	-3264, -3230, -3196, -3162, -3128, -3094, -3060, -3026
		DW	-2992, -2958, -2924, -2890, -2856, -2822, -2788, -2754
		DW	-2720, -2686, -2652, -2618, -2584, -2550, -2516, -2482
		DW	-2448, -2414, -2380, -2346, -2312, -2278, -2244, -2210
		DW	-2176, -2142, -2108, -2074, -2040, -2006, -1972, -1938
		DW	-1904, -1870, -1836, -1802, -1768, -1734, -1700, -1666
		DW	-1632, -1598, -1564, -1530, -1496, -1462, -1428, -1394
		DW	-1360, -1326, -1292, -1258, -1224, -1190, -1156, -1122
		DW	-1088, -1054, -1020,  -986,  -952,  -918,  -884,  -850
		DW	 -816,  -782,  -748,  -714,  -680,  -646,  -612,  -578
		DW	 -544,  -510,  -476,  -442,  -408,  -374,  -340,  -306
		DW	 -272,  -238,  -204,  -170,  -136,  -102,   -68,   -34
		; volume 35
		DW	    0,    35,    70,   105,   140,   175,   210,   245
		DW	  280,   315,   350,   385,   420,   455,   490,   525
		DW	  560,   595,   630,   665,   700,   735,   770,   805
		DW	  840,   875,   910,   945,   980,  1015,  1050,  1085
		DW	 1120,  1155,  1190,  1225,  1260,  1295,  1330,  1365
		DW	 1400,  1435,  1470,  1505,  1540,  1575,  1610,  1645
		DW	 1680,  1715,  1750,  1785,  1820,  1855,  1890,  1925
		DW	 1960,  1995,  2030,  2065,  2100,  2135,  2170,  2205
		DW	 2240,  2275,  2310,  2345,  2380,  2415,  2450,  2485
		DW	 2520,  2555,  2590,  2625,  2660,  2695,  2730,  2765
		DW	 2800,  2835,  2870,  2905,  2940,  2975,  3010,  3045
		DW	 3080,  3115,  3150,  3185,  3220,  3255,  3290,  3325
		DW	 3360,  3395,  3430,  3465,  3500,  3535,  3570,  3605
		DW	 3640,  3675,  3710,  3745,  3780,  3815,  3850,  3885
		DW	 3920,  3955,  3990,  4025,  4060,  4095,  4130,  4165
		DW	 4200,  4235,  4270,  4305,  4340,  4375,  4410,  4445
		DW	-4480, -4445, -4410, -4375, -4340, -4305, -4270, -4235
		DW	-4200, -4165, -4130, -4095, -4060, -4025, -3990, -3955
		DW	-3920, -3885, -3850, -3815, -3780, -3745, -3710, -3675
		DW	-3640, -3605, -3570, -3535, -3500, -3465, -3430, -3395
		DW	-3360, -3325, -3290, -3255, -3220, -3185, -3150, -3115
		DW	-3080, -3045, -3010, -2975, -2940, -2905, -2870, -2835
		DW	-2800, -2765, -2730, -2695, -2660, -2625, -2590, -2555
		DW	-2520, -2485, -2450, -2415, -2380, -2345, -2310, -2275
		DW	-2240, -2205, -2170, -2135, -2100, -2065, -2030, -1995
		DW	-1960, -1925, -1890, -1855, -1820, -1785, -1750, -1715
		DW	-1680, -1645, -1610, -1575, -1540, -1505, -1470, -1435
		DW	-1400, -1365, -1330, -1295, -1260, -1225, -1190, -1155
		DW	-1120, -1085, -1050, -1015,  -980,  -945,  -910,  -875
		DW	 -840,  -805,  -770,  -735,  -700,  -665,  -630,  -595
		DW	 -560,  -525,  -490,  -455,  -420,  -385,  -350,  -315
		DW	 -280,  -245,  -210,  -175,  -140,  -105,   -70,   -35
		; volume 36
		DW	    0,    36,    72,   108,   144,   180,   216,   252
		DW	  288,   324,   360,   396,   432,   468,   504,   540
		DW	  576,   612,   648,   684,   720,   756,   792,   828
		DW	  864,   900,   936,   972,  1008,  1044,  1080,  1116
		DW	 1152,  1188,  1224,  1260,  1296,  1332,  1368,  1404
		DW	 1440,  1476,  1512,  1548,  1584,  1620,  1656,  1692
		DW	 1728,  1764,  1800,  1836,  1872,  1908,  1944,  1980
		DW	 2016,  2052,  2088,  2124,  2160,  2196,  2232,  2268
		DW	 2304,  2340,  2376,  2412,  2448,  2484,  2520,  2556
		DW	 2592,  2628,  2664,  2700,  2736,  2772,  2808,  2844
		DW	 2880,  2916,  2952,  2988,  3024,  3060,  3096,  3132
		DW	 3168,  3204,  3240,  3276,  3312,  3348,  3384,  3420
		DW	 3456,  3492,  3528,  3564,  3600,  3636,  3672,  3708
		DW	 3744,  3780,  3816,  3852,  3888,  3924,  3960,  3996
		DW	 4032,  4068,  4104,  4140,  4176,  4212,  4248,  4284
		DW	 4320,  4356,  4392,  4428,  4464,  4500,  4536,  4572
		DW	-4608, -4572, -4536, -4500, -4464, -4428, -4392, -4356
		DW	-4320, -4284, -4248, -4212, -4176, -4140, -4104, -4068
		DW	-4032, -3996, -3960, -3924, -3888, -3852, -3816, -3780
		DW	-3744, -3708, -3672, -3636, -3600, -3564, -3528, -3492
		DW	-3456, -3420, -3384, -3348, -3312, -3276, -3240, -3204
		DW	-3168, -3132, -3096, -3060, -3024, -2988, -2952, -2916
		DW	-2880, -2844, -2808, -2772, -2736, -2700, -2664, -2628
		DW	-2592, -2556, -2520, -2484, -2448, -2412, -2376, -2340
		DW	-2304, -2268, -2232, -2196, -2160, -2124, -2088, -2052
		DW	-2016, -1980, -1944, -1908, -1872, -1836, -1800, -1764
		DW	-1728, -1692, -1656, -1620, -1584, -1548, -1512, -1476
		DW	-1440, -1404, -1368, -1332, -1296, -1260, -1224, -1188
		DW	-1152, -1116, -1080, -1044, -1008,  -972,  -936,  -900
		DW	 -864,  -828,  -792,  -756,  -720,  -684,  -648,  -612
		DW	 -576,  -540,  -504,  -468,  -432,  -396,  -360,  -324
		DW	 -288,  -252,  -216,  -180,  -144,  -108,   -72,   -36
		; volume 37
		DW	    0,    37,    74,   111,   148,   185,   222,   259
		DW	  296,   333,   370,   407,   444,   481,   518,   555
		DW	  592,   629,   666,   703,   740,   777,   814,   851
		DW	  888,   925,   962,   999,  1036,  1073,  1110,  1147
		DW	 1184,  1221,  1258,  1295,  1332,  1369,  1406,  1443
		DW	 1480,  1517,  1554,  1591,  1628,  1665,  1702,  1739
		DW	 1776,  1813,  1850,  1887,  1924,  1961,  1998,  2035
		DW	 2072,  2109,  2146,  2183,  2220,  2257,  2294,  2331
		DW	 2368,  2405,  2442,  2479,  2516,  2553,  2590,  2627
		DW	 2664,  2701,  2738,  2775,  2812,  2849,  2886,  2923
		DW	 2960,  2997,  3034,  3071,  3108,  3145,  3182,  3219
		DW	 3256,  3293,  3330,  3367,  3404,  3441,  3478,  3515
		DW	 3552,  3589,  3626,  3663,  3700,  3737,  3774,  3811
		DW	 3848,  3885,  3922,  3959,  3996,  4033,  4070,  4107
		DW	 4144,  4181,  4218,  4255,  4292,  4329,  4366,  4403
		DW	 4440,  4477,  4514,  4551,  4588,  4625,  4662,  4699
		DW	-4736, -4699, -4662, -4625, -4588, -4551, -4514, -4477
		DW	-4440, -4403, -4366, -4329, -4292, -4255, -4218, -4181
		DW	-4144, -4107, -4070, -4033, -3996, -3959, -3922, -3885
		DW	-3848, -3811, -3774, -3737, -3700, -3663, -3626, -3589
		DW	-3552, -3515, -3478, -3441, -3404, -3367, -3330, -3293
		DW	-3256, -3219, -3182, -3145, -3108, -3071, -3034, -2997
		DW	-2960, -2923, -2886, -2849, -2812, -2775, -2738, -2701
		DW	-2664, -2627, -2590, -2553, -2516, -2479, -2442, -2405
		DW	-2368, -2331, -2294, -2257, -2220, -2183, -2146, -2109
		DW	-2072, -2035, -1998, -1961, -1924, -1887, -1850, -1813
		DW	-1776, -1739, -1702, -1665, -1628, -1591, -1554, -1517
		DW	-1480, -1443, -1406, -1369, -1332, -1295, -1258, -1221
		DW	-1184, -1147, -1110, -1073, -1036,  -999,  -962,  -925
		DW	 -888,  -851,  -814,  -777,  -740,  -703,  -666,  -629
		DW	 -592,  -555,  -518,  -481,  -444,  -407,  -370,  -333
		DW	 -296,  -259,  -222,  -185,  -148,  -111,   -74,   -37
		; volume 38
		DW	    0,    38,    76,   114,   152,   190,   228,   266
		DW	  304,   342,   380,   418,   456,   494,   532,   570
		DW	  608,   646,   684,   722,   760,   798,   836,   874
		DW	  912,   950,   988,  1026,  1064,  1102,  1140,  1178
		DW	 1216,  1254,  1292,  1330,  1368,  1406,  1444,  1482
		DW	 1520,  1558,  1596,  1634,  1672,  1710,  1748,  1786
		DW	 1824,  1862,  1900,  1938,  1976,  2014,  2052,  2090
		DW	 2128,  2166,  2204,  2242,  2280,  2318,  2356,  2394
		DW	 2432,  2470,  2508,  2546,  2584,  2622,  2660,  2698
		DW	 2736,  2774,  2812,  2850,  2888,  2926,  2964,  3002
		DW	 3040,  3078,  3116,  3154,  3192,  3230,  3268,  3306
		DW	 3344,  3382,  3420,  3458,  3496,  3534,  3572,  3610
		DW	 3648,  3686,  3724,  3762,  3800,  3838,  3876,  3914
		DW	 3952,  3990,  4028,  4066,  4104,  4142,  4180,  4218
		DW	 4256,  4294,  4332,  4370,  4408,  4446,  4484,  4522
		DW	 4560,  4598,  4636,  4674,  4712,  4750,  4788,  4826
		DW	-4864, -4826, -4788, -4750, -4712, -4674, -4636, -4598
		DW	-4560, -4522, -4484, -4446, -4408, -4370, -4332, -4294
		DW	-4256, -4218, -4180, -4142, -4104, -4066, -4028, -3990
		DW	-3952, -3914, -3876, -3838, -3800, -3762, -3724, -3686
		DW	-3648, -3610, -3572, -3534, -3496, -3458, -3420, -3382
		DW	-3344, -3306, -3268, -3230, -3192, -3154, -3116, -3078
		DW	-3040, -3002, -2964, -2926, -2888, -2850, -2812, -2774
		DW	-2736, -2698, -2660, -2622, -2584, -2546, -2508, -2470
		DW	-2432, -2394, -2356, -2318, -2280, -2242, -2204, -2166
		DW	-2128, -2090, -2052, -2014, -1976, -1938, -1900, -1862
		DW	-1824, -1786, -1748, -1710, -1672, -1634, -1596, -1558
		DW	-1520, -1482, -1444, -1406, -1368, -1330, -1292, -1254
		DW	-1216, -1178, -1140, -1102, -1064, -1026,  -988,  -950
		DW	 -912,  -874,  -836,  -798,  -760,  -722,  -684,  -646
		DW	 -608,  -570,  -532,  -494,  -456,  -418,  -380,  -342
		DW	 -304,  -266,  -228,  -190,  -152,  -114,   -76,   -38
		; volume 39
		DW	    0,    39,    78,   117,   156,   195,   234,   273
		DW	  312,   351,   390,   429,   468,   507,   546,   585
		DW	  624,   663,   702,   741,   780,   819,   858,   897
		DW	  936,   975,  1014,  1053,  1092,  1131,  1170,  1209
		DW	 1248,  1287,  1326,  1365,  1404,  1443,  1482,  1521
		DW	 1560,  1599,  1638,  1677,  1716,  1755,  1794,  1833
		DW	 1872,  1911,  1950,  1989,  2028,  2067,  2106,  2145
		DW	 2184,  2223,  2262,  2301,  2340,  2379,  2418,  2457
		DW	 2496,  2535,  2574,  2613,  2652,  2691,  2730,  2769
		DW	 2808,  2847,  2886,  2925,  2964,  3003,  3042,  3081
		DW	 3120,  3159,  3198,  3237,  3276,  3315,  3354,  3393
		DW	 3432,  3471,  3510,  3549,  3588,  3627,  3666,  3705
		DW	 3744,  3783,  3822,  3861,  3900,  3939,  3978,  4017
		DW	 4056,  4095,  4134,  4173,  4212,  4251,  4290,  4329
		DW	 4368,  4407,  4446,  4485,  4524,  4563,  4602,  4641
		DW	 4680,  4719,  4758,  4797,  4836,  4875,  4914,  4953
		DW	-4992, -4953, -4914, -4875, -4836, -4797, -4758, -4719
		DW	-4680, -4641, -4602, -4563, -4524, -4485, -4446, -4407
		DW	-4368, -4329, -4290, -4251, -4212, -4173, -4134, -4095
		DW	-4056, -4017, -3978, -3939, -3900, -3861, -3822, -3783
		DW	-3744, -3705, -3666, -3627, -3588, -3549, -3510, -3471
		DW	-3432, -3393, -3354, -3315, -3276, -3237, -3198, -3159
		DW	-3120, -3081, -3042, -3003, -2964, -2925, -2886, -2847
		DW	-2808, -2769, -2730, -2691, -2652, -2613, -2574, -2535
		DW	-2496, -2457, -2418, -2379, -2340, -2301, -2262, -2223
		DW	-2184, -2145, -2106, -2067, -2028, -1989, -1950, -1911
		DW	-1872, -1833, -1794, -1755, -1716, -1677, -1638, -1599
		DW	-1560, -1521, -1482, -1443, -1404, -1365, -1326, -1287
		DW	-1248, -1209, -1170, -1131, -1092, -1053, -1014,  -975
		DW	 -936,  -897,  -858,  -819,  -780,  -741,  -702,  -663
		DW	 -624,  -585,  -546,  -507,  -468,  -429,  -390,  -351
		DW	 -312,  -273,  -234,  -195,  -156,  -117,   -78,   -39
		; volume 40
		DW	    0,    40,    80,   120,   160,   200,   240,   280
		DW	  320,   360,   400,   440,   480,   520,   560,   600
		DW	  640,   680,   720,   760,   800,   840,   880,   920
		DW	  960,  1000,  1040,  1080,  1120,  1160,  1200,  1240
		DW	 1280,  1320,  1360,  1400,  1440,  1480,  1520,  1560
		DW	 1600,  1640,  1680,  1720,  1760,  1800,  1840,  1880
		DW	 1920,  1960,  2000,  2040,  2080,  2120,  2160,  2200
		DW	 2240,  2280,  2320,  2360,  2400,  2440,  2480,  2520
		DW	 2560,  2600,  2640,  2680,  2720,  2760,  2800,  2840
		DW	 2880,  2920,  2960,  3000,  3040,  3080,  3120,  3160
		DW	 3200,  3240,  3280,  3320,  3360,  3400,  3440,  3480
		DW	 3520,  3560,  3600,  3640,  3680,  3720,  3760,  3800
		DW	 3840,  3880,  3920,  3960,  4000,  4040,  4080,  4120
		DW	 4160,  4200,  4240,  4280,  4320,  4360,  4400,  4440
		DW	 4480,  4520,  4560,  4600,  4640,  4680,  4720,  4760
		DW	 4800,  4840,  4880,  4920,  4960,  5000,  5040,  5080
		DW	-5120, -5080, -5040, -5000, -4960, -4920, -4880, -4840
		DW	-4800, -4760, -4720, -4680, -4640, -4600, -4560, -4520
		DW	-4480, -4440, -4400, -4360, -4320, -4280, -4240, -4200
		DW	-4160, -4120, -4080, -4040, -4000, -3960, -3920, -3880
		DW	-3840, -3800, -3760, -3720, -3680, -3640, -3600, -3560
		DW	-3520, -3480, -3440, -3400, -3360, -3320, -3280, -3240
		DW	-3200, -3160, -3120, -3080, -3040, -3000, -2960, -2920
		DW	-2880, -2840, -2800, -2760, -2720, -2680, -2640, -2600
		DW	-2560, -2520, -2480, -2440, -2400, -2360, -2320, -2280
		DW	-2240, -2200, -2160, -2120, -2080, -2040, -2000, -1960
		DW	-1920, -1880, -1840, -1800, -1760, -1720, -1680, -1640
		DW	-1600, -1560, -1520, -1480, -1440, -1400, -1360, -1320
		DW	-1280, -1240, -1200, -1160, -1120, -1080, -1040, -1000
		DW	 -960,  -920,  -880,  -840,  -800,  -760,  -720,  -680
		DW	 -640,  -600,  -560,  -520,  -480,  -440,  -400,  -360
		DW	 -320,  -280,  -240,  -200,  -160,  -120,   -80,   -40
		; volume 41
		DW	    0,    41,    82,   123,   164,   205,   246,   287
		DW	  328,   369,   410,   451,   492,   533,   574,   615
		DW	  656,   697,   738,   779,   820,   861,   902,   943
		DW	  984,  1025,  1066,  1107,  1148,  1189,  1230,  1271
		DW	 1312,  1353,  1394,  1435,  1476,  1517,  1558,  1599
		DW	 1640,  1681,  1722,  1763,  1804,  1845,  1886,  1927
		DW	 1968,  2009,  2050,  2091,  2132,  2173,  2214,  2255
		DW	 2296,  2337,  2378,  2419,  2460,  2501,  2542,  2583
		DW	 2624,  2665,  2706,  2747,  2788,  2829,  2870,  2911
		DW	 2952,  2993,  3034,  3075,  3116,  3157,  3198,  3239
		DW	 3280,  3321,  3362,  3403,  3444,  3485,  3526,  3567
		DW	 3608,  3649,  3690,  3731,  3772,  3813,  3854,  3895
		DW	 3936,  3977,  4018,  4059,  4100,  4141,  4182,  4223
		DW	 4264,  4305,  4346,  4387,  4428,  4469,  4510,  4551
		DW	 4592,  4633,  4674,  4715,  4756,  4797,  4838,  4879
		DW	 4920,  4961,  5002,  5043,  5084,  5125,  5166,  5207
		DW	-5248, -5207, -5166, -5125, -5084, -5043, -5002, -4961
		DW	-4920, -4879, -4838, -4797, -4756, -4715, -4674, -4633
		DW	-4592, -4551, -4510, -4469, -4428, -4387, -4346, -4305
		DW	-4264, -4223, -4182, -4141, -4100, -4059, -4018, -3977
		DW	-3936, -3895, -3854, -3813, -3772, -3731, -3690, -3649
		DW	-3608, -3567, -3526, -3485, -3444, -3403, -3362, -3321
		DW	-3280, -3239, -3198, -3157, -3116, -3075, -3034, -2993
		DW	-2952, -2911, -2870, -2829, -2788, -2747, -2706, -2665
		DW	-2624, -2583, -2542, -2501, -2460, -2419, -2378, -2337
		DW	-2296, -2255, -2214, -2173, -2132, -2091, -2050, -2009
		DW	-1968, -1927, -1886, -1845, -1804, -1763, -1722, -1681
		DW	-1640, -1599, -1558, -1517, -1476, -1435, -1394, -1353
		DW	-1312, -1271, -1230, -1189, -1148, -1107, -1066, -1025
		DW	 -984,  -943,  -902,  -861,  -820,  -779,  -738,  -697
		DW	 -656,  -615,  -574,  -533,  -492,  -451,  -410,  -369
		DW	 -328,  -287,  -246,  -205,  -164,  -123,   -82,   -41
		; volume 42
		DW	    0,    42,    84,   126,   168,   210,   252,   294
		DW	  336,   378,   420,   462,   504,   546,   588,   630
		DW	  672,   714,   756,   798,   840,   882,   924,   966
		DW	 1008,  1050,  1092,  1134,  1176,  1218,  1260,  1302
		DW	 1344,  1386,  1428,  1470,  1512,  1554,  1596,  1638
		DW	 1680,  1722,  1764,  1806,  1848,  1890,  1932,  1974
		DW	 2016,  2058,  2100,  2142,  2184,  2226,  2268,  2310
		DW	 2352,  2394,  2436,  2478,  2520,  2562,  2604,  2646
		DW	 2688,  2730,  2772,  2814,  2856,  2898,  2940,  2982
		DW	 3024,  3066,  3108,  3150,  3192,  3234,  3276,  3318
		DW	 3360,  3402,  3444,  3486,  3528,  3570,  3612,  3654
		DW	 3696,  3738,  3780,  3822,  3864,  3906,  3948,  3990
		DW	 4032,  4074,  4116,  4158,  4200,  4242,  4284,  4326
		DW	 4368,  4410,  4452,  4494,  4536,  4578,  4620,  4662
		DW	 4704,  4746,  4788,  4830,  4872,  4914,  4956,  4998
		DW	 5040,  5082,  5124,  5166,  5208,  5250,  5292,  5334
		DW	-5376, -5334, -5292, -5250, -5208, -5166, -5124, -5082
		DW	-5040, -4998, -4956, -4914, -4872, -4830, -4788, -4746
		DW	-4704, -4662, -4620, -4578, -4536, -4494, -4452, -4410
		DW	-4368, -4326, -4284, -4242, -4200, -4158, -4116, -4074
		DW	-4032, -3990, -3948, -3906, -3864, -3822, -3780, -3738
		DW	-3696, -3654, -3612, -3570, -3528, -3486, -3444, -3402
		DW	-3360, -3318, -3276, -3234, -3192, -3150, -3108, -3066
		DW	-3024, -2982, -2940, -2898, -2856, -2814, -2772, -2730
		DW	-2688, -2646, -2604, -2562, -2520, -2478, -2436, -2394
		DW	-2352, -2310, -2268, -2226, -2184, -2142, -2100, -2058
		DW	-2016, -1974, -1932, -1890, -1848, -1806, -1764, -1722
		DW	-1680, -1638, -1596, -1554, -1512, -1470, -1428, -1386
		DW	-1344, -1302, -1260, -1218, -1176, -1134, -1092, -1050
		DW	-1008,  -966,  -924,  -882,  -840,  -798,  -756,  -714
		DW	 -672,  -630,  -588,  -546,  -504,  -462,  -420,  -378
		DW	 -336,  -294,  -252,  -210,  -168,  -126,   -84,   -42
		; volume 43
		DW	    0,    43,    86,   129,   172,   215,   258,   301
		DW	  344,   387,   430,   473,   516,   559,   602,   645
		DW	  688,   731,   774,   817,   860,   903,   946,   989
		DW	 1032,  1075,  1118,  1161,  1204,  1247,  1290,  1333
		DW	 1376,  1419,  1462,  1505,  1548,  1591,  1634,  1677
		DW	 1720,  1763,  1806,  1849,  1892,  1935,  1978,  2021
		DW	 2064,  2107,  2150,  2193,  2236,  2279,  2322,  2365
		DW	 2408,  2451,  2494,  2537,  2580,  2623,  2666,  2709
		DW	 2752,  2795,  2838,  2881,  2924,  2967,  3010,  3053
		DW	 3096,  3139,  3182,  3225,  3268,  3311,  3354,  3397
		DW	 3440,  3483,  3526,  3569,  3612,  3655,  3698,  3741
		DW	 3784,  3827,  3870,  3913,  3956,  3999,  4042,  4085
		DW	 4128,  4171,  4214,  4257,  4300,  4343,  4386,  4429
		DW	 4472,  4515,  4558,  4601,  4644,  4687,  4730,  4773
		DW	 4816,  4859,  4902,  4945,  4988,  5031,  5074,  5117
		DW	 5160,  5203,  5246,  5289,  5332,  5375,  5418,  5461
		DW	-5504, -5461, -5418, -5375, -5332, -5289, -5246, -5203
		DW	-5160, -5117, -5074, -5031, -4988, -4945, -4902, -4859
		DW	-4816, -4773, -4730, -4687, -4644, -4601, -4558, -4515
		DW	-4472, -4429, -4386, -4343, -4300, -4257, -4214, -4171
		DW	-4128, -4085, -4042, -3999, -3956, -3913, -3870, -3827
		DW	-3784, -3741, -3698, -3655, -3612, -3569, -3526, -3483
		DW	-3440, -3397, -3354, -3311, -3268, -3225, -3182, -3139
		DW	-3096, -3053, -3010, -2967, -2924, -2881, -2838, -2795
		DW	-2752, -2709, -2666, -2623, -2580, -2537, -2494, -2451
		DW	-2408, -2365, -2322, -2279, -2236, -2193, -2150, -2107
		DW	-2064, -2021, -1978, -1935, -1892, -1849, -1806, -1763
		DW	-1720, -1677, -1634, -1591, -1548, -1505, -1462, -1419
		DW	-1376, -1333, -1290, -1247, -1204, -1161, -1118, -1075
		DW	-1032,  -989,  -946,  -903,  -860,  -817,  -774,  -731
		DW	 -688,  -645,  -602,  -559,  -516,  -473,  -430,  -387
		DW	 -344,  -301,  -258,  -215,  -172,  -129,   -86,   -43
		; volume 44
		DW	    0,    44,    88,   132,   176,   220,   264,   308
		DW	  352,   396,   440,   484,   528,   572,   616,   660
		DW	  704,   748,   792,   836,   880,   924,   968,  1012
		DW	 1056,  1100,  1144,  1188,  1232,  1276,  1320,  1364
		DW	 1408,  1452,  1496,  1540,  1584,  1628,  1672,  1716
		DW	 1760,  1804,  1848,  1892,  1936,  1980,  2024,  2068
		DW	 2112,  2156,  2200,  2244,  2288,  2332,  2376,  2420
		DW	 2464,  2508,  2552,  2596,  2640,  2684,  2728,  2772
		DW	 2816,  2860,  2904,  2948,  2992,  3036,  3080,  3124
		DW	 3168,  3212,  3256,  3300,  3344,  3388,  3432,  3476
		DW	 3520,  3564,  3608,  3652,  3696,  3740,  3784,  3828
		DW	 3872,  3916,  3960,  4004,  4048,  4092,  4136,  4180
		DW	 4224,  4268,  4312,  4356,  4400,  4444,  4488,  4532
		DW	 4576,  4620,  4664,  4708,  4752,  4796,  4840,  4884
		DW	 4928,  4972,  5016,  5060,  5104,  5148,  5192,  5236
		DW	 5280,  5324,  5368,  5412,  5456,  5500,  5544,  5588
		DW	-5632, -5588, -5544, -5500, -5456, -5412, -5368, -5324
		DW	-5280, -5236, -5192, -5148, -5104, -5060, -5016, -4972
		DW	-4928, -4884, -4840, -4796, -4752, -4708, -4664, -4620
		DW	-4576, -4532, -4488, -4444, -4400, -4356, -4312, -4268
		DW	-4224, -4180, -4136, -4092, -4048, -4004, -3960, -3916
		DW	-3872, -3828, -3784, -3740, -3696, -3652, -3608, -3564
		DW	-3520, -3476, -3432, -3388, -3344, -3300, -3256, -3212
		DW	-3168, -3124, -3080, -3036, -2992, -2948, -2904, -2860
		DW	-2816, -2772, -2728, -2684, -2640, -2596, -2552, -2508
		DW	-2464, -2420, -2376, -2332, -2288, -2244, -2200, -2156
		DW	-2112, -2068, -2024, -1980, -1936, -1892, -1848, -1804
		DW	-1760, -1716, -1672, -1628, -1584, -1540, -1496, -1452
		DW	-1408, -1364, -1320, -1276, -1232, -1188, -1144, -1100
		DW	-1056, -1012,  -968,  -924,  -880,  -836,  -792,  -748
		DW	 -704,  -660,  -616,  -572,  -528,  -484,  -440,  -396
		DW	 -352,  -308,  -264,  -220,  -176,  -132,   -88,   -44
		; volume 45
		DW	    0,    45,    90,   135,   180,   225,   270,   315
		DW	  360,   405,   450,   495,   540,   585,   630,   675
		DW	  720,   765,   810,   855,   900,   945,   990,  1035
		DW	 1080,  1125,  1170,  1215,  1260,  1305,  1350,  1395
		DW	 1440,  1485,  1530,  1575,  1620,  1665,  1710,  1755
		DW	 1800,  1845,  1890,  1935,  1980,  2025,  2070,  2115
		DW	 2160,  2205,  2250,  2295,  2340,  2385,  2430,  2475
		DW	 2520,  2565,  2610,  2655,  2700,  2745,  2790,  2835
		DW	 2880,  2925,  2970,  3015,  3060,  3105,  3150,  3195
		DW	 3240,  3285,  3330,  3375,  3420,  3465,  3510,  3555
		DW	 3600,  3645,  3690,  3735,  3780,  3825,  3870,  3915
		DW	 3960,  4005,  4050,  4095,  4140,  4185,  4230,  4275
		DW	 4320,  4365,  4410,  4455,  4500,  4545,  4590,  4635
		DW	 4680,  4725,  4770,  4815,  4860,  4905,  4950,  4995
		DW	 5040,  5085,  5130,  5175,  5220,  5265,  5310,  5355
		DW	 5400,  5445,  5490,  5535,  5580,  5625,  5670,  5715
		DW	-5760, -5715, -5670, -5625, -5580, -5535, -5490, -5445
		DW	-5400, -5355, -5310, -5265, -5220, -5175, -5130, -5085
		DW	-5040, -4995, -4950, -4905, -4860, -4815, -4770, -4725
		DW	-4680, -4635, -4590, -4545, -4500, -4455, -4410, -4365
		DW	-4320, -4275, -4230, -4185, -4140, -4095, -4050, -4005
		DW	-3960, -3915, -3870, -3825, -3780, -3735, -3690, -3645
		DW	-3600, -3555, -3510, -3465, -3420, -3375, -3330, -3285
		DW	-3240, -3195, -3150, -3105, -3060, -3015, -2970, -2925
		DW	-2880, -2835, -2790, -2745, -2700, -2655, -2610, -2565
		DW	-2520, -2475, -2430, -2385, -2340, -2295, -2250, -2205
		DW	-2160, -2115, -2070, -2025, -1980, -1935, -1890, -1845
		DW	-1800, -1755, -1710, -1665, -1620, -1575, -1530, -1485
		DW	-1440, -1395, -1350, -1305, -1260, -1215, -1170, -1125
		DW	-1080, -1035,  -990,  -945,  -900,  -855,  -810,  -765
		DW	 -720,  -675,  -630,  -585,  -540,  -495,  -450,  -405
		DW	 -360,  -315,  -270,  -225,  -180,  -135,   -90,   -45
		; volume 46
		DW	    0,    46,    92,   138,   184,   230,   276,   322
		DW	  368,   414,   460,   506,   552,   598,   644,   690
		DW	  736,   782,   828,   874,   920,   966,  1012,  1058
		DW	 1104,  1150,  1196,  1242,  1288,  1334,  1380,  1426
		DW	 1472,  1518,  1564,  1610,  1656,  1702,  1748,  1794
		DW	 1840,  1886,  1932,  1978,  2024,  2070,  2116,  2162
		DW	 2208,  2254,  2300,  2346,  2392,  2438,  2484,  2530
		DW	 2576,  2622,  2668,  2714,  2760,  2806,  2852,  2898
		DW	 2944,  2990,  3036,  3082,  3128,  3174,  3220,  3266
		DW	 3312,  3358,  3404,  3450,  3496,  3542,  3588,  3634
		DW	 3680,  3726,  3772,  3818,  3864,  3910,  3956,  4002
		DW	 4048,  4094,  4140,  4186,  4232,  4278,  4324,  4370
		DW	 4416,  4462,  4508,  4554,  4600,  4646,  4692,  4738
		DW	 4784,  4830,  4876,  4922,  4968,  5014,  5060,  5106
		DW	 5152,  5198,  5244,  5290,  5336,  5382,  5428,  5474
		DW	 5520,  5566,  5612,  5658,  5704,  5750,  5796,  5842
		DW	-5888, -5842, -5796, -5750, -5704, -5658, -5612, -5566
		DW	-5520, -5474, -5428, -5382, -5336, -5290, -5244, -5198
		DW	-5152, -5106, -5060, -5014, -4968, -4922, -4876, -4830
		DW	-4784, -4738, -4692, -4646, -4600, -4554, -4508, -4462
		DW	-4416, -4370, -4324, -4278, -4232, -4186, -4140, -4094
		DW	-4048, -4002, -3956, -3910, -3864, -3818, -3772, -3726
		DW	-3680, -3634, -3588, -3542, -3496, -3450, -3404, -3358
		DW	-3312, -3266, -3220, -3174, -3128, -3082, -3036, -2990
		DW	-2944, -2898, -2852, -2806, -2760, -2714, -2668, -2622
		DW	-2576, -2530, -2484, -2438, -2392, -2346, -2300, -2254
		DW	-2208, -2162, -2116, -2070, -2024, -1978, -1932, -1886
		DW	-1840, -1794, -1748, -1702, -1656, -1610, -1564, -1518
		DW	-1472, -1426, -1380, -1334, -1288, -1242, -1196, -1150
		DW	-1104, -1058, -1012,  -966,  -920,  -874,  -828,  -782
		DW	 -736,  -690,  -644,  -598,  -552,  -506,  -460,  -414
		DW	 -368,  -322,  -276,  -230,  -184,  -138,   -92,   -46
		; volume 47
		DW	    0,    47,    94,   141,   188,   235,   282,   329
		DW	  376,   423,   470,   517,   564,   611,   658,   705
		DW	  752,   799,   846,   893,   940,   987,  1034,  1081
		DW	 1128,  1175,  1222,  1269,  1316,  1363,  1410,  1457
		DW	 1504,  1551,  1598,  1645,  1692,  1739,  1786,  1833
		DW	 1880,  1927,  1974,  2021,  2068,  2115,  2162,  2209
		DW	 2256,  2303,  2350,  2397,  2444,  2491,  2538,  2585
		DW	 2632,  2679,  2726,  2773,  2820,  2867,  2914,  2961
		DW	 3008,  3055,  3102,  3149,  3196,  3243,  3290,  3337
		DW	 3384,  3431,  3478,  3525,  3572,  3619,  3666,  3713
		DW	 3760,  3807,  3854,  3901,  3948,  3995,  4042,  4089
		DW	 4136,  4183,  4230,  4277,  4324,  4371,  4418,  4465
		DW	 4512,  4559,  4606,  4653,  4700,  4747,  4794,  4841
		DW	 4888,  4935,  4982,  5029,  5076,  5123,  5170,  5217
		DW	 5264,  5311,  5358,  5405,  5452,  5499,  5546,  5593
		DW	 5640,  5687,  5734,  5781,  5828,  5875,  5922,  5969
		DW	-6016, -5969, -5922, -5875, -5828, -5781, -5734, -5687
		DW	-5640, -5593, -5546, -5499, -5452, -5405, -5358, -5311
		DW	-5264, -5217, -5170, -5123, -5076, -5029, -4982, -4935
		DW	-4888, -4841, -4794, -4747, -4700, -4653, -4606, -4559
		DW	-4512, -4465, -4418, -4371, -4324, -4277, -4230, -4183
		DW	-4136, -4089, -4042, -3995, -3948, -3901, -3854, -3807
		DW	-3760, -3713, -3666, -3619, -3572, -3525, -3478, -3431
		DW	-3384, -3337, -3290, -3243, -3196, -3149, -3102, -3055
		DW	-3008, -2961, -2914, -2867, -2820, -2773, -2726, -2679
		DW	-2632, -2585, -2538, -2491, -2444, -2397, -2350, -2303
		DW	-2256, -2209, -2162, -2115, -2068, -2021, -1974, -1927
		DW	-1880, -1833, -1786, -1739, -1692, -1645, -1598, -1551
		DW	-1504, -1457, -1410, -1363, -1316, -1269, -1222, -1175
		DW	-1128, -1081, -1034,  -987,  -940,  -893,  -846,  -799
		DW	 -752,  -705,  -658,  -611,  -564,  -517,  -470,  -423
		DW	 -376,  -329,  -282,  -235,  -188,  -141,   -94,   -47
		; volume 48
		DW	    0,    48,    96,   144,   192,   240,   288,   336
		DW	  384,   432,   480,   528,   576,   624,   672,   720
		DW	  768,   816,   864,   912,   960,  1008,  1056,  1104
		DW	 1152,  1200,  1248,  1296,  1344,  1392,  1440,  1488
		DW	 1536,  1584,  1632,  1680,  1728,  1776,  1824,  1872
		DW	 1920,  1968,  2016,  2064,  2112,  2160,  2208,  2256
		DW	 2304,  2352,  2400,  2448,  2496,  2544,  2592,  2640
		DW	 2688,  2736,  2784,  2832,  2880,  2928,  2976,  3024
		DW	 3072,  3120,  3168,  3216,  3264,  3312,  3360,  3408
		DW	 3456,  3504,  3552,  3600,  3648,  3696,  3744,  3792
		DW	 3840,  3888,  3936,  3984,  4032,  4080,  4128,  4176
		DW	 4224,  4272,  4320,  4368,  4416,  4464,  4512,  4560
		DW	 4608,  4656,  4704,  4752,  4800,  4848,  4896,  4944
		DW	 4992,  5040,  5088,  5136,  5184,  5232,  5280,  5328
		DW	 5376,  5424,  5472,  5520,  5568,  5616,  5664,  5712
		DW	 5760,  5808,  5856,  5904,  5952,  6000,  6048,  6096
		DW	-6144, -6096, -6048, -6000, -5952, -5904, -5856, -5808
		DW	-5760, -5712, -5664, -5616, -5568, -5520, -5472, -5424
		DW	-5376, -5328, -5280, -5232, -5184, -5136, -5088, -5040
		DW	-4992, -4944, -4896, -4848, -4800, -4752, -4704, -4656
		DW	-4608, -4560, -4512, -4464, -4416, -4368, -4320, -4272
		DW	-4224, -4176, -4128, -4080, -4032, -3984, -3936, -3888
		DW	-3840, -3792, -3744, -3696, -3648, -3600, -3552, -3504
		DW	-3456, -3408, -3360, -3312, -3264, -3216, -3168, -3120
		DW	-3072, -3024, -2976, -2928, -2880, -2832, -2784, -2736
		DW	-2688, -2640, -2592, -2544, -2496, -2448, -2400, -2352
		DW	-2304, -2256, -2208, -2160, -2112, -2064, -2016, -1968
		DW	-1920, -1872, -1824, -1776, -1728, -1680, -1632, -1584
		DW	-1536, -1488, -1440, -1392, -1344, -1296, -1248, -1200
		DW	-1152, -1104, -1056, -1008,  -960,  -912,  -864,  -816
		DW	 -768,  -720,  -672,  -624,  -576,  -528,  -480,  -432
		DW	 -384,  -336,  -288,  -240,  -192,  -144,   -96,   -48
		; volume 49
		DW	    0,    49,    98,   147,   196,   245,   294,   343
		DW	  392,   441,   490,   539,   588,   637,   686,   735
		DW	  784,   833,   882,   931,   980,  1029,  1078,  1127
		DW	 1176,  1225,  1274,  1323,  1372,  1421,  1470,  1519
		DW	 1568,  1617,  1666,  1715,  1764,  1813,  1862,  1911
		DW	 1960,  2009,  2058,  2107,  2156,  2205,  2254,  2303
		DW	 2352,  2401,  2450,  2499,  2548,  2597,  2646,  2695
		DW	 2744,  2793,  2842,  2891,  2940,  2989,  3038,  3087
		DW	 3136,  3185,  3234,  3283,  3332,  3381,  3430,  3479
		DW	 3528,  3577,  3626,  3675,  3724,  3773,  3822,  3871
		DW	 3920,  3969,  4018,  4067,  4116,  4165,  4214,  4263
		DW	 4312,  4361,  4410,  4459,  4508,  4557,  4606,  4655
		DW	 4704,  4753,  4802,  4851,  4900,  4949,  4998,  5047
		DW	 5096,  5145,  5194,  5243,  5292,  5341,  5390,  5439
		DW	 5488,  5537,  5586,  5635,  5684,  5733,  5782,  5831
		DW	 5880,  5929,  5978,  6027,  6076,  6125,  6174,  6223
		DW	-6272, -6223, -6174, -6125, -6076, -6027, -5978, -5929
		DW	-5880, -5831, -5782, -5733, -5684, -5635, -5586, -5537
		DW	-5488, -5439, -5390, -5341, -5292, -5243, -5194, -5145
		DW	-5096, -5047, -4998, -4949, -4900, -4851, -4802, -4753
		DW	-4704, -4655, -4606, -4557, -4508, -4459, -4410, -4361
		DW	-4312, -4263, -4214, -4165, -4116, -4067, -4018, -3969
		DW	-3920, -3871, -3822, -3773, -3724, -3675, -3626, -3577
		DW	-3528, -3479, -3430, -3381, -3332, -3283, -3234, -3185
		DW	-3136, -3087, -3038, -2989, -2940, -2891, -2842, -2793
		DW	-2744, -2695, -2646, -2597, -2548, -2499, -2450, -2401
		DW	-2352, -2303, -2254, -2205, -2156, -2107, -2058, -2009
		DW	-1960, -1911, -1862, -1813, -1764, -1715, -1666, -1617
		DW	-1568, -1519, -1470, -1421, -1372, -1323, -1274, -1225
		DW	-1176, -1127, -1078, -1029,  -980,  -931,  -882,  -833
		DW	 -784,  -735,  -686,  -637,  -588,  -539,  -490,  -441
		DW	 -392,  -343,  -294,  -245,  -196,  -147,   -98,   -49
		; volume 50
		DW	    0,    50,   100,   150,   200,   250,   300,   350
		DW	  400,   450,   500,   550,   600,   650,   700,   750
		DW	  800,   850,   900,   950,  1000,  1050,  1100,  1150
		DW	 1200,  1250,  1300,  1350,  1400,  1450,  1500,  1550
		DW	 1600,  1650,  1700,  1750,  1800,  1850,  1900,  1950
		DW	 2000,  2050,  2100,  2150,  2200,  2250,  2300,  2350
		DW	 2400,  2450,  2500,  2550,  2600,  2650,  2700,  2750
		DW	 2800,  2850,  2900,  2950,  3000,  3050,  3100,  3150
		DW	 3200,  3250,  3300,  3350,  3400,  3450,  3500,  3550
		DW	 3600,  3650,  3700,  3750,  3800,  3850,  3900,  3950
		DW	 4000,  4050,  4100,  4150,  4200,  4250,  4300,  4350
		DW	 4400,  4450,  4500,  4550,  4600,  4650,  4700,  4750
		DW	 4800,  4850,  4900,  4950,  5000,  5050,  5100,  5150
		DW	 5200,  5250,  5300,  5350,  5400,  5450,  5500,  5550
		DW	 5600,  5650,  5700,  5750,  5800,  5850,  5900,  5950
		DW	 6000,  6050,  6100,  6150,  6200,  6250,  6300,  6350
		DW	-6400, -6350, -6300, -6250, -6200, -6150, -6100, -6050
		DW	-6000, -5950, -5900, -5850, -5800, -5750, -5700, -5650
		DW	-5600, -5550, -5500, -5450, -5400, -5350, -5300, -5250
		DW	-5200, -5150, -5100, -5050, -5000, -4950, -4900, -4850
		DW	-4800, -4750, -4700, -4650, -4600, -4550, -4500, -4450
		DW	-4400, -4350, -4300, -4250, -4200, -4150, -4100, -4050
		DW	-4000, -3950, -3900, -3850, -3800, -3750, -3700, -3650
		DW	-3600, -3550, -3500, -3450, -3400, -3350, -3300, -3250
		DW	-3200, -3150, -3100, -3050, -3000, -2950, -2900, -2850
		DW	-2800, -2750, -2700, -2650, -2600, -2550, -2500, -2450
		DW	-2400, -2350, -2300, -2250, -2200, -2150, -2100, -2050
		DW	-2000, -1950, -1900, -1850, -1800, -1750, -1700, -1650
		DW	-1600, -1550, -1500, -1450, -1400, -1350, -1300, -1250
		DW	-1200, -1150, -1100, -1050, -1000,  -950,  -900,  -850
		DW	 -800,  -750,  -700,  -650,  -600,  -550,  -500,  -450
		DW	 -400,  -350,  -300,  -250,  -200,  -150,  -100,   -50
		; volume 51
		DW	    0,    51,   102,   153,   204,   255,   306,   357
		DW	  408,   459,   510,   561,   612,   663,   714,   765
		DW	  816,   867,   918,   969,  1020,  1071,  1122,  1173
		DW	 1224,  1275,  1326,  1377,  1428,  1479,  1530,  1581
		DW	 1632,  1683,  1734,  1785,  1836,  1887,  1938,  1989
		DW	 2040,  2091,  2142,  2193,  2244,  2295,  2346,  2397
		DW	 2448,  2499,  2550,  2601,  2652,  2703,  2754,  2805
		DW	 2856,  2907,  2958,  3009,  3060,  3111,  3162,  3213
		DW	 3264,  3315,  3366,  3417,  3468,  3519,  3570,  3621
		DW	 3672,  3723,  3774,  3825,  3876,  3927,  3978,  4029
		DW	 4080,  4131,  4182,  4233,  4284,  4335,  4386,  4437
		DW	 4488,  4539,  4590,  4641,  4692,  4743,  4794,  4845
		DW	 4896,  4947,  4998,  5049,  5100,  5151,  5202,  5253
		DW	 5304,  5355,  5406,  5457,  5508,  5559,  5610,  5661
		DW	 5712,  5763,  5814,  5865,  5916,  5967,  6018,  6069
		DW	 6120,  6171,  6222,  6273,  6324,  6375,  6426,  6477
		DW	-6528, -6477, -6426, -6375, -6324, -6273, -6222, -6171
		DW	-6120, -6069, -6018, -5967, -5916, -5865, -5814, -5763
		DW	-5712, -5661, -5610, -5559, -5508, -5457, -5406, -5355
		DW	-5304, -5253, -5202, -5151, -5100, -5049, -4998, -4947
		DW	-4896, -4845, -4794, -4743, -4692, -4641, -4590, -4539
		DW	-4488, -4437, -4386, -4335, -4284, -4233, -4182, -4131
		DW	-4080, -4029, -3978, -3927, -3876, -3825, -3774, -3723
		DW	-3672, -3621, -3570, -3519, -3468, -3417, -3366, -3315
		DW	-3264, -3213, -3162, -3111, -3060, -3009, -2958, -2907
		DW	-2856, -2805, -2754, -2703, -2652, -2601, -2550, -2499
		DW	-2448, -2397, -2346, -2295, -2244, -2193, -2142, -2091
		DW	-2040, -1989, -1938, -1887, -1836, -1785, -1734, -1683
		DW	-1632, -1581, -1530, -1479, -1428, -1377, -1326, -1275
		DW	-1224, -1173, -1122, -1071, -1020,  -969,  -918,  -867
		DW	 -816,  -765,  -714,  -663,  -612,  -561,  -510,  -459
		DW	 -408,  -357,  -306,  -255,  -204,  -153,  -102,   -51
		; volume 52
		DW	    0,    52,   104,   156,   208,   260,   312,   364
		DW	  416,   468,   520,   572,   624,   676,   728,   780
		DW	  832,   884,   936,   988,  1040,  1092,  1144,  1196
		DW	 1248,  1300,  1352,  1404,  1456,  1508,  1560,  1612
		DW	 1664,  1716,  1768,  1820,  1872,  1924,  1976,  2028
		DW	 2080,  2132,  2184,  2236,  2288,  2340,  2392,  2444
		DW	 2496,  2548,  2600,  2652,  2704,  2756,  2808,  2860
		DW	 2912,  2964,  3016,  3068,  3120,  3172,  3224,  3276
		DW	 3328,  3380,  3432,  3484,  3536,  3588,  3640,  3692
		DW	 3744,  3796,  3848,  3900,  3952,  4004,  4056,  4108
		DW	 4160,  4212,  4264,  4316,  4368,  4420,  4472,  4524
		DW	 4576,  4628,  4680,  4732,  4784,  4836,  4888,  4940
		DW	 4992,  5044,  5096,  5148,  5200,  5252,  5304,  5356
		DW	 5408,  5460,  5512,  5564,  5616,  5668,  5720,  5772
		DW	 5824,  5876,  5928,  5980,  6032,  6084,  6136,  6188
		DW	 6240,  6292,  6344,  6396,  6448,  6500,  6552,  6604
		DW	-6656, -6604, -6552, -6500, -6448, -6396, -6344, -6292
		DW	-6240, -6188, -6136, -6084, -6032, -5980, -5928, -5876
		DW	-5824, -5772, -5720, -5668, -5616, -5564, -5512, -5460
		DW	-5408, -5356, -5304, -5252, -5200, -5148, -5096, -5044
		DW	-4992, -4940, -4888, -4836, -4784, -4732, -4680, -4628
		DW	-4576, -4524, -4472, -4420, -4368, -4316, -4264, -4212
		DW	-4160, -4108, -4056, -4004, -3952, -3900, -3848, -3796
		DW	-3744, -3692, -3640, -3588, -3536, -3484, -3432, -3380
		DW	-3328, -3276, -3224, -3172, -3120, -3068, -3016, -2964
		DW	-2912, -2860, -2808, -2756, -2704, -2652, -2600, -2548
		DW	-2496, -2444, -2392, -2340, -2288, -2236, -2184, -2132
		DW	-2080, -2028, -1976, -1924, -1872, -1820, -1768, -1716
		DW	-1664, -1612, -1560, -1508, -1456, -1404, -1352, -1300
		DW	-1248, -1196, -1144, -1092, -1040,  -988,  -936,  -884
		DW	 -832,  -780,  -728,  -676,  -624,  -572,  -520,  -468
		DW	 -416,  -364,  -312,  -260,  -208,  -156,  -104,   -52
		; volume 53
		DW	    0,    53,   106,   159,   212,   265,   318,   371
		DW	  424,   477,   530,   583,   636,   689,   742,   795
		DW	  848,   901,   954,  1007,  1060,  1113,  1166,  1219
		DW	 1272,  1325,  1378,  1431,  1484,  1537,  1590,  1643
		DW	 1696,  1749,  1802,  1855,  1908,  1961,  2014,  2067
		DW	 2120,  2173,  2226,  2279,  2332,  2385,  2438,  2491
		DW	 2544,  2597,  2650,  2703,  2756,  2809,  2862,  2915
		DW	 2968,  3021,  3074,  3127,  3180,  3233,  3286,  3339
		DW	 3392,  3445,  3498,  3551,  3604,  3657,  3710,  3763
		DW	 3816,  3869,  3922,  3975,  4028,  4081,  4134,  4187
		DW	 4240,  4293,  4346,  4399,  4452,  4505,  4558,  4611
		DW	 4664,  4717,  4770,  4823,  4876,  4929,  4982,  5035
		DW	 5088,  5141,  5194,  5247,  5300,  5353,  5406,  5459
		DW	 5512,  5565,  5618,  5671,  5724,  5777,  5830,  5883
		DW	 5936,  5989,  6042,  6095,  6148,  6201,  6254,  6307
		DW	 6360,  6413,  6466,  6519,  6572,  6625,  6678,  6731
		DW	-6784, -6731, -6678, -6625, -6572, -6519, -6466, -6413
		DW	-6360, -6307, -6254, -6201, -6148, -6095, -6042, -5989
		DW	-5936, -5883, -5830, -5777, -5724, -5671, -5618, -5565
		DW	-5512, -5459, -5406, -5353, -5300, -5247, -5194, -5141
		DW	-5088, -5035, -4982, -4929, -4876, -4823, -4770, -4717
		DW	-4664, -4611, -4558, -4505, -4452, -4399, -4346, -4293
		DW	-4240, -4187, -4134, -4081, -4028, -3975, -3922, -3869
		DW	-3816, -3763, -3710, -3657, -3604, -3551, -3498, -3445
		DW	-3392, -3339, -3286, -3233, -3180, -3127, -3074, -3021
		DW	-2968, -2915, -2862, -2809, -2756, -2703, -2650, -2597
		DW	-2544, -2491, -2438, -2385, -2332, -2279, -2226, -2173
		DW	-2120, -2067, -2014, -1961, -1908, -1855, -1802, -1749
		DW	-1696, -1643, -1590, -1537, -1484, -1431, -1378, -1325
		DW	-1272, -1219, -1166, -1113, -1060, -1007,  -954,  -901
		DW	 -848,  -795,  -742,  -689,  -636,  -583,  -530,  -477
		DW	 -424,  -371,  -318,  -265,  -212,  -159,  -106,   -53
		; volume 54
		DW	    0,    54,   108,   162,   216,   270,   324,   378
		DW	  432,   486,   540,   594,   648,   702,   756,   810
		DW	  864,   918,   972,  1026,  1080,  1134,  1188,  1242
		DW	 1296,  1350,  1404,  1458,  1512,  1566,  1620,  1674
		DW	 1728,  1782,  1836,  1890,  1944,  1998,  2052,  2106
		DW	 2160,  2214,  2268,  2322,  2376,  2430,  2484,  2538
		DW	 2592,  2646,  2700,  2754,  2808,  2862,  2916,  2970
		DW	 3024,  3078,  3132,  3186,  3240,  3294,  3348,  3402
		DW	 3456,  3510,  3564,  3618,  3672,  3726,  3780,  3834
		DW	 3888,  3942,  3996,  4050,  4104,  4158,  4212,  4266
		DW	 4320,  4374,  4428,  4482,  4536,  4590,  4644,  4698
		DW	 4752,  4806,  4860,  4914,  4968,  5022,  5076,  5130
		DW	 5184,  5238,  5292,  5346,  5400,  5454,  5508,  5562
		DW	 5616,  5670,  5724,  5778,  5832,  5886,  5940,  5994
		DW	 6048,  6102,  6156,  6210,  6264,  6318,  6372,  6426
		DW	 6480,  6534,  6588,  6642,  6696,  6750,  6804,  6858
		DW	-6912, -6858, -6804, -6750, -6696, -6642, -6588, -6534
		DW	-6480, -6426, -6372, -6318, -6264, -6210, -6156, -6102
		DW	-6048, -5994, -5940, -5886, -5832, -5778, -5724, -5670
		DW	-5616, -5562, -5508, -5454, -5400, -5346, -5292, -5238
		DW	-5184, -5130, -5076, -5022, -4968, -4914, -4860, -4806
		DW	-4752, -4698, -4644, -4590, -4536, -4482, -4428, -4374
		DW	-4320, -4266, -4212, -4158, -4104, -4050, -3996, -3942
		DW	-3888, -3834, -3780, -3726, -3672, -3618, -3564, -3510
		DW	-3456, -3402, -3348, -3294, -3240, -3186, -3132, -3078
		DW	-3024, -2970, -2916, -2862, -2808, -2754, -2700, -2646
		DW	-2592, -2538, -2484, -2430, -2376, -2322, -2268, -2214
		DW	-2160, -2106, -2052, -1998, -1944, -1890, -1836, -1782
		DW	-1728, -1674, -1620, -1566, -1512, -1458, -1404, -1350
		DW	-1296, -1242, -1188, -1134, -1080, -1026,  -972,  -918
		DW	 -864,  -810,  -756,  -702,  -648,  -594,  -540,  -486
		DW	 -432,  -378,  -324,  -270,  -216,  -162,  -108,   -54
		; volume 55
		DW	    0,    55,   110,   165,   220,   275,   330,   385
		DW	  440,   495,   550,   605,   660,   715,   770,   825
		DW	  880,   935,   990,  1045,  1100,  1155,  1210,  1265
		DW	 1320,  1375,  1430,  1485,  1540,  1595,  1650,  1705
		DW	 1760,  1815,  1870,  1925,  1980,  2035,  2090,  2145
		DW	 2200,  2255,  2310,  2365,  2420,  2475,  2530,  2585
		DW	 2640,  2695,  2750,  2805,  2860,  2915,  2970,  3025
		DW	 3080,  3135,  3190,  3245,  3300,  3355,  3410,  3465
		DW	 3520,  3575,  3630,  3685,  3740,  3795,  3850,  3905
		DW	 3960,  4015,  4070,  4125,  4180,  4235,  4290,  4345
		DW	 4400,  4455,  4510,  4565,  4620,  4675,  4730,  4785
		DW	 4840,  4895,  4950,  5005,  5060,  5115,  5170,  5225
		DW	 5280,  5335,  5390,  5445,  5500,  5555,  5610,  5665
		DW	 5720,  5775,  5830,  5885,  5940,  5995,  6050,  6105
		DW	 6160,  6215,  6270,  6325,  6380,  6435,  6490,  6545
		DW	 6600,  6655,  6710,  6765,  6820,  6875,  6930,  6985
		DW	-7040, -6985, -6930, -6875, -6820, -6765, -6710, -6655
		DW	-6600, -6545, -6490, -6435, -6380, -6325, -6270, -6215
		DW	-6160, -6105, -6050, -5995, -5940, -5885, -5830, -5775
		DW	-5720, -5665, -5610, -5555, -5500, -5445, -5390, -5335
		DW	-5280, -5225, -5170, -5115, -5060, -5005, -4950, -4895
		DW	-4840, -4785, -4730, -4675, -4620, -4565, -4510, -4455
		DW	-4400, -4345, -4290, -4235, -4180, -4125, -4070, -4015
		DW	-3960, -3905, -3850, -3795, -3740, -3685, -3630, -3575
		DW	-3520, -3465, -3410, -3355, -3300, -3245, -3190, -3135
		DW	-3080, -3025, -2970, -2915, -2860, -2805, -2750, -2695
		DW	-2640, -2585, -2530, -2475, -2420, -2365, -2310, -2255
		DW	-2200, -2145, -2090, -2035, -1980, -1925, -1870, -1815
		DW	-1760, -1705, -1650, -1595, -1540, -1485, -1430, -1375
		DW	-1320, -1265, -1210, -1155, -1100, -1045,  -990,  -935
		DW	 -880,  -825,  -770,  -715,  -660,  -605,  -550,  -495
		DW	 -440,  -385,  -330,  -275,  -220,  -165,  -110,   -55
		; volume 56
		DW	    0,    56,   112,   168,   224,   280,   336,   392
		DW	  448,   504,   560,   616,   672,   728,   784,   840
		DW	  896,   952,  1008,  1064,  1120,  1176,  1232,  1288
		DW	 1344,  1400,  1456,  1512,  1568,  1624,  1680,  1736
		DW	 1792,  1848,  1904,  1960,  2016,  2072,  2128,  2184
		DW	 2240,  2296,  2352,  2408,  2464,  2520,  2576,  2632
		DW	 2688,  2744,  2800,  2856,  2912,  2968,  3024,  3080
		DW	 3136,  3192,  3248,  3304,  3360,  3416,  3472,  3528
		DW	 3584,  3640,  3696,  3752,  3808,  3864,  3920,  3976
		DW	 4032,  4088,  4144,  4200,  4256,  4312,  4368,  4424
		DW	 4480,  4536,  4592,  4648,  4704,  4760,  4816,  4872
		DW	 4928,  4984,  5040,  5096,  5152,  5208,  5264,  5320
		DW	 5376,  5432,  5488,  5544,  5600,  5656,  5712,  5768
		DW	 5824,  5880,  5936,  5992,  6048,  6104,  6160,  6216
		DW	 6272,  6328,  6384,  6440,  6496,  6552,  6608,  6664
		DW	 6720,  6776,  6832,  6888,  6944,  7000,  7056,  7112
		DW	-7168, -7112, -7056, -7000, -6944, -6888, -6832, -6776
		DW	-6720, -6664, -6608, -6552, -6496, -6440, -6384, -6328
		DW	-6272, -6216, -6160, -6104, -6048, -5992, -5936, -5880
		DW	-5824, -5768, -5712, -5656, -5600, -5544, -5488, -5432
		DW	-5376, -5320, -5264, -5208, -5152, -5096, -5040, -4984
		DW	-4928, -4872, -4816, -4760, -4704, -4648, -4592, -4536
		DW	-4480, -4424, -4368, -4312, -4256, -4200, -4144, -4088
		DW	-4032, -3976, -3920, -3864, -3808, -3752, -3696, -3640
		DW	-3584, -3528, -3472, -3416, -3360, -3304, -3248, -3192
		DW	-3136, -3080, -3024, -2968, -2912, -2856, -2800, -2744
		DW	-2688, -2632, -2576, -2520, -2464, -2408, -2352, -2296
		DW	-2240, -2184, -2128, -2072, -2016, -1960, -1904, -1848
		DW	-1792, -1736, -1680, -1624, -1568, -1512, -1456, -1400
		DW	-1344, -1288, -1232, -1176, -1120, -1064, -1008,  -952
		DW	 -896,  -840,  -784,  -728,  -672,  -616,  -560,  -504
		DW	 -448,  -392,  -336,  -280,  -224,  -168,  -112,   -56
		; volume 57
		DW	    0,    57,   114,   171,   228,   285,   342,   399
		DW	  456,   513,   570,   627,   684,   741,   798,   855
		DW	  912,   969,  1026,  1083,  1140,  1197,  1254,  1311
		DW	 1368,  1425,  1482,  1539,  1596,  1653,  1710,  1767
		DW	 1824,  1881,  1938,  1995,  2052,  2109,  2166,  2223
		DW	 2280,  2337,  2394,  2451,  2508,  2565,  2622,  2679
		DW	 2736,  2793,  2850,  2907,  2964,  3021,  3078,  3135
		DW	 3192,  3249,  3306,  3363,  3420,  3477,  3534,  3591
		DW	 3648,  3705,  3762,  3819,  3876,  3933,  3990,  4047
		DW	 4104,  4161,  4218,  4275,  4332,  4389,  4446,  4503
		DW	 4560,  4617,  4674,  4731,  4788,  4845,  4902,  4959
		DW	 5016,  5073,  5130,  5187,  5244,  5301,  5358,  5415
		DW	 5472,  5529,  5586,  5643,  5700,  5757,  5814,  5871
		DW	 5928,  5985,  6042,  6099,  6156,  6213,  6270,  6327
		DW	 6384,  6441,  6498,  6555,  6612,  6669,  6726,  6783
		DW	 6840,  6897,  6954,  7011,  7068,  7125,  7182,  7239
		DW	-7296, -7239, -7182, -7125, -7068, -7011, -6954, -6897
		DW	-6840, -6783, -6726, -6669, -6612, -6555, -6498, -6441
		DW	-6384, -6327, -6270, -6213, -6156, -6099, -6042, -5985
		DW	-5928, -5871, -5814, -5757, -5700, -5643, -5586, -5529
		DW	-5472, -5415, -5358, -5301, -5244, -5187, -5130, -5073
		DW	-5016, -4959, -4902, -4845, -4788, -4731, -4674, -4617
		DW	-4560, -4503, -4446, -4389, -4332, -4275, -4218, -4161
		DW	-4104, -4047, -3990, -3933, -3876, -3819, -3762, -3705
		DW	-3648, -3591, -3534, -3477, -3420, -3363, -3306, -3249
		DW	-3192, -3135, -3078, -3021, -2964, -2907, -2850, -2793
		DW	-2736, -2679, -2622, -2565, -2508, -2451, -2394, -2337
		DW	-2280, -2223, -2166, -2109, -2052, -1995, -1938, -1881
		DW	-1824, -1767, -1710, -1653, -1596, -1539, -1482, -1425
		DW	-1368, -1311, -1254, -1197, -1140, -1083, -1026,  -969
		DW	 -912,  -855,  -798,  -741,  -684,  -627,  -570,  -513
		DW	 -456,  -399,  -342,  -285,  -228,  -171,  -114,   -57
		; volume 58
		DW	    0,    58,   116,   174,   232,   290,   348,   406
		DW	  464,   522,   580,   638,   696,   754,   812,   870
		DW	  928,   986,  1044,  1102,  1160,  1218,  1276,  1334
		DW	 1392,  1450,  1508,  1566,  1624,  1682,  1740,  1798
		DW	 1856,  1914,  1972,  2030,  2088,  2146,  2204,  2262
		DW	 2320,  2378,  2436,  2494,  2552,  2610,  2668,  2726
		DW	 2784,  2842,  2900,  2958,  3016,  3074,  3132,  3190
		DW	 3248,  3306,  3364,  3422,  3480,  3538,  3596,  3654
		DW	 3712,  3770,  3828,  3886,  3944,  4002,  4060,  4118
		DW	 4176,  4234,  4292,  4350,  4408,  4466,  4524,  4582
		DW	 4640,  4698,  4756,  4814,  4872,  4930,  4988,  5046
		DW	 5104,  5162,  5220,  5278,  5336,  5394,  5452,  5510
		DW	 5568,  5626,  5684,  5742,  5800,  5858,  5916,  5974
		DW	 6032,  6090,  6148,  6206,  6264,  6322,  6380,  6438
		DW	 6496,  6554,  6612,  6670,  6728,  6786,  6844,  6902
		DW	 6960,  7018,  7076,  7134,  7192,  7250,  7308,  7366
		DW	-7424, -7366, -7308, -7250, -7192, -7134, -7076, -7018
		DW	-6960, -6902, -6844, -6786, -6728, -6670, -6612, -6554
		DW	-6496, -6438, -6380, -6322, -6264, -6206, -6148, -6090
		DW	-6032, -5974, -5916, -5858, -5800, -5742, -5684, -5626
		DW	-5568, -5510, -5452, -5394, -5336, -5278, -5220, -5162
		DW	-5104, -5046, -4988, -4930, -4872, -4814, -4756, -4698
		DW	-4640, -4582, -4524, -4466, -4408, -4350, -4292, -4234
		DW	-4176, -4118, -4060, -4002, -3944, -3886, -3828, -3770
		DW	-3712, -3654, -3596, -3538, -3480, -3422, -3364, -3306
		DW	-3248, -3190, -3132, -3074, -3016, -2958, -2900, -2842
		DW	-2784, -2726, -2668, -2610, -2552, -2494, -2436, -2378
		DW	-2320, -2262, -2204, -2146, -2088, -2030, -1972, -1914
		DW	-1856, -1798, -1740, -1682, -1624, -1566, -1508, -1450
		DW	-1392, -1334, -1276, -1218, -1160, -1102, -1044,  -986
		DW	 -928,  -870,  -812,  -754,  -696,  -638,  -580,  -522
		DW	 -464,  -406,  -348,  -290,  -232,  -174,  -116,   -58
		; volume 59
		DW	    0,    59,   118,   177,   236,   295,   354,   413
		DW	  472,   531,   590,   649,   708,   767,   826,   885
		DW	  944,  1003,  1062,  1121,  1180,  1239,  1298,  1357
		DW	 1416,  1475,  1534,  1593,  1652,  1711,  1770,  1829
		DW	 1888,  1947,  2006,  2065,  2124,  2183,  2242,  2301
		DW	 2360,  2419,  2478,  2537,  2596,  2655,  2714,  2773
		DW	 2832,  2891,  2950,  3009,  3068,  3127,  3186,  3245
		DW	 3304,  3363,  3422,  3481,  3540,  3599,  3658,  3717
		DW	 3776,  3835,  3894,  3953,  4012,  4071,  4130,  4189
		DW	 4248,  4307,  4366,  4425,  4484,  4543,  4602,  4661
		DW	 4720,  4779,  4838,  4897,  4956,  5015,  5074,  5133
		DW	 5192,  5251,  5310,  5369,  5428,  5487,  5546,  5605
		DW	 5664,  5723,  5782,  5841,  5900,  5959,  6018,  6077
		DW	 6136,  6195,  6254,  6313,  6372,  6431,  6490,  6549
		DW	 6608,  6667,  6726,  6785,  6844,  6903,  6962,  7021
		DW	 7080,  7139,  7198,  7257,  7316,  7375,  7434,  7493
		DW	-7552, -7493, -7434, -7375, -7316, -7257, -7198, -7139
		DW	-7080, -7021, -6962, -6903, -6844, -6785, -6726, -6667
		DW	-6608, -6549, -6490, -6431, -6372, -6313, -6254, -6195
		DW	-6136, -6077, -6018, -5959, -5900, -5841, -5782, -5723
		DW	-5664, -5605, -5546, -5487, -5428, -5369, -5310, -5251
		DW	-5192, -5133, -5074, -5015, -4956, -4897, -4838, -4779
		DW	-4720, -4661, -4602, -4543, -4484, -4425, -4366, -4307
		DW	-4248, -4189, -4130, -4071, -4012, -3953, -3894, -3835
		DW	-3776, -3717, -3658, -3599, -3540, -3481, -3422, -3363
		DW	-3304, -3245, -3186, -3127, -3068, -3009, -2950, -2891
		DW	-2832, -2773, -2714, -2655, -2596, -2537, -2478, -2419
		DW	-2360, -2301, -2242, -2183, -2124, -2065, -2006, -1947
		DW	-1888, -1829, -1770, -1711, -1652, -1593, -1534, -1475
		DW	-1416, -1357, -1298, -1239, -1180, -1121, -1062, -1003
		DW	 -944,  -885,  -826,  -767,  -708,  -649,  -590,  -531
		DW	 -472,  -413,  -354,  -295,  -236,  -177,  -118,   -59
