/***************************************************************************/
/* tandy.c  -- Routines needed for Tandy DAC                               */
/* Copyright (c) 1996 John A. Ball                                         */
/*                                                                         */
/* This source is available for your own personal use only! You may make   */
/* any changes you wish but please do not distribute modified source code. */
/* Please notify me of any errors or improvements.                         */
/*                                                                         */
/* by John A. Ball   January 6, 1996                                       */
/***************************************************************************/

#include "playsnd.h"

#define TRUE 1
#define NOCOMPRESS 100

#include <stdio.h>
#include <dos.h>
#include <errno.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <malloc.h>
#include <string.h>
#include <sound.h>
#include <graph.h>

extern int debug;
extern int verbose;
extern int shell;
extern struct CARD_INFO card_info;
extern int volume;
extern int compression;
extern int magnitude;
extern int default_bits;
extern int halve_buffer;
extern int stop;
extern int repeat;
extern int error;
extern int multi_error;
extern int conversion_table;
extern unsigned int play_rate;
extern unsigned int pitch;
extern char _far **fbuffer;
extern unsigned int dma_size;

void show_card_info(void);
int speaker(int state);
void delay(char tc, int period);
int dacplay(char _far *fbuffer,int k,int frequency,int mode,int volume);
void show_dac_error(int error);
int find_tandy(void);
int get_card_type(void);
	
	int tandy_dac=0;

static void (_interrupt _far *vect0f)(void);
static void (_interrupt _far *vect1a)(void);
static void (_interrupt _far *vect1c)(void);
static void (_interrupt _far *vect1d)(void);
static void (_interrupt _far *vect1f)(void);
static void (_interrupt _far *vect40)(void);
static void (_interrupt _far *vect44)(void);

/* Make sure Tandy DAC Available */

int find_tandy(void)
{
	_asm{
	mov ax,08100h
	int 01ah
	jnc ok
	cmp ax,0c4h
	jz end
	cmp ax,01e4h
	jz end
  nfg:  mov ax,0
	jmp end
  ok:   cmp ax,03ffh
	jg nfg
  end:  mov tandy_dac,ax
	}
  if(!tandy_dac)
   if(verbose)printf("Tandy DAC not detected using PC Speaker\n");
   return(tandy_dac);
}

void show_card_info(void)
{
	if(debug && card_info.io_addr)printf("Tandy Dac found @ %x\n",card_info.io_addr);
}

void delay(char tc, int period)
{
}
	 
int dacplay(char _far *fbuffer,int k,int frequency,int mode,int volume)
{
	 int error=0;

	mode=(mode & 0xfffe);

	 switch(mode)
	 {
	 case 0:  
	   error=tplay(fbuffer,k,frequency,volume);
	   break;
	 case TCOMP:
	   if(shell)printf("Tandy Compression not supported!\n");
	   else if(verbose)printf("Tandy Compression not supported!\n");
	   multi_error=TRUE;
	   error=NOCOMPRESS;
	   break;
	 default:
	   if(shell)printf("Type of Compression not supported!\n");
	   else if(verbose)printf("Type of Compression not supported!\n");
	   multi_error=TRUE;
	   error=NOCOMPRESS;
	   break;
	}
	 return(error);
}
	
void show_dac_error(int error)
{
	switch (error)
	{
	case NOCOMPRESS:
	  if(verbose)printf("Sound compression method not supported!\n");
	  break;
	default:
	  if(verbose)printf("Error in DAC playback! (%i)\n",error);
	break;
	}
}

/* Check for a Sound Card */

int get_card_type(void)        
{
	int type=0;
	int address=0;

	address=find_tandy();
	if(address){
	  type=TANDYSND;
	  card_info.io_addr=address;
	}
	return(type);
}

int speaker(int state)
{
   if(tandy_dac!=0 && state==1){

     /* Get vectors that are changed by th tandy BIOS and save them */
	vect0f = _dos_getvect( 0x0f );
	vect1a = _dos_getvect( 0x1a );
	vect1c = _dos_getvect( 0x1c );
	vect1d = _dos_getvect( 0x1d );
	vect1f = _dos_getvect( 0x1f );
	vect40 = _dos_getvect( 0x40 );
	vect44 = _dos_getvect( 0x44 );
   }
   if(tandy_dac!=0 && state==0){
	if(debug)printf("Disabling Tandy Dac @ %X",tandy_dac);
	_asm{
	 MOV AX,08400H
	 INT 01AH               ;Call interrupt to HALT sound
	 MOV CX,60000
   loophere:
	 JMP ahead
   ahead:
	 LOOP loophere
	 MOV AL,05              ;Disable DMA channel 1
	 OUT 0AH,AL
	 MOV AL,00h
	 MOV DX,tandy_dac       ;Reset TANDY SOUND CHIP
	 OUT DX,AL
	 MOV CX,60000
   loophere1:
	 JMP ahead1
   ahead1:
	 LOOP loophere1
	}
	if(debug)printf(" and DMA channel 1\n");

	_asm{
	 MOV AX,08500H
	 INT 01AH               ;Call interrupt to restore Joy Stick
	}

	/* Restore vectors that were changed by Tandy BIOS */

	_dos_setvect( 0x0f, vect0f );
	_dos_setvect( 0x1a, vect1a );
	_dos_setvect( 0x1c, vect1c );
	_dos_setvect( 0x1d, vect1d );
	_dos_setvect( 0x1f, vect1f );
	_dos_setvect( 0x40, vect40 );
	_dos_setvect( 0x44, vect44 );

      }
      return(0);
}
