/*** TEST16.C 				 Demonstrate all DIGPAK capable play modes. 	 ***/
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "loader.h"
#include "support.h"
#include "digplay.h"    // Include DIGPLAY header.
#include "doscalls.h"   // Include DOS tools header.
#include "t16.h"

void main(void)
{
	int cap;
	SNDSTRUC *snd;
	long int siz;
	char *sound;
	char *workspace;

	if ( !LoadDigPak("SOUNDRV.COM") )
	{
		printf("Unable to load SOUNDRV.COM\n");
		exit(1);
	}
	if ( !InitDigPak() )
	{
		UnLoadDigPak();
		printf("Unable to initialize digitized sound hardware.\n");
		exit(1);
	}

	snd = realalloc(sizeof(SNDSTRUC));

	sound = floadlow("TEST.SND", &siz);
	if ( sound )
	{
		cap = AudioCapabilities();
		workspace = realalloc(64000); //allocate lots of memory for workspace.
		if ( siz*4 > 64000L ) siz = 64000/4;
		printf("Press a key to play test sound effect in 8 bit mono mode.\n");
		printf("Press ESC to go to next step in the test suite.\n");

		memorymove(workspace,sound,siz);
		snd->sound = RealPtr(workspace);
		snd->frequency = 11000;
		snd->sndlen = siz;
		MassageAudio(snd);

		do
		{
			DigPlay2(snd);
		} while ( getkey() != 27 );
		if ( cap & STEREOPLAY )
		{
			printf("Press a key to play test sound effect in 8 bit stereo mode.\n");
			printf("JUST out of the LEFT speaker.\n");
			printf("Press ESC to go to next step in the test suite.\n");
			Left8(sound,workspace,siz);
			snd->sound = RealPtr(workspace);
			snd->frequency = 11000;
			snd->sndlen = siz*2;

			SetPlayMode(PCM_8_STEREO);
			MassageAudio(snd);
			do
			{
				DigPlay2(snd);
			} while ( getkey() != 27 );

			printf("Press a key to play test sound effect in 8 bit stereo mode.\n");
			printf("JUST out of the RIGHT speaker.\n");
			printf("Press ESC to go to next step in the test suite.\n");
			Right8(sound,workspace,siz);
			snd->sound = RealPtr(workspace);
			snd->frequency = 11000;
			snd->sndlen = siz*2;
			SetPlayMode(PCM_8_STEREO);
			MassageAudio(snd);
			do
			{
				DigPlay2(snd);
			} while ( getkey() != 27 );
		}
		if ( cap&PCM16 )
		{
			printf("Press a key to play test sound effect in 16 bit MONO mode.\n");
			printf("Press ESC to go to next step in the test suite.\n");
			Mono16(sound,workspace,siz);
			snd->sound = RealPtr(workspace);
			snd->frequency = 11000;
			snd->sndlen = siz*2;
			SetPlayMode(PCM_16_MONO);
			do
			{
				DigPlay2(snd);
			} while ( getkey() != 27 );
		}


		if ( cap&PCM16STEREO )
		{
			printf("Press a key to play test sound effect in 16 bit STEREO mode.\n");
			printf("Will play 16 bit sound effect, just out of LEFT channel.\n");
			printf("Press ESC to go to next step in the test suite.\n");
			Left16(sound,workspace,siz);
			snd->sound = RealPtr(workspace);
			snd->frequency = 11000;
			snd->sndlen = siz*4;
			SetPlayMode(PCM_16_STEREO);
			do
			{
				DigPlay2(snd);
			} while ( getkey() != 27 );

			printf("Press a key to play test sound effect in 16 bit STEREO mode.\n");
			printf("Will play 16 bit sound effect, just out of RIGHT channel.\n");
			printf("Press ESC to go to next step in the test suite.\n");
			Right16(sound,workspace,siz);
			snd->sound = RealPtr(workspace);
			snd->frequency = 11000;
			snd->sndlen = siz*4;
			SetPlayMode(PCM_16_STEREO);
			do
			{
				DigPlay2(snd);
			} while ( getkey() != 27 );
		}
		SetPlayMode(PCM_8_MONO);
	}
	else
		printf("Unable to load test sound effect 'TEST.SND'.\n");

	UnLoadDigPak();
}
