//** Demonstration program for the new MIDPAK and DIGPAK loading and
//** unloading system.	Uses LOADER.C.
#include <stdio.h>
#include <stdlib.h>

#include "midpak.h"
#include "doscalls.h"
#include "loader.h"
#include "support.h"

void main(int argc,char **argv)
{
	char *song;
	long int siz,songlen;
	int xcon,keypress,sequence=0,SegueNumber=0;
	char str[80];

	if ( LoadMidPak("MIDPAK.COM", "MIDPAK.ADV", "MIDPAK.AD" ) ) // Load MIDPAK into memory.
	{
		if ( InitMidPak() ) // Initialize MIDPAK driver.
		{
			song = floadlow("TEST.XMI", &songlen); // Load song into memory.
			if ( song )
			{
				RegisterXmidi(song,songlen); // register the song.
				SetRelativeVolume(100,0) ;
				PlaySequence(0); // play the song.
				printf("Have begun to play the song...\n");
				printf("Press a key '0'-'4' to 'segue' to that sequence.\n");
				xcon = 0;
				do
				{
					sequence = ReportSequenceNumber(); // Find out current sequence number.
					if ( SequenceStatus() == SEQ_PLAYING )
						sprintf(str,"Playing sequence #%d",sequence);
					else
						sprintf(str,"Sequence #%d not playing.",sequence);
					tprint(0,0,40,str,BLUE BEHIND YELLOW);
					sprintf(str,"Next segue request #%d",SegueNumber);
					tprint(0,1,40,str,BLUE BEHIND YELLOW);
					if ( keystat() )
					{
						keypress = getkey();
						switch ( keypress )
						{
							case 27: xcon = 1;
							default:
								if ( keypress >= '0' && keypress <= '4' )
								{
									SegueNumber = keypress-'0';
									SegueSequence(SegueNumber,-1);
									if ( SequenceStatus() != SEQ_PLAYING )
									{
										PlaySequence(SegueNumber);
									}
								}
								break;
						}
					}
				} while (!xcon);
			}
		}
	}

	DeInitMidPak();
	UnLoadMidPak();
}
