
{$DEFINE CPUTYPE}

Unit JP_Unit;

Interface

Uses DOS,
     CRT;


CONST
   CleanChr : Array[$00..$FF] of Byte = ($FF,1,2,3,4,5,6,7,8,9,$FF,$FF,$FF,$FF,14,15,
                      $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,
                      $20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F,
                      $30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F,
                      $40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F,
                      $50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,$5F,
                      $60,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F,
                      $70,$71,$72,$73,$74,$75,$76,$77,$78,$79,$7A,$7B,$7C,$7D,$7E,$7F,
                      $80,$81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,
                      $90,$91,$92,$93,$94,$95,$96,$97,$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,
                      $A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF,
                      $B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,$BA,$BB,$BC,$BD,$BE,$BF,
                      $C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF,
                      $D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF,
                      $E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,
                      $F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF);

var
	 Regs:Registers;
   CPURes : Integer;
   FPURes : Integer;

Function InKey:String;
Function IsScrLock: Boolean;
Function IsCapLock: Boolean;
Function IsNumLock: Boolean;
Function LAnsi:Boolean;
{$IFDEF CPUTYPE}
Function CPUName : String;
Function CPUType : Word;
Function FPUType : Word;
{$ENDIF}
Procedure JP_Idle;                                  {Internal use only (maybe)}
Procedure DelayMS(ms : Word);                          {From SWAG}
Function GetKey(Prompt:String):String;
Function UCASE(InString:String):String;
Function LeadingZero(w : Word) : String;
Function rDate(pDate:DateTime; Opt:Integer):String;    {INCOMPLETE}
Function rTime(pDate:DateTime; Opt:Integer):String;    {INCOMPLETE}
{ year, month, day, hour, min, sec : word }

Implementation

{$IFDEF CPUTYPE}
{$F+}
{$L CPUTYPE.OBJ}
Function CPUType : Word; External;    {1=86,2=286,3=386,4=486,5=586,etc.}
Function FPUType : Word; External;    {0=None,1=87,2=287,3=387,4=487,Internal}
{$F-}
{$ENDIF}

var   KStatus: Byte absolute $0040:$0017;

function IsScrLock : Boolean;
 begin
   IsScrLock:=(KStatus AND 16)=16;
 end;
function IsCapLock : Boolean;
 begin
   IsCapLock:=(KStatus AND 64)=64;
 end;
function IsNumLock : Boolean;
 begin
   IsNumLock:=(KStatus AND 32)=32;
 end;

Procedure DelayMS(ms : Word); Assembler;    {From SWAG}
Asm
  mov ax, 1000
  mul ms
  mov cx, dx
  mov dx, ax
  mov ah, $86
  int $15
End;


Function LeadingZero(w : Word) : String;
var s : String;
begin Str(w:0,s); If Length(s) = 1 then s:='0'+s; LeadingZero := s; end;

Function rDate(pDate:DateTime; Opt:Integer):String;
 var
   TmpRes:String;
   TmpStr:String;
 begin
  TmpRes:='[ERROR]';
  case Opt of
   1 : TmpRes:=LeadingZero(pDate.Month)+'-'+LeadingZero(pDate.Day)+'-'+
               LeadingZero(pDate.Year);
{   2 : TmpRes:=LeadingZero(pDate.}
  end;
  rDate:=TmpRes
 end;

Function rTime(pDate:DateTime; Opt:Integer):String;
 begin
  asm nop end;
 end;


Function UCASE(InString:String):String;
Var
  index : Byte;
  tempStr : String;
Begin
  For index := 1 to Length(inString) do
     tempStr[index] := UpCase(inString[index]);
  tempStr[0] := inString[0];
  UCASE := tempStr;
End;


Procedure JP_Idle;
  begin
   asm nop end;
  end;

Function InKey:String;
 var
  TmpStr:String;
  TmpWord:Word;
  ch:Char;
  ex:Byte;
 begin
  TmpStr:='';
  if KeyPressed then begin
      ch:=ReadKey;
         if (Ord(ch)=0) and (KeyPressed) then begin
                TmpStr:=ch+ReadKey;
               end else begin
                TmpStr:=ch;
               end;
    end else begin
      JP_Idle;
    end;
  InKey:=TmpStr;
 end;

{       If Length(Key)=1 then  Key:=UPCASE(Key[1]); }
Function GetKey(Prompt:String):String;
  var
   TmpKey:String;
  begin
   If Prompt='' then Write('* PAUSE *')  else Write(Prompt);
   repeat
    TmpKey:=Inkey;
   until TmpKey<>'';
   DelLine; Write(#13);
   GetKey:=TmpKey;
  end;

Function LAnsi:Boolean;
 begin
	FillChar(Regs,SizeOf(Regs),0);
	Regs.AX:=$1A00;
	Intr($2F,Regs);
	LANSI:= Regs.AL=$FF;
 end;

{$IFDEF CPUTYPE}
Function CPUName:String;
 var
  TmpStr:String;
 begin
   FPURes:=0; CPURes:=0;
   CPURes:=CPUType;  FPURes:=FPUType;
   case CPURes of
    1 : TmpStr:='88/86';
    2 : TmpStr:='80286';
    3 : TmpStr:='80386';
    4 : TmpStr:='80486';
    5 : TmpStr:='80586';   { 585 or Pentium (P5) }
    6 : TmpStr:='80686';   { 686 or P6 }
    7 : TmpStr:='80786';   { 786 or higher }
    else TmpStr:='Unknown';
   end;
   if FPURes<0 then TmpStr:=TmpStr+'dx'  else TmpStr:=TmpStr+'sx';
   CPUName:=TmpStr;
 end;
{$ENDIF}

END.


