#include	<stdio.h>
#include	<string.h>
#include	<sys/time.h>

#include	"smbhdr.h"
#include	"smbpd.h"
#include	"lpt.h"
#include	"netio.h"
#include	"util.h"

int			nlpt = 0;
struct lpt_info		lpt[MAXLPT] =
{
	{ "LPT1", "", NONESUCH, 523, 0, 0 },
	{ "LPT2", "", NONESUCH, 587, 0, 0 },
	{ "LPT3", "", NONESUCH, 659, 0, 0 }
};
int			notone = 0;
int			reinit = 0;	/* reinitialise on abort */
int			toconsole = 0;	/* print to console for testing */
int			measureonly = 0;/* don't print, just measure speed */

int find_printer(char *name)
{
	int		i;

	for (i = 0; i < nlpt; ++i)
	{
		if (strncasecmp(name, lpt[i].name, MAXLABEL) == 0)
			return (lpt[i].avail == NONESUCH ||
				lpt[i].avail == DISABLED ? -1 : i);
	}
	return (-1);
}

#ifdef		DOS
#include	<bios.h>
#include	<alloc.h>

/* try this many times to see if can accept next byte right away */
#define		POLL_MAX	10

void            	(*normal_init)(char *name, char *value);

static void my_init(char *name, char *value)
{
	/* shouldn't really be here */
	if (strcmp(name, "WORKGROUP") == 0)
		Strncpy(my_work_group, value, sizeof(my_work_group));
	else if (strcmp(name, "PRINTER1NAME") == 0)
		Strncpy(lpt[0].name, value, sizeof(lpt[0].name));
	else if (strcmp(name, "PRINTER2NAME") == 0)
		Strncpy(lpt[1].name, value, sizeof(lpt[1].name));
	else if (strcmp(name, "PRINTER3NAME") == 0)
		Strncpy(lpt[2].name, value, sizeof(lpt[2].name));
	else if (normal_init)
		(*normal_init)(name, value);
}

void callback_init(void)
{
	/* hook onto init procedure to get NAME=VALUE pairs */
	normal_init = usr_init;
	usr_init = my_init;
}

void init_printers(void)
{
	int			i, ret;
	struct lpt_info		*p;

	if (nlpt == 0)				/* not overridden by -n? */
	{
		ret = biosequip();
		nlpt = (ret >> 14) & 0x3;
	}
	for (i = 0; i < nlpt; ++i)
	{
		p = &lpt[i];
		if (p->avail == DISABLED)	/* unavail from cmd line? */
			continue;
		(void)bios_printer_init(i);	/* initialise printer */
		sleep(2);			/* let printer settle */
		p->status = bios_printer_status(i);	/* get status */
		if (p->status & (P_TIMEOUT|P_IOERROR))
		{
			p->avail = NONESUCH;	/* printer not available */
			(void)printf("%s: Error initialising %s\n",
				ptime(), lpt[i].name);
		}
		else
		{
			if ((p->largebuf = farmalloc((unsigned long)MAXBUFFER)) == 0)
			{
				printf("Out of heap memory\n");
				exit(1);
			}
			p->avail = FREE;	/* printer available */
			p->jobname[0] = '\0';
			(void)printf("%s: %s initialised",
				ptime(), p->name);
			if (p->hwaddr && (ret = peek(0, 0x408 + i * 2)) != 0)
				(void)printf(", direct hardware access at %#3X",
					p->hwaddr = ret);
			(void)printf("\n");
		}
	}
	for (i = 0; i < MAXLPT; ++i)
	{
		if (notone || lpt[i].avail != FREE)
			continue;
		sound(lpt[i].tone);
		sleep(1);
		nosound();
	}
}

void check_printer_status(int printer, struct lpt_info *p)
{
	int			current, delta;

	current = bios_printer_status(printer);
	/* report changes from last time */
	delta = (current ^ p->status) & P_CHANGES;
	if (!delta)
		return;
	p->status = current;
	if (current & P_TIMEOUT)
		report_change("time out", printer);
	if (current & P_IOERROR)
		report_change("I/O error", printer);
	if (delta & P_SELECTED)
	{
		if (current & P_SELECTED)
			report_change("online", printer);
		else
			report_change("offline", printer);
	}
	if (current & P_NOPAPER)
		report_change("paper out", printer);
}

/*
 *	Direct hardware write to printer port
 */
int printer_outbuf(int port, char *buffer, int count)
{
	int		i, printed, status;

	printed = 0;
	inportb(port+1);		/* read status */
	status = (inportb(port+1) & 0xf8) ^ 0x48;
	while (count > 0 && (status & P_READY) == P_READY)
	{
		outportb(port, *buffer++);	/* write character */
		outportb(port+2, 0x0d);		/* raise strobe */
		outportb(port+2, 0x0c);		/* lower strobe */
		++printed;
		--count;
		/* sample the busy line for a few tries */
		for (i = 0; i < POLL_MAX; ++i)
		{
			status = (inportb(port+1) & 0xf8) ^ 0x48;
			if ((status & P_READY) == P_READY)
				break;
		}
	}
	return (printed);
}

int print_data(struct smbconn *client)
{
	int		printer, printed, c;
	struct lpt_info	*p;

	if (client->datalength <= 0)
		return (1);
	if (toconsole)
	{
		fwrite(client->dataptr, sizeof(char), client->datalength, stdout);
		client->joblen += client->datalength;
		return (1);
	}
	p = &lpt[printer = client->printer];
	check_printer_status(printer, p);
	/* if printer is busy, go back to poll loop */
	if ((p->status & P_READY) != P_READY)
		return (0);
	if (p->hwaddr != 0)
	{
		printed = printer_outbuf(p->hwaddr, client->dataptr, client->datalength);
		client->dataoffset += printed;
	}
	else
	{
		printed = 0;
		/* loop, printing as much as possible */
		/* eat your heart out, Pascal */
		while (client->dataoffset < client->datalength &&
			(bios_printer_status(printer) & P_READY) == P_READY)
		{
			c = client->dataptr[client->dataoffset++];
			(void)bios_printer_outch(printer, c);
/*
 *	The status returned by bios_printer_outch is useless because it
 *	gives the condition after printing and of course if there is no room
 *	or the printer is busy, it blocks
 */
			++printed;
		}
	}
	client->joblen += printed;
	return (client->dataoffset >= client->datalength);
}
#endif		/* DOS */
