/*===========================================================================
SOLAR v0.95.2 slrnews :: Module ..\slrnews\kill.c
Original Author: Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This software module has been placed in the public domain.
===========================================================================*/

/* Include Files */
#include <string.h>
#include <stdio.h>
#include <dir.h>
#include "kill.h"

/*
 * Function: int kill_msg(FILE *message_file);
 * Purpose : If user has a kill file, check the message's From:
 *           and Subject: headers against the entries in the kill file.
 * Return  : 0 if a string from kill file matches something in either
 *           header. non-zero if there is no match found, or no kill file.
*/

int kill_msg(FILE *message_file)
{
  char killpath[MAXPATH];
  FILE *killfile = NULL;
  char killstr[128];
  char header[1024];
  int flag = 0;

  strcpy(killpath, user_path);
  strcat(killpath, "\\");
  strcat(killpath,KILL_NAME);

  if ((killfile = fopen(killpath,"rt")) == NULL) goto NoKill;

  while (fgets(header,1024,message_file) != NULL)
  {
    strlwr(header);
    if (strnicmp(header,"From:",5) == 0)
    {
      flag++;
      while (fgets(killstr,128,killfile) != NULL)
      {
        strlwr(killstr);
        killstr[strlen(killstr) - 1] = '\0';
        if (strstr(header,killstr) != NULL) goto Kill;
      }
      fseek(killfile, 0L, SEEK_SET);
    }
    if (strnicmp(header,"Subject:",8) == 0)
    {
      flag++;
      while (fgets(killstr,128,killfile) != NULL)
      {
        strlwr(killstr);
        killstr[strlen(killstr) - 1] = '\0';
        if (strstr(header,killstr) != NULL) goto Kill;
      }
      fseek(killfile, 0L, SEEK_SET);
    }
    if (flag == 2) break;
  }

NoKill:
  fseek(message_file, 0L, SEEK_SET);
  if (killfile) fclose(killfile);
  return 1;
Kill:
  fseek(message_file, 0L, SEEK_SET);
  if (killfile) fclose(killfile);
  return 0;
}
