/*===========================================================================
SOLAR :: ..\common\filesize.c

Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>
This software module has been placed into the public domain.
===========================================================================*/

#include <stdio.h>

/*
 * Function: filesize()
 * Purpose : Determine the number of bytes in a file. Strip CR(?)
 * Return  : The number of bytes in the file, zero if none.
*/

long filesize(FILE *filename)
{
  long bytes  = 0L;
  long curpos = 0L;
	char temp;

	curpos = ftell(filename);
	fseek(filename, 0L, SEEK_SET);
	temp = fgetc(filename);
	while (!feof(filename))
	{
    if (temp != '\r') bytes++;
		temp = fgetc(filename);
	}
	fseek(filename, curpos, SEEK_SET);
  return bytes;
}
