#include "vietmap.c"
#define AA -1
#define aa 63
#define Aa_breve 6
#define Aa_circumflex 12
#define OO 33
#define oo 97
#define Oo_circumflex 6
#define Oo_horn 12
#define EE 17
#define ee 81
#define Ee_circumflex 6
#define II 28
#define ii 92
#define UU 50
#define uu 114
#define Uu_horn 6
#define YY 61
#define yy 125
#define DD 104
#define dd 100
#define sac 1
#define huyen 2
#define hoi 3
#define nga 4
#define nang 5

int get_compose(state,c,oldchar,vi_mode)
int state;
int c;
int *oldchar;
int *vi_mode;
{ 
  char ch;
  static int compose_sum;
  switch (state){
  case 1: compose_sum = 0; /* init */
          if (*vi_mode == 2) 
            if (!(c == 'M' || c == 'm' || c == 'V' || c == 'v'))
		{*oldchar = '\\' ;return (-2);};
          switch (c){
          case 'd' : compose_sum =  dd; break;
          case 'D' : compose_sum =  DD; break;
          case 'A' : compose_sum =  AA; break;
          case 'a' : compose_sum =  aa; break;
	  case 'E' : compose_sum =  EE; break;
	  case 'e' : compose_sum =  ee; break;
	  case 'I' : compose_sum =  II; break;
	  case 'i' : compose_sum =  ii; break;
	  case 'O' : compose_sum =  OO; break;
	  case 'o' : compose_sum =  oo; break;
	  case 'U' : compose_sum =  UU; break;
	  case 'u' : compose_sum =  uu; break;
	  case 'Y' : compose_sum =  YY; break;
	  case 'y' : compose_sum =  yy; break;
          case 'M' : 
          case 'm' : *vi_mode = 0; 
                     return (-1);	
          case 'V' : 
          case 'v' : *vi_mode = 1; 
                     return (-1);
          case 'L' : 
	  case 'l' : *vi_mode = 2;
                     return (-1);
          default: return c; /* otherwise return char as is */
          };
          *oldchar = c;
          return 0; /* get here if still in legal sequence */
          break;

  case 2:
          if (compose_sum ==dd || compose_sum == DD)
            if (!(c=='d' || c=='D')) goto illegal;
          switch (c){
	  case 'd' : if (compose_sum == dd ) return vietmap[(128 + 81)];
	  case 'D' : if ((compose_sum == dd) || (compose_sum == DD))
                                             return vietmap[(128 + 17)];
                     goto illegal;
          case '\'': return vietmap[compose_sum + 128 + sac] ; /* A'a'O'o'E'e'U'u' */
          case '`' : return vietmap[compose_sum + 128 +huyen];
          case '?' : if (compose_sum == YY) return vietmap[(5)];
          	     else if (compose_sum == yy) return vietmap[(29)];
                     else           return vietmap[compose_sum + 128 +hoi] ;
          case '~' : if (compose_sum == YY) return vietmap[(16)];
          	     else if (compose_sum == yy) return vietmap[(30)];
                     else           return vietmap[compose_sum + 128 +nga] ;
          case '.' : if (compose_sum == YY) return vietmap[(20)];
          	     else if (compose_sum == yy) return vietmap[(31)];
                     else           return vietmap[compose_sum + 128 +nang] ;
          case '(' : 
                     if (compose_sum == AA || compose_sum == aa)
                         compose_sum = compose_sum + Aa_breve;
                     else goto illegal;
		     break;
          case '^' : if (compose_sum == AA || compose_sum == aa)
			compose_sum = compose_sum + Aa_circumflex;
		     else if (compose_sum == OO || compose_sum == oo)
			compose_sum = compose_sum + Oo_circumflex;
		     else if (compose_sum == EE || compose_sum == ee)
			compose_sum = compose_sum + Ee_circumflex;
                     else goto illegal;
		     break;
	  case '+' : if (compose_sum == OO || compose_sum == oo)
			compose_sum = compose_sum + Oo_horn;
		     else if (compose_sum == UU || compose_sum == uu)
			compose_sum = compose_sum + Uu_horn;
                     else goto illegal;
		     break;
          default  :        /* illegal sequence or closure*/
illegal:
		     if (compose_sum == DD) ch = 'D' ;
                     else if (compose_sum == dd) ch = 'd' ;
		     else if (compose_sum == AA) ch = 'A' ;
                     else if (compose_sum == aa) ch = 'a' ;
                     else if (compose_sum == EE) ch = 'E' ;
                     else if (compose_sum == ee) ch = 'e' ;
                     else if (compose_sum == II) ch = 'I' ;
                     else if (compose_sum == ii) ch = 'i' ;
                     else if (compose_sum == OO) ch = 'O' ;
                     else if (compose_sum == oo) ch = 'o' ;
                     else if (compose_sum == UU) ch = 'U' ;
                     else if (compose_sum == uu) ch = 'u' ;
                     else if (compose_sum == YY) ch = 'Y' ;
                     else if (compose_sum == yy) ch = 'y' ;
                     *oldchar = ch;
		     if (c == '\001') return (ch); /* closure */
                      return (-2);
		    
			break;
          } /*end switch c*/
          /*get here if still in legal sequence*/
          *oldchar= vietmap[compose_sum+128] ;/*a^e^...*/
          return 0; /* thanks cuong */
	  break;
   case 3:
          switch (c){
          case '\'': return vietmap[compose_sum + 128 + sac] ; /* A('A^'O^'E^'O+' */
          case '`' : return vietmap[compose_sum + 128 +huyen];
          case '?' : return vietmap[compose_sum + 128 +hoi] ;
	  case '~' : return vietmap[compose_sum + 128 +nga];
          case '.' : return vietmap[compose_sum + 128 +nang];
          default:
                     ch = vietmap[compose_sum + 128] ;
                     *oldchar = ch;
		     if (c == '\001') return (ch); /* closure */
                     return -2;
	  } ;
   }/*switch*/
} 

