{$A+,B-,D+,E+,F-,I+,L+,N-,O-,R-,S+,V-}
{$M 16384,0,655360}
program Compare_bootsector_partitiontable_with_info_in_file;
{(C) Copyright A. Merckens 1989}
{DO NOT MODIFY IN ANY WAY --> otherwise: installation will fail!}
uses Crt, Dos;

type
  cluster_size = array [0..511] of byte;

var
  buffer, buffer2: cluster_size;
  f: file;
  i, j, disk, head, track, sector: integer;
  active: byte;
  p1, filename: string ;
  Old13, New13, Old40, New40: Pointer;
  partgood, other_sys: boolean;
  installstartbyte, startbyte : longint;

procedure abort(code: integer; s: string );
begin
  writeln(#7); writeln(s);
  if code = 1 then
  begin
  writeln('Call: BOOTCOMP [drive] [filenaam]  - see manual');
  end;
  {$I-}close(f);{$I+}
  halt(255);
end;


procedure read_sector_from_drive(drive, track, sector, head: integer;
                                 var buffer: cluster_size);

var
  reg: registers;

begin
  reg.ah := 2; reg.al := 1; reg.ch := track; reg.cl := sector; {sector nummer}
  reg.dh := head; reg.dl := drive; reg.es := seg(buffer); reg.bx := ofs(buffer);
  intr($13, reg);
end;

begin
  clrscr; highvideo;
  p1 := 'A dummy string that makes sure that the English version the same size as the Dutch';
  write('BOOTCOMP 1.0 -  Checks for presence of bootsector virus  -  (C) A. Merckens 1989');
  gotoxy(1,2); normvideo;
  New40 := ptr($5555, $5555); {This should be installed}
  New13 := ptr($4444, $4444);
  GetIntVec($40, Old40);

  startbyte := longint(new13^);
  installstartbyte := $44444444;

  If (New40 <> Old40) or (seg(new13^)< $C000) or (startbyte <> installstartbyte) then
    abort(0,
         'BOOTCOMP is probably not installed for this computer.'
          + #10 + #13 + 'See the manual for more information.');

  GetIntVec($13, Old13);

  If Paramcount > 2 then abort(1, 'Too many parameters specified.');

  If Paramcount = 2 then
  Begin
    p1 := paramstr(1); filename := paramstr(2);
    if NOT ((pos(':', p1) = 2) and (length(p1) = 2)) then
    begin
      filename := p1; p1 := paramstr(2);
    end;

    p1[1] := UpCase(p1[1]);

    if NOT ((pos(':', p1) = 2) or (length(p1) <> 2)) and
	   (p1[1] in ['A'..'Z','1','2']) then
    abort(1, 'Wrong parameters specified');

	if (p1[1] >= 'C') or (p1[1]='1') then disk := $80
	else if p1[1] = '2' then disk := $81
    else disk := ord((p1[1])) - 65; {Start met A-drive}
  End
  Else abort(1, 'Not enough parameters specified.');

  writeln('Disk ',p1, ' is tested using file ',filename,' ');
  assign(f, filename);
  {$I-}
  reset(f, 1); {$I+}

  If Ioresult <> 0 then
    abort(0, concat('The file ', filename, ' is not found'));

  if (filesize(f) <> 512) and (filesize(f) <> 1024) then
    abort(0, 'Wrong filename given.');

  blockread(f, buffer2, 512, j); {bootsector, OR partitiontable};

  SetIntVec($13, New13); {Put new interrupt 13 to BIOS-interrupt}

  read_sector_from_drive(disk, 0, 1, 0, buffer); {read bootsector or partition
                                        table}
  if (filesize(f)=1024) then
  begin
    if (disk >= $80) then
    begin
      write('Partition-table ...');
      partgood := true;
      for i := 0 to 511 do {start van de PARTITION-code}
        if buffer[i] <> buffer2[i] then
          partgood := false;

      if partgood then writeln('OK.  ') else
      begin
       writeln;
        writeln('');
        writeln(#7, #7, 'The partitiontable differs from the saved one.');
        writeln('This can be caused by the following: '); writeln;
        writeln('   The Partiontable has been manipulated by an other program');
        writeln('   The given filename is not correct');
        writeln('   A virus has put itself in the partitiontable');
       writeln;
       writeln('Look in the manual for the actions to take!');
       writeln('');
      repeat
      until readkey <> #0;
      abort(0, '');
     end;
   end;
   blockread(f, buffer2, 512, j); {This is the bootsector}
  end;

  active := 0;
  if disk >= $80 then {we just read the partition table....}
    begin
      for i := 1 to 4 do
        if buffer[$1AE + i * $10] = $80 then active := i; {i is the active
                                        DOSpartition}

      if active = 0 then
      begin
        SetIntVec($13, Old13);
        abort(0, 'No active bootsector found for harddisk '+char(disk-$50));
      end;

      if filesize(f)=512 then
        writeln(#7,'WARNING: the partitiontable will not be tested! - see manual');

      read_sector_from_drive(disk, buffer[$1AE + active * $10 + 3], {track /
                                        cylinder with next:}
                             buffer[$1AE + active * $10 + 2], {sector}
                             buffer[$1AE + active * $10 + 1], {head}
                             buffer);
    end;

  SetIntVec($13, Old13);
  write('Bootsector ...');
  for i := $1E to 508 do {start van de code}
  if buffer[i] <> buffer2[i] then
  begin
    other_sys := false;
    for j := $3 to $A do
      if buffer[j] <> buffer2[j] then other_sys := true;
	  writeln;
    writeln('');
    writeln(#7, #7, 'The bootsector differs from the saved one.');
    writeln('This can be caused by the following: '); writeln;
    writeln('   A new system has been installed');
    writeln('   The given filename is not correct');
    writeln('   A virus has put itself in the bootsector');
    writeln;
    if other_sys then
	  begin
      writeln('Probably one of the first two hold true, since: ');
      write('Systemname saved in file ', filename, ': ');
      highvideo;
      for j := $3 to $A do write(char(buffer2[j]));
      normvideo;
      writeln;
      write('Actual systemname','':9+length(filename),': ');
      highvideo;
      for j := $3 to $A do write(char(buffer[j]));
      normvideo;
      writeln;
    end;

    writeln('Look in the manual for the actions to take!');
	  writeln('');

    repeat until readkey <> #0;
    abort(0, '');
  end;
  write('OK.');
  close(f);
end.
