                                        ;this is the actual code portion
                                        ;which remains in memory after
                                        ;installation
.model  tiny
.386
code    segment         dword use16
        assume          cs:code, ds:code
        locals
        org             0
start:

code_size       dd      code_end-start  ;size of code
video           dd      ?               ;saved interrupt vector (10h)
video_alt       dd      ?               ;saved interrupt vector (6Dh)

        jmp     new_video               ;interrupt handler entry (10h)
        align   4
        jmp     new_video_alt           ;interrupt handler entry (6Dh)
        align   4

modes_table     dw      40h dup (?)     ;list of VESA video modes
codes_table     db      40h dup (?)     ;refresh rates for those modes

set_refresh_rate:
        pushad
        xchg    ax,bx
        and     ax,7FFFh                ;ax = VESA video mode
        xor     bx,bx
@@1:    cmp     word ptr \
                cs:[modes_table+bx],0FFFFh
        je      short @@3
        cmp     cs:[modes_table+bx],ax
        je      short @@2
        inc     bx
        inc     bx
        jmp     short @@1
@@2:    shr     bx,1
        mov     bl,cs:[codes_table+bx]
        cmp     bl,0FFh
        je      short @@3
        mov     ax,3005h                ;set refresh rate
        pushf
        call    dword ptr cs:[video_alt]
@@3:    popad
        ret

new_video:
        pushf
        cmp     ax,4F02h                ;VESA BIOS extention: set video mode
        je      short @@2
        cmp     ax,30CFh                ;installation check
        jne     short @@1
        cmp     bx,30CFh
        jne     short @@1
        popf
        mov     dx,cs                   ;response
        xchg    bl,bh
        xchg    al,ah
        iret
@@1:    popf
        jmp     dword ptr cs:[video]
@@2:    popf
        push    bx
        pushf
        call    dword ptr cs:[video]
        pop     bx
        call    set_refresh_rate
        iret

new_video_alt:
        pushf
        cmp     ax,4F02h
        je      short @@1
        popf
        jmp     dword ptr cs:[video_alt]
@@1:    popf
        push    bx
        pushf
        call    dword ptr cs:[video_alt]
        pop     bx
        call    set_refresh_rate
        iret

code_end:

code    ends
        end     start
