if test "$lm" = ""
then
   lm=lm
fi
# use environ para $lm to point to the lm command or put lm on the PATH

# send a file to everyone in an email folder who requests the file
# by putting a keyword/sentence in his subject title.
# keyword/sentence is case-insensitive, white spaces are treated as one

# temporary files
tmp1=$HOME/.tmp.01
tmp2=$HOME/.tmp.02
tmp3=$HOME/.tmp.03
BoxAll=$HOME/.tmp.04
BoxOne=$HOME/.tmp.05

# files to keep record of replied and unreplied mails
replied=/dev/null
unreplied=/dev/null

rm -f $tmp1 $tmp2 $tmp3

folderfile=$1
replyfile=$2
keyword=$3

if test $# -le 2
then
   echo Usage: \ \  reply  folder  reply  keyword \[ new-subject-words \]
   echo
   echo \ \ \ \ \ \<keyword\> is case-insensitive. If no new subject title is given,
   echo \ \ \ \ \ then RE: \<old subject title\> will be taken as the subject title.
   echo \ \ \ \ \ If keyword is \"\", then all mails will be replied.
   echo \ \ \ \ \ e.g. \ \   reply email xyz.data  \"request xyz.data ver 1.2\"
   exit 1
fi

shift
shift
shift

## test reply-file emptyness
$lm -x1N0f$replyfile
if [ $? -eq 0 ]
then
  ## duplicate mail-folder and test its emptyness
  if test -f $folderfile
  then
      cp -f $folderfile $BoxAll
      ## change it to 'mv' if necessary
  else
     echo Empty mail folder \[ $folderfile \].
     exit 1
  fi
else
  echo Empty mail reply file \[ $replyfile \].
  exit 1
fi



## download one single mail
while test -f $BoxAll
do
  if test -f $BoxOne
  then
    rm -f $BoxOne
  fi
  mail -f $BoxAll << GETONEMAIL > /dev/null
s1 $BoxOne
d1
q
GETONEMAIL


  ## priority: Reply-TO:  From:  Sender:
  ## STATUS line as last line
  ## $tmp1 will hold crude address line
  $lm -M12pstatus\:\* -N1G12greply-to\:\* -\^$tmp1 -f$BoxOne
  $lm -f$tmp1 -x1\^/dev/null
  if [ $? -gt 1 ]
  then
     $lm -M12pstatus\:\* -N1G12gfrom\:\* -\^$tmp1 -f$BoxOne
     $lm -f$tmp1 -x1\^/dev/null
     if [ $? -gt 1 ]
     then
        $lm -M12pstatus\:\* -N1G12gsender\:\* -\^$tmp1 -f$BoxOne
     fi
  fi


  ## test if address is found
  $lm -x1f$tmp1 -C2dreply-to\: -dfrom\: -dsender\: -B"REPLIED to:" -Y1/10E > $tmp2

  if [ $? -gt 1 ]
  then
     echo Email address not found!
     exit 1
  fi

  ## test if the subject is found
  echo $keyword | $lm -Y1atTA\\ -B$lm -B" -G5g" -E"  -x7M12pstatus\:\*"  -E" -N1f" -E$BoxOne -E" > /dev/null " > $tmp3
  sh $tmp3


if [ $? -gt 1 ]
then
  ## need to reply to current mail

  cat $tmp2
  ## build mail command line to $tmp2
  if [ $# -eq 0 ]
  then
     $lm -N1f$BoxOne -G12gsubject\:\* -Y1 |$lm -atTC2dsubject\: -B"Re: " -\^$tmp3
     $lm -A\\ -f$tmp3 |$lm -\^$tmp2 -B"mail -s " -/32E
  else
     echo $* > $tmp3
  $lm -Y1A\\ -f$tmp3 -\^$tmp2 -B"mail -s "  -/32E
  fi
  $lm -N1Y1f$tmp3 -/10E -B"Subject: "
  $lm -x5f$tmp1 -d\< -D\> > /dev/null

  if [ $? -gt 1 ]
  then
     $lm -f$tmp1 -d\< -D\> | $lm -/10E >> $tmp2
  else
     $lm -atTf$tmp1 -/32q -/10r | $lm -y1 | $lm -/10q -atT/32r -o2N1/10E >> $tmp2
  fi

  echo \~r $replyfile > $tmp1
  $lm -x1N1 -f$tmp2 > /dev/null
  if [ $? -eq 0 ]
  then
     cat $tmp1 | sh $tmp2
  fi
  cat $BoxOne >> $replied


else
  ## no need to reply at all
    $lm -x1f$tmp1 -C2dreply-to\: -dfrom\: -dsender\: -B"NOT replied:" -Y1/10E
    $lm -N1f$BoxOne -j2G5gsubject\:
    cat $BoxOne >> $unreplied
fi
  rm -f $BoxOne
    echo
done

rm -f $tmp1 $tmp2 $tmp3 $BoxAll $BoxOne
