# Borland BCC Makefile as produced by Borland's PRJ2MAK utility.
# Usage:
#  make -fdigext.mak
#
# Note:
# 1 -	Your PATH statement must include wherever BCC.EXE and TLINK.EXE
#	are located.  (MAKE.EXE uses the PATH variable to locate them.)
# 2 -	This file assumes your Borland-related stuff ("\lib", "\inc")
#	is on the path C:\BORLAND.  Edit as appropriate.
# 3 -	DIGEXT could probably be compiled in the TINY model.  I didn't
#	bother (since .EXE programs are more familiar to people these
#	days).
# 4 -	Don't freak if TLINK complains about the duplicate definitions
#	of _setargv_, _argv and _argc.  That comes from the WILDARGS.OBJ
#	module that gives us commandline parameter wildcard capability.
#	You could delete the WILDARGS.OBJ stuff:  this would reduce
#	the executable by 400 bytes or so.  But you also couldn't do
#	neat_and_nifty things like DIGEXT *.SMA :-)
#
# David Kirschbaum
# Toad Hall
# kirsch@usasoc.soc.mil

.AUTODEPEND

#		*Translator Definitions*
CC = bcc +DIGEXT.CFG
TASM = TASM
TLINK = tlink


#		*Implicit Rules*
.c.obj:
  $(CC) -c {$< }

.cpp.obj:
  $(CC) -c {$< }

#		*List Macros*


EXE_dependencies =  \
  digext.obj \
  ..\borland\lib\wildargs.obj

#		*Explicit Rules*
digext.exe: digext.cfg $(EXE_dependencies)
  $(TLINK) /x/c/d/P-/LC:\BORLAND\LIB @&&|
c0s.obj+
digext.obj+
..\borland\lib\wildargs.obj
digext
		# no map file
emu.lib+
maths.lib+
cs.lib
|


#		*Individual File Dependencies*
digext.obj: digext.c 

#		*Compiler Configuration File*
digext.cfg: digext.mak
  copy &&|
-ff-
-A
-K
-k-
-d
-wamb
-wamp
-wasm
-wpro
-wcln
-wdef
-wsig
-wnod
-wstv
-wucp
-wuse
-IC:\BORLAND\INCLUDE
-LC:\BORLAND\LIB
-P-.C
| digext.cfg
