;			       SUFFIX
;

sfx_len		equ	050h
ibuf_len	equ	0100h
obuf_len	equ	0150h
stk_len		equ	0100h
total_buflen	=	sfx_len	+ ibuf_len + obuf_len +	stk_len

codeseg		segment
		assume	cs:codeseg, ds:codeseg

		org	100h

suffix		proc	far
start:		jmp	short init

; ---------------------------------
msg1		db	13, 10,	'Usage is: SUFFIX <quoted string>', 13,	10, '$'
msg2		db	13, 10,	'Unable	to allocate memory - aborting.'
		db	13, 10,	'$'
; ---------------------------------

init:		mov	bx,offset pgm_end
		add	bx,0Fh
		mov	cl,4
		shr	bx,cl
		mov	ah,04Ah		; allocate memory explicitly
		int	021h
		mov	dx,offset msg2	; set up error message
		jc	err_exit	; quit if cf=1
		xor	ax,ax			; init buffers and stk
		mov	di,offset last_line	       ;  to all 0's
		mov	cx,total_buflen
		shr	cx,1
		cld
		rep	stosw
		mov	sp,offset pgm_end

		mov	si,81h		; point	si to command line parms
		call	get_suffix	; get the quoted suffix	string
		mov	dx,offset msg1	; set up other error msg
		cmp	al,5		; success code
		jne	err_exit	; unsuccessful - quit with err msg
		call	get_suffix	; This checks for extra	stuff on
		mov	dx,offset msg1
		cmp	al,3		;  the command line, and quits with
		jne	err_exit	;  error msg if	found.

main:		call	get_line	; input	a line from std	in
		jc	quit		;  quit	on carry set (eof or error)
		call	set_suffix	; suffix it
		call	out_put		; output it to std out
		jc	quit		;  quit	on error.
		jmp	main		; repeat until eof(input)


err_exit:	mov	di,dx
		mov	cx,0FFh
		mov	al,024h
		cld
		repnz	scasb		; this was to get len of message
		dec	di
		mov	cx,di
		sub	cx,dx		; some arithmetic
		mov	bx,2		; handle for std error
		mov	ah,040h		; output msg to	std error
		int	021h		;  (error msg will go to con)
		mov	al,1		; exit status =	1
quit:		mov	ah,04Ch
		int	021h		; terminate process.

suffix		endp


; ----------------------------------------------------------------------------
;		SUBROUTINE  get_suffix
;		get the	quoted suffix into the holding area
;

get_suffix	proc	near
		call	rem_spc			; skips	spaces on cmd line
		mov	di,si			; save si in di
		cmp	byte ptr [si],0Dh	; see if we have eoln
		jne	Q1			; no, continue
		mov	al,3			;  else	return eoln code.
		ret

Q1:		mov	dl,022h			; double quote
		cmp	[si],dl
		je	P1			; ok, continue
		mov	dl,027h			; single quote
		cmp	[si],dl
		je	P1			; still	ok, continue
		mov	al,4			; no, return non-quote code.
		ret

P1:		inc	si		; now get quoted string	into vacant
		mov	di,offset last_line    ; suffix	buffer area

Q2:		lodsb			; get [si] into	al
		cmp	al,dl		; check	for matching quote, still in
		je	Q3		; dl.  If found, we're done.
		cmp	al,0Dh		; check	for eoln
		je	P2		; if found here, error
		stosb			; OK - store al	to [es:di]
		cmp	di,offset in_buffer
		je	P2		;  too many chars, exit	with error
		jmp	Q2		; repeat until done or error.
Q3:		mov	al,5		; success.

P3:		mov	byte ptr [di],0		; null terminate the string
		mov	di,offset last_line	       ; reset di
		ret

P2:		mov	al,6		; error	(non-success) code
		jmp	P3

get_suffix	endp

; --------------------------------------------------------------------------
;		SUBROUTINE  get_line
;		inputs a string	(line) from std	in

get_line	proc	near
		mov	si,offset in_buffer	; point	si to input buffer

G1:		mov	dx,si			; point	dx to input buffer
		mov	cx,1			; set char count to 1
		mov	bx,0			; select handle	for input
		mov	ah,3Fh			; DOS input from std in
		int	21h

		jc	getline_ret		; error, code in ax
		stc
		mov	cx,ax			; ax = chars read
		jcxz	getline_ret		; return if no chars read
		mov	al,0			; set exit status to 0
		cmp	byte ptr [si],0Ah	; eoln,	return
		je	getline_ret
		cmp	byte ptr [si],1Ah	; check	for eof
		stc
		jz	getline_ret		; eof, ret w/carry set
		inc	si			; inc si
		cmp	si,offset out_buffer	; check	for buffer overrun
		jb	G1			; OK, repeat
		mov	al,1			; not OK, exit status 1
		stc				;  ret w/carry set

getline_ret:	ret

get_line	endp

; -------------------------------------------------------------------------
;		SUBROUTINE  set_suffix
;		suffixes the line that was input

set_suffix	proc	near
		cld
		mov	di,offset out_buffer	; point	to output buffer

; first	move the input line into the output buffer:

		mov	si,offset in_buffer	; set si to input buffer

S1:		lodsb				; [si] into al
		stosb				; al to	[es:di]
		cmp	al,0Dh			; check	for eoln
		jne	S1			; if yes, goto S2

; now move the suffix into the output buffer:

		mov	si,offset last_line	       ; restore suffix	ptr to si
		dec	di			; move di back 1 char
S2:		lodsb				; [si] into al
		cmp	al,0			; end of suffix	(null term.)
		je	S3			; now finish line
		stosb				; al to	[es:di]
		jmp	S2			; repeat
S3:		mov	al,0Dh			; put the eoln on output.
		stosb
		mov	al,0Ah
		stosb
		ret				; done - return
set_suffix	endp

; -------------------------------------------------------------------------
;		SUBROUTINE  out_put
;		outputs	the string (line) to std out

out_put		proc	near
		mov	si,offset out_buffer
		mov	dx,si		; put si in dx
		xor	cx,cx		; start	cx at 0

O1:		inc	cx		; pre-increment	for char count
		cmp	cx,obuf_len	; check	for buffer overrun
		stc
		jge	output_ret	; suffix + line	too long, exit
		lodsb			; [si] into al
		cmp	al,0Ah		; see if it's eoln
		jne	O1		; if not, repeat.
		mov	bx,1		; set up std out
		mov	ah,040h		; output cx characters.
		int	021h

output_ret:	ret			; carry	set if error.

out_put		endp

; -------------------------------------------------------------------------
;		SUBROUTINE
;		skips over spaces

rem_spc		proc	near
R1:
		cmp	byte ptr [si],20h
		jne	rem_spc_ret
		inc	si
		jmp	R1

rem_spc_ret:	ret
rem_spc		endp

; --------------------------------------------------------------------------
;  buffer allocation:
last_line	label	word

in_buffer	=	last_line + sfx_len
out_buffer	=	in_buffer + ibuf_len
pgm_end		=	out_buffer + obuf_len +	stk_len

codeseg		ends
		end	start
