//               GFX, graphical extension for Turbo Vision.
//                       Written By: Simor Balazs
//               Ported to TV 2.0 By: Michael Fainstein
//                              V 3.10
//
// This software can be freely distributed provided, that the author
// message remains intact, and it is not used for professional purposes.
// If you make modifications to the software and you want to redistribute it,
// please let the user know, that it is not the original version.
// You may NOT redistribute the source code of the software, it is
// not shareware.

#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TKeys
#define Uses_TScreen
#define Uses_TMouse
#define Uses_MsgBox
#define Uses_TWindow
#define Uses_TDialog
#define Uses_TButton
#define Uses_TInputLine
#define Uses_fpstream
#define Uses_TStaticText
#define Uses_TRadioButtons
#define Uses_TLabel
#define Uses_TSItem
#include <tvision\tv.h>

#include <graphics.h>
#include "gfx.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>

#include <time.h>
#include <dos.h>

#include <alloc.h>

#if defined(__DPMI32__) || defined(__DPMI16__)
#define CatchExceptions
#endif

#ifdef CatchExceptions
#include "tvexcdlg.h"
#endif

//undefine this symbol, if you want to see the speed difference between the
//cached and non-cached graphics view at "File/Pop Up Graphics" menu.
#define Graphics_caching

const GRFX = 120;
const toGR = 121;
const toTX = 122;
const About= 123;
const MVMNT = 124;
const BarCh = 125;
const TxtTst = 126;
const PieCh = 127;
const toDOS = 128;
const CursorChange = 150;
const PleaseWait = 151;

ushort startMode = smDefault;


gfx_mouse_shape pointer_shapes[10];
int pointer_shapes_num;
gfx_mouse_shape wait_shapes[10];
int wait_shapes_num;
gfx_mouse_shape move_shapes[10];
int move_shapes_num;
gfx_mouse_shape resize_shapes[10];
int resize_shapes_num;


class MyProgressBar : public GView
{
public:
   // default the background char to 178, but you can pass any char you want
   MyProgressBar(TRect& r, unsigned long iters, char abackChar='');
   ~MyProgressBar();
   virtual void draw();     // for text mode
   virtual void paint();    // for graphic mode
   virtual TPalette& getPalette() const;
   virtual void update(unsigned long aProgress);
   void setTotal(unsigned long newTotal); // set the maximum iteration

protected:
   char          backChar;   // background character
   unsigned long total;      // total iterations to complete 100 %
   unsigned long progress;   // current iteration value
   char *        th_bar;     // thermometer bar
   unsigned int  dispLen;    // length of bar
   unsigned int  curPercent; // current percentage
   unsigned int  curWidth;
   unsigned int  numOffset;  // offset in the string to display the percentage
   double        charValue;

private:
   void calcPercent();     // calculate new percentage
};

class TPleaseWaitDialog : public TDialog
{
public:
    TPleaseWaitDialog( );
    virtual void handleEvent( TEvent& );

    MyProgressBar *pBar;
    TButton *cancel_button;

private:
    gfx_mouse_shape_descriptor defaultCursor;
    gfx_mouse_shape_descriptor currentCursor;
};

class IdleObject
{
public:
	virtual void idle_function(void) {}

	IdleObject *n; //pointer to next IdleObject
};

class Movie : public GView, public IdleObject
{
	int states;
	long sz;
	char *pict;
	int state;
public:
	Movie(const TRect& bounds);
	~Movie(void);
	virtual void idle_function(void);
	virtual void paint(void);
};

class MyMoving : public GView, public IdleObject
{
public:
	MyMoving(const TRect& bounds);
	~MyMoving(void);
	virtual void idle_function(void);
	void paint(void);

private:
	int state;
	int max;
	TPoint cntr;
};

class MyDrawing : public GView
{
#ifdef Graphics_caching
	Boolean stored;
	void *img;
	GRect ex; //extent, for  which the img is stored
#endif
public:
	MyDrawing (const TRect& bounds) : GView(bounds) {
#ifdef Graphics_caching
	stored = False;
	img = 0;
#endif
	}
#ifdef Graphics_caching
	~MyDrawing () { if (img) farfree(img); }
#endif
	virtual void paint(void);
};

class BarChart : public GView
{
public:
	BarChart (const TRect& bounds) : GView(bounds) {}
	virtual void paint(void);
};

class TextTst : public GView
{
public:
	TextTst (const TRect& bounds) : GView(bounds) {}
	virtual void paint(void);
};

class PieChart : public GView
{
public:
	PieChart (const TRect& bounds) : GView(bounds) {}
	virtual void paint(void);
};

class TGMouseDisplay : public GView
{
public:
	TGMouseDisplay (const TRect& bounds, gfx_mouse_shape ms) : GView(bounds), gms(ms) {}
	virtual void paint(void);
protected:
    gfx_mouse_shape gms;
};

class TMyApp : public GApplication
	{
	public:
		TMyApp(ushort mode, char *bgiPath);

		virtual void handleEvent(TEvent &event);
        static TStatusLine *initStatusLine( TRect r );
		static TMenuBar *initMenuBar( TRect r );
		virtual void idle(void);
		int registeridle(IdleObject *obj);
		void unregisteridle(IdleObject *obj);

	private:
	IdleObject *idleobj;

	clock_t idle_timer;
	};


TMyApp *app;


MyProgressBar::MyProgressBar(TRect& bounds, unsigned long aTotal, char abackChar)
 :  GView(bounds)
{
    backChar = abackChar;
    total = aTotal;
    numOffset = (size.x/2)-3;
    th_bar = new char[size.x+1];
    memset(th_bar,backChar,size.x);
    th_bar[size.x] = '\0';
    charValue = (double)100/(double)size.x;
    progress =
    curPercent =
    curWidth = 0;
}

MyProgressBar::~MyProgressBar()
{
    delete th_bar;
}

void MyProgressBar::draw()
{
    if ( ScreenModeIsGraphic() ) {
        GView::draw();
        return;
    }
     
    char string[4];

    itoa(curPercent,string,10);
    string[3] = '\0';
    if ( curPercent < 10 ) {
        string[2] = string[0];
        string[1] = string[0] = ' ';
    }
    else if ( curPercent < 100 && curPercent > 9 ) {
        string[2] = string[1];
        string[1] = string[0];
        string[0] = ' ';
    }

    TDrawBuffer nbuf;
    uchar colorNormal, colorHiLite;

    colorNormal = getColor(1);
    uchar fore = colorNormal >> 4;                   // >>4 is same as /16
    colorHiLite = fore+((colorNormal-(fore<<4))<<4); // <<4 is same as *16
    nbuf.moveChar(0,backChar,colorNormal,size.x);
    nbuf.moveStr(numOffset,string,colorNormal);
    nbuf.moveStr(numOffset+3," %",colorNormal);
    for ( int i = 0 ; i < curWidth ; i++ ) {
        nbuf.putAttribute(i,colorHiLite);
    }
    writeLine(0, 0, size.x, 1, nbuf);
}

void MyProgressBar::paint()
{
    GRect ext = getGExtent();
    
    uchar colorNormal, colorHiLite;

    colorNormal = getColor(1);
    uchar fore = colorNormal >> 4;
    colorHiLite = colorNormal & 0x0F;

    int x = ext.a.x + int(long(curPercent) * (ext.b.x - ext.a.x) / 100l);
    setfillstyle(SOLID_FILL, colorHiLite);
    bar(ext.a.x, ext.a.y, x, ext.b.y);
    setfillstyle(SOLID_FILL, fore);
    bar(x, ext.a.y, ext.b.x, ext.b.y);

	setcolor(WHITE);
	settextstyle (DEFAULT_FONT, HORIZ_DIR, 1);
	settextjustify(CENTER_TEXT, CENTER_TEXT);
    char cbuf[10];
    sprintf(cbuf, "%d %%", curPercent);
	outtextxy(ext.b.x/2, ext.b.y/2, cbuf);
}

TPalette& MyProgressBar::getPalette() const
{
#define cpProgressBar "\x04"
    static TPalette palette( cpProgressBar, sizeof( cpProgressBar )-1 );
    return palette;
}


void MyProgressBar::update(unsigned long aProgress)
{
    progress = aProgress;
    calcPercent();
    drawView();
}

void MyProgressBar::calcPercent()
{
    unsigned int percent;
    unsigned int width;
    
    // calculate the new percentage
    percent = (int) ( ((double)progress/(double)total) * 100.0 + 0.5 );
    
    // percentage change?
    if ( percent != curPercent ) {
        curPercent = percent;          // save new percentage
        width = (int)((double)curPercent/charValue);// calculate percentage bar width
        
        // width change?
        if ( width != curWidth ) {
            curWidth = width;          // save new width
        }
    }
}

Movie::Movie(const TRect& bounds) : GView(bounds)
{
	sz = 3963;
	states = 4;
	pict = (char *)farmalloc(sz*states);
	state=0;

fpstream in;	//reading the file containing the silly head.
	in.open("images",ios::binary|ios::in|ios::nocreate);
	if (in.fail())
		{
		free(pict);
		pict = 0;
		return;
		}
	in.readBytes(pict, size_t(sz*states));
	in.close();

unsigned w,h;
	if (ScreenModeIsGraphic())  //only in graphics modes
		{
		imagedimensions(pict, &w, &h);
		growTo(w/_xCharSize, h/_yCharSize+1); //growing to the necessary size
		}
}

Movie::~Movie(void)
{
	app->unregisteridle(this);
	if (pict) free(pict);
}

void Movie::paint(void)
{
	TView::draw(); //original background
	if (!pict) return;
	putimage(0,0,pict+sz*state,COPY_PUT);
}

void Movie::idle_function(void)
{
	if (!pict) return;
	if (1 != beginPaint()) return;
	state = (state+1)%states;
	putimage(0,0,pict+sz*state,COPY_PUT);
	endPaint();
}


MyMoving::~MyMoving(void)
{
	app->unregisteridle(this);
}

MyMoving::MyMoving(const TRect& bounds) : GView(bounds)
{
GRect ext;

	ext = getGExtent();

	cntr.x = ext.b.x/2;
	cntr.y = ext.b.y/2;

	max = (cntr.x > cntr.y ? cntr.x : cntr.y);
	state = 0;
}

void MyMoving::paint(void)
{
	clearviewport();
}

void MyMoving::idle_function(void)
{
	if (1 != beginPaint()) return;
	setcolor(BLACK);
	circle (cntr.x , cntr.y , state);

	GRect ext = getGExtent(); //New part ensures that the circles will be in
	cntr.x = ext.b.x/2; //the center even after bound changes
	cntr.y = ext.b.y/2;
	max = (cntr.x > cntr.y ? cntr.x : cntr.y);

	state = max < state+4 ? 0 : state + 4;

	setcolor(YELLOW);
	circle (cntr.x , cntr.y , state);
	endPaint();
}

void MyDrawing::paint(void)
{
	GRect ext = getGExtent();
#ifdef Graphics_caching
	if (stored && ext == ex)
		{
		putimage (0, 0, img, COPY_PUT);
		return;
		} //if
#endif
	TPoint cntr;   //Centerpoint
	cntr.x = ext.b.x/2;
	cntr.y = ext.b.y/2;
	int max = (cntr.x > cntr.y ? cntr.x : cntr.y);

	clearviewport();
	//TView::draw();

	for (int i = max; i>0; i-=4)
		{
		setcolor ( (i/4)%16);
		setfillstyle (SOLID_FILL, (i/4)%16);
		fillellipse (cntr.x , cntr.y , i,i);
		} //for

#ifdef Graphics_caching
	if (!isClear()) return;

	if (stored)
		farfree(img);

	ex = ext;

	GRect a = getGAbsBounds();

    unsigned long imgSz = imagesize(a.a.x, a.a.y, a.b.x, a.b.y);
	img = farmalloc(imgSz);

	//::setviewport(0,0,getmaxx(),getmaxy(),1);
	getimage(a.a.x, a.a.y, a.b.x, a.b.y, img);

	stored = True;
#endif
}

void BarChart::paint(void)
{
	clearviewport();
	GRect ext = getGExtent();

	setcolor(WHITE);
	for (int i=0; i<4; i++)
		{
		setfillstyle(SOLID_FILL, i+9);
		bar3d(i*ext.b.x/4+5, 10+i*5, (i+1)*ext.b.x/4-5, ext.b.y, 10, 1);
		} //for
}

void TextTst::paint()
{
	GRect ext = getGExtent();
	clearviewport();
	setcolor(WHITE);
	settextstyle (GOTHIC_FONT, HORIZ_DIR,6);
	settextjustify(CENTER_TEXT, CENTER_TEXT);
	outtextxy(ext.b.x/2, ext.b.y/2, "A Test");
}

void PieChart::paint()
{
int data[5]={13, 32, 100, 54, 90};
int xas, yas;

	GRect ext = getGExtent();
	getaspectratio(&xas, &yas);
	int r = (int) (((long)ext.b.y*yas>(long)ext.b.x*xas ?
			(long)ext.b.x*xas/yas : (long)ext.b.y*yas/xas) *7/8/2);
	clearviewport();
	setcolor(WHITE);
	int s = 0;
	for (int i=0; i<5; i++)
		{
		setfillstyle(SOLID_FILL, 9+i);
		pieslice(ext.b.x/2, ext.b.y/2, s, s+data[i], r);
		s += data[i];
		} //for

	setfillstyle(SOLID_FILL, 9+i);
	pieslice(ext.b.x/2+10, ext.b.y/2 + 5, s, 359, r);
}

void TGMouseDisplay::paint()
{
    int i, j;
    short wa, wx;
    gfx_mouse_shape_descriptor sd;

    GMouseShape::getMouseShapeDescriptor(gms, sd);

    // draw black background
	setcolor(BLACK);
    for ( i = 0 ; i < 16 ; ++i ) {
	    line(0,i,15,i);
    }
    // draw xor_mask
    for ( i = 0 ; i < 16 ; ++i ) {
        wx = sd.xor_mask[i];
        for ( j = 0 ; j < 16 ; ++j ) {
            if ( (wx & 0x8000) != 0 ) {
                putpixel(j, i, WHITE);
            }
            wx <<= 1;
        }
    }

    // draw white background
	setcolor(WHITE);
    for ( i = 0 ; i < 16 ; ++i ) {
	    line(0+16,i,15+16,i);
    }
    for ( i = 0 ; i < 16 ; ++i ) {
        wa = sd.and_mask[i];
        wx = sd.xor_mask[i];
        for ( j = 0 ; j < 16 ; ++j ) {
            if ( (wa & 0x8000) != 0 ) {
                if ( (wx & 0x8000) != 0 ) {
                    // inverted
                    putpixel(j+16, i, BLACK);
                }
                else {
                    // no change
                }
            }
            else {
                if ( (wx & 0x8000) != 0 ) {
                    // no change
                }
                else {
                    putpixel(j+16, i, BLACK);
                }
            }
            wa <<= 1;
            wx <<= 1;
        }
    }
}

int GMShapeIndex(gfx_mouse_shape_descriptor& cursor, gfx_mouse_shape * shapes)
{
    int i;
    gfx_mouse_shape_descriptor crs;

    for ( i = 0 ; i < 10 ; ++i ) {
        GMouseShape::getMouseShapeDescriptor(shapes[i], crs );
        if ( memcmp(&cursor, &crs, sizeof(cursor)) == 0 ) {
            return(i);
        }
    }
    return(0);
}

struct gmShapeSelectDataRec {
    ushort pointer;
    ushort move;
    ushort resize;
    ushort wait;
};

class TGMShapeSelectDialog : public TDialog
{
public:
    TGMShapeSelectDialog( );
    virtual void handleEvent( TEvent& );

    TRadioButtons *pointer_select;
    TRadioButtons *move_select;
    TRadioButtons *resize_select;
    TRadioButtons *wait_select;

    TStaticText *pointer_test;
    TStaticText *move_test;
    TStaticText *resize_test;
    TStaticText *wait_test;

private:
    gfx_mouse_shape_descriptor defaultCursor;
    gfx_mouse_shape_descriptor currentCursor;
};

TGMShapeSelectDialog::TGMShapeSelectDialog() :
       TDialog(TRect(0, 3, 80, 23), "Graphic Mouse Shape Selection"),
       TWindowInit(TGMShapeSelectDialog::initFrame)

{
    TView *control;
    int i, j;

    pointer_select = new TRadioButtons(TRect(3, 3, 18, 11),
        new TSItem("default",
        new TSItem("n-w 1",
        new TSItem("n-w 2",
        new TSItem("north 1",
        new TSItem("north 2",
        new TSItem("east",
        new TSItem("n-e arrow",
        new TSItem("west", 0)))))))));
    insert(pointer_select);
    insert(new TLabel(TRect(2, 2, 10, 3), "Pointer", pointer_select));

    j = 0;
    pointer_shapes[j++] = GM_DEFAULT_ARROW;
    pointer_shapes[j++] = GM_POINTER_NW1;
    pointer_shapes[j++] = GM_POINTER_NW2;
    pointer_shapes[j++] = GM_POINTER_N1;
    pointer_shapes[j++] = GM_POINTER_N2;
    pointer_shapes[j++] = GM_POINTER_E;
    pointer_shapes[j++] = GM_NE_ARROW;
    pointer_shapes[j++] = GM_POINTER_W;
    pointer_shapes_num = j;

    for ( i = 0 ; i < j ; ++i ) {
        control = new TGMouseDisplay(TRect(18, 3+i, 22, 4+i), pointer_shapes[i]);
        insert(control);
    }

    move_select = new TRadioButtons(TRect(24, 3, 33, 7),
        new TSItem("n-s",
        new TSItem("e-w",
        new TSItem("+ 1",
        new TSItem("+ 2", 0)))));
    insert(move_select);
    insert(new TLabel(TRect(23, 2, 28, 3), "Move", move_select));

    j = 0;
    move_shapes[j++] = GM_NS_ARROW;
    move_shapes[j++] = GM_EW_ARROW;
    move_shapes[j++] = GM_MOVE;
    move_shapes[j++] = GM_MOVE2;
    move_shapes_num = j;

    for ( i = 0 ; i < j ; ++i ) {
        control = new TGMouseDisplay(TRect(33, 3+i, 37, 4+i), move_shapes[i]);
        insert(control);
    }

    resize_select = new TRadioButtons(TRect(39, 3, 50, 7),
        new TSItem("nw-se",
        new TSItem("ne-sw",
        new TSItem("+ 1",
        new TSItem("+ 2", 0)))));
    insert(resize_select);
    insert(new TLabel(TRect(38, 2, 45, 3), "Resize", resize_select));

    j = 0;
    resize_shapes[j++] = GM_NW_SE_ARROW;
    resize_shapes[j++] = GM_NE_SW_ARROW;
    resize_shapes[j++] = GM_MOVE;
    resize_shapes[j++] = GM_MOVE2;
    resize_shapes_num = j;

    for ( i = 0 ; i < j ; ++i ) {
        control = new TGMouseDisplay(TRect(50, 3+i, 54, 4+i), resize_shapes[i]);
        insert(control);
    }

    wait_select = new TRadioButtons(TRect(56, 3, 73, 7),
        new TSItem("hourglass 1",
        new TSItem("hourglass 2",
        new TSItem("clock 1",
        new TSItem("clock 2", 0)))));
    insert(wait_select);
    insert(new TLabel(TRect(55, 2, 60, 3), "Wait", wait_select));

    j = 0;
    wait_shapes[j++] = GM_HOURGLASS1;
    wait_shapes[j++] = GM_HOURGLASS2;
    wait_shapes[j++] = GM_CLOCK1;
    wait_shapes[j++] = GM_CLOCK2;
    wait_shapes_num = j;

    for ( i = 0 ; i < j ; ++i ) {
        control = new TGMouseDisplay(TRect(73, 3+i, 77, 4+i), wait_shapes[i]);
        insert(control);
    }

    pointer_test = new TStaticText(TRect(3, 12, 18, 15), "Pointer\n"
        "test\n"
        "area\n");
    pointer_test->options |= ofFramed;
    insert(pointer_test);
    
    move_test = new TStaticText(TRect(24, 12, 33, 15), "Move\n"
        "test\n"
        "area");
    move_test->options |= ofFramed;
    insert(move_test);
    
    resize_test = new TStaticText(TRect(39, 12, 50, 15), "Resize\n"
        "test\n"
        "area");
    resize_test->options |= ofFramed;
    insert(resize_test);
    
    wait_test = new TStaticText(TRect(56, 12, 73, 15), "Wait\n"
        "test\n"
        "area");
    wait_test->options |= ofFramed;
    insert(wait_test);

    control = new TButton(TRect(15, 17, 25, 19), "Apply", cmOK, bfDefault);
    insert(control);
    
    control = new TButton(TRect(48, 17, 58, 19), "Cancel", cmCancel, bfNormal);
    insert(control);

    defaultCursor = GApplication::defaultCursor;
    currentCursor = defaultCursor;

    selectNext(False);
}

void TGMShapeSelectDialog::handleEvent( TEvent& event)
{
    gfx_mouse_shape_descriptor cursor;
    ushort ind;
    int i;
    struct {
        TView *test_view;
        TView *select_view;
        gfx_mouse_shape *shapes;
        int shapes_num;
    } cursorSelectData[4] = {
        { pointer_test, pointer_select, pointer_shapes, pointer_shapes_num },
        { move_test,    move_select,    move_shapes,    move_shapes_num },
        { resize_test,  resize_select,  resize_shapes,  resize_shapes_num },
        { wait_test,    wait_select,    wait_shapes,    wait_shapes_num },
    };

    if ( event.what == evMouseMove ) {
        cursor = defaultCursor;
        for ( i = 0 ; i < 4 ; ++i ) {
            if ( cursorSelectData[i].test_view->mouseInView(event.mouse.where) ) {
                cursorSelectData[i].select_view->getData(&ind);
                GMouseShape::getMouseShapeDescriptor(cursorSelectData[i].shapes[ind], cursor );
                break;
            }
        }

        if ( memcmp(&cursor, &currentCursor, sizeof(cursor)) != 0 ) {
            currentCursor = cursor;
            app->setDefaultCursor(currentCursor);
        }
    }
    else if ( event.what == evMouseDown ) {
        for ( i = 0 ; i < 4 ; ++i ) {
            if ( cursorSelectData[i].test_view->mouseInView(event.mouse.where) ) {
                cursorSelectData[i].select_view->getData(&ind);
                ind  = (ind + 1) % cursorSelectData[i].shapes_num;
                cursorSelectData[i].select_view->setData(&ind);
                cursorSelectData[i].select_view->getData(&ind);
                GMouseShape::getMouseShapeDescriptor(cursorSelectData[i].shapes[ind], currentCursor );
                app->setDefaultCursor(currentCursor);
                break;
            }
        }
    }

    TDialog::handleEvent(event);
}

TPleaseWaitDialog::TPleaseWaitDialog() :
    TDialog(TRect(17, 9, 63, 16), "Please Wait"),
    TWindowInit(TPleaseWaitDialog::initFrame)
{
    pBar = new MyProgressBar(TRect(6, 2, 40, 3), 100);
    insert(pBar);
    
    cancel_button = new TButton(TRect(18, 4, 28, 6), "~C~ancel", cmCancel, bfNormal);
    insert(cancel_button);
    
    defaultCursor = GM_WAIT;
    currentCursor = defaultCursor;

    selectNext(False);
}

void TPleaseWaitDialog::handleEvent( TEvent& event)
{
    gfx_mouse_shape_descriptor cursor;

    if ( event.what == evMouseMove ) {
        if ( cancel_button->mouseInView(event.mouse.where) ) {
            cursor = GApplication::defaultCursor;
        }
        else {
            cursor = GM_WAIT;
        }

        if ( memcmp(&cursor, &currentCursor, sizeof(cursor)) != 0 ) {
            currentCursor = cursor;
            GMouseShape::setMouseGraphicCursor(currentCursor);
        }
    }
    TDialog::handleEvent(event);
}

void TMyApp::idle(void)
{
	TProgram::idle();

	if (idle_timer == clock())
		{
		return;
		} //if
	idle_timer = clock();

IdleObject *p=idleobj;

	while (p)
		{
		p->idle_function();
		p = p->n;
		} //while
}


int TMyApp::registeridle( IdleObject *obj )
{
const Number_of_idle_objects = 5;
IdleObject *p0 = 0;
IdleObject *p = idleobj;
int i = 1;

	while (p && i<Number_of_idle_objects)
		{
		p0 = p;
		p = p->n;
		i++;
		}//while
	if (p) return 0; // too many idle objects
	if (p0)
		p0->n=obj;// adding to queue
	else
		idleobj = obj;
	obj->n = 0; //closing queue
	return 1;
}

void TMyApp::unregisteridle(IdleObject *obj)
{
IdleObject *p = idleobj;
IdleObject *p0;

	if (idleobj == obj)
		{
		idleobj = idleobj->n; //unlinking the first
		return;
		} //if

	while(p)
		{
		p0 = p;
		p = p->n;
		if(p == obj)
			{
			p0->n = p->n; //unlinking p
			return;
			} //if
		} //while
}

void TMyApp::handleEvent (TEvent &event)
{
    TDialog *w;

	if (event.what == evCommand)
    {
		switch (event.message.command)
		{
		case GRFX:
            {
			TDialog *w = new TDialog(TRect(0,0, 50, 11), "Graphics");
			w->options &= ~ofBuffered;
			w->insert (new TButton( TRect (38, 8, 48, 10), "~O~K", cmOK, bfDefault));
			w->insert (new TInputLine(TRect (2, 8, 36,9),32) );
			w->insert (new MyDrawing(TRect(2, 2, 24, 6) ));
			w->insert (new MyDrawing(TRect(26, 2, 48, 6) ));
			deskTop->insert(w);
			clearEvent(event);
            }
		break;

		case BarCh:
            {
			w = new TDialog(TRect(0,0, 50, 11), "Bar Chart");
			w->options &= ~ofBuffered;
			w->insert (new TButton( TRect (38, 8, 48, 10), "~O~K", cmOK, bfDefault));
			w->insert (new TInputLine(TRect (2, 8, 36,9),32) );
			w->insert (new BarChart(TRect(2, 2, 24, 6) ));
			w->insert (new BarChart(TRect(26, 2, 48, 6) ));
			deskTop->insert(w);
			clearEvent(event);
            }
		break;

		case TxtTst:
            {
			w = new TDialog(TRect(0,0, 50, 11), "Text Test");
			w->options &= ~ofBuffered;
			w->insert (new TButton( TRect (38, 8, 48, 10), "~O~K", cmOK, bfDefault));
			w->insert (new TInputLine(TRect (2, 8, 36,9),32) );
			w->insert (new TextTst(TRect(2, 2, 24, 6) ));
			w->insert (new TextTst(TRect(26, 2, 48, 6) ));
			deskTop->insert(w);
			clearEvent(event);
            }
		break;

		case PieCh:
            {
			w = new TDialog(TRect(0,0, 35, 11), "Pie Chart");
			w->options &= ~ofBuffered;
			w->flags |= wfGrow;
			TView *pch = new PieChart( TRect (1, 1, 34, 10));
			pch->growMode = gfGrowHiX | gfGrowHiY; //moves with its owner.
			w->insert (pch);
			deskTop->insert(w);
			clearEvent(event);
            }
		break;

		case MVMNT:
            {
			TDialog *m = new TDialog(TRect(0,0, 50, 11), "Moving Graphics");
			m->options &= ~ofBuffered;
			m->flags |= wfGrow;
			MyMoving *p = new MyMoving(TRect(1, 1, 49, 10) );
			p->growMode = gfGrowHiX | gfGrowHiY;
			m->insert (p);
			if (registeridle(p))
				deskTop->insert(m);
			else
				{
				messageBox("\x03 Sorry, cannot insert more Moving Graphics.",
					mfError | mfOKButton);
				destroy (m);
				}
			clearEvent(event);
            }
		break;

        case PleaseWait:
        {
            GMouseShape wCur(GM_WAIT);  // set mouse cursor shape to GM_WAIT
			TPleaseWaitDialog *pw = new TPleaseWaitDialog();
            deskTop->insert(pw);
            unsigned long i;
            clock_t startTime, currTime;
            Boolean closeDialog = False;
            for ( i = 0 ; i < 100 ; ++i ) {
                startTime = clock();
                for ( ; ; ) {
                    currTime = clock();
                    if ( (currTime - startTime) < 200 ) {
                        idle();
                        pw->getEvent(event);
                        if ( event.what == evCommand ) {
                            if (event.message.command == cmCancel ||
                                event.message.command == cmClose ||
                                event.message.command == cmQuit )
                            {
                                closeDialog = True;
                                break;
                            }
                        }
                        pw->handleEvent(event);
                    }
                    else {
                        break;
                    }
                }
                if ( closeDialog ) {
                    break;
                }
                pw->pBar->update(i+1);
            }
            destroy(pw);
			clearEvent(event);
            // standard cursor shape will be restored upon exit from this block
        }
		break;

		case CursorChange:
        {
			TGMShapeSelectDialog *crs = new TGMShapeSelectDialog();
            gmShapeSelectDataRec shape;

            shape.pointer = GMShapeIndex(GApplication::defaultCursor, pointer_shapes);
            shape.move = GMShapeIndex(GApplication::moveCursor, move_shapes);
            shape.resize = GMShapeIndex(GApplication::resizeCursor, resize_shapes);
            shape.wait = GMShapeIndex(GApplication::waitCursor, wait_shapes);

			if ( executeDialog(crs, &shape) == cmOK ) {
                setDefaultCursor(pointer_shapes[shape.pointer]);
                setMoveCursor(move_shapes[shape.move]);
                setResizeCursor(resize_shapes[shape.resize]);
                setWaitCursor(wait_shapes[shape.wait]);
            }
            else {
                setDefaultCursor(pointer_shapes[shape.pointer]);
            }
			clearEvent(event);
        }
		break;

		case toTX:
			disableCommand(toTX);
			enableCommand(toGR);

			setScreenMode(smCO80);
		break;

		case toGR:
			disableCommand(toGR);
			enableCommand(toTX);

			setScreenMode(smDefault);
			if ( ScreenModeIsText() ) {
				disableCommand(toTX);
				enableCommand(toGR);
			}
		break;

		case toDOS:
            suspend();
#ifdef CatchExceptions
            DPMIExceptionHandler::releaseExceptions();
#endif
            system("cls");
            cout << "Type EXIT to return...";
            system( getenv( "COMSPEC"));
#ifdef CatchExceptions
            DPMIExceptionHandler::trapExceptions();
#endif
            resume();
            redraw();
		break;

		case About:
            {
            char mem_amount[30];
            int ma_len;
            sprintf(mem_amount, "coreleft() = %ld", coreleft());
            ma_len = strlen(mem_amount);
			w = new TDialog(TRect(20, 5, 66, 17), "About");
			w->insert (new TButton( TRect (7, 9, 17, 11), "~O~K", cmOK, bfDefault));
			w->insert (new TStaticText(TRect(20, 9, 20 + 1 + ma_len, 11), mem_amount));
			w->insert (new TStaticText(TRect(2,2,32,8),
					"\x03TV in Graphics mode\n"
					"\x03Written By Simor Balazs\n"
					"\x03Ported to TV 2.0\n"
#if defined(__DPMI32__)
					"\x03(32-bit p-mode)\n"
#elif defined(__DPMI16__)
					"\x03(16-bit p-mode)\n"
#else

#if defined(__OVERLAY__)
					"\x03(real overlayed mode)\n"
#else
					"\x03(real mode)\n"
#endif

#endif
					"\x03 By Michael Fainstein\n"
					"\x03Source is (C) 1993, 1994, 1995") );
			Movie *mv= new Movie(TRect(33,1,34,2));
			if (!registeridle(mv))
				destroy(mv);
			else
				w->insert(mv);

			executeDialog(w, NULL);
            }
		break;

		} // switch
	} // if

	TApplication::handleEvent(event);
}//handleEvent

TMyApp::TMyApp(ushort mode, char *bgiPath) :
		TProgInit( &TMyApp::initStatusLine, &TMyApp::initMenuBar,
				&TMyApp::initDeskTop )
		, GApplication(mode, bgiPath)
	{
	idleobj = 0;
	idle_timer = clock();
	}

TStatusLine *TMyApp::initStatusLine(TRect r)
{
    r.a.y = r.b.y - 1;     // move top to 1 line above bottom
    return new TStatusLine( r,
        *new TStatusDef( 0, 0xFFFF ) +
            *new TStatusItem( 0, kbF10, cmMenu ) +
            *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
            *new TStatusItem( "~Alt-F3~ Close", kbAltF3, cmClose ) +
            *new TStatusItem( 0, kbF5, cmZoom ) +
            *new TStatusItem( "~F6~ NextWnd", kbF6, cmNext ) +
            *new TStatusItem( 0, kbCtrlF5, cmResize )
        );
}

TMenuBar *TMyApp::initMenuBar( TRect r )
{
	r.b.y = r.a.y+1;

    TSubMenu& fileMenu =
		*new TSubMenu( "~F~ile", kbNoKey )+
			*new TMenuItem( "Pop up graphics", GRFX, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up movement", MVMNT, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up bar chart", BarCh, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up pie chart", PieCh, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up text test", TxtTst, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Progress Bar & Wait Cursor demo", PleaseWait, kbNoKey, hcNoContext,0);
    if ( TMouse::present() ) {
        fileMenu = fileMenu + 
            *new TMenuItem( "Select cursor shape", CursorChange, kbNoKey, hcNoContext,0);
    }
    fileMenu = fileMenu + 
			newLine() +
			*new TMenuItem( "~G~raphics mode", toGR, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "~T~ext mode", toTX, kbNoKey, hcNoContext,0) +
			newLine() +
            *new TMenuItem( "Shell to ~D~OS", toDOS, kbNoKey ) +
			newLine() +
			*new TMenuItem( "E~x~it", cmQuit, kbAltX, hcNoContext, 0 );

    return new TMenuBar( r,
    /*
		*new TSubMenu( "~F~ile", kbNoKey )+
			*new TMenuItem( "Pop up graphics", GRFX, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up movement", MVMNT, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up bar chart", BarCh, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up pie chart", PieCh, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up text test", TxtTst, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Select cursor shape", CursorChange, kbNoKey, hcNoContext,0) +
			newLine() +
			*new TMenuItem( "~G~raphics mode", toGR, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "~T~ext mode", toTX, kbNoKey, hcNoContext,0) +
			newLine() +
            *new TMenuItem( "Shell to ~D~OS", toDOS, kbNoKey ) +
			newLine() +
			*new TMenuItem( "E~x~it", cmQuit, kbAltX, hcNoContext, 0 ) +
        */
        fileMenu +
		*new TSubMenu( "~H~elp", kbNoKey )+
			*new TMenuItem( "~A~bout", About, kbNoKey)
		);
}


int main(int argc, char* argv[])
{
    char *bgi_path = 0;

#ifdef CatchExceptions
    TVExceptionCatcher ex;
#endif

    if ( argc > 1 && toupper(argv[1][0]) == 'T' ) {
        startMode = smCO80;
    }
    if ( argc > 2 ) {
        bgi_path = argv[2];
    }

	app = new TMyApp(startMode, bgi_path);

    if ( ScreenModeIsText() ) {
    	app->disableCommand(toTX);
    }
    else {
    	app->disableCommand(toGR);
    }

	app->run();
	delete app;

	return 0;
}
