{ ASPECTR.PAS }
program AspectRatio;
{ Demonstrates the effect of varying the aspect ratio
  on circle drawing. Increasing Xasp results in an
  increasingly elliptical circle, in the Y axis.
  Decreasing Xasp or increasing Yasp produces a
  increasing ellipse in the horizontal direction.
}
uses
  Crt, Graph;

var
  { Parameters to InitGraph }
  GraphDriver : Integer;
  GraphError  : Integer;
  GraphMode   : Integer;
  { X and Y aspect ratio values }
  Xasp, Yasp  : Word;
  { Used for display purposes }
  XString,
  YString     : String[20];

procedure ClearSection ( X1, Y1, X2, Y2 : Integer );
begin
  SetViewPort (X1, Y1, X2, Y2, ClipOff);
  ClearViewPort;
  SetViewPort (0, 0, GetMaxX, GetMaxY, ClipOn);
end;

begin

  { Request autodetection of correct graphics driver }
  GraphDriver := Detect;

  { Initialize graphics system; look for driver files
    in specified directory }
  InitGraph ( GraphDriver, GraphMode, 'F:\BP\BGI' );

  GraphError := GraphResult;
  if GraphError <> grOk  then
  begin
    Writeln('Error occurred:', GraphErrorMsg(GraphError));
    Halt(1);
  end;

  { Display prompt line }
  SetTextJustify ( LeftText, BottomText );
  SetTextStyle ( DefaultFont, HorizDir, 1 );
  OutTextXY ( 10, GetMaxY - 10, 'Press any key to stop.');

  SetTextJustify( LeftText, TopText );
  GetAspectRatio ( Xasp, Yasp );
  repeat
    Yasp := Yasp - 25;
    SetAspectRatio ( Xasp, Yasp );
    Circle ( GetMaxX div 2, GetMaxY div 2, 75 );
    Str( Xasp:5, XString );
    Str( Yasp:5, YString );
    { Clear out a section on the screen and ... }
    ClearSection (10, 10, 10+TextWidth(XString+', '
		  +YString), 10+TextHeight(XString));
    { Display current Xasp and Yasp values }
    OutTextXY ( 10, 10, XString + ', ' + YString );
  until KeyPressed;


  CloseGraph;

end.
