{$A+,B-,D-,E+,F-,G-,I-,L-,N-,O-,R-,S-,V-,X-}

UNIT Power;   { code adapted from Kahan's PARANOIA program 05-01-92 N. Juffa }


INTERFACE

FUNCTION Pow (X, Y: REAL): REAL;


IMPLEMENTATION

{ Crude power function:  see Cody & Waite for a better one. }

FUNCTION Pow (X, Y: REAL): REAL;

VAR Z:        REAL;
    IY:       LONGINT;
    Reciproc: BOOLEAN;

BEGIN { Pow }
   IF Y = 0.0 THEN
      Pow := 1.0
   ELSE IF (X = 0.0) AND (Y > 0.0) THEN
      Pow := 0.0
   ELSE IF (Y = Int (Y)) AND (Abs(Y) <= MAXLONGINT) THEN BEGIN
      IY := TRUNC (Y);
      IF IY < 0 THEN
         X := 1/X;
      IY := Abs (IY);
      Z := 1.0;
      WHILE IY > 0 DO BEGIN
         IF Odd (IY) THEN
            Z := Z * X;
         IY := IY DIV 2;
         IF IY > 0 THEN
            X := Sqr (X);
      END; {endwhile}
      Pow := Z;
      END { if Y = Int (....}
   ELSE
      Pow := Exp (Y * Ln (X));
END; { Pow }

END. { Power }
