uses OpenDOS;
                                      
var tasks, maximum_tasks, foreground_task_index,
    available_KB, total_KB, i: word;
    major_version, minor_version: byte; 

procedure Task_info(index:word);
  begin
    if index=foreground_task_index then write('>') else write(' ');
    writeln(Get_task_name(index)+'        ':8,
            '  No: ',index:5,
            '  ID: ',index_to_id(index):5,
            '  open files: ',Check_open_files(index):5)
  end;

begin
  if not Task_manager_installed then
    writeln('No task manager')
  else begin
    Get_status(tasks, maximum_tasks, foreground_task_index);
    Get_version(major_version, minor_version);
    writeln('Task manager version: ',major_version,'.',minor_version);
    writeln('Currently ',tasks,' tasks, maximum ',maximum_tasks);
    writeln('EMS limit per task: ',Get_per_task_EMS_limit,' pages',
            ' = ',longint(Get_per_task_EMS_limit)*16,' KB');
    Get_swap_space_info(available_KB, total_KB);
    writeln('Swap space: available ',available_KB,' KB, total ',total_KB,' KB');
    writeln;
    for i:= 0 to tasks-1 do Task_info(i)
  end
end.

