program EpsonTst (input,output);
uses
    Epson;

const
    PolyPoints	= 12;

var
    PltClr,
    XPos,
    YPos	: Integer;

procedure PixLine(s : String);
    var
	i	: Integer;
    begin
	for i := 1 to length(s) do
            case s[i] do
            ':':begin
                    PutDot(XPos+i-1,YPos,1);
                    PutDot(XPos+i-1,YPos-1,1)
                end;
            '`':PutDot(XPos+i-1,YPos-1,1);
            '.':PutDot(XPos+i-1,YPos,1)
            end;
	Dec(YPos,2)
    end;

var
    i,j		: Integer;
    Xa,Ya	: Word;
    PP		: array [0..PolyPoints] of PointType;
begin
    OpenPlot(False,'prtfile');

    (*---- lower left corner ----*)
    Line(0,0,10,0);
    Line(0,0,0,10);

    (*---- upper left corner ----*)
    Line(0,DotMaxY,10,DotMaxY);
    Line(0,DotMaxY,0,DotMaxY-10);

    (*---- lower right corner ----*)
    Line(DotMaxX,0,DotMaxX-10,0);
    Line(DotMaxX,0,DotMaxX,10);

    (*---- upper right corner ----*)
    Line(DotMaxX,DotMaxY,DotMaxX-10,DotMaxY);
    Line(DotMaxX,DotMaxY,DotMaxX,DotMaxY-10);

    (*--- crosshairs at center ----*)
    i := DotMaxX div 2;
    j := DotMaxY div 2;
    Line(i-10,j,i+10,j);
    Line(i,j-10,i,j+10);

    GetPlotAspectRatio(Xa,Ya);
    PlotRectangle(10,200, 110,300);
    PlotRectangle(10,10, 10+100, 10+(100*Xa) div Ya);

    for j := 4 to PolyPoints do begin
	for i := 1 to j do
	    with PP[i] do begin
		X := trunc(cos(2*i*pi/j)*j*30)
			+(DotMaxX div 2);
		Y := trunc(sin(2*i*pi/j)*j*30*Xa/Ya)
			+(DotMaxY div 2)
	      end;
	PP[0] := PP[j];
	DrawPoly(j+1,PP);
      end;

    XPos := DotMaxX-70;
    YPos := 16;
    PixLine('```::```                           ..');
    PixLine('   ::    ....    .....  ...::...   ..   . .....    ..... .');
    PixLine('   ::  ::....:: ``....     ::      ::   ::    ::  ::    ::');
    PixLine('   ::  ``.....  .....:`    `:.:` ..::.. ::    ::  `:....::');
    PixLine('                                                   .....:`');

    YPos := 200;
    XPos := 100;
    PixLine('    :````````````````:')
    PixLine('    : .````````````. :');
    PixLine('    : :    `  `    : :');
    PixLine('    : :  `......`  : :');
    PixLine('    : `............` :')
    PixLine('    `................`                  ..................');
    PixLine('.........................          ..```           ..``:..:.');
    PixLine(':              .......  :      ...:...............:.......');
    PixLine(':                       :``....:                .  .  .  :');
    PixLine(':.......................:      :.........................:');

    PrintBitMap;
    ClosePlot
end.
