{ BPVTST.PAS : Test BPVLIB Unit

  Title    : BPVTST
  Version  : 1.4
  Date     : Nov 08, 1996
  Author   : J.R. Ferguson
  Language : Borland Pascal 7.0 with Objects + Turbo Vision 2.0
  Usage    : MS-DOS Real or Protected Mode application
}

{ --- Compiler options --- }

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }

PROGRAM BPVTST;

Uses Objects, App, Dialogs, Drivers, Menus, MsgBox, StdDlg, Views, Dos,
     StpLib, BpvLib;

{$I OBJTYPE.INC}

const
  C_Title        = 'Test BPVLIB';
  C_Ident        = 'BPVTST v1.4';
  C_SetupFile    = 'BPVTST.SET';

  C_ColsFirst    = true;     { tile columns first }

  cm_FileDos     = cmDosShell;
  cm_FileExit    = cmQuit;
  cm_OptEGA      = 110;
  cm_OptSave     = 111;
  cm_OptRestore  = 112;
  cm_WinCascade  = cmCascade;
  cm_WinTile     = cmTile;
  cm_WinNew      = 122;
  cm_WinClose    = 123;
  cm_WinCloseAll = 124;
  cm_WinEGA      = 125;
  cm_HelpAbout   = 131;

  hc0            = hcNoContext;
  kb0            = kbNoKey;

type
  P_MenuBar     = ^T_MenuBar;
  P_StatusLine  = ^T_StatusLine;
  P_TestList    = ^T_TestList;
  P_FileWindow  = ^T_FileWindow;
  P_Application = ^T_Application;

  T_CommandSet  = set of Byte;

  T_MenuBar     = Object(TMenuBar)
    procedure   Draw; virtual;
  end;

  T_StatusLine  = Object(TStatusLine)
    procedure   Draw; virtual;
  end;

  T_TestList    = Object(TStringCollection)
    Constructor Init;
  end;

  T_FileWindow  = Object(T_ListWindow)
    Constructor Init(var V_Rect: TRect);
    Destructor  Done; virtual;
    Constructor Load(var V_Stream: TStream);
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   ProcessItem(V_Row: integer); virtual;
  end;

  T_Application = Object(TApplication)
    ChildCount  : integer;
    Constructor Init;
    procedure   InitMenuBar; virtual;
    procedure   InitStatusLine; virtual;
    function    CreateChild: P_FileWindow;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoOptEGA;
    procedure   DoOptSave;
    procedure   DoOptRestore;
    procedure   DoWinNew;
    procedure   DoWinCloseAll;
    procedure   DoHelpAbout;
  end;

const
  C_WinCommands : T_CommandSet =
    [cm_WinCascade, cm_WinTile, cm_WinClose, cm_WinCloseAll];

  R_FileWindow  : TStreamRec = (
    ObjType     : OT_Test_Object_0;
    VmtLink     : Ofs(TypeOf(T_FileWindow)^);
    Load        : @T_FileWindow.Load;
    Store       : @T_FileWindow.Store
  );

  R_TestList    : TStreamRec = (
    ObjType     : OT_Test_Object_1;
    VmtLink     : Ofs(TypeOf(T_TestList)^);
    Load        : @T_TestList.Load;
    Store       : @T_TestList.Store
  );



{ --- General --- }

procedure StreamRegistration;
begin
  RegisterObjects;
  RegisterApp;
  RegisterDialogs;
  RegisterMenus;
  RegisterViews;
  RegisterBpvLib;
  RegisterType(R_FileWindow);
  RegisterType(R_TestList);
end;



{ --- T_MenuBar --- }

procedure T_MenuBar.Draw;
var R: TRect;
begin
  inherited Draw;
  GetExtent(R); WriteStr(R.B.X-Length(C_Title)-1,R.A.Y,C_Title,1);
end;


{ --- T_StatusLine --- }

procedure T_StatusLine.Draw;
var R: TRect;
begin
  inherited Draw;
  GetExtent(R); WriteStr(R.B.X-Length(C_Ident)-1,R.A.Y,C_Ident,1);
end;


{ --- T_TestList --- }

Constructor T_TestList.Init;
var r: integer; c: char; s: String;
begin
  Inherited Init(20,10);
  for r:= 0 to Random(26) do begin
    c:= chr(ord('a')+r);
    StpMake(s,c,1+Random(80));
    Insert(NewStr(s));
  end;
end;


{ --- T_FileWindow -- }

Constructor T_FileWindow.Init(var V_Rect: TRect);
begin
  Inherited Init(V_Rect,'',wnNoNumber,New(P_TestList,Init));
  Options:= Options or ofTileable;
  Inc(P_Application(Application)^.ChildCount);
  EnableCommands(C_WinCOmmands);
end;

Destructor  T_FileWindow.Done;
begin
  with P_Application(Application)^ do begin
    Dec(ChildCount);
    if ChildCount = 0 then DisableCommands(C_WinCommands);
  end;
  Inherited Done;
end;

Constructor T_FileWindow.Load(var V_Stream: TStream);
begin
  Inherited Load(V_Stream);
  Inc(P_Application(Application)^.ChildCount);
  EnableCommands(C_WinCOmmands);
end;

procedure   T_FileWindow.HandleEvent(var V_Event: TEvent);
begin
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evBroadCast: case Command of
      cm_WinClose  : Close;
    end;
  end;
end;

procedure   T_FileWindow.ProcessItem(V_Row: integer);
var RowStr: String[10];
begin
  Str(V_Row, RowStr);
  MessageBox(#13#10'row number = '+RowStr,nil,mfInformation or mfOKButton);
end;


{ --- T_Application --- }

Constructor T_Application.Init;
begin
  Randomize;
  StreamRegistration;
  Inherited Init;
  DeskTop^.TileColumnsFirst:= C_ColsFirst;
  ChildCount:= 0;
  DisableCommands(C_WinCommands);
  CreateChild;
end;

procedure   T_Application.InitMenuBar;
var R: TRect;
begin
  GetExtent(R); R.B.Y:= R.A.Y + 1;
  MenuBar:= New(P_MenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile'           ,hc0, NewMenu(
      NewItem('~D~OS Shell'       ,''      ,kb0    ,cm_FileDos     ,hc0,
      NewItem('E~x~it'            ,'Alt+X' ,kbAltX ,cm_FileExit    ,hc0,
    nil))),
    NewSubMenu('~O~ptions'        ,hc0, NewMenu(
      NewItem('~E~GA lines'       ,''      ,kb0    ,cm_OptEGA      ,hc0,
      NewItem('~S~ave desktop'    ,''      ,kb0    ,cm_OptSave     ,hc0,
      NewItem('~R~estore desktop' ,''      ,kb0    ,cm_OptRestore  ,hc0,
    nil)))),
    NewSubMenu('~W~indow'         ,hc0, NewMenu(
      NewItem('~C~ascade'         ,''      ,kb0    ,cm_WinCascade  ,hc0,
      NewItem('~T~ile'            ,''      ,kb0    ,cm_WinTile     ,hc0,
      NewItem('Cl~o~se all'       ,''      ,kb0    ,cm_WinCloseAll ,hc0,
      NewLine(
      NewItem('~N~ew window'      ,''      ,kb0    ,cm_WinNew      ,hc0,
    nil)))))),
    NewSubMenu('~H~elp'           ,hc0, NewMenu(
      NewItem('~A~bout'           ,''      ,kb0    ,cm_HelpAbout   ,hc0,
    nil)),
  nil)))))));
end;

procedure   T_Application.InitStatusLine;
var R: TRect;
begin
  GetExtent(R); R.A.Y:= R.B.Y - 1;
  StatusLine:= New(P_StatusLine, Init(R,
    NewStatusDef($0000,$FFFF,
      NewStatusKey('~Alt+X~ Exit' ,kbAltX ,cm_FileExit,
      StdStatusKeys(
    nil)),
  nil)));
end;

function    T_Application.CreateChild: P_FileWindow;
var R: TRect; p: P_FileWindow;
begin
  GetTileRect(R);
  p:= P_FileWindow(InsertWindow(New(P_FileWindow, Init(R))));
  if p <> nil then Cascade;
  CreateChild:= p;
end;

procedure   T_Application.HandleEvent(var V_Event: TEvent);
  procedure Clear; begin ClearEvent(V_Event); end;
begin { T_Application.HandleEvent }
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evCommand: case Command of
      cm_OptEGA      : begin DoOptEGA      ; Clear; end;
      cm_OptSave     : begin DoOptSave     ; Clear; end;
      cm_OptRestore  : begin DoOptRestore  ; Clear; end;
      cm_WinCloseAll : begin DoWinCloseAll ; Clear; end;
      cm_WinNew      : begin DoWinNew      ; Clear; end;
      cm_HelpAbout   : begin DoHelpAbout   ; Clear; end;
    end;
  end;
end;

procedure   T_Application.DoOptEGA;
begin SetScreenMode(ScreenMode xor smFont8x8); end;

procedure   T_Application.DoOptSave;
var Stream: TBufStream;
begin
  Stream.Init(C_SetupFile,StCreate,1024);
  Stream.Put(DeskTop);
  Stream.Done;
  if Stream.Status <> stOK then begin
    MessageBox(
      #3'Unable to save setup file'#13+
      #3+C_SetupFile+#13+
      #3+BPVStreamMsg(Stream),
      nil,mfError+mfOKButton);
  end;
end;

procedure   T_Application.DoOptRestore;
var Stream: TBufStream; dsk: PDeskTop; R: TRect;
begin
  Stream.Init(C_SetupFile,StOpenread,1024);
  dsk:= PDeskTop(Stream.Get);
  Stream.Done;
  if Stream.Status <> stOK then begin
    MessageBox(
      #3'Unable to load setup file'#13+
      #3+C_SetupFile+#13+
      #3+BPVStreamMsg(Stream),
      nil,mfError+mfOKButton);
  end
  else if ValidView(dsk) = nil then begin
    MessageBox(
      #3'Unable to load setup file'#13+
      #3+C_SetupFile+#13+
      #3'Not a valid desktop view',
      nil,mfError+mfOKButton);

  end
  else begin
    Delete(DeskTop); Dispose(DeskTop,Done);
    DeskTop:= dsk; Insert(dsk);
    GetExtent(R); R.Grow(0,-1); DeskTop^.Locate(R);
  end;
end;


procedure   T_Application.DoWinNew;
begin CreateChild; end;


procedure   T_Application.DoWinCloseAll;
begin Message(DeskTop,evBroadCast,cm_WinClose,nil); end;

procedure   T_Application.DoHelpAbout;
begin
  MessageBox(
    #3+C_Ident+#13+
    #3'Borland Pascal + Turbo Vision'#13+
    #3'(C) 1996, J.R. Ferguson',
    nil,mfInformation or mfOKButton);
end;


{ --- Main program --- }

begin
  Application:= New(P_Application,Init);
  Application^.Run;
  Dispose(Application,Done);
end.
