%pagesize 72,132

; Title		: STPLIB1
; Function	: Assembler routines for STPLIB.PAS
; Version	: 5.2
; Date		: Dec 10,1997
; Author	: J R Ferguson
; Language	: Intel 8068/8088 assembler
; Assembler	: Turbo Assembler v1.0
;
; Remarks	: segment crossing strings are not supported
;
; ==> Use TASM v1.0 (not v3.2) to assemble this module.
;     TASM v3.2 will incorrectly generate a near call to function
;     ChrLib.LexOrder in function StpLexNCmp, which will hang the
;     computer at run time. TASM v1.0 correctly generates a far call.



		.sall
		name	STPLIB1
		%trunc
		.model	TPASCAL
		locals	@@


MaxStp		=	255	;max allowed string length

;----------------------------------------------------------------------------
;		macro's
;----------------------------------------------------------------------------


LoCase		macro	reg8
		local	l1
		cmp	reg8,'A'
		jb	l1
		cmp	reg8,'Z'
		ja	l1
		add	reg8,'a'-'A'
l1:
		endm


UpCase		macro	reg8
		local	l1
		cmp	reg8,'a'
		jb	l1
		cmp	reg8,'z'
		ja	l1
		sub	reg8,'a'-'A'
l1:
		endm


IfSpace		macro	reg8,label
		local	l1
		cmp	reg8,' '
		je	label
		cmp	reg8,13
		ja	l1
		cmp	reg8,9
		jae	label
l1:
		endm


IfNoSpace	macro	reg8,label
		local	l1
		cmp	reg8,' '
		je	l1
		cmp	reg8,12
		ja	label
		cmp	reg8,9
		jb	label
l1:
		endm


%newpage
;----------------------------------------------------------------------------
		.code
;----------------------------------------------------------------------------

		extrn	LexOrder: far	;from ChrLib

%newpage
; function StpCmp(s1, s2: StpTyp): integer;
;
StpCmp		proc	far		s1:dword, s2:dword
		public	StpCmp

		les	di,s1		;return StpNCmp(s1,s2,MaxStp)
		push	es
		push	di
		les	di,s2
		push	es
		push	di
		mov	ax,MaxStp
		push	ax
		call	far ptr StpNCmp
		ret

StpCmp		endp
%newpage
; procedure StpcCat(var s: StpTyp; c: char);
;
StpcCat		proc	far		s:dword, c:byte
		public	StpcCat

		les	di,s		;es:di := s pointer
		mov	bl,es:[di]	;bl := length(s)

		inc	bl		;increment length
		jz	@@1		;exit on overflow
		mov	es:[di],bl	;store new length
		mov	al,c		;append character
		xor	bh,bh
		mov	es:[bx+di],al

@@1:		ret

StpcCat		endp
%newpage
; function StpcGet(var s: StpTyp): char;
;
StpcGet		proc	far		s:dword
		public	StpcGet

		les	di,s		;es:di := s pointer
		mov	cl,es:[di]	;cl := length(s)

		xor	al,al		;if cl = 0 return 0
		and	cl,cl
		jz	@@1

		mov	dx,ds		;save ds
		cld			;direction forward
		xor	ch,ch		;cx := byte count
		dec	byte ptr es:[di];decrement string length
		inc	di		;es:di := dst pointer
		lds	si,s		;ds:si := src pointer
		inc	si
		lodsb			;get first char
		rep	movsb		;adjust string
		mov	ds,dx		;restore ds

@@1:		ret

StpcGet		endp
%newpage
; function StpcPos(s: StpTyp; c: char): StpInd;
;
StpcPos		proc	far		s:dword, c:byte
		public	StpcPos

		les	di,s		;es:di := d pointer
		mov	al,c		;al := c
		mov	bl,es:[di]	;bx := length(s)
		xor	bh,bh
		inc	di
		mov	cx,bx
		cld			;direction forward
		repne	scasb		;scan byte
		mov	ax,0
		jne	@@1		;no match: return 0
		mov	ax,bx		;match: return position
		sub	ax,cx
@@1:		ret

StpcPos		endp
%newpage
; function StpcRet(s: StpTyp; i: StpInd): char;
;
StpcRet		proc	far		s:dword, i:byte
		public	StpcRet

		les	di,s		;es:di := d pointer
		mov	bl,i		;bl := i

		and	bl,bl		;if bl = 0 then bl := 1
		jnz	@@1
		inc	bl

@@1:		xor	al,al		;bl > length(s) then return 0
		cmp	bl,es:[di]
		ja	@@2

		xor	bh,bh		;else return character
		mov	al,es:[bx+di]

@@2:		ret

StpcRet		endp
%newpage
; function StpcRPos(s: StpTyp; c: char): StpInd;
;
StpcRPos	proc	far		s:dword, c:byte
		public	StpcRPos

		les	di,s		;es:di := d pointer
		mov	al,c		;al := c
		mov	cl,es:[di]	;cx := length(s)
		xor	ch,ch
		add	di,cx		;point to last character
		std			;direction backward
		repne	scasb		;scan byte
		jne	@@1		;if found
		inc	cx		;  correct count
@@1:		mov	ax,cx

		ret

StpcRPos	endp
%newpage
; procedure StpcUpd(var s: StpTyp; c: char; i: StpInd);
;
StpcUpd		proc	far		s:dword, c:byte, i:byte
		public	StpcUpd

		les	di,s		;es:di := d pointer
		mov	bl,i		;bl := i

		and	bl,bl		;exit if bl = 0
		jz	@@1
		cmp	bl,es:[di]	;extit if bl > length(s)
		ja	@@1

		mov	al,c
		xor	bh,bh
		mov	es:[bx+di],al	;update character

@@1:		ret

StpcUpd		endp
%newpage
; function StpcUppPos(s: StpTyp; c: char): StpInd;
;
StpcUppPos	proc	far		s: dword, c: byte
		public	StpcUppPos

		mov	dx,ds		;save ds
		lds	si,s		;ds:si := s pointer
		lodsb			;cx := length(s)
		xor	ah,ah
		mov	cx,ax
		jcxz	@@x		;return 0 if length is 0
		mov	bx,cx		;save length(s) in bx

		mov	ah,c		;ah := ToUpper(c)
		UpCase	ah

		cld			;direction forward
@@1:		lodsb			;scan byte
		UpCase	al
		cmp	ah,al
		je	@@2
		loop	@@1

		xor	ax,ax		;no match: return 0
		jmp	short @@x

@@2:		mov	ax,bx		;match: return position
		sub	ax,cx
		inc	ax

@@x:		mov	ds,dx		;restore dx
		ret

StpcUppPos	endp
%newpage
; procedure StpFill(var s: StpTyp; c: char; n: StpInd);
;
StpFill		proc	far		s:dword, c:byte, n:byte
		public	StpFill

		les	di,s		;es:di := d pointer
		mov	ah,c		;ah := c
		mov	al,n		;al := n

		mov	bl,es:[di]	;bx := length(s)
		xor	bh,bh
		mov	cl,al		;cx := byte count
		xor	ch,ch		;    = n - length(s)
		sub	cx,bx
		jle	@@1		;exit if cx <= 0

		cld			;direction forward
		stosb			;store new length
		add	di,bx		;point to end of string
		mov	al,ah
		rep	stosb		;fill

@@1:		ret

StpFill		endp
%newpage
; procedure StpGtw(var w,s: StpTyp);
;
StpGtw		proc	far		w:dword, s:dword
		public	StpGtw

		mov	dx,ds		;save ds
		lds	si,s		;ds:si := s pointer
		les	di,w		;es:di := w pointer
		mov	bx,di		;save offset w

		mov	cl,[si]		;cx := length(s)
		xor	ch,ch

		cld			;direction forward
		inc	si		;adjust s ptr to first char
		inc	di		;adjust w ptr to first char

		jcxz	@@4		;empty string: no parsing
@@1:		lodsb			;skip white space
		IfNoSpace al,@@3
		loop	@@1
		jmp	short @@4	;end of string: stop parsing

@@2:		lodsb			;copy to white space
		IfSpace al,@@4
@@3:		stosb
		loop	@@2

@@4:		dec	si		;adjust si to last char read
		dec	di		;adjust di to last char written

		mov	ax,di		;set w length
		sub	ax,bx
		mov	es:[bx],al

		les	di,s		;delete white space + word from s
		mov	al,cl		;  set new length s
		stosb
		rep	movsb		;  move remaining chars to front

		mov	ds,dx		;restore ds
		ret

StpGtw		endp
%newpage
; function StpLexCmp(s1, s2: StpTyp): integer;
;
StpLexCmp	proc	far		s1:dword, s2:dword
		public	StpLexCmp

		les	di,s1		;return StpLexNCmp(s1,s2,MaxStp)
		push	es
		push	di
		les	di,s2
		push	es
		push	di
		mov	ax,MaxStp
		push	ax
		call	far ptr StpLexNCmp

		ret

StpLexCmp	endp
%newpage
; function StpLexNCmp(s1, s2: StpTyp; n: StpInd): integer;
;
StpLexNCmp	proc	far		s1:dword, s2:dword, n:byte
		public	StpLexNCmp

		push	ds		;save ds
		lds	si,s1		;ds:si := s1 pointer
		les	di,s2		;es:di := s2 pointer
		mov	ch,n		;ch := n

		mov	dl,[si]		;dl := minimun(n,length(s1))
		cmp	dl,ch
		jbe	@@1
		mov	dl,ch
@@1:		mov	dh,es:[di]	;dh := minimun(n,length(s2))
		cmp	dh,ch
		jbe	@@2
		mov	dh,ch
@@2:		mov	cl,dl		;cx := minimun (dl,dh)
		cmp	cl,dh
		jbe	@@3
		mov	cl,dh
@@3:		xor	ch,ch
		jcxz	@@5		;cx = 0 : compare lengths

@@4:		inc	si		;get characters
		inc	di
		mov	al,[si]
		mov	bl,es:[di]
		and	al,7fh		;strip parity
		and	bl,7fh
		UpCase	al		;compare uppercase values
		UpCase	bl
		cmp	al,bl		;equal ?
		jnz	@@6		;  no : lexorder compare these chars
		loop	@@4		;  yes: compare next characters

@@5:		mov	al,dl		;all equal: compare string lengths
		sub	al,dh
		pop	ds		;restore ds
		cbw			;return sign extended result
		ret

@@6:		pop	ds		;restore ds
		push	ax		;return LexOrder(al,bl)
		push	bx
		call	far ptr LexOrder

		ret

StpLexNCmp	endp
%newpage
; procedure StpLow(var s: StpTyp);
;
StpLow		proc	far		s:dword
		public	StpLow

		mov	dx,ds		;save ds
		lds	si,s		;ds:si := s pointer

		mov	cl,[si]		;cx:= length(s)
		xor	ch,ch
		jcxz	@@3

@@1:		inc	si
		mov	al,[si]
		cmp	al,'A'
		jb	@@2
		cmp	al,'Z'
		ja	@@2
		add	byte ptr [si],'a'-'A'
@@2:		loop	@@1

@@3:		mov	ds,dx		;restore ds
		ret

StpLow		endp
%newpage
; procedure StpNCat(var dst: StpTyp; src: StpTyp; n: StpInd);
;
StpNCat		proc	far		dst:dword, src:dword, n:byte
		public	StpNCat

		mov	dx,ds		;save ds
		lds	si,src		;ds:si := src pointer
		les	di,dst		;es:si := dst pointer
		mov	ch,n		;ch := n

		mov	bl,es:[di]	;bx := length(dst)
		xor	bh,bh

		mov	cl,[si]		;cx := minimum(n,length(src))
		cmp	cl,ch
		jbe	@@1
		mov	cl,ch
@@1:		xor	ch,ch

		mov	ax,bx		;ax := new length(dst)
		add	ax,cx		;    = minimum(cx,MaxStp)
		cmp	ax,MaxStp
		jbe	@@2
		mov	ax,MaxStp

@@2:		mov	cx,ax		;cx := byte move count
		sub	cx,bx		;    = new length(dst) - old length(dst)

		cld			;direction forward
		stosb			;store new length(dst)
		add	di,bx		;move es:di to end of dst
		inc	si		;move ds:si to start of src
		rep	movsb		;concatenate strings

		mov	ds,dx		;restore ds
		ret

StpNCat		endp
%newpage
; function StpNCmp(s1, s2: StpTyp; n: StpInd): integer;
;
StpNCmp		proc	far		s1:dword, s2:dword, n:byte
		public	StpNCmp

		push	ds		;save ds
		lds	si,s1		;ds:si := s1 pointer
		les	di,s2		;es:di := s2 pointer
		mov	ch,n		;ch := n

		mov	dl,[si]		;dl := minimum(n,length(s1))
		cmp	dl,ch
		jbe	@@1
		mov	dl,ch
@@1:		mov	dh,es:[di]	;dh := minimum(n,length(s2))
		cmp	dh,ch
		jbe	@@2
		mov	dh,ch
@@2:		mov	cl,dl		;cx := minimum(dl,dh)
		cmp	cl,dh
		jbe	@@3
		mov	cl,dh
@@3:		xor	ch,ch
		jcxz	@@5		;cx = 0 : compare lengths

@@4:		inc	si		;adjust pointers
		inc	di
		repe	cmpsb		;compare strings
		mov	ax,-1		;return -1 if s1 < s2
		jb	@@6
		mov	ax,1		;return +1 if s1 > s2
		ja	@@6

@@5:		mov	al,dl		;compare string lengths if equal
		sub	al,dh
		cbw			;sign extend result

@@6:		pop	ds			;restore ds
		ret

StpNCmp		endp
%newpage
; procedure StpRAS(var s: StpTyp);
;
StpRAS		proc	far		s:dword
		public	StpRAS

                les	di,s		;es:di := s pointer

		mov	cl,es:[di]	;cx := length(s)
		xor	ch,ch
		jcxz	@@3		;cx = 0 : do nothing

		mov	dx,ds		;save ds
		lds	si,s		;ds:si := s pointer
		xor	bh,bh		;bh := 0 (new length(s))
@@1:		inc	si		;get char bl := [++si]
		mov	bl,[si]
		IfSpace	bl,@@2		;if not IsSpace(bl)
		inc	bh		;  ++bh
		inc	di		;  [++di] := bl
		mov	es:[di],bl
@@2:		loop	@@1		;next char

		les	di,s		;store new length(s)
		mov	es:[di],bh
		mov	ds,dx		;restore ds


@@3:		ret

StpRAS		endp
%newpage
; procedure StpRev(var s: StpTyp);
;
StpRev		proc	far		s: dword
		public	StpRev

		les	di,s		;es:di := s pointer
		mov	al,es:[di]	;ax := length(s)
		xor	ah,ah
		mov	cx,ax		;cx := byte count
		shr	cx,1		;    = length(s) div 2
		jcxz	@@2		;cx = 0 : do nothing

		mov	dx,ds		;save ds

		add	di,ax		;es:di := ptr to last char
		lds	si,s		;ds:si := ptr to first char
		inc	si
@@1:		mov	al,[si]		;exchange first, last char
		mov	ah,es:[di]
		mov	[si],ah
		mov	es:[di],al
		inc	si		;adjust pointers
		dec	di
		loop	@@1		;if --count > 0 then next char

		mov	ds,dx		;restore ds

@@2:		ret

StpRev		endp
%newpage
; procedure StpRLS(var s: StpTyp);
;
StpRLS		proc	far		s:dword
		public	StpRLS

		les	di,s		;es:di := s pointer

		mov	cl,es:[di]	;cx := length(s)
		xor	ch,ch
		jcxz	@@3		;cx = 0 : do nothing

		mov	dx,ds		;save ds
		lds	si,s		;ds:si := s pointer
		inc	si		;set at first character
		cld			;direction forward

@@1:		lodsb			;get char
		IfNoSpace al,@@2	;if not IsSpace then exit loop
		loop	@@1		;else next char

@@2:		dec 	si		;backup one char
		mov	al,cl		;store new length
		stosb
		rep	movsb		;left adjust string s

		mov	ds,dx		;restore ds

@@3:		ret

StpRLS		endp
%newpage
; function StpRPos(src, pat: StpTyp): StpInd;
;
StpRPos		proc	far		src:dword, pat:dword
		public	StpRPos

		push	ds		;save ds
		lds	si,pat		;ds:si := pat pointer
		les	di,src		;es:di := src pointer

		xor	ax,ax		;assume result = 0
		mov	dl,[si]		;dl := length(pat)
		and	dl,dl		;exit if dl = 0
		jz	@@x
		mov	bl,es:[di]	;bl := length(src)
		and	bl,bl		;exit if bl = 0
		jz	@@x
		sub	bl,dl		;bl := length(src) - lengt(pat)
		jb	@@x		;exit if bl < 0

		xor	bh,bh		;expand bl to bx
		xor	dh,dh		;expand dl to dx
		inc	si		;position pat ptr
		inc	di		;position src ptr
		add	di,bx
		cld			;direction forward
@@1:		push	si
		push	di
		mov	cx,dx
		repe	cmpsb
		pop	di
		pop	si
		je	@@2
		dec	di		;backup src ptr
		dec	bx
		jns	@@1

@@2:		inc	bx
		mov	ax,bx

@@x:		pop	ds		;restore ds
		ret

StpRPos		endp
%newpage
; procedure StpRTS(var s: StpTyp);
;
StpRTS		proc	far		s:dword
		public	StpRTS

		les	di,s		;es:di := s pointer

		mov	cl,es:[di]	;cx := length(s)
		xor	ch,ch
		jcxz	@@3		;cx = 0 : do nothing

		add	di,cx		;es:di := ptr to last char of s
@@1:		mov	al,es:[di]	;get char
		dec	di
		IfNoSpace al,@@2	; if not IsSpace then exit loop
		loop	@@1		;else next char

@@2:		les	di,s		;es:di := s pointer
		mov	es:[di],cl	;store new length(s)

@@3:		ret

StpRTS		endp
%newpage
%newpage
; procedure StpStzCpy(var dst: StpTyp; const src: StzPtr);
;
StpStzCpy	proc	far		dst:dword, src:dword
		public	StpStzCpy

		mov	dx,ds		;save ds
		cld			;direction forward

		xor	cx,cx		;assume strlen(src) = 0
		les	di,src		;es:di := src pointer
		and	di,di		;check if src=nil
		jnz	@@1
		mov	ax,es
		and	ax,ax
		jz	@@2

@@1:		mov	cx,MaxStp
		xor	al,al
		repne	scasb
		sub	cx,MaxStp
		not	cx

@@2:		lds	si,src		;ds:si := src pointer
		les	di,dst		;es:di := dst pointer
		mov	al,cl		;set length byte of dst
		stosb
		rep	movsb		;copy contents

		mov	ds,dx		;restore ds
		ret

StpStzCpy	endp
%newpage
; procedure StpSub(var dst: StpTyp; src: StpTyp; i,n: StpInd);
;
StpSub		proc	far		dst:dword, src:dword, i:byte, n:byte
		public	StpSub

		mov	dx,ds		;save ds
		lds	si,src		;ds:si := src pointer
		les	di,dst		;es:di := dst pointer

		mov	al,i		;ax := i
		xor 	ah,ah
		and	ax,ax		;if ax = 0 then ax := 1
		jnz	@@1
		inc	ax

@@1:		mov	bl,[si]		;bx := lengt(src) + 1 - ax
		xor	bh,bh
		inc	bx
		sub	bx,ax
		jge	@@2		;if bx < 0 then bx := 0
		xor	bx,bx

@@2:		mov	cl,n		;cx := byte count
		xor	ch,ch		;    = minimum(n,bx)
		cmp	cx,bx
		jbe	@@3
		mov	cx,bx

@@3:		add	si,ax		;adjust src pointer
		cld			;direction forward
		mov	al,cl		;store dst length
		stosb
		rep	movsb		;copy substring

		mov	ds,dx		;restore ds
		ret

StpSub		endp
%newpage
; procedure StpUpp(var s: StpTyp);
;
StpUpp		proc	far		s:dword
		public	StpUpp

		mov	dx,ds		;save ds
		lds	si,s		;ds:si := s pointer

		mov	cl,[si]		;cx := length(s)
		xor	ch,ch
		jcxz	@@3		;if cx = 0 : do nothing]

@@1:		inc	si
		mov	al,[si]
		cmp	al,'a'
		jb	@@2
		cmp	al,'z'
		ja	@@2
		sub	byte ptr [si],'a'-'A'
@@2:		loop	@@1

@@3:		mov	ds,dx		;restore ds
		ret

StpUpp		endp
%newpage
; function StpUppCmp(s1, s2: StpTyp): integer;
;
StpUppCmp	proc	far		s1:dword, s2:dword
		public	StpUppCmp

		les	di,s1		;return StpUppNCmp(s1,s2,MaxStp)
		push	es
		push	di
		les	di,s2
		push	es
		push	di
		mov	ax,MaxStp
		push	ax
		call	far ptr StpUppNCmp

		ret

StpUppCmp	endp
%newpage
; function StpUppNCmp(s1, s2: StpTyp; n: StpInd): integer;
;
StpUppNCmp	proc	far		s1:dword, s2:dword, n:byte
		public	StpUppNCmp

		push	ds		;save ds
		lds	si,s1		;ds:si := s1 pointer
		les	di,s2		;es:di := s2 pointer
		mov	ch,n		;ch := n

		mov	dl,[si]		;dl := minimum(n,length(s1))
		cmp	dl,ch
		jbe	@@1
		mov	dl,ch
@@1:		mov	dh,es:[di]	;dh := minimum(n,length(s2))
		cmp	dh,ch
		jbe	@@2
		mov	dh,ch
@@2:		mov	cl,dl		;cx := minimum(dl,dh)
		cmp	cl,dh
		jbe	@@3
		mov	cl,dh
@@3:		xor	ch,ch
		jcxz	@@5		;cx = 0 : compare lengths

@@4:		inc	si		;get characters
		inc	di
		mov	al,[si]
		mov	bl,es:[di]
		UpCase	al		;subtract upcase values
		UpCase	bl
		sub	al,bl
		jnz	@@6		;not equal: return difference
		loop	@@4		;equal    : compare next character

@@5:		mov	al,dl		;all equal: compare lengths
		sub	al,dh

@@6:		pop	ds		;restore ds
		cbw			;return sign extended result
		ret

StpUppNCmp	endp

code		ends
		end
