{ DBGLIB.PAS : Pascal debug routine library

  Titile  : DBGLIB
  Version : 4.0
  Date    : Nov 09,1996
  Language: Borland Pascal 7.0 (all targets)
  Author  : J.R. Ferguson
  Usage   : Unit
}

UNIT DbgLib;

INTERFACE
uses DefLib, ConLib;

const DbgDebugMode : boolean = false;

procedure DbgAskDebug;
{ Execute this procedure at the start of your program. It will ask
  'Debug? (Y/N) : ' and by answering Y(es) or N(o) the global boolean
  variable DbgDebugMode is set accordingly. }

procedure DbgTrace(msg: StpTyp);
{ This routine displays the string msg, but only if DbgDebugMode is true. }

IMPLEMENTATION

procedure DbgAskDebug;
begin DbgDebugMode:= YesNo('Debug') end;

procedure DbgTrace(msg: StpTyp);
begin if DbgDebugMode then begin writeln; write('/',msg,'/ ') end end;

END.
