
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994 Stefan Milius                }
{                                                       }
{*******************************************************}

{ Portions Copyright (c) 1992 Borland International }

{
  GVVIEWS.TXT GVVIEWS.DOC GINFO.TXT GINFO.DOC NEW.TXT GV.VER
}


Unit GVViews;

{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-}

interface

{$ifdef Windows}
uses Wintypes, Objects, Drivers, Views, WinProcs, WinGr;
{$else}
uses Objects, Drivers, Views, Memory;
{$endif}

Const

{ Color Palettes }

  CFrame         = #1#2#3#4#5#6#7#8#9#10#11#12#13;
  CScrollBar     = #14#15#16#17#18;
  CScroller      = #19#20#21#22;
  CListViewer    = #134#135#136#137#138#139;
  CScrollbarBack = #18;

  CWhiteWindow   = #10#11#12#13#14#15#16#17#18#19#20#21#22#23#24#25#26#27#28+
		   #29#30#31;
  CGrayWindow    = #32#33#34#35#36#37#38#39#40#41#42#43#44#45#46#47#48#49#50+
		   #51#52#53;
  CCyanWindow    = #54#55#56#57#58#59#60#61#62#63#64#65#66#67#68#69#70#71#72+
		   #73#74#75;

{ TView State masks }

  sfVisible     = $0001;    sfCursorVis   = $0002;    sfCursorIns   = $0004;
  sfRoot	= $0008;    sfActive      = $0010;    sfSelected    = $0020;
  sfFocused     = $0040;    sfDragging    = $0080;    sfDisabled    = $0100;
  sfModal       = $0200;    sfDefault     = $0400;    sfExposed     = $0800;
  sfFirstPass   = $4000;    sfTransparent = $8000;

{ TView Option masks }

  ofSelectable  = $0001;    ofTopSelect   = $0002;    ofFirstClick  = $0004;
  ofStoreBack   = $0008;    ofPreProcess  = $0010;    ofPostProcess = $0020;
  ofBuffer      = $0040;    ofTileable    = $0080;    ofCenterX     = $0100;
  ofCenterY     = $0200;    ofCentered    = $0300;    ofValidate    = $0400;
  ofMetaFile    = $0800;    ofHoldFirst   = $1000;    ofBufferOne   = $2000;
  ofFirstPass   = $4000;

{ TView GrowMode masks }

  gfGrowLoX     = $01;      gfGrowLoY     = $02;      gfGrowHiX    = $04;
  gfGrowHiY     = $08;      gfGrowAll     = $0F;      gfGrowRel    = $10;
  gfRedrawX     = $20;      gfRedrawY     = $40;      gfAlign      = $80;

{ Standard command codes }

  cmValid   = 0;            cmQuit    = 1;            cmError   = 2;
  cmMenu    = 3;            cmClose   = 4;            cmZoom    = 5;
  cmResize  = 6;            cmNext    = 7;            cmPrev    = 8;
  cmHelp    = 9;

{ TDialog standard commands }

  cmOK      = 10;           cmCancel  = 11;           cmYes     = 12;
  cmNo      = 13;           cmDefault = 14;

{ TButton message commands }

  cmGrabDefault = 15;       cmReleaseDefault = 16;

{ TWindow message commands }

  cmHeyYou = 40;
  cmSelectWindowNum = 55;

{ Help contexts }

  hcNoContext = 0;
  hcDragging = 1000;
  hc = 1000;

{ Standard messages }

  cmReceivedFocus     = 50;
  cmReleasedFocus     = 51;
  cmCommandSetChanged = 52;

{ ListViewer flags }

  lfPartialLines   = $00001;

{ Event class }

  evPositionalCtx = $800;

{ StandardScrollbar flags }

  sbHorizontal     = $0001;
  sbVertical       = $0002;
  sbHandleKeyBoard = $0004;
  sbDoScrolling    = $0008;

{ ScrollBar flags }

  sbLeftArrow  = 0;  sbRightArrow = 1;  sbPageLeft   = 2;  sbPageRight  = 3;
  sbUpArrow    = 4;  sbDownArrow  = 5;  sbPageUp     = 6;  sbPageDown   = 7;
  sbIndicator  = 8;

{ TWindow Flags masks }

  wfMove       = $01;
  wfGrow       = $02;
  wfClose      = $04;
  wfZoom       = $08;
  wfShowNumber = $10;
  wfBackground = $20;
  wfShowTitle  = $40;
  wfModal      = $80;
  wfHideClose  = $100;

{ TWindow number constants }

  wnNoNumber    =  0;
  wnJustANumber = 10;

{ TWindow palette entries }

  wpWhiteWindow = 0;
  wpGrayWindow  = 1;
  wpCyanWindow  = 2;

{ ResMode values }

  rmDnRi  = 1;  rmUpRi  = 2;  rmDnLe  = 3;  rmUpLe  = 4;  rmLeft  = 5;
  rmRight = 6;  rmUp    = 7;  rmDown  = 8;

{ Minimal window size }

  GMinWinSize : TPoint = (X: 170; Y: 100);

{ Window field size }

  IconSize = 20;

{ Window dragging add constant }

  WinDragAdd = 5;

{ Window commands to enable/disable }

  WindowCmds: TCommandSet = [cmNext, cmPrev, cmTile, cmCascade];

{ Maximum view size for FirstPass draw in square pixels
  (size calcule of TGView.CalcFirstPass)
}
  FirstPassMaximum: LongInt = 10000;

Type

  PVRect = pointer;

  PGGroup = ^TGGroup;
  PGView = ^TGView;

  TGView = Object (TView)
    GOwner:PGGroup;
    GNext:PGView;
    CursorSize: TPoint;
    CursorFlag: Boolean;
    CursorLock: ShortInt;
    ViewLock: Integer;
  {$ifdef Windows}
    Wnd: TWinHandle;
  {$endif Windows}
    constructor Init (var Bounds: TRect);
    constructor Load (var S: TStream);
    destructor Done; virtual;
    procedure CalcBounds(var Bounds: TRect; Delta: TPoint); virtual;
    procedure CalcFirstPass; virtual;
    procedure ChangeBounds (var R: TRect); virtual;
    procedure ChMCursor; virtual;
    function CreateDragView: PGView; virtual;
    procedure DeleteRectList(var RectList: PVRect);
    procedure DragView(Event: TEvent; Mode: Byte; var Limits: TRect;
       MinSize, MaxSize: TPoint; ResMode: Byte);
    procedure Draw; virtual;
    procedure DrawCursor;
    procedure DrawRectList(var RectList: PVRect);
    procedure DrawView;
    procedure DrawClipped(Clip: PVRect; VisOwner: PGView); virtual;
    procedure DrawVisible; virtual;
    procedure DrawVisibleLocal(Local: pointer);
    procedure EndModal(Command: Word); virtual;
    function Exposed: Boolean;
    function Focus: Boolean;
    procedure FreeBack; virtual;
    function GetColor(Color: Word):Word;
    function GetHelpCtx: Word; virtual;
    procedure GetPeerViewPtr(var S: TStream; var P);
    procedure GetVisibleRect(var RectList: PVRect);
    procedure GetInVisibleRect(var RectList: PVRect);
    function GetVisibility: PVRect;
    function GetStandardFont: Word; virtual;
    procedure GrowTo(X, Y: Integer);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure HideCursor;
    procedure HideDrawClipped(Clip: PVRect; VisOwner: PGView); virtual;
    {procedure KeyEvent (var Event: TEvent);}
    procedure Locate (var Bounds: TRect); virtual;
    procedure MakeFirst;
  {$ifdef Windows}
    procedure MakeGlobal(Source: TPoint; var Dest: TPoint);
    procedure MakeLocal(Source: TPoint; var Dest: TPoint);
  {$endif Windows}
    function MouseEvent(var Event: TEvent; Mask: Word): Boolean;
    procedure MoveTo(X, Y: Integer);
    function NextView: PGView;
    function Prev: PGView;
    function PrevView: PGView;
    procedure PutInFrontOf(Target: PGView); virtual;
    procedure PutPeerViewPtr(var S: TStream; P: PGView);
    procedure SetViewPort; virtual;
    procedure RestoreBackground; virtual;
    procedure RestoreViewPort; virtual;
    procedure Select;
    procedure SetCursor(X, Y: Integer);
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    function SetSubRect(var SubRect: TRect): Boolean;
    procedure ShowCursor;
    procedure ShowDrawClipped(Clip: PVRect; VisOwner: PGView); virtual;
    procedure Store(var S: TStream);
    procedure StoreBack; virtual;
    function TopView: PGView;
  private
    Vis: PVRect;
    Back: pointer;
    procedure CopyDrawView(Source: PVRect; var Bounds: TRect; Delta: TPoint);
  {$ifdef Windows}
    procedure CreateWin;
    procedure DestroyWin;
  {$endif Windows}
    function GetOwnerClippedBounds(var Bounds: TRect): Boolean;
    procedure SubtractInvisible(var AVis: PVRect; VisOwner: PGView;
      SubTrans: Boolean);
  End;

{ TFrame object }

  { Palette layout }
  { 1  = Selected frame }
  { 2  = Normal frame }
  { 3  = Modal frame }
  { 4  = Zoomfield }
  { 5  = Normal background }
  { 6  = Selected background }
  { 7  = Normal title }
  { 8  = Selected title }
  { 9  = Close-/Zoomfield outside }
  { 10 = Closefield frame }
  { 11 = Closefield inside }
  { 12 = Closefield shadow }

  PFrame = ^TFrame;
  TFrame = Object (TGView)
    TitleSize:Integer;
    constructor Init (var Bounds:TRect);
    constructor Load (var S: TStream);
    procedure Store (var S: TStream);
    procedure CalcFirstPass; virtual;
    procedure ChMCursor; virtual;
    function GetPalette:PPalette; virtual;
    procedure Draw; virtual;
    procedure DrawZoomField (Down: Boolean); virtual;
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure SetState (AState: Word; Enable: Boolean); virtual;
    function Valid (Command: Word): Boolean; virtual;
  private
    OldC: Integer;
    function Zoomed: Boolean;
  End;

{ TBackGround object }

  PBackGround = ^TBackGround;
  TBackGround = Object (TGView)
    constructor Init (var Bounds:TRect);
    constructor Load (var S: TStream);
    procedure Store (var S: TStream);
    procedure Draw; virtual;
  End;

{ TScrollbarBack object }

  PScrollBarBack = ^TScrollBarBack;
  TScrollBarBack = object(TBackground)
    function GetPalette: PPalette; virtual;
  end;

{ TScrollBar object }

  { Palette layout }
  { 1 = Background }
  { 2 = Frame }
  { 3 = Buttons }
  { 4 = Button shadows }
  { 5 = Page area }

  PScrollBar = ^TScrollBar;
  TScrollBar = object(TGView)
    ButtonSize: Byte;
    Flags: Byte;
    Value: Integer;
    Min: Integer;
    Max: Integer;
    PgStep: Integer;
    ArStep: Integer;
    constructor Init(var Bounds: TRect);
    constructor Load(var S: TStream);
     { procedure ChangeBounds (var Bounds: TRect); virtual; }
    procedure Draw; virtual;
    procedure DrawUpButton (Down: Boolean); virtual;
    procedure DrawDnButton (Down: Boolean); virtual;
    procedure DrawIndicator (V: Integer; Down: Boolean); virtual;
    function GetPalette: PPalette; virtual;
    function GetPosition (V: Integer): Integer; virtual;
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure RestoreIndicator (OldV: Integer); virtual;
    procedure ScrollDraw; virtual;
    function ScrollStep (Part: Integer): Integer; virtual;
    procedure SetParams (AValue, AMin, AMax, APgStep, AArStep: Integer);
    procedure SetRange (AMin, AMax: Integer);
    procedure SetState (AState: Word; Enable: Boolean); virtual;
    procedure SetStep (APgStep, AArStep: Integer);
    procedure SetValue (AValue: Integer);
    procedure Store (var S: TStream);
  end;

{ TScroller object }

  { Palette Layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal background }
  { 4 = Selected background }

  PScroller = ^TScroller;
  TScroller = object(TGView)
    HScrollBar: PScrollBar;
    VScrollBar: PScrollBar;
    Delta: TPoint;
    Limit: TPoint;
    TextSize: TPoint;
    constructor Init(var Bounds: TRect; AHScrollBar, AVScrollBar: PScrollBar);
    constructor Load(var S: TStream);
    procedure ChangeBounds(var Bounds: TRect); virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure ScrollDraw; virtual;
    procedure ScrollTo(X, Y: Integer);
    procedure SetLimit(X, Y: Integer);
    function ShownRows: Integer;
    function ShownCols: Integer;
    procedure Store(var S: TStream);
  private
    ScrollLock: Byte;
  end;

{ TListViewer object }

  { Palette layout }
  { 1 = Background }
  { 2 = Frame }
  { 3 = Normal Text }
  { 4 = Selected Text }
  { 5 = Normal Background }
  { 6 = Selected Background }

  PListViewer = ^TListViewer;
  TListViewer = object(TGView)
    ScrollBar: PScrollBar;
    TopItem: Integer;
    Focused: Integer;
    Range: Integer;
    Flags: Word;
    constructor Init(var Bounds: TRect; AScrollBar: PScrollBar);
    constructor Load(var S: TStream);
    procedure ChangeBounds(var Bounds: TRect); virtual;
    procedure Draw; virtual;
    procedure DrawItem (Item: Integer); virtual;
    procedure DrawItemText(Item: Integer; R: TRect); virtual;
    procedure FocusItem(Item: Integer); virtual;
    procedure GetItemRect(Item: Integer; var R: TRect); virtual;
    procedure GetItemSubRect(var R: TRect); virtual;
    function GetPageSize: Integer; virtual;
    function GetPalette: PPalette; virtual;
    function GetText(Item: Integer; MaxLen: Integer): String; virtual;
    function IsSelected(Item: Integer): Boolean; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure SelectItem(Item: Integer); virtual;
    procedure SetRange(ARange: Integer);
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    procedure Store(var S: TStream);
  end;

{ TDragRect object }

  PDragRect = ^TDragRect;
  TDragRect = object(TGView)
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
    procedure HideDrawClipped(Clip: PVRect; VisOwner: PGView); virtual;
    procedure Locate(var Bounds: TRect); virtual;
  end;

{ TPeerList record }

  PPeerList = ^TPeerList;
  TPeerList = record
    Number: Integer;
    Master: ^PGView;
    Next: PPeerList
  End;

{ TGGroup object }

  TGGroup = object(TGView)
    Last: PGView;
    Current: PGView;
    Phase: (phFocused, phPreProcess, phPostProcess);
    StandardFont: Word;
    EndState: Word;
    constructor Init(var Bounds: TRect);
    constructor Load (var S: TStream);
    destructor Done; virtual;
    procedure Awaken; virtual;
    procedure CalcFirstPass; virtual;
    procedure ChangeBounds(var Bounds: TRect); virtual;
    procedure ChMCursor; virtual;
    procedure DrawClipped(Clip: PVRect; VisOwner: PGView); virtual;
    procedure DrawVisible; virtual;
    function DataSize: Word; virtual;
    procedure Delete(P: PGView);
    procedure Draw; virtual;
    procedure EndModal(Command: Word); virtual;
    procedure EventError(var Event: TEvent); virtual;
    function ExecView(P: PGView): Word;
    function Execute: Word; virtual;
    function First: PGView;
    function FirstThat (Test: Pointer): PGView;
    function FocusNext(Forwards: Boolean): Boolean;
    procedure ForEach (Action: Pointer);
    procedure GetData(var Rec); virtual;
    function GetHelpCtx: Word; virtual;
    procedure GetSubViewPtr (var S: TStream; var P);
    procedure HandleEvent(var Event: TEvent); virtual;
    function Insert(P: PGView): pointer;
    function InsertBefore(P, Target: PGView): pointer;
    procedure Lock;
    procedure PutSubViewPtr (var S: TStream; P: PGView);
    procedure Redraw;
    procedure SelectNext(Forwards: Boolean);
    procedure SetData(var Rec); virtual;
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    procedure Store (var S: TStream);
    procedure UnLock;
    function Valid(Command: Word): Boolean; virtual;
  private
    LockFlag: Byte;
    function At(Index: Integer): PGView;
    function FirstMatch(AState: Word; AOptions: Word): PGView;
    function FindNext(Forwards: Boolean): PGView;
    function IndexOf(P: PGView): Integer;
    procedure InsertView(P, Target: PGView);
    procedure RemoveView(P: PGView);
    procedure ResetCurrent;
    procedure SetCurrent(P: PGView; Mode: SelectMode);
  end;

{ TWindow object }

  { Palette layout }
  { 1  = Background }
  { 2  = Frame active }
  { 3  = Frame not active }
  { 4  = Frame modal }
  { 5  = Zoomfield }
  { 6  = Title background normal}
  { 7  = Title background selected }
  { 8  = Title normal}
  { 9  = Title selected }
  { 10 = Close- and Zoomfield outside }
  { 11 = Closefield frame }
  { 12 = Closefield inside }
  { 13 = Closefield shadow }
  { 14 = Scrollbar background }
  { 15 = Scrollbar frame }
  { 16 = Scrollbar buttons }
  { 17 = Scrollbar button shadows }
  { 18 = Scrollbar page area }
  { 19 = Scroller normal text }
  { 20 = Scroller selected text }
  { 21 = Scroller normal background }
  { 22 = Scroller selected background }

  PWindow = ^TWindow;
  TWindow = Object (TGGroup)
    Flags: Word;
    ZoomRect: TRect;
    Number: Integer;
    Palette: Integer;
    Frame: PFrame;
    Title: PString;
    ScrBBck: PBackground;
    constructor Init(var Bounds: TRect; ATitle: TTitleStr; ANumber: Integer);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    procedure Close; virtual;
    procedure GetClientRect(var R: TRect); virtual;
    function GetPalette: PPalette; virtual;
    function GetTitle(MaxSize: Integer): TTitleStr; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitFrame; virtual;
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    procedure SizeLimits(var Min, Max: TPoint); virtual;
    function StandardScrollBar(AOptions: Word): PScrollBar;
    procedure Store(var S: TStream);
    function Valid(Command: Word): Boolean; virtual;
    procedure Zoom; virtual;
  private
    function AmLastWindow: Boolean;
  End;

{ the drag view
}
const
  TheDragView: PGView = nil;
  TheDraggedView: PGView = nil;

{ GVViews registration procedure }

  procedure RegisterGVViews;

{ Stream registration records }

const

  RGView: TStreamRec = (
    ObjType: 102;
    VmtLink: Ofs(TypeOf(TGView)^);
    Load: @TGView.Load;
    Store: @TGView.Store);

  RFrame: TStreamRec = (
    ObjType: 103;
    VmtLink: Ofs(TypeOf(TFrame)^);
    Load: @TFrame.Load;
    Store: @TFrame.Store);

  RBackground: TStreamRec = (
    ObjType: 104;
    VmtLink: Ofs(TypeOf(TBackground)^);
    Load: @TBackground.Load;
    Store: @TBackground.Store);

  RScrollBar: TStreamRec = (
    ObjType: 105;
    VmtLink: Ofs(TypeOf(TScrollBar)^);
    Load: @TScrollBar.Load;
    Store: @TScrollBar.Store);

  RScroller: TStreamRec = (
    ObjType: 106;
    VmtLink: Ofs(TypeOf(TScroller)^);
    Load: @TScroller.Load;
    Store: @TScroller.Store);

  RListViewer: TStreamRec = (
    ObjType: 107;
    VmtLink: Ofs(TypeOf(TListViewer)^);
    Load: @TListViewer.Load;
    Store: @TListViewer.Store);

  RGGroup: TStreamRec = (
    ObjType: 108;
    VmtLink: Ofs(TypeOf(TGGroup)^);
    Load: @TGGroup.Load;
    Store: @TGGroup.Store);

  RWindow: TStreamRec = (
    ObjType: 109;
    VmtLink: Ofs(TypeOf(TWindow)^);
    Load: @TWindow.Load;
    Store: @TWindow.Store);

implementation

{$ifdef Windows}
uses ExtGraph, VgaMem, GVisible, GvWinNum;
{$else}
uses Crt, Gr, MetaGr, ExtGraph, MyMouse, MyFonts, GVDriver, VGAMem,
     GVisible, GVWinNum, WinRes;
{$endif}

type

  PFixupList = ^TFixupList;
  TFixupList = array[1..4096] of Pointer;

const

  OwnerGroup: PGGroup = nil;
  FixupList: PFixupList = nil;
  TheTopView: PGView = nil;

{ maximal Count for TVRect }

  maxRect = 10;

{ Help functions }

function Min (x, y: Integer): Integer; Assembler;
Asm
	MOV	AX, X
        CMP	AX, Y
        JLE	@@1
        MOV	AX, Y
@@1:
End;

function Max (x, y: Integer): Integer; Assembler;
Asm
	MOV	AX, X
        CMP 	AX, Y
        JGE	@@1
        MOV	AX, Y
@@1:
End;

function Ranges (x, Lx, Hx: Integer): Boolean; Assembler;
Asm
	MOV	AX, X
	CMP	AX, Lx
        JL	@@1
        CMP	AX, Hx
        JG	@@1
        MOV	AX, 1
        JMP	@@2
@@1:	XOR	AX, AX
@@2:
End;

(************************** TGView object ***********************************)

constructor TGView.Init;
Begin
  TView.Init (Bounds);
  EventMask := EventMask or (evTimer + evPositionalCtx);
  GNext := nil;
  GOwner := nil;
  Options := Options or (ofBuffer + ofMetafile + ofFirstPass);
  CursorLock := 2;
End;

constructor TGView.Load;
Begin
  TView.Load (S);
  S.Read (CursorSize, SizeOf (CursorSize));
  S.Read (CursorLock, SizeOf (CursorLock));
  GOwner:=nil;
  GNext:=nil;
{   CursorLock := 2; }
End;

destructor TGView.Done;
Begin
  Hide;
  If GOwner <> nil then GOwner^.Delete(@Self);
End;

procedure TGView.CalcFirstPass;
begin
  SetState(sfFirstPass,
    (State and sfTransparent = 0) and
    (Options and GlobalOptions and ofFirstPass <> 0) and
    (LongMul(Size.X, Size.Y) < FirstPassMaximum))
end;

procedure TGView.CalcBounds(var Bounds: TRect; Delta: TPoint);
var S, D: Integer;
    Min, Max: TPoint;

 procedure Grow(var I: Integer);
 Begin
   if GrowMode and gfGrowRel = 0 then Inc(I, D) else
     I := LongDiv((LongMul(I, S) + (S - D) shr 1), (S - D));
 End;

 function Range(Val, Min, Max: Integer): Integer;
 Begin
   if Val < Min then Range := Min else
     if Val > Max then Range := Max else
       Range := Val;
 End;

Begin
  GetBounds(Bounds);
  S := GOwner^.Size.X;
  D := Delta.X;
  if GrowMode and gfGrowLoX <> 0 then Grow(Bounds.A.X);
  if GrowMode and gfGrowHiX <> 0 then Grow(Bounds.B.X);
  S := GOwner^.Size.Y;
  D := Delta.Y;
  if GrowMode and gfGrowLoY <> 0 then Grow(Bounds.A.Y);
  if GrowMode and gfGrowHiY <> 0 then Grow(Bounds.B.Y);
  SizeLimits(Min, Max);
  Bounds.B.X := Bounds.A.X + Range(Bounds.B.X - Bounds.A.X, Min.X, Max.X);
  Bounds.B.Y := Bounds.A.Y + Range(Bounds.B.Y - Bounds.A.Y, Min.Y, Max.Y);
End;

procedure TGView.ChangeBounds;
var
  aVis: PVis;
  P: TPoint;

	procedure DoDrawFirstPass; far;
	begin
	  DrawFirstPass(GOwner, @Self);
	end;

Begin
  SetBounds(R);
  CalcFirstPass;
  If (Options and GlobalOptions and ofBuffer <> 0) and GetState(sfTransparent)
  then begin
    aVis := GetVisibility;
    Unindirect(aVis, GOwner);
    LongInt(P) := 0; MakeGlobal(P, P);
    DrawVisLocal(aVis, P, @Self, @DoDrawFirstPass, CurBP);
    FreeVis(aVis);
    {SetViewport;
    DrawFirstPass(GOwner, @Self);
    RestoreViewport}
  end
  else
    DrawVisible
End;

procedure TGView.ChMCursor; Assembler;
Asm
End;

procedure TGView.CopyDrawView(Source: PVRect; var Bounds: TRect; Delta: TPoint);
var
  AVis, IVis, SVis: PVis;
  P1, P2, P3: TPoint;
  Opt: Word;
  OldBounds: TRect;

 procedure DoCopy; far;
 Begin
   CritUnionDelta(Delta);
   CopyScreen(P1.X, P1.Y, P2.X, P2.Y, P3.X, P3.Y);
   SetBounds(Bounds);
 End;

Begin
  GetBounds(OldBounds);
  SetBounds(Bounds);
  If GetVgaMemCaps and vmcCopy = 0
  then begin
    FreeVis(Source);
    DrawView
  end
  else begin
    AVis := GetVisibility;
    If AVis <> nil
    then begin
      MoveVis(Source, Delta);
      SubtractHiddenSources(Source, Delta);

      IVis := IntersectVis(AVis, Source);	{ joins Trans }
      SubtractVis(AVis, Source);
      FreeVis(Source);

      If IVis <> nil
      then begin
	LongInt(P3) := 0; MakeGlobal(P3, P3);
	P1.X := P3.X - Delta.X;
	P1.Y := P3.Y - Delta.Y;
	P2.X := P1.X + Size.X;
	P2.Y := P1.Y + Size.Y;
	SVis := SortVis(IVis, Delta);	{ now destroys IVis }
	Opt := Options;
	SetBounds(OldBounds);
	Options := Opt and not (ofBuffer+ofMetafile); { CopyScreen is not bufferable }
	DrawVisLocal(SVis, P3, @Self, @DoCopy, CurBP);
	Options := Opt;
	SetBounds(Bounds);
	FreeVis(SVis);
      end;
      DrawClipped(AVis, @Self);		{ now destroys AVis }
    end
  end
End;

{$ifdef Windows}
procedure TGView.CreateWin;
var
  Orig: TPoint;
  P: PGView;
  W: TWinHandle;
begin
  P := GOwner;
  Orig := Origin;
  while (P <> nil) and (P^.Wnd = 0) do
  begin
    Inc(Orig.X, P^.Origin.X);
    Inc(Orig.Y, P^.Origin.Y);
    P := P^.GOwner;
  end;
  If P = nil
  then W := 0
  else W := P^.Wnd;
  If W = 0 then
  Wnd := CreateWindow(WindowClass, nil, ws_OverlappedWindow or ws_ClipSiblings or ws_ClipChildren,
    Orig.X, Orig.Y, Size.X, Size.Y, W, 0, hInstance, @Self)
  else Wnd := CreateWindow(WindowClass, nil, ws_Child or ws_ClipSiblings or ws_ClipChildren,
    Orig.X, Orig.Y, Size.X, Size.Y, W, 0, hInstance, @Self);
  ShowWindow(Wnd, sw_Show);
end;

procedure TGView.DestroyWin;
begin
  DestroyWindow(Wnd);
  Wnd := 0;
end;
{$endif Windows}

function TGView.CreateDragView: PGView;
var
  R: TRect;
  Rect: PGView;
begin
  GetBounds(R);
  Rect := New(PDragRect, Init(R));
  GOwner^.InsertBefore(Rect, @Self);
  CreateDragView := Rect
end;

procedure TGView.DeleteRectList;
Begin
  FreeVis(RectList)
End;

procedure TGView.DragView(Event: TEvent; Mode: Byte; var Limits: TRect;
       MinSize, MaxSize: TPoint; ResMode: Byte);
var P, S: TPoint;
    SaveBounds: TRect;
    SaveOpt: Word;
    VisBefore, VisAfter: PVis;
    Rect: PGView;

 procedure DoneRect;
 var
   R: TRect;
 Begin
   If Rect <> @Self
   then begin
     Rect^.GetBounds(R);
     Dispose(Rect, Done);
 {$ifndef Windows}
     If (GrowMode and gfAlign <> 0) and
	(R.B.X - R.A.X = Size.X) and (R.B.Y - R.A.Y = Size.Y) and
	(GrFlags and 1 = 0)
     then R.Move(((R.A.X - Origin.X + 4) and $FFF8) + Origin.X - R.A.X, 0);
 {$endif}
     Locate(R);
   end
 End;

 procedure MoveGrow(X1, Y1, X2, Y2: Integer);
 var
   R, OldR: TRect;
 begin
   X2 := Min(Max(X2, MinSize.X), MaxSize.X);
   Y2 := Min(Max(Y2, MinSize.Y), MaxSize.Y);
   X1 := Min(Max(X1, Limits.A.X - X2 + 1), Limits.B.X - 1 - IconSize * 2);
   Y1 := Min(Max(Y1, Limits.A.Y - Y2 + 1), Limits.B.Y - 1 - IconSize);
   if Mode and dmLimitLoX <> 0 then X1 := Max(X1, Limits.A.X);
   if Mode and dmLimitLoY <> 0 then Y1 := Max(Y1, Limits.A.Y);
   if Mode and dmLimitHiX <> 0 then X1 := Min(X1, Limits.B.X - X2);
   if Mode and dmLimitHiY <> 0 then Y1 := Min(Y1, Limits.B.Y - Y2);
   R.Assign(X1, Y1, X1 + X2, Y1 + Y2);
   Rect^.Locate(R)
 end;

 procedure Change(DX, DY: Integer);
 begin
   if (Mode and dmDragMove <> 0) and (GetShiftState and $03 = 0) then
   begin
     Inc(P.X, DX);
     Inc(P.Y, DY);
   end else
   if (Mode and dmDragGrow <> 0) and (GetShiftState and $03 <> 0) then
   begin
     Inc(S.X, DX);
     Inc(S.Y, DY);
   end;
 end;

 procedure Update(X, Y: Integer);
 begin
   if Mode and dmDragMove <> 0 then
   begin
     P.X := X;
     P.Y := Y;
   end;
 end;

 procedure Correct(X, Y: Boolean);
 Begin
   With Rect^ do Begin
     If Y then Begin
       If Size.Y - Event.Where.Y + Origin.Y < MinSize.Y then
	 Event.Where.Y := Origin.Y + Size.Y - MinSize.Y;
       If Size.Y - Event.Where.Y + Origin.Y > MaxSize.Y then
	 Event.Where.Y := Origin.Y + Size.Y - MaxSize.Y;
       If (Mode and dmLimitLoY <> 0) and (Event.Where.Y < Limits.A.Y)
	 Then Event.Where.Y := Max(Limits.A.Y, Event.Where.Y);
     End;
     If X then Begin
       If Size.X - Event.Where.X + Origin.X < MinSize.X then
	 Event.Where.X := Origin.X + Size.X - MinSize.X;
       If Size.X - Event.Where.X + Origin.X > MaxSize.X then
	 Event.Where.X := Origin.X + Size.X - MaxSize.X;
       If (Mode and dmLimitLoX <> 0) and (Event.Where.X < Limits.A.X)
	 Then Event.Where.X := Max(Limits.A.X, Event.Where.X);
     End;
   End;
 End;

 procedure SetMouse;
 var P: TPoint;
 Begin
   With Rect^ do Begin
     P.X := Size.X div 2; P.Y := Size.Y div 2;
     MakeGlobal(P, P);
     SetMousePos(P.X, P.Y);
   End;
 End;

Begin
  If GOwner = nil then Exit;
  SaveOpt := Options;
  Options := Options and not ofHoldFirst;
  Rect := CreateDragView;
  SetState(sfDragging, True);
  TheDragView := Rect;
  TheDraggedView := @Self;
  GetBounds(SaveBounds);
  if Event.What = evMouseDown then
  begin
    If Mode and dmDragMove <> 0 then SetCurrentCursor (mcMove);
    If Mode and dmDragGrow <> 0 then
      Case ResMode Of
	rmDnRi, rmUpLe : SetCurrentCursor (mcResizeDnRi);
	rmDnLe, rmUpRi : SetCurrentCursor (mcResizeDnLe);
	rmUp, rmDown   : SetCurrentCursor (mcResizeVert);
	rmLeft, rmRight: SetCurrentCursor (mcResizeHori);
      End;

    If Mode and dmDragMove <> 0 then
    begin
      P.X := Origin.X - Event.Where.X;
      P.Y := Origin.Y - Event.Where.Y;
      repeat
	Inc(Event.Where.X, P.X);
	Inc(Event.Where.Y, P.Y);
	MoveGrow(Event.Where.X, Event.Where.Y, Size.X, Size.Y);
      until not MouseEvent(Event, evMouseMove);
    end else
    begin
      If ResMode in [rmUpLe, rmLeft, rmDnLe] then
	P.X := Origin.X - Event.Where.X
      Else P.X := Size.X - Event.Where.X;
      If ResMode in [rmUpRi, rmUp, rmUpLe] then
	P.Y := Origin.Y - Event.Where.Y
      Else P.Y := Size.Y - Event.Where.Y;
      repeat
	Inc(Event.Where.X, P.X);
	Inc(Event.Where.Y, P.Y);
	Case ResMode Of
	  rmUpLe : Begin
		     Correct(true, true);
		     MoveGrow(Event.Where.X, Event.Where.Y,
		       Size.X - Event.Where.X + Origin.X,
		       Size.Y - Event.Where.Y + Origin.Y);
		   End;
	  rmUp   : Begin
		     Correct(false, true);
		     MoveGrow(Origin.X, Event.Where.Y, Size.X,
                       Size.Y - Event.Where.Y + Origin.Y);
		   End;
          rmUpRi : Begin
                     Correct(false, true);
                     MoveGrow(Origin.X, Event.Where.Y, Event.Where.X,
                       Size.Y - Event.Where.Y + Origin.Y);
		   End;
	  rmLeft : Begin
		     Correct(true, false);
		     MoveGrow(Event.Where.X, Origin.Y,
		       Size.X - Event.Where.X + Origin.X, Size.Y);
		   End;
	  rmDnLe : Begin
		     Correct(true, false);
		     MoveGrow(Event.Where.X, Origin.Y,
		       Size.X - Event.Where.X + Origin.X, Event.Where.Y);
		   End;
	  rmDnRi : MoveGrow(Origin.X, Origin.Y, Event.Where.X, Event.Where.Y);
	  rmRight: MoveGrow(Origin.X, Origin.Y, Event.Where.X, Size.Y);
	  rmDown : MoveGrow(Origin.X, Origin.Y, Size.X, Event.Where.Y);

	End;
      until not MouseEvent(Event, evMouseMove);
    end;
  end else
  begin
    SetCurrentCursor(mcMove);
    SetMouse;
    repeat
      P := Rect^.Origin;
      S := Rect^.Size;
      KeyEvent(Event);
      case Event.KeyCode and $FF00 of
	kbLeft: If GetShiftState and kbCtrlShift <> 0 then
		  Change(0, -WinDragAdd*8)
		Else Change(-WinDragAdd, 0);
	kbRight: If GetShiftState and kbCtrlShift <> 0 then
		   Change(0, WinDragAdd*8)
		 Else Change(WinDragAdd, 0);
	kbUp: Change(0, -WinDragAdd);
	kbDown: Change(0, WinDragAdd);
	kbCtrlLeft: Change(-WinDragAdd*8, 0);
	kbCtrlRight: Change(WinDragAdd*8, 0);
	{
	kbCtrlUp: Change(0, -WinDragAdd*8);
	kbCtrlDn: Change(0, WinDragAdd*8);
	}
	kbHome: Update(Limits.A.X, P.Y);
	kbEnd: Update(Limits.B.X - S.X, P.Y);
	kbPgUp: Update(P.X, Limits.A.Y);
	kbPgDn: Update(P.X, Limits.B.Y - S.Y);
      end;
      MoveGrow(P.X, P.Y, S.X, S.Y);
      SetMouse;
    until (Event.KeyCode = kbEnter) or (Event.KeyCode = kbEsc);
    if Event.KeyCode = kbEsc then Rect^.Locate(SaveBounds);
  end;
  SetCurrentCursor(mcHourGlass);
  TheDragView := nil;
  TheDraggedView := nil;
  SetState(sfDragging, False);
  DoneRect;
  Options := SaveOpt;
  SetCurrentCursor(mcNoCursor);
End;

procedure TGView.Draw;
var C: Byte;
Begin
  If not GetState(sfTransparent)
  then begin
    C := GetColor(1);
    SetFillStyle (SolidFill, C);
    Bar (0, 0, Size.X-1, Size.Y-1);
  end
End;

procedure TGView.DrawClipped;	{ has to destroy Clip }
var
  Bounds: TRect;
begin
  If GetState(sfVisible + sfExposed) and
     GetOwnerClippedBounds(Bounds)
  then begin
    ClipVis(Clip, Bounds);
    SubtractInvisible(Clip, VisOwner, false);
    DrawRectList(Clip);
  end;
  FreeVis(Clip)
end;

procedure TGView.DrawCursor;
var R: TRect;
    SaveOpt: Word;
Begin
  SaveOpt := Options;
  Options := Options and not ofBuffer;
  SetViewPort;
  R.Assign(Cursor.X, Cursor.Y, Cursor.X+CursorSize.X, Cursor.Y+CursorSize.Y);
  SetFillStyle (SolidFill, White);
  SetWriteMode (XORPut);
  With R do
    Bar (A.X, A.Y, B.X - 1, B.Y - 1);
  SetWriteMode (NormalPut);
  RestoreViewport;
  Options := SaveOpt;
End;

procedure TGView.DrawRectList;
var
  P: TPoint;
Begin
  LongInt(P) := 0; MakeGlobal(P, P);
  DrawVis(RectList, P, @Self)
End;

procedure TGView.DrawView;
var
  SaveOpt: Word;
Begin
  If GetState(sfTransparent)
  then begin
    SaveOpt := Options;
    Options := Options and not ofSelectable;
    Hide;
    Show;
    Options := SaveOpt
  end
  else
    DrawVisible
End;

procedure TGView.DrawVisible;
var
  aVis: PVis;
  P: TPoint;
Begin
  aVis := GetVisibility;
  If aVis = nil then Exit;
  LongInt(P) := 0; MakeGlobal(P, P);
  DrawVis(aVis, P, @Self);
  FreeVis(aVis)
End;

procedure TGView.DrawVisibleLocal;
var
  aVis: PVis;
  P: TPoint;
Begin
  aVis := GetVisibility;
  If aVis = nil then Exit;
  LongInt(P) := 0; MakeGlobal(P, P);
  DrawVisLocal(aVis, P, @Self, Local, PrevBP);
  FreeVis(aVis)
End;

procedure TGView.EndModal;
var P: PView;
Begin
  P := TopView;
  If TopView <> nil then TopView^.EndModal(Command);
End;

function TGView.Exposed;
var G: PGGroup;
Begin
  If GetState (sfExposed+sfVisible) then
    If GOwner<>nil then Begin
      G:=GOwner;
      While (G<>nil) and (G^.LockFlag=0) do
	G:=G^.GOwner;
      Exposed:=G=nil
    End
    Else Exposed:=True
  Else Exposed := false;
End;

function TGView.Focus;
var Result: Boolean;
Begin
  Result := True;
  If State and (sfSelected + sfModal) = 0 then Begin
    If GOwner <> nil then Begin
      Result := GOwner^.Focus;
      If Result then
        If ((GOwner^.Current = nil) or
	  (GOwner^.Current^.Options and ofValidate = 0) or
          (GOwner^.Current^.Valid(cmReleasedFocus))) then Select
						     else Result := False;
    End;
  End;
  Focus := Result;
End;

procedure TGView.FreeBack;
begin
  If Back <> nil
  then begin
    FreeScreenBuf(Back);
    Back := nil
  end
end;

function TGView.GetColor; Assembler;
Const
{$IFDEF VER60}
  GetPal = 4 + $28;
{$ELSE}
  GetPal = vmtHeaderSize + $2C;
{$ENDIF}
Asm
	LES	SI, Self
@@3:	PUSH	ES
        PUSH	SI
        MOV	DI, ES:[SI]
	CALL	DWORD PTR [DI].GetPal
	PUSH	ES
        MOV     ES, DX
        MOV	DI, AX
	OR	AX, DX
        JZ	@@1
        XOR	BX, BX
	MOV     BL, [ES:DI]
	CMP	BX, Color
	JB	@@1
	ADD	DI, Color
	MOV     BL, [ES:DI]
	MOV	Color, BX
@@1:    POP	ES
	LES	SI, ES:[SI].TGView.GOwner
        MOV	AX, ES
	OR	AX, SI
	JNZ	@@3
@@2:	MOV	AX, Color
End;

function TGView.GetHelpCtx: Word;
begin
  if State and sfDragging <> 0
  then GetHelpCtx := hcDragging
  else GetHelpCtx := HelpCtx
end;

function TGView.GetOwnerClippedBounds; assembler;
asm
	push	ds
	lds	si, Bounds
	les	di, Self
	mov	[si].TRect.A.x, 0
	mov	[si].TRect.A.y, 0
	mov	ax, es:[di].Size.x
	mov	dx, es:[di].Size.y
	mov	[si].TRect.B.x, ax
	mov	[si].TRect.B.y, dx
	jmp	@@5
@@1:
	les	di, es:[di].TGView.GOwner
	mov	ax, es
	or	ax, di
	mov	ax, 1
	jz	@@0

	xor	ax, ax
	cmp	es:[di].TGGroup.LockFlag, 0
	jnz	@@0

	cmp	[si].TRect.A.X, 0
	jg	@@2
	mov	[si].TRect.A.X, 0
@@2:
	cmp	[si].TRect.A.Y, 0
	jg	@@3
	mov	[si].TRect.A.Y, 0
@@3:
	mov	ax, es:[di].TGView.Size.x
	cmp	[si].TRect.B.x, ax
	jl	@@4
	mov	[si].TRect.B.x, ax
@@4:
	mov	ax, es:[di].TGView.Size.y
	cmp	[si].TRect.B.y, ax
	jl	@@5
	mov	[si].TRect.B.y, ax
@@5:
{$ifdef Windows}
	test	es:[di].TGView.State, sfRoot
	mov	ax, 1
	jnz	@@0
{$endif Windows}
	mov	ax, es:[di].TGView.Origin.x
	add	[si].TRect.A.x, ax
	add	[si].TRect.B.x, ax
	mov	ax, es:[di].TGView.Origin.y
	add	[si].TRect.A.y, ax
	add	[si].TRect.B.y, ax
	jmp	@@1
@@0:
	pop	ds
end;

procedure TGView.GetPeerViewPtr;
var
  Index: Integer;
begin
  S.Read(Index, SizeOf(Word));
  if (Index = 0) or (OwnerGroup = nil) then Pointer(P) := nil
  else
  begin
    Pointer(P) := FixupList^[Index];
    FixupList^[Index] := @P;
  end;
end;

function TGView.GetStandardFont;
Begin
  If GOwner <> nil then GetStandardFont:=GOwner^.StandardFont
		   else GetStandardFont:=ftSansSerif;
End;

procedure TGView.GetInVisibleRect;
Begin
  RectList := nil
End;

function TGView.GetVisibility;
var
  aVis: PVis;
  Bounds: TRect;
Begin
  GetVisibility := nil;
  if (State and (sfVisible + sfExposed) <> (sfVisible + sfExposed)) or
     not GetOwnerClippedBounds(Bounds) then Exit;
  aVis := NewVis(Bounds);
  SubtractInvisible(aVis, nil, false);
  GetVisibility := aVis
End;

procedure TGView.GetVisibleRect;
Begin
  RectList := GetVisibility
End;

procedure TGView.GrowTo(X, Y: Integer);
var R: TRect;
Begin
  R.Assign(Origin.X, Origin.Y, Origin.X + X, Origin.Y + Y);
  Locate(R);
End;

procedure TGView.HandleEvent;
var
  Ctx: Word;
Begin
  If Event.What = evMouseDown
  then begin
    If (State and (sfSelected + sfDisabled) = 0) and
       (Options and ofSelectable <> 0) then
      If not Focus or (Options and ofFirstClick = 0) then
	ClearEvent(Event);
  end else
  if Event.What = evTimer
  then begin
    If (State and (sfCursorVis + sfExposed + sfSelected) = sfCursorVis + sfExposed + sfSelected) and
       (Event.InfoWord mod 8 = 0)
    then begin
      DrawCursor;
      CursorFlag:=not CursorFlag;
    End;
  end else
  if Event.What = evPositionalCtx
  then begin
    Ctx := GetHelpCtx;
    If Ctx <> 0
    then begin
      Event.What := evNothing;
      Event.InfoLong := Ctx
    end
  end
End;

procedure TGView.HideCursor;
Begin
  Inc(CursorLock);
  If Cursorlock = 1 then SetState(sfCursorVis, false);
End;

procedure TGView.HideDrawClipped(Clip: PVRect; VisOwner: PGView);
var
  SaveState: Word;
  SaveOpt: Word;
  P: TPoint;
  R: TRect;

	procedure Paste; far;
	begin
	  DrawScreenBuf(Back)
	end;

begin
  GetOwnerClippedBounds(R);
  ClipVis(Clip, R);
  If Back = nil
  then begin
    SaveState := State;
    State := State and not sfVisible;
    If GOwner <> nil
    then begin
      GOwner^.DrawClipped(Clip, VisOwner)
    end
    else FreeVis(Clip);
    State := SaveState;
  end
  else begin
    SubtractInvisible(Clip, VisOwner, false);
    LongInt(P) := 0;
    MakeGlobal(P, P);
    SaveOpt := Options;
    Options := Options and not (ofBuffer + ofMetafile);
    DrawVisLocal(Clip, P, @Self, @Paste, CurBP);
    Options := SaveOpt;
    FreeVis(Clip)
  end
end;

procedure TGView.Locate;
var
  R: TRect;
  P, Min, Max: TPoint;
  VisBefore, VisAfter: PVRect;

 function Range(Val, Min, Max: Integer): Integer;
 Begin
   If Val < Min then Range := Min else
     If Val > Max then Range := Max else
       Range := Val;
 End;

Begin
  SizeLimits(Min, Max);
  Bounds.B.X := Bounds.A.X + Range(Bounds.B.X - Bounds.A.X, Min.X, Max.X);
  Bounds.B.Y := Bounds.A.Y + Range(Bounds.B.Y - Bounds.A.Y, Min.Y, Max.Y);
  GetBounds(R);
  If not Bounds.Equals(R) then Begin
    If (Options and GlobalOptions and ofBuffer = 0) and GetState(sfTransparent)
    then begin
      RestoreBackground;
      ChangeBounds(Bounds);
    end
    else begin
      VisBefore := GetVisibility;
      ChangeBounds(Bounds);
      GetExtent(Bounds);
      LongInt(P) := 0; MakeGlobal(P, P);
      Bounds.Move(P.X, P.Y);
      SubtractRegion(VisBefore, Bounds);

      GetBounds(Bounds);
      SetBounds(R);
      HideDrawClipped(VisBefore, @Self);
      SetBounds(Bounds);
      FreeBack
    end
  End;
End;

procedure TGView.MakeFirst;
Begin
  PutInFrontOf(GOwner^.First);
End;

{$ifdef Windows}
procedure TGView.MakeGlobal(Source: TPoint; var Dest: TPoint); assembler;
asm
	LES     DI,Self
	XOR     AX,AX
	MOV     DX,AX
@@1:
	test	es:[di].TView.State, sfRoot
	jnz	@@0
	ADD     AX,ES:[DI].TView.Origin.X
	ADD     DX,ES:[DI].TView.Origin.Y
	LES     DI,ES:[DI].TView.Owner
	MOV     SI,ES
	OR      SI,DI
	JNE     @@1
@@0:
	ADD     AX,Source.X
	ADD     DX,Source.Y
	LES     DI,Dest
	CLD
	STOSW
	XCHG    AX,DX
	STOSW
end;

procedure TGView.MakeLocal(Source: TPoint; var Dest: TPoint); assembler;
asm
	LES     DI,Self
	XOR     AX,AX
	MOV     DX,AX
@@1:
	test	es:[di].TView.State, sfRoot
	jnz	@@0

	ADD     AX,ES:[DI].TView.Origin.X
	ADD     DX,ES:[DI].TView.Origin.Y
	LES     DI,ES:[DI].TView.Owner
	MOV     SI,ES
	OR      SI,DI
	JNE     @@1
@@0:
	NEG     AX
	NEG     DX
	ADD     AX,Source.X
	ADD     DX,Source.Y
	LES     DI,Dest
	CLD
	STOSW
	XCHG    AX,DX
	STOSW
end;
{$endif Windows}

function TGView.MouseEvent;
Begin
  Repeat
    GetEvent (Event);
  Until Event.What and (Mask or evMouseUp) <> 0;
  MouseEvent := Event.What <> evMouseUp;
End;

procedure TGView.MoveTo(X, Y: Integer);
var R: TRect;
Begin
  R.Assign(X, Y, X + Size.X, Y + Size.Y);
  Locate(R);
End;

function TGView.NextView;
Begin
  If GOwner<>nil then If @Self=GOwner^.Last then NextView:=nil
					    else NextView:=GNext
		 else NextView:=nil;
End;

function TGView.Prev; assembler;
Asm
	LES     DI,Self
        MOV     CX,DI
        MOV     BX,ES
@@1:    MOV     AX,DI
        MOV     DX,ES
	LES     DI,ES:[DI].TGView.GNext
        CMP     DI,CX
        JNE     @@1
        MOV     SI,ES
	CMP     SI,BX
	JNE     @@1
End;

function TGView.PrevView;
Begin
  If GOwner<>nil then If @Self=GOwner^.First then PrevView:=nil
                                             else PrevView:=Prev
		 else PrevView:=nil;
End;

procedure TGView.PutInFrontOf;
var
  VisBefore, VisAfter {, VisCopy}: PVRect;
  OldNext: PGView;

 procedure MoveView;
 Begin
   GOwner^.RemoveView(@Self);
   GOwner^.InsertView(@Self, Target);
 End;

 procedure SubtractTrans(Vis: PVRect; TopView, BottomView: PGView);
 var
   Orig: TPoint;
   P: PGView;
   R: TRect;
 begin
   P := TopView;
   LongInt(Orig) := 0;
   GOwner^.MakeGlobal(Orig, Orig);
   while (P <> nil) and (P <> BottomView) do
   begin
     If P^.State and (sfVisible + sfTransparent) = (sfVisible + sfTransparent)
     then begin
       P^.GetBounds(R);
       R.Move(Orig.X, Orig.Y);
       SubtractRegion(VisBefore, R);
     end;
     P := P^.NextView
   end
 end;

 function MovedUp: Boolean;
 var
   P: PGView;
 begin
   P := OldNext;
   while (P <> nil) and (P <> @Self) do
     P := P^.NextView;
   MovedUp := P = nil
 end;

Begin
  If Target = @Self then
    GOwner^.SetCurrent(@Self, NormalSelect)
  else
  if (GOwner <> nil) and (Target <> NextView) and
    ((Target = nil) or (Target^.GOwner = GOwner))
  then
    if State and (sfVisible + sfExposed) <> (sfVisible + sfExposed)
    then MoveView
    else begin
      VisBefore := GetVisibility;
      OldNext := GNext;
      State := State and not sfVisible;
      MoveView;
      State := State or sfVisible;
      VisAfter := GetVisibility;

      If MovedUp
      then begin  { Moved up }
        SubtractTrans(VisBefore, NextView, OldNext);
        SubtractVis(VisAfter, VisBefore);
        FreeVis(VisBefore);
        ShowDrawClipped(VisAfter, @Self);
      end
      else begin  { Moved down }
        SubtractTrans(VisAfter, OldNext, @Self);
        SubtractVis(VisBefore, VisAfter);
        FreeVis(VisAfter);
        GOwner^.DrawClipped(VisBefore, GOwner)
      end;

{      VisCopy := CopyVis(VisAfter);
      SubtractVis(VisAfter, VisBefore);
      SubtractVis(VisBefore, VisCopy);
      FreeVis(VisCopy);
      DrawClipped(VisAfter, @Self);
      HideDrawClipped(VisBefore, GOwner); }

      if Options and ofSelectable <> 0 then
      begin
	{GOwner^.ResetCurrent;}
	GOwner^.SetCurrent(@Self, NormalSelect) { ****** sth to be dun }
       { Owner^.ResetCursor;}
      end;
    end;
end;

procedure TGView.PutPeerViewPtr;
var
  Index: Integer;
begin
  if (P = nil) or (OwnerGroup = nil) then Index := 0
  else Index := OwnerGroup^.IndexOf(P);
  S.Write(Index, SizeOf(Word));
end;

procedure TGView.RestoreBackground;
var
  AVis: PVis;
Begin
  AVis := GetVisibility;
  If AVis <> nil then HideDrawClipped(AVis, @Self);
  FreeBack
End;

procedure TGView.RestoreViewPort;
var R: TRect;
Begin
  If ViewLock < 1 then Exit;
  If ViewLock = 1 then Begin
    If not EndDraw(vis, @Self)			{ will zero ViewLock }
    then {error};
    FreeVis(vis);
    vis := nil;
  End
  else Begin
    Dec(ViewLock);
    GetExtent(R);
    SetSubRect(R)
  end
End;

function TGView.SetSubRect(var SubRect: TRect): Boolean;
var
  R: TRect;
Begin
  with SubRect do Begin
    R.Copy(SubRect);
    R.Move(DrawOrigin.x, DrawOrigin.y);
    R.Intersect(MetaClipRect);
    SetSubRect := not R.Empty;
    SetClipRectR(R)
  End
End;

procedure TGView.ShowCursor;
Begin
  If CursorLock > 0 then Dec(CursorLock);
  If CursorLock = 0 then SetState(sfCursorVis, true);
End;

procedure TGView.ShowDrawClipped(Clip: PVRect; VisOwner: PGView);
begin
  If not GetState(sfTransparent)
  then DrawClipped(Clip, VisOwner)
  else If GOwner <> nil then
    GOwner^.DrawClipped(Clip, GOwner);
end;

procedure TGView.SetViewPort;
var
  P: TPoint;
  R: TRect;
Begin
  If ViewLock = 0 then Begin
    vis := GetVisibility;
    LongInt(P) := 0; MakeGlobal(P, P);
    If not BeginDraw(vis, P, @Self, true)		{ will inc ViewLock }
    then begin
      {error}
      FreeVis(vis);
      vis := nil
    end
  End
  Else Begin
    Inc(ViewLock);
    GetExtent(R);
    SetSubRect(R);
  end
End;


Procedure TGView.Select;
begin
  if Options and ofSelectable <> 0 then
    if Options and ofTopSelect <> 0 then MakeFirst else
      if GOwner <> nil then GOwner^.SetCurrent(@Self, NormalSelect);
end;

procedure TGView.SetCursor;
Begin
  HideCursor;
  Cursor.X:=X;
  Cursor.Y:=Y;
  ShowCursor;
End;

Procedure TGView.SetState;
var
  Command: Word;
  ToShow, ToHide: Boolean;
Begin
  If AState and sfCursorVis <> 0 then
    If Enable then Begin
      If (State and sfCursorVis=0) and
	 GetState(sfExposed + sfVisible + sfSelected) then Begin
	If CursorFlag then DrawCursor;
      End
    End
    Else Begin
      If (State and sfCursorVis <>0) and
	 GetState(sfExposed + sfVisible + sfSelected) then Begin
	If CursorFlag then DrawCursor;
      End;
    End;

  If AState = sfVisible then Begin
    ToShow := Enable and (State and sfVisible = 0);
    ToHide := not Enable and (State and sfVisible <> 0);
    If ToHide then RestoreBackground;
  End;

{$ifdef Windows}
  If (AState = sfRoot) or (AState = sfExposed) then
    If Enable and ((State or AState) and (sfRoot + sfExposed) = (sfRoot + sfExposed))
    then CreateWin else
    if not Enable and ((State and not AState) and (sfRoot + sfExposed) <> (sfRoot + sfExposed))
    then DestroyWin;
{$endif Windows}

  If Enable
    Then State:=State or AState
    Else State:=State and not AState;

  if GOwner <> nil then
    case AState of
      sfVisible:
	Begin
	  If ToShow
	  then begin
	    If Options and GlobalOptions and ofStoreBack <> 0
	    then StoreBack;
	    If Options and ofSelectable <> 0
	    then
	      {GOwner^.ResetCurrent;}
	      GOwner^.SetCurrent(@Self, NormalSelect);
	    if GOwner^.State and sfExposed <> 0 then
	      SetState(sfExposed, Enable);
	    DrawVisible
	  end
	  else begin
	    if GOwner^.State and sfExposed <> 0 then
	      SetState(sfExposed, Enable);
	    if Options and ofSelectable <> 0
	    then GOwner^.ResetCurrent
	  end
	End;
      sfFocused:
	Begin
	  If Enable then ShowCursor
		    else HideCursor;
	  if Enable then
	    Command := cmReceivedFocus else
	    Command := cmReleasedFocus;
	  Message(GOwner, evBroadcast, Command, @Self);
	End;
      sfExposed:
	CalcFirstPass;
      sfTransparent:
	DrawView;
    End;
End;

procedure TGView.Store;
Begin
  TView.Store (S);
  S.Write (CursorSize, SizeOf (CursorSize));
  S.Write (CursorLock, SizeOf (CursorLock));
End;

procedure TGView.StoreBack;
var R: TRect;
Begin
  FreeBack;
  LongInt(R.A) := 0; MakeGlobal(R.A, R.A); MakeGlobal(Size, R.B);
{$ifndef Windows}
  SetCriticalArea(R);
{$endif}
  HideMouse;
  With R do Back := StoreScreen(A.X, A.Y, B.X, B.Y);
  ShowMouse;
End;

procedure TGView.SubtractInvisible(var AVis: PVRect; VisOwner: PGView;
  SubTrans: Boolean);
var
  Orig: TPoint;

 procedure SubtractPeers(Orig: TPoint; G: PGGroup; Cur: PGView);
 var
   P: PGView;
   R: TRect;
 Begin
   If G = nil then Exit;
   P := G^.First;
   while P <> Cur do Begin
     If P^.State and (sfVisible + sfRoot) = sfVisible then Begin
       P^.GetBounds(R);
       R.Move(Orig.x, Orig.y);
       If P^.Options and ofStoreBack <> 0
       then begin
	 IndirectRegion(aVis, R, P);
	 SubtractRegion(aVis, R)
       end else
       If (P^.State and sfTransparent <> 0) and not SubTrans
       then IndirectRegion(aVis, R, P)
       else SubtractRegion(aVis, R)
     End;
     P := P^.GNext
   End
 End;

 procedure Subtract(Orig: TPoint; P: PGView);
 var
   R: TRect;
 Begin
   while (P <> nil) and (P <> VisOwner)
   {$ifdef Windows} and (P^.State and sfRoot = 0) {$endif Windows} do
   Begin
     Dec(Orig.x, P^.Origin.x);
     Dec(Orig.y, P^.Origin.y);
     SubtractPeers(Orig, P^.GOwner, P);
     P := P^.GOwner;
     IndirectRegion(aVis, R, nil)
   End
 End;

Begin
  If (VisOwner <> nil) and (VisOwner^.GOwner = @Self)
  then begin
    { down-clip, one step supported }
    Unindirect(aVis, @Self)
  end
  else begin
    { up-clip }
    LongInt(Orig) := 0;
    MakeGlobal(Orig, Orig);
    Subtract(Orig, @Self);
  end
End;

function TGView.TopView: PGView;
var P: PGView;
Begin
  If TheTopView = nil then Begin
    P := @Self;
    While (P <> nil) and (P^.State and sfModal = 0) do P := P^.GOwner;
    TopView := P;
  End
  Else TopView := TheTopView;
End;

(**************************** TFrame object *********************************)

Constructor TFrame.Init;
Begin
  TGView.Init (Bounds);
  EventMask:=evMouse+evKeyBoard+evCommand;
  Options:=Options or (ofPostProcess + ofFirstPass);
  GrowMode:=gfGrowHiX+gfGrowHiY;
  TitleSize:= 20;
  OldC:=mcStd;
End;

constructor TFrame.Load;
Begin
  TGView.Load (S);
  S.Read (TitleSize, SizeOf (TitleSize));
  OldC:=mcStd;
End;

procedure TFrame.Store;
Begin
  TGView.Store (S);
  S.Write (TitleSize, SizeOf (TitleSize));
End;

procedure TFrame.CalcFirstPass;
begin
  SetState(sfFirstPass,
    (State and sfTransparent = 0) and
    (Options and GlobalOptions and ofFirstPass <> 0))
end;

procedure TFrame.ChMCursor;
var P: TPoint;
Begin
  If (GOwner=nil) {or (GOwner^.State and sfFocused = 0)} then Exit;
  If (PWindow (GOwner)^.Flags and wfGrow <>0) and Exposed then Begin
    MakeLocal(MouseWhere, P);
    { check the hori borders }
    If Ranges(P.Y, 0, 3) then
      If Ranges(P.X, 0, 22) then NewNum := mcResizeDnRi
      Else If Ranges(P.X, Size.X - 23, Size.X - 1) then NewNum := mcResizeDnLe
           Else NewNum := mcResizeVert
    Else If Ranges(P.Y, Size.Y - 4, Size.Y - 1) then
           If Ranges(P.X, 0, 22) then NewNum := mcResizeDnLe
           Else If Ranges(P.X, Size.X - 23, Size.X - 1) then NewNum := mcResizeDnRi
                Else NewNum := mcResizeVert;

    { check the vert. borders }
    If NewNum = MCurStandard then
      If Ranges(P.X, 0, 3) then
        If Ranges(P.Y, 0, 22) then NewNum := mcResizeDnRi
        Else If Ranges(P.Y, Size.Y - 23, Size.Y - 1) then NewNum := mcResizeDnLe
             Else NewNum := mcResizeHori
      Else If Ranges(P.X, Size.X - 4, Size.X - 1) then
             If Ranges(P.Y, 0, 22) then NewNum := mcResizeDnLe
             Else If Ranges(P.Y, Size.Y - 23, Size.Y - 1) then NewNum := mcResizeDnRi
                  Else NewNum := mcResizeHori;

  End;
End;

Function TFrame.GetPalette;
Const
  P:String [Length (CFrame)]=CFrame;
Begin
  GetPalette:=@P;
End;

Procedure TFrame.Draw;
Var
  R, Client: TRect;
  S: String;
  C, Flags: Byte;

 procedure PaintFrame(Modal: Boolean; var Client: TRect);
 var D, I: Integer;
 Begin
   SetColor (Black);
   RectAngle (0, 0, Size.X-1, Size.Y-1);
   If Modal then Begin
     If State and sfActive <> 0 then SetColor(GetColor(4))
                                else SetColor(GetColor(3));
     For I:=1 to 4 do RectAngle (I, I, Size.X-I-1, Size.Y-I-1);
     SetColor(White);
     Rectangle(5, 4, Size.X - 6, Size.Y - 6);
     Client.Assign(6, 5, Size.X - 6, Size.Y - 6);
   End else Begin
     If State and sfActive <> 0 then SetColor(GetColor(2))
                                else SetColor(GetColor(3));
     For I:=1 to 2 do RectAngle (I, I, Size.X-I-1, Size.Y-I-1);
     SetColor(Black);
     Rectangle(3, 3, Size.X - 4, Size.Y - 4);
     If Flags and wfGrow <> 0 then Begin
       SetColor (GetColor (5));
       HoriLine (Size.X-3,Size.Y-23,Size.X-1);
       VertLine (Size.X-24,Size.Y-3,Size.Y-1);
       HoriLine (0, 22, 2);
       VertLine (22, 0, 2);
       HoriLine (0, Size.Y-23, 2);
       VertLine (22, Size.Y-3, Size.Y-1);
       HoriLine (Size.X-3, 22, Size.X-1);
       VertLine (Size.X-23, 0, 2);
     End;
     Client.Assign(4, 4, Size.X - 4, Size.Y - 4);
   End
 End;

Begin
  GetExtent (R);
  Flags:=PWindow (GOwner)^.Flags;
  { Rahmen }
  PaintFrame(Flags and wfModal <> 0, Client);
  R.Copy(Client);

  { Titelzeile }
  (* Hintergrundfarben *)
  If Flags and wfShowTitle <> 0 then Begin
    R.B.Y := R.A.Y + TitleSize - 1;
    If GetState (sfActive) then C:=7
			   else C:=6;
    SetFillStyle (SolidFill, GetColor (C));
    Bar (R.A.X, R.A.Y, R.B.X - 1, R.B.Y - 2);
    (* Umrandungen *)
    SetColor (Black);
    HoriLine (R.A.X, R.A.Y+TitleSize-2, R.B.X - 1);
    (* Beschriftung *)
    If Flags and wfClose <>0 then Inc (R.A.X, IconSize);
    If Flags and wfZoom <>0 then Dec (R.B.X, IconSize);
    If GetState (sfActive) then C:=9
			   else C:=8;
    SetSubRect(R);
    Dec (R.B.X, R.A.X); Dec (R.B.Y, R.A.Y);
    SetTextJustify(CenterText, CenterText);
    SetTextParams(ftSystem, 0, GetColor(C), false);
    OutTextXY(R.A.X + R.B.X div 2, R.A.Y + R.B.Y div 2, PWindow(GOwner)^.GetTitle($FF));
    R.Assign(0,0, Size.X, Size.Y);
    SetSubRect(R);
    (* Schliefeld *)
    R.Copy(Client);
    If Flags and wfClose <>0 then Begin
      SetColor(Black);
      VertLine (R.A.X + IconSize - 2, R.A.Y, R.A.Y + TitleSize - 2);
      R.B.X := R.A.X + IconSize - 3; R.B.Y := R.A.Y + TitleSize - 3;
      SetFillStyle (SolidFill, GetColor (10));
      Bar (R.A.X, R.A.Y, R.B.X, R.B.Y);
      Inc (R.A.X, 2); Dec (R.B.X, 3);
      R.A.Y:=R.A.Y+(R.B.Y-R.A.Y) div 2-1;
      R.B.Y:=R.A.Y+2;
      SetColor (GetColor (11)); RectAngle (R.A.X, R.A.Y, R.B.X, R.B.Y);
      SetColor (GetColor (13));
      HoriLine (R.A.X+1, R.B.Y+1, R.B.X + 1);
      VertLine (R.B.X+1, R.A.Y+1, R.A.Y + 2);
      SetColor (GetColor (12));
      HoriLine (R.A.X+1, R.A.Y+1, R.B.X-1);
    End;
    (* Fensternummer *)
    If (Flags and wfShowNumber <> 0) and (PWindow(GOwner)^.Number <> wnNoNumber) and
       (PWindow(GOwner)^.Number < 10) then Begin
      R.Copy(Client); Dec(R.A.Y);
      R.A.X := R.B.X - IconSize + 1; R.B.Y := R.A.Y + TitleSize - 1;
      If Flags and wfZoom <> 0 then R.Move(-IconSize + 1, 0);
      With R do Begin
        SetFillStyle(SolidFill, LightGray);
        Bar(A.X, A.Y, B.X, B.Y);
	SetColor (DarkGray);
        VertLine (A.X + 3, A.Y + 3, B.Y - 2);
        HoriLine (A.X + 3, A.Y + 3, B.X - 3);
        SetColor (White);
        HoriLine (A.X + 1, A.Y + 1, B.X - 1);
        VertLine (B.X - 3, A.Y + 3, B.Y - 2);
        HoriLine (A.X + 3, B.Y - 2, B.X - 3);
        SetColor (Black);
        RectAngle (A.X, A.Y, B.X, B.Y);
        Str(PWindow(GOwner)^.Number, S);
        Dec(B.X, A.X); Dec(B.Y, A.Y);
        SetTextJustify(CenterText, CenterText);
        SetTextParams(ftSansSerif, 0, GetColor(8), false);
        OutTextXY(A.X + B.X div 2, A.Y + B.Y div 2 + 2, S);
      End;
    End;
    DrawZoomField (False);
  End;
  { Hintergrund }
  If Flags and wfBackground <> 0 then Begin
    PWindow(GOwner)^.GetClientRect(R);
    SetFillStyle(SolidFill, GetColor(1));
    With R do Bar(A.X, A.Y, B.X - 1, B.Y - 1);
  End;
End;

procedure TFrame.DrawZoomField;
var R: TRect;
Begin
  If (PWindow (GOwner)^.Flags and wfZoom <>0) {and
     not GetState (sfDragging)} then Begin
    SetViewPort;
    R.Assign (Size.X-3-IconSize, 3, Size.X-3, 3+TitleSize);
    If PWindow(GOwner)^.Flags and wfModal <> 0 then R.Move(-1, 1);
    DrawButton (R, Down, True, White, Black, LightGray, DarkGray);
    If not Zoomed then {DrawIcon (R.A.X, R.A.Y, 4, $0F)}
			DrawColIcon(R.A.X, R.A.Y, 4, 0)
		  else {DrawIcon (R.A.X, R.A.Y, 5, $0F);}
			DrawColIcon(R.A.X, R.A.Y, 5, 0);
    RestoreViewPort;
  End;
End;

procedure TFrame.HandleEvent;
var P, Min, Max: TPoint;
    R: TRect;
    Flags, ResMode: Byte;
    Zoomfield: Boolean;
Begin
  TGView.HandleEvent (Event);
  Flags:=PWindow (GOwner)^.Flags;
  MakeLocal (Event.Where, P);
  If (Event.What=evMouseDown) and MouseInView (Event.Where) then Begin
    If Flags and wfShowTitle <> 0 then Begin
      If Flags and wfModal <> 0 then R.Assign(6, 5, 4 + IconSize, 3 + TitleSize)
				else R.Assign(4, 4, 2 + IconSize, 2 + TitleSize);
      If R.Contains (P) and (Flags and wfClose <> 0) then Begin
	 Repeat Until not MouseEvent (Event, evNothing);
	 MakeLocal (Event.Where, P);
	 If R.Contains(P) then Begin
	   Event.What:=evCommand;
	   Event.Command:=cmClose;
	   Event.InfoPtr:=nil;
	   PutEvent (Event);
         End;
         ClearEvent (Event);
         Exit
      End;
      If Flags and wfModal <>0 then R.Assign(Size.X - 5 - IconSize, 5, Size.X - 6, 3 + TitleSize)
                               else R.Assign(Size.X - 3 - IconSize, 4, Size.X - 4, 2 + TitleSize);

      If R.Contains (P) and (Flags and wfZoom <> 0) then Begin
        Zoomfield:=False;
	Repeat
          MakeLocal (Event.Where, P);
          If (R.Contains (P) and not Zoomfield) or
             (not R.Contains (P) and Zoomfield) then Begin
            Zoomfield:=not Zoomfield;
            DrawZoomfield (Zoomfield);
          End;
	Until not MouseEvent (Event, evMouseAuto);
        DrawZoomField (False);
        If R.Contains (P) then Begin
          Event.What:=evCommand;
          Event.Command:=cmZoom;
          Event.InfoPtr:=nil;
          PutEvent (Event);
          ClearEvent (Event);
        End;
        Exit
      End;
      If Flags and wfMove <>0 then Begin
        If Flags and wfModal <> 0 then
	  R.Assign(5, 5, Size.X - 6, 3 + TitleSize)
        Else R.Assign(3, 4, Size.X - 4, 2 + TitleSize);
        If Flags and wfClose <> 0 then Inc(R.A.X, IconSize);
        If Flags and wfZoom <> 0 then Dec(R.B.X, IconSize);
        If R.Contains (P) then Begin
          If not Event.Double then With PWindow (GOwner)^ do Begin
            GOwner^.GetExtent (R);
	    SizeLimits (Min, Max);
            DragView (Event,DragMode or dmDragMove, R, Min, Max, 0);
            ClearEvent (Event);
          End
          Else If Flags and wfZoom <> 0 then PWindow (GOwner)^.Zoom;
          Exit
        End
      End
    End;
    If Flags and wfGrow<>0 then Begin
      ResMode:=0;
      MakeLocal (Event.Where, P);
      GetExtent(R);
      If R.Contains(P) then Begin
        If Ranges(P.Y, 0, 3) then
          If Ranges(P.X, 0, 22) then ResMode := rmUpLe
          Else If Ranges(P.X, Size.X - 23, Size.X - 1) then ResMode := rmUpRi
               Else ResMode := rmUp
        Else If Ranges(P.Y, Size.Y - 4, Size.Y - 1) then
               If Ranges(P.X, 0, 22) then ResMode := rmDnLe
	       Else If Ranges(P.X, Size.X - 23, Size.X - 1) then ResMode := rmDnRi
                    Else ResMode := rmDown;
        If ResMode = 0 then
          If Ranges(P.X, 0, 3) then
            If Ranges(P.Y, 0, 22) then ResMode := rmUpLe
            Else If Ranges(P.Y, Size.Y - 23, Size.Y - 1) then ResMode := rmDnLe
                 Else ResMode := rmLeft
          Else If Ranges(P.X, Size.X - 4, Size.X - 1) then
                 If Ranges(P.Y, 0, 22) then ResMode := rmUpRi
                 Else If Ranges(P.Y, Size.Y - 23, Size.Y - 1) then ResMode := rmDnRi
                      Else ResMode := rmRight

      End;
      If ResMode <>0 then With PWindow (GOwner)^ do Begin
        GOwner^.GetExtent (R);
        SizeLimits (Min, Max);
        DragView (Event,DragMode or dmDragGrow, R, Min, Max, ResMode);
        ClearEvent (Event)
      End
    End
  End
End;

procedure TFrame.SetState;
Begin
  TGView.SetState (AState, Enable);
  If AState and sfActive <> 0 then DrawView;
End;

function TFrame.Valid;
Begin
  Valid:=TGView.Valid (Command);
End;

function TFrame.Zoomed: Boolean;
var Min, Max: TPoint;
Begin
  If GOwner <> nil then With GOwner^ do Begin
    SizeLimits(Min, Max);
    Zoomed := (LongInt(Origin) = 0) and (LongInt(Size) = LongInt(Max));
  End
  Else Zoomed := false;
End;

(**************************** TBackGround object ****************************)

Constructor TBackGround.Init;
Begin
  TGView.Init (Bounds);
  EventMask:=0;
  GrowMode:=gfGrowHiX+gfGrowHiY;
End;

constructor TBackground.Load;
Begin
  TGView.Load (S);
End;

procedure TBackground.Store;
Begin
  TGView.Store (S);
End;

Procedure TBackGround.Draw;
Begin
  SetFillStyle (SolidFill, GetColor (1));
  Bar (0, 0, Size.X-1, Size.Y-1);
End;

(**************************** TScrollbarBack object *************************)

function TScrollbarBack.GetPalette: PPalette;
const
  P: string[Length(CScrollbarBack)] = CScrollbarBack;
begin
  GetPalette := @P
end;

(****************************** TScrollBar object ***************************)

constructor TScrollBar.Init;
Begin
  TGView.Init (Bounds);
  {Options:=Options or ofPostProcess;}
  Value:=0;
  Min:=0;
  Max:=0;
  PgStep:=1;
  ArStep:=1;
  ButtonSize:=18;
  If Size.X<=ButtonSize then Begin
    Flags:=sbVertical;
    GrowMode:=gfGrowLoX + gfGrowHiX + gfGrowHiY;
  End
  Else Begin
    Flags:=sbHorizontal;
    GrowMode:=gfGrowLoY + gfGrowHiX + gfGrowHiY;
  End;
End;

constructor TScrollBar.Load;
Begin
  TGView.Load (S);
  S.Read (Value, SizeOf (Value));
  S.Read (Min, SizeOf (Min));
  S.Read (Max,SizeOf (Max));
  S.Read (ArStep, SizeOf (ArStep));
  S.Read (PgStep, SizeOf (PgStep));
  S.Read (Flags, SizeOf (Flags));
  ButtonSize:=18;
End;

procedure TScrollBar.Draw;
var R: TRect;
Begin
  DrawUpButton (false);
  DrawDnButton (false);

  GetExtent (R);
  SetColor (GetColor (2));
  RectAngle (0, 0, Size.X-1, Size.Y-1);

  If Flags and sbVertical <>0 then
    R.Assign (1, ButtonSize, Size.X-2, Size.Y-ButtonSize-1)
  Else R.Assign (ButtonSize, 1, Size.X-1-ButtonSize, Size.Y-2);
  SetFillStyle (SolidFill, GetColor (5));
  Bar (R.A.X, R.A.Y, R.B.X, R.B.Y);

  If State and sfDisabled = 0 then DrawIndicator (Value, false);
End;

procedure TScrollBar.DrawUpButton;
var R: TRect;
Begin
  SetViewPort;
  GetExtent (R);
  If Flags and sbVertical <> 0 then R.B.Y:=ButtonSize
			       else R.B.X:=ButtonSize;
  DrawButton (R, Down, True, GetColor (1), GetColor (2), GetColor (3),
	      GetColor (4));
  If Flags and sbVertical <>0 then
    If GetState (sfDisabled) then Begin
      {DrawIcon (R.A.X, R.A.Y, 13, $10F);
      DrawIcon (R.A.X, R.A.Y, 9, $07);}
      DrawColIcon (R.A.X, R.A.Y, 13, 15);
      DrawColIcon (R.A.X, R.A.Y, 9, 8)
    End
    Else {DrawIcon (R.A.X, R.A.Y, 9, $0F)}
      DrawColIcon(R.A.X, R.A.Y, 9, 0)
  Else If GetState (sfDisabled) then Begin
	 {DrawIcon (R.A.X, R.A.Y, 12, $10F);
	 DrawIcon (R.A.X, R.A.Y, 8, $07);}
	 DrawColIcon(R.A.X, R.A.Y, 12, 15);
	 DrawColIcon(R.A.X, R.A.Y, 8, 8);
       End
       Else {DrawIcon (R.A.X, R.A.Y, 8, $0F);}
	 DrawColIcon(R.A.X, R.A.Y, 8, 0);
  RestoreViewPort;
End;

procedure TScrollBar.DrawDnButton;
var R: TRect;
Begin
  SetViewPort;
  GetExtent (R);
  If Flags and sbVertical <> 0 then R.A.Y:=R.B.Y-ButtonSize
			       else R.A.X:=R.B.X-ButtonSize;
  DrawButton (R, Down, True, GetColor (1), GetColor (2), GetColor (3),
	      GetColor (4));
  If Flags and sbVertical <>0 then
    If GetState (sfDisabled) then Begin
      DrawColIcon (R.A.X, R.A.Y, 14, 15);
      DrawColIcon (R.A.X, R.A.Y, 10, 8)
    End
    Else DrawColIcon(R.A.X, R.A.Y, 10, 0)
  Else If GetState (sfDisabled) then Begin
	 DrawColIcon(R.A.X, R.A.Y, 11, 15);
	 DrawColIcon(R.A.X, R.A.Y, 7, 8);
       End
       Else DrawColIcon(R.A.X, R.A.Y, 7, 0);
  RestoreViewPort;
End;

procedure TScrollBar.DrawIndicator;
var R: TRect;
    Pos: Integer;
Begin
  SetViewPort;
  Pos:=GetPosition (V);
  If Flags and sbVertical <>0 then
    R.Assign (0, ButtonSize-1+Pos, Size.X, ButtonSize-1+Pos+ButtonSize)
  Else R.Assign (ButtonSize-1+Pos, 0, ButtonSize-1+Pos+ButtonSize, Size.Y);
  DrawButton (R, Down, True, GetColor (1), GetColor (2), GetColor (3),
	      GetColor (4));
  RestoreViewPort;
End;

function TScrollBar.GetPalette;
const P: String [Length (CScrollBar)] = CScrollBar;
Begin
  GetPalette:=@P;
End;

function TScrollBar.GetPosition;
var R: TRect;
Begin
  If Max>Min then Begin
    GetExtent (R);
    If Flags and sbVertical <>0 then Begin
      R.Grow (-1,-ButtonSize);
      Dec (R.B.Y,ButtonSize-2);
      GetPosition:=Round ((R.B.Y-R.A.Y) / (Max-Min) * (V-Min));
    End
    Else Begin
      R.Grow (-ButtonSize,-1);
      Dec (R.B.X,ButtonSize-2);
      GetPosition:=Round ((R.B.X-R.A.X) / (Max-Min) * (V-Min));
    End;
  End
  Else GetPosition:=0;
End;

procedure TScrollBar.HandleEvent;
var MIV, Down: Boolean;
    Delta, A: Integer;
    R, H: TRect;
    EvWhere, P: TPoint;

 function ValueOf (Pos: TPoint): Integer;
 var R: TRect;
     V: Integer;
 Begin
   GetExtent (R);
   If Flags and sbVertical <>0 then Begin
     R.Grow (0,-ButtonSize);
     Dec (R.B.Y,ButtonSize-2);
     V:=Round (((Max-Min)/(R.B.Y-R.A.Y)*(Pos.Y-R.A.Y))+Min);
   End
   Else Begin
     R.Grow (-ButtonSize,0);
     Dec (R.B.X,ButtonSize-2);
     V:=Round (((Max-Min)/(R.B.X-R.A.X)*(Pos.X-R.A.X))+Min);
   End;
   If V>Max then V:=Max;
   If V<Min then V:=Min;
   ValueOf:=V;
 End;

Begin
  TGView.HandleEvent (Event);
  MIV:=MouseInView (Event.Where);
  If (Event.What=evKeyBoard) {and ((Flags and sbHandleKeyBoard <>0) or
     GetState (sfSelected)) } then Begin
    Delta:=0;
    If Flags and sbVertical <>0 then
      Case Event.KeyCode Of
	kbUp       : Delta:=ScrollStep (sbUpArrow);
	kbDown     : Delta:=ScrollStep (sbDownArrow);
	kbPgDn     : Delta:=ScrollStep (sbPageDown);
	kbPgUp     : Delta:=ScrollStep (sbPageUp);
	kbCtrlPgDn : Delta:=Max-Value;
	kbCtrlPgUp : Delta:=Min-Value;
       else Exit;
      End
    Else
      Case Event.KeyCode Of
	kbRight : Delta:=ScrollStep (sbRightArrow);
        kbLeft  : Delta:=ScrollStep (sbLeftArrow);
        kbHome  : Delta:=Min-Value;
	kbEnd   : Delta:=Max-Value;
       else Exit;
      End;
    ClearEvent (Event);
    SetValue (Value+Delta);
  End;
  If (Event.What=evMouseDown) and MIV then Begin
    GetExtent (R);
    MakeLocal (Event.Where, EvWhere);
    If Flags and sbVertical <>0 then R.B.Y:=ButtonSize
				else R.B.X:=ButtonSize;
    If R.Contains (EvWhere) then Begin
      Down:=True;
      DrawUpButton (True);
      Repeat
        MakeLocal (Event.Where, EvWhere);
        If (R.Contains (EvWhere) and not Down) or
           (not R.Contains (EvWhere) and Down) then Begin
          Down:=not Down;
          DrawUpButton (Down);
	End;
        If Down then
          If Flags and sbVertical <>0 then SetValue (Value+ScrollStep (sbUpArrow))
                                      else SetValue (Value+ScrollStep (sbLeftArrow));

      Until not MouseEvent (Event, evMouseAuto);
      DrawUpButton (False);
      ClearEvent (Event);
    End;
    GetExtent (R);
    If Flags and sbVertical <>0 then R.A.Y:=R.B.Y-ButtonSize
                                else R.A.X:=R.B.X-ButtonSize;
    If R.Contains (EvWhere) then Begin
      Down:=True;
      DrawDnButton (True);
      Repeat
        MakeLocal (Event.Where, EvWhere);
        If (R.Contains (EvWhere) and not Down) or
           (not R.Contains (EvWhere) and Down) then Begin
          Down:=not Down;
	  DrawDnButton (Down);
        End;
        If Down then
          If Flags and sbVertical <>0 then SetValue (Value+ScrollStep (sbDownArrow))
				      else SetValue (Value+ScrollStep (sbRightArrow));

      Until not MouseEvent (Event, evMouseAuto);
      DrawDnButton (False);
      ClearEvent (Event);
    End;
    GetExtent (R);
    If Flags and sbVertical <>0 then R.Grow (0,-ButtonSize)
                                else R.Grow (-ButtonSize,0);
    H:=R;
    If Flags and sbVertical <>0 then Begin
      R.B.Y:=R.A.Y+ButtonSize;
      R.Move (0,GetPosition (Value)-1);
    End
    Else Begin
      R.B.X:=R.A.X+ButtonSize;
      R.Move (GetPosition (Value)-1,0);
    End;
    If R.Contains (EvWhere) then Begin
      P.X:=EvWhere.X-R.A.X;
      P.Y:=EvWhere.Y-R.A.Y;
      Down:=False;
      Repeat
        MakeLocal (Event.Where, EvWhere);
        If (MouseInView (Event.Where) and not Down) or
           (not MouseInView (Event.Where) and Down) then Begin
          Down:=not Down;
          DrawIndicator (Value, Down);
        End;
        If Down then Begin
          If Flags and sbVertical <>0 then Dec (EvWhere.Y, P.Y)
                                      else Dec (EvWhere.X, P.X);
          Delta:=ValueOf (EvWhere);
          If (Min<=Delta) and (Max>=Delta) and (Value<>Delta) then Begin
            RestoreIndicator (Value);
            Value:=Delta;
	    DrawIndicator (Value, True);
            If Flags and sbDoScrolling <> 0 then ScrollDraw;
          End;
        End;
      Until not MouseEvent (Event, evMouseAuto);
      DrawIndicator (Value, false);
      ScrollDraw;
      ClearEvent (Event);
    End
    Else If H.Contains (EvWhere) then Begin
           If Flags and sbVertical<>0 then A:=EvWhere.Y-ButtonSize
                                      else A:=EvWhere.X-ButtonSize;
           Down:=GetPosition (Value)<A;
           Repeat
             MakeLocal (Event.Where, EvWhere);
             If Flags and sbVertical<>0 then A:=EvWhere.Y-ButtonSize
                                        else A:=EvWhere.X-ButtonSize;
             If Down then SetValue (Value+ScrollStep (sbPageDown))
                     else SetValue (Value+ScrollStep (sbPageUp));
           Until not MouseEvent (Event, evMouseAuto) or
		 (Down and (GetPosition (Value)>A)) or
                 (not Down and (GetPosition (Value)<A));
           ClearEvent (Event);
         End;
  End;
End;

procedure TScrollBar.RestoreIndicator;
var R: TRect;
    POldV: Integer;
Begin
  SetViewPort;
  HideMouse;
  GetExtent (R);
  If Flags and sbVertical <>0 then
    R.Assign (1, ButtonSize, Size.X-1, Size.Y-ButtonSize)
  Else R.Assign (ButtonSize, 1, Size.X-ButtonSize, Size.Y-1);
  POldV:=GetPosition (OldV);
  If Flags and sbVertical <>0 then Begin
    Inc (R.A.Y,POldV);
    If POldV>GetPosition (Min) then Dec (R.A.Y);
    R.B.Y:=R.A.Y+ButtonSize;
    If POldV>=GetPosition (Max) then Dec (R.B.Y);
  End
  Else Begin
    Inc (R.A.X, POldV);
    If POldV>GetPosition (Min) then Dec (R.A.X);
    R.B.X:=R.A.X+ButtonSize;
    If POldV>=GetPosition (Max) then Dec (R.B.X);
  End;
  SetFillStyle (SolidFill,GetColor (5));
  Bar (R.A.X, R.A.Y, R.B.X-1, R.B.Y-1);
  ShowMouse;
  RestoreViewPort;
End;

procedure TScrollBar.ScrollDraw;
Begin
  If GetState (sfExposed) then Message (GOwner,evBroadCast,cmScrollBarChanged,@Self);
End;

function TScrollBar.ScrollStep;
Begin
  Case Part Of
    sbLeftArrow, sbUpArrow    : ScrollStep:=-ArStep;
    sbRightArrow, sbDownArrow : ScrollStep:=ArStep;
    sbPageLeft, sbPageUp      : ScrollStep:=-PgStep;
    sbPageRight, sbPageDown   : ScrollStep:=PgStep;
   else ScrollStep:=0;
  End;
End;

procedure TScrollBar.SetParams;
var OldV: Integer;
Begin
  If AMax < AMin then AMax := AMin;
  If AValue < AMin then AValue := AMin;
  If AValue > AMax then AValue := AMax;
  OldV := Value;
  If (OldV <> AValue) or (Min <> AMin) or (Max <> AMax) then Begin
    Value := AValue;
    If Exposed and not GetState (sfDragging) then Begin
      RestoreIndicator (OldV);
      Min := AMin;
      Max := AMax;
      If State and sfDisabled = 0 then DrawIndicator (Value, false);
    End
    Else Begin
      Min := AMin;
      Max := AMax;
    End;

    If OldV <> AValue then ScrollDraw;
  End;
  PgStep := APgStep;
  ArStep := AArStep;

  If Min = Max then Begin
    If State and sfDisabled = 0 then SetState (sfDisabled, True)
  End
  Else If State and sfDisabled <> 0 then SetState (sfDisabled, False);
End;

procedure TScrollBar.SetRange;
Begin
  SetParams (Value,AMin,AMax,PgStep,ArStep);
End;

procedure TScrollBar.SetState;
Begin
  TGView.SetState (AState, Enable);
  If (AState and sfDisabled <>0) and Exposed and
     (State and sfDragging = 0) then Begin
    If not Enable then DrawIndicator(Value, False)
                  else RestoreIndicator(Value);
    DrawUpButton (False);
    DrawDnButton (False);
  End;
End;

procedure TScrollBar.SetStep;
Begin
  SetParams (Value,Min,Max,APgStep,AArStep);
End;

procedure TScrollBar.SetValue;
Begin
  SetParams (AValue,Min,Max,PgStep,ArStep);
End;

procedure TScrollBar.Store;
Begin
  TGView.Store (S);
  S.Write (Value, SizeOf (Value));
  S.Write (Min, SizeOf (Min));
  S.Write (Max,SizeOf (Max));
  S.Write (ArStep, SizeOf (ArStep));
  S.Write (PgStep, SizeOf (PgStep));
  S.Write (Flags, SizeOf (Flags));
End;

(****************************** TScroller object ****************************)

constructor TScroller.Init;
Begin
  TGView.Init (Bounds);
  Options := Options or ofSelectable;
  EventMask := EventMask or evBroadcast;
  HScrollBar := AHScrollBar;
  VScrollBar := AVScrollBar;
  TextSize.X := 8;
  TextSize.Y := 18;
End;

constructor TScroller.Load;
Begin
  TGView.Load (S);
  GetPeerViewPtr (S, HScrollBar);
  GetPeerViewPtr (S, VScrollBar);
  S.Read (Delta, SizeOf (TPoint)*3);
End;

procedure TScroller.ChangeBounds;

 procedure SetScrollBars(Enable: Boolean);
 Begin
   If HScrollBar <> nil then HScrollBar^.SetState(sfDragging, Enable);
   If VScrollBar <> nil then VScrollBar^.SetState(sfDragging, Enable);
 End;

Begin
  SetBounds (Bounds);
  Inc (ScrollLock);
  SetScrollBars(true);
  SetLimit (Limit.X, Limit.Y);
  SetScrollBars(false);
  Dec (ScrollLock);
End;

function TScroller.GetPalette: PPalette;
const
  P: String [Length (CScroller)] = CScroller;
Begin
  GetPalette := @P;
End;

procedure TScroller.HandleEvent(var Event: TEvent);
Begin
  TGView.HandleEvent(Event);
  If (Event.What = evBroadcast) and (Event.Command = cmScrollBarChanged) and
     ((Event.InfoPtr = HScrollBar) or (Event.InfoPtr = VScrollBar)) then
      ScrollDraw;
End;

procedure TScroller.ScrollDraw;
var
  D, O: TPoint;
begin
  {If ScrollLock > 0 then Exit;}
  If HScrollBar <> nil then D.X := HScrollBar^.Value
		       else D.X := 0;
  If VScrollBar <> nil then D.Y := VScrollBar^.Value
		       else D.Y := 0;
  If (D.X <> Delta.X) or (D.Y <> Delta.Y) then Begin
    HideCursor;
    O.X := (Delta.X - D.X) * TextSize.X;
    O.Y := (Delta.Y - D.Y) * TextSize.Y;
    SetCursor(Cursor.X + O.X, Cursor.Y + O.Y);
    If ScrollLock = 0
    then begin
      Delta := D;
      ScrollView(@Self, O, nil);
    end;
    ShowCursor
  End
end;

procedure TScroller.ScrollTo;
Begin
  Inc(ScrollLock);
  If HScrollBar <> nil then HScrollBar^.SetValue (X);
  If VScrollBar <> nil then VScrollBar^.SetValue (Y);
  Dec(ScrollLock);
  ScrollDraw;
End;

procedure TScroller.SetLimit;
Begin
  Limit.X := X;
  Limit.Y := Y;
  Inc(ScrollLock);
  If HScrollBar <> nil then With HScrollBar^ do
    SetParams (Value, 0, X - (Self.Size.X div TextSize.X),
      (Self.Size.X - 1) div TextSize.X, ArStep);
  If VScrollBar <> nil then With VScrollBar^ do
    SetParams(Value, 0, Y - (Self.Size.Y div TextSize.Y),
      (Self.Size.Y - 1) div TextSize.Y, ArStep);
  Dec(ScrollLock);
  ScrollDraw;
End;

function TScroller.ShownRows: Integer;
begin
  ShownRows := (Size.Y + TextSize.Y - 1) div TextSize.Y
end;

function TScroller.ShownCols: Integer;
begin
  ShownCols := (Size.X + TextSize.X - 1) div TextSize.X
end;

procedure TScroller.Store;
Begin
  TGView.Store (S);
  PutPeerViewPtr (S, HScrollBar);
  PutPeerViewPtr (S, VScrollBar);
  S.Write (Delta, SizeOf (TPoint)*3);
End;

(***************************** TListViewer object ***************************)

constructor TListViewer.Init;
Begin
  TGView.Init (Bounds);
  Options:=Options or (ofFirstClick+ofSelectable);
  EventMask:=evMouse+evKeyBoard+evBroadcast+evCommand;
  ScrollBar:=AScrollBar;
  If ScrollBar<>nil then ScrollBar^.SetStep (GetPageSize+1,1);
End;

constructor TListViewer.Load;
Begin
  TGView.Load (S);
  GetPeerViewPtr (S,ScrollBar);
  S.Read (Focused,SizeOf (Focused));
  S.Read (Range, SizeOf (Range));
  S.Read (TopItem,SizeOf (TopItem));
  S.Read (Flags, SizeOf(Flags))
End;

procedure TListViewer.ChangeBounds;
Begin
  TGView.ChangeBounds (Bounds);
  If ScrollBar<>nil then ScrollBar^.SetStep (GetPageSize+1,1);
End;

procedure TListViewer.Draw;
var I: Integer;
Begin
  SetFillStyle (SolidFill,GetColor (1));
  Bar (0, 0, Size.X-1, Size.Y-1);
  SetColor (GetColor (2));
  RectAngle (0, 0, Size.X-1, Size.Y-1);
  For I := TopItem to TopItem + GetPageSize + (Flags and lfPartialLines) do
    If I<Range then DrawItem (I);
End;

procedure TListViewer.DrawItem;
var R, Sub: TRect;
    L: Integer;
    C, Tc: Word;
Begin
  If Item>=Range then Exit;
  SetViewPort;
  GetItemRect(Item, R);
  If GetState (sfSelected) then If Item=Focused then Begin C:=6; Tc:=4 End
						else Begin C:=5; Tc:=3 End
			   else Begin C:=5; Tc:=3 End;
  SetFillStyle (SolidFill,GetColor (C));
  If (Item >= TopItem) and
     (Item <= TopItem + GetPageSize + (Flags and lfPartialLines)) then Begin
    GetItemSubRect(Sub);
    Sub.Intersect(R);
    SetSubRect(Sub);
    Bar (R.A.X, R.A.Y, R.B.X-1, R.B.Y-1);
    If IsSelected (Item) and
       ((Item <> Focused) or (State and sfSelected = 0)) then Begin
      SetColor (GetColor (2));
      SetLineStyle (4,$BBBB,1);
      RectAngle (R.A.X, R.A.Y, R.B.X-1, R.B.Y-1);
      SetLineStyle (SolidLn,0,1);
    End;
    SetTextJustify(LeftText, CenterText);
    SetTextParams(ftSansSerif, 0, GetColor(Tc), false);
    DrawItemText(Item, R);
  End;
  RestoreViewPort;
End;

procedure TListViewer.DrawItemText(Item: Integer; R: TRect);
var
  S: String;
  Sub: TRect;
Begin
  S := GetText(Item, $FF);
  While TextWidth(S) > R.B.X do Dec(S[0]);
  R.Grow(-5, 0);
  GetItemSubRect(Sub);
  Sub.Intersect(R);
  SetSubRect(Sub);
  Dec(R.B.Y, R.A.Y);
  OutTextXY(R.A.X, R.A.Y + R.B.Y div 2 + 1, S);
End;

procedure TListViewer.FocusItem;
var P: TPoint;
    R, ItemR, H: TRect;
    OldF: Integer;
Begin
  If (Item<>Focused) and (Item<Range) and (Item>=0) then Begin
    OldF := Focused;
    Focused:=Item;
    If ScrollBar<>nil then ScrollBar^.SetValue(Item);
    P.X := 0;
    GetItemSubRect(R);
    If Item=TopItem-1 then Begin
      DrawItem(OldF);
      If Flags and lfPartialLines <> 0
        then DrawItem(Focused);
      Dec(TopItem);
      GetItemRect(GetPageSize + TopItem, ItemR);
      If Flags and lfPartialLines = 0
      then R.B.Y := ItemR.B.Y;
      GetItemRect(Item, ItemR);
      P.Y := ItemR.B.Y - ItemR.A.Y;
      ScrollView(@Self, P, @R);
    End else
    If Item = GetPageSize + 1 + TopItem then Begin
      DrawItem(OldF);
      If Flags and lfPartialLines <> 0
        then DrawItem(Focused);
      P.Y := 0;
      Repeat
        GetItemRect(TopItem, H);
        Dec(P.Y, H.B.Y - H.A.Y);
        Inc (TopItem);
        GetItemRect(Item, ItemR)
      Until ItemR.B.Y <= R.B.Y;
      If Flags and lfPartialLines = 0
      then R.B.Y := ItemR.B.Y;
      ScrollView(@Self, P, @R);
    End else
    If (Item>GetPageSize+TopItem) then Begin
      Repeat
        Inc(TopItem);
        GetItemRect(Item, ItemR)
      Until ItemR.B.Y <= R.B.Y;
      If TopItem<0 then TopItem:=0;
      DrawView;
    End else
    If Item<TopItem then Begin
      TopItem:=Item;
      DrawView;
    End else Begin
      DrawItem(OldF);
      DrawItem(Focused);
    End
  End
End;

procedure TListViewer.GetItemRect(Item: Integer; var R: TRect);
Begin
  R.Assign (3, 3+(Item-TopItem)*15, Size.X-3, 18+(Item-TopItem)*15);
End;

procedure TListViewer.GetItemSubRect(var R: TRect);
Begin
  R.Assign(3, 3, Size.X - 3, Size.Y - 3);
End;

function TListViewer.GetPageSize: Integer;
var I, C: Integer;
    R, Sub: TRect;
Begin
  I := TopItem;
  GetItemSubRect(Sub);
  C := 0;
  Repeat
    GetItemRect(I, R);
    Inc(I); Inc(C);
  Until R.B.Y > Sub.B.Y;
  Dec(C, 2);
  GetPageSize := C;
End;

function TListViewer.GetPalette;
Const P: String [Length (CListViewer)] = CListViewer;
Begin
  GetPalette:=@P;
End;

function TListViewer.GetText;
Begin Abstract End;

procedure TListViewer.HandleEvent;
var R: TRect;
    EvWhere: TPoint;
    I: Integer;

Begin
  TGView.HandleEvent (Event);
  If Event.What=evKeyBoard then Begin
    I := GetPageSize;
    Case Event.KeyCode Of
      kbUp       : If Focused>0 then FocusItem (Focused-1);
      kbDown     : If Focused<Range-1 then FocusItem (Focused+1);
      kbHome     : FocusItem (TopItem);
      kbEnd      : If TopItem+I<Range then FocusItem (TopItem+I)
                                      else FocusItem (Range-1);
      kbPgUp     : If Focused - I - 1 > -1 then FocusItem (Focused - I - 1)
                                           else FocusItem (0);
      kbPgDn     : If Focused + I+1<Range then FocusItem (Focused + I+1)
                                          else FocusItem (Range-1);
      kbCtrlPgUp : FocusItem (0);
      kbCtrlPgDn : FocusItem (Range-1);
     else If Event.CharCode=' ' then SelectItem(Focused)
				else Exit;
    end;
    ClearEvent (Event);
  End;
  If (Event.What=evMouseDown) and MouseInView (Event.Where) then Begin
    Repeat
      MakeLocal (Event.Where,EvWhere);
      For I := TopItem to TopItem + GetPageSize + (Flags and lfPartialLines) do Begin
	GetItemRect(I, R);
	If R.Contains (EvWhere) then Begin
	  FocusItem(Min(I, Range - 1));
	  If Event.Double and (I < Range) then
	    SelectItem(Focused);
	End;
      End;
      R.Assign (0,0,Size.X-1,Size.Y-1);
      If EvWhere.Y<R.A.Y then FocusItem (Max(0, Focused-1));
      If EvWhere.Y>R.B.Y then FocusItem (Min(Focused+1, Range-1));
    Until not MouseEvent (Event, evMouseMove+evMouseAuto);
    ClearEvent (Event);
  End;
  If (Event.What=evBroadCast) and (Event.InfoPtr=ScrollBar) and
     (Event.Command=cmScrollBarChanged) and
     (Focused <> ScrollBar^.Value) then Begin
    If not GetState (sfSelected) then Select;
    FocusItem (ScrollBar^.Value);
  End;
End;

function TListViewer.IsSelected;
Begin IsSelected:=Item=Focused End;

procedure TListViewer.SelectItem;
Begin
  Message(GOwner, evBroadCast, cmListItemSelected, @Self);
End;

procedure TListViewer.SetRange;
Begin
  Range:=ARange;
  If ScrollBar<>nil then ScrollBar^.SetRange (0,Range-1);
  If Focused>=Range then FocusItem (0);
End;

procedure TListViewer.SetState;
Begin
  TGView.SetState (AState,Enable);
  If AState and sfSelected <>0 then If Exposed then DrawItem (Focused);
End;

procedure TListViewer.Store;
Begin
  TGView.Store (S);
  PutPeerViewPtr (S,PGView (ScrollBar));
  S.Write (Focused, SizeOf (Focused));
  S.Write (Range, SizeOf (Range));
  S.Write (TopItem, SizeOf (TopItem));
  S.Write (Flags, SizeOf (Flags))
End;

{$ifndef Windows}
procedure Copyright; assembler;
Asm
	RET
	DB	"Graphics Vision (C) Stefan Milius"
End;
{$endif}

(*************************** TGGroup object *********************************)

constructor TGGroup.Init;
Begin
  TGView.Init (Bounds);
  Last:=nil;
  Current:=nil;
  Options := (Options or (ofSelectable + ofBufferOne)) and not ofFirstPass;
  EventMask:=$FFFF;
  StandardFont:=ftSansSerif;
End;

constructor TGGroup.Load;
var FixupSave: PFixupList;
    Count, I: Integer;
    P, Q: ^Pointer;
    V: PGView;
    OwnerSave: PGGroup;
Begin
  SetCurrentCursor (mcHourGlass);

  TGView.Load(S);
  S.Read (StandardFont, SizeOf (StandardFont));
  OwnerSave := OwnerGroup;
  OwnerGroup := @Self;
  FixupSave := FixupList;
  S.Read(Count, SizeOf(Word));
  asm
	MOV     CX,Count
	SHL     CX,1
	SHL     CX,1
	SUB     SP,CX
	MOV     FixupList.Word[0],SP
        MOV     FixupList.Word[2],SS
        MOV     DI,SP
        PUSH    SS
        POP     ES
        XOR     AL,AL
        CLD
	REP     STOSB
  end;
  for I := 1 to Count do
  begin
    V := PGView(S.Get);
    if V <> nil then InsertView(V, nil);
  end;
  V := Last;
  for I := 1 to Count do
  begin
    V := V^.GNext;
    P := FixupList^[I];
    while P <> nil do
    begin
      Q := P;
      P := P^;
      Q^ := V;
    end;
  end;
  OwnerGroup := OwnerSave;
  FixupList := FixupSave;
  GetSubViewPtr(S, V);
  SetCurrent(V, NormalSelect);
  if OwnerGroup = nil then Awaken;

  SetCurrentCursor (mcNoCursor);
End;

destructor TGGroup.Done;
var P, T: PGView;
Begin
  Hide;
  P := Last;
  if P <> nil then
  begin
    repeat
      P^.Hide;
      P := P^.Prev;
    until P = Last;
    repeat
      T := P^.Prev;
      Dispose(P, Done);
      P := T;
    until Last = nil;
  end;
  TGView.Done;
End;

function TGGroup.At(Index: Integer): PGView; assembler;
asm
	LES     DI,Self
	LES     DI,ES:[DI].TGGroup.Last
	MOV     CX,Index
@@1:    LES     DI,ES:[DI].TGView.GNext
	LOOP    @@1
	MOV     AX,DI
	MOV     DX,ES
end;

procedure TGGroup.Awaken;

  procedure DoAwaken(P: PGView); far;
  begin
    P^.Awaken;
  end;

begin
  ForEach(@DoAwaken);
end;

procedure TGGroup.CalcFirstPass;
begin
  SetState(sfFirstPass, false)
end;

procedure TGGroup.ChangeBounds;
var D: TPoint;
    VisBefore: PVis;
    OCB: TRect;

 procedure DoCalcChange(P: PView); far;
 var R: TRect;
 begin
   P^.CalcBounds(R, D);
   P^.ChangeBounds(R);
 end;

begin
  D.X := Bounds.B.X - Bounds.A.X - Size.X;
  D.Y := Bounds.B.Y - Bounds.A.Y - Size.Y;
  if Longint(D) = 0 then
  begin
    if State and (sfVisible + sfExposed) <> (sfVisible + sfExposed)
    then SetBounds(Bounds)
    else begin
      {VisBefore := GetVisibility;}
      If GetOwnerClippedBounds(OCB)
      then begin
	VisBefore := NewVis(OCB);
	SubtractInvisible(VisBefore, nil, true { Trans sub });
      end
      else VisBefore := nil;
      D.X := Bounds.A.X - Origin.X;
      D.Y := Bounds.A.Y - Origin.Y;
      CopyDrawView(VisBefore, Bounds, D)
    end
  end else
  begin
    SetBounds(Bounds);
    Lock;
    ForEach(@DoCalcChange);
    Unlock;
  end;
end;

procedure TGGroup.ChMCursor;
var
  P: PGView;
  Where: TPoint;
  R: TRect;
begin
  MakeLocal(MouseWhere, Where);
  If (Where.x >= 0) and (Where.x < Size.x) and
     (Where.y >= 0) and (Where.y < Size.y)
  then begin
    P := First;
    while P <> nil do
    begin
      If P^.State and sfVisible <> 0
      then Begin
	P^.GetBounds(R);
	If R.Contains(Where) then begin
	  P^.ChMCursor;
	  Exit
	end
      end;
      P := P^.NextView
    end
  end
End;

function TGGroup.DataSize: Word;
var
  T: Word;

  procedure AddSubviewDataSize(P: PView); far;
  begin
    Inc(T, P^.DataSize);
  end;

begin
  T := 0;
  ForEach(@AddSubviewDataSize);
  DataSize := T;
end;

procedure TGGroup.Delete;
var SaveState: Word;
Begin
  SaveState := P^.State;
  P^.Hide;
  RemoveView(P);
  P^.Owner := nil;
  P^.GOwner := nil;
  P^.GNext := nil;
  if SaveState and sfVisible <> 0 then P^.Show;
End;

procedure TGGroup.Draw;
{ This method will only be called by a FirstPassDraw action,
  mainly for transparent overlapping.
}
var
  P: PGView;
Begin
  {do a kind of ReDraw}
  P := Last;
  while P <> nil do
    with P^ do
    begin
      If State and sfVisible <> 0
      then DrawFirstPass(P, nil);
      P := P^.PrevView
    end;
End;

procedure TGGroup.DrawClipped;
var
  Orig: TPoint;
  StateMask: Word;

	function FirstPassView(P: PGView): Boolean; far;
	begin
	  FirstPassView := P^.State and sfFirstPass <> 0
	end;

	function TransparentView(P: PGView): Boolean; far;
	begin
	  TransparentView := P^.State and (sfTransparent + sfRoot) = sfTransparent
	end;

	procedure DoDrawFirstPass; far;
	var
	  P: PGView;
	begin
	  P := Last;
	  while P <> nil do
	    with P^ do
	    begin
	      If State and (sfVisible + sfFirstPass + sfRoot) = sfVisible + sfFirstPass
	      then DrawFirstPass(P, @Self);
	      P := P^.PrevView
	    end;
	end;

	procedure DoDrawClipped(P: PGView); far;
	var
	  R: TRect;
	begin
	  with P^ do
	    If State and (sfVisible + sfRoot) = sfVisible
	    then begin
	      If State and StateMask = 0
	      then DrawClipped(CopyVis(Clip), P);
	      GetBounds(R);
	      R.Move(Orig.x, Orig.y);
	      If State and sfTransparent = 0
	      then SubtractRegion(Clip, R)
	      else IndirectRegion(Clip, R, P)
	    end
	end;

begin
  If Exposed
  then begin
    LongInt(Orig) := 0;
    MakeGlobal(Orig, Orig);
    SubtractInvisible(Clip, VisOwner, false);
    StateMask := sfFirstPass + sfTransparent;
    { First pass
    }
    If FirstThat(@FirstPassView) <> nil
    then begin
      If FirstThat(@TransparentView) <> nil
      then StateMask := sfTransparent
      else DrawVisLocal(Clip, Orig, @Self, @DoDrawFirstPass, CurBP);
    end;
    { Second pass
    }
    ForEach(@DoDrawClipped);
  end;
  FreeVis(Clip)
end;

procedure TGGroup.DrawVisible;
Begin
  ReDraw
End;

procedure TGGroup.EndModal;
Begin
  If State and sfModal <> 0 then EndState := Command
			    else TGView.EndModal(Command);
End;

procedure TGGroup.EventError;
Begin
  If GOwner<>nil then GOwner^.EventError (Event);
End;

function TGGroup.Execute;
var Event: TEvent;
Begin
  Repeat
    EndState:=0;
    Repeat
      GetEvent (Event);
      HandleEvent (Event);
      If Event.What<>evNothing then EventError (Event);
    Until EndState<>0;
  Until Valid (EndState);
  Execute:=EndState;
End;

function TGGroup.ExecView;
var SaveOptions: Word;
    SaveOwner: PGGroup;
    SaveTopView: PGView;
    SaveCurrent: PGView;
    SaveCommands: TCommandSet;
Begin
  if P <> nil then
  begin
    SaveOptions := P^.Options;
    SaveOwner := P^.GOwner;
    SaveTopView := TheTopView;
    SaveCurrent := Current;
    GetCommands(SaveCommands);
    TheTopView := P;
    P^.Options := P^.Options and not ofSelectable;
    P^.SetState(sfModal, True);
    SetCurrent(P, EnterSelect);
    if SaveOwner = nil then Insert(P);
    ExecView := P^.Execute;
    if SaveOwner = nil then Delete(P);
    SetCurrent(SaveCurrent, LeaveSelect);
    P^.SetState(sfModal, False);
    P^.Options := SaveOptions;
    TheTopView := SaveTopView;
    SetCommands(SaveCommands);
  end else ExecView := cmCancel;
End;

function TGGroup.First;
Begin
  If Last=nil
    Then First:=nil
    Else First:=Last^.GNext;
End;

function TGGroup.FirstMatch(AState: Word; AOptions: Word): PGView;

function Matches(P: PGView): Boolean; far;
begin
  Matches := (P^.State and AState = AState) and
    (P^.Options and AOptions = AOptions);
end;

begin
  FirstMatch := FirstThat(@Matches);
end;

function TGGroup.FirstThat; Assembler;
var ALast: Pointer;
Asm
        LES     DI,Self
	LES     DI,ES:[DI].TGGroup.Last
        MOV     AX,ES
	OR      AX,DI
        JE      @@3
	MOV     WORD PTR ALast[2],ES
        MOV     WORD PTR ALast[0],DI
@@1:    LES     DI,ES:[DI].TGView.GNext
        PUSH    ES
        PUSH    DI
        PUSH    ES
	PUSH    DI
{$IFDEF Windows}
	MOV	AX,[BP]
	AND	AL,0FEH
	PUSH	AX
{$ELSE}
        PUSH    WORD PTR [BP]
{$ENDIF}
	CALL    Test
	POP     DI
	POP     ES
	OR      AL,AL
	JNE     @@2
	CMP     DI,WORD PTR ALast[0]
	JNE     @@1
	MOV     AX,ES
	CMP     AX,WORD PTR ALast[2]
	JNE     @@1
	XOR     DI,DI
	MOV     ES,DI
@@2:    MOV     SP,BP
@@3:    MOV     AX,DI
	MOV     DX,ES
End;

function TGGroup.FindNext(Forwards: Boolean): PGView;
var P: PGView;
begin
  FindNext := nil;
  if Current <> nil then
  begin
    P := Current;
    repeat
      if Forwards then P := P^.GNext else P := P^.Prev;
    until ((P^.State and (sfVisible + sfDisabled) = sfVisible) and
      (P^.Options and ofSelectable <> 0)) or (P = Current);
    if P <> Current then FindNext := P;
  end;
end;

function TGGroup.FocusNext(Forwards: Boolean): Boolean;
var P: PGView;
begin
  P := FindNext(Forwards);
  FocusNext := True;
  if P <> nil then FocusNext := P^.Focus;
end;

procedure TGGroup.ForEach; assembler;
var ALast: Pointer;
Asm
	LES     DI,Self
	LES     DI,ES:[DI].TGGroup.Last
        MOV     AX,ES
	OR      AX,DI
        JE      @@4
	MOV     WORD PTR ALast[2],ES
        MOV     WORD PTR ALast[0],DI
	LES     DI,ES:[DI].TGView.GNext
@@1:    CMP     DI,WORD PTR ALast[0]
	JNE     @@2
        MOV     AX,ES
        CMP     AX,WORD PTR ALast[2]
	JE      @@3
@@2:    PUSH    WORD PTR ES:[DI].TGView.GNext[2]
	PUSH    WORD PTR ES:[DI].TGView.GNext[0]
	PUSH    ES
	PUSH    DI
{$IFDEF Windows}
	MOV	AX,[BP]
	AND	AL,0FEH
	PUSH	AX
{$ELSE}
	PUSH    WORD PTR [BP]
{$ENDIF}
	CALL    Action
	POP     DI
	POP     ES
	JMP     @@1
@@3:
{$IFDEF Windows}
	MOV	AX,[BP]
	AND	AL,0FEH
	PUSH	AX
{$ELSE}
	PUSH    WORD PTR [BP]
{$ENDIF}
	CALL    Action
@@4:
End;

procedure TGGroup.GetData;
type Bytes = array[0..65534] of Byte;

var I: Word;
    V: PGView;
Begin
  I := 0;
  if Last <> nil then
  begin
    V := Last;
    repeat
      V^.GetData(Bytes(Rec)[I]);
      Inc(I, V^.DataSize);
      V := V^.Prev;
    until V = Last;
  end;
End;

function TGGroup.GetHelpCtx;
var Help: Word;
Begin
  Help := hcNoContext;
  If Current <> nil then Help := Current^.GetHelpCtx;
  If Help = hcNoContext then Help := TGView.GetHelpCtx;
  GetHelpCtx := Help;
End;

procedure TGGroup.GetSubViewPtr;
var Index: Word;
Begin
  S.Read(Index, SizeOf(Word));
  if Index > 0 then
    Pointer(P) := At(Index)
  else
    Pointer(P) := nil;
End;

procedure TGGroup.HandleEvent;

 procedure DoHandleEvent(P: PGView); far;
 begin
   if (P = nil) or ((P^.State and sfDisabled <> 0)
     and (Event.What and (PositionalEvents or FocusedEvents) <> 0)) then Exit;
   case Phase of
     phPreProcess: if P^.Options and ofPreProcess = 0 then Exit;
     phPostProcess: if P^.Options and ofPostProcess = 0 then Exit;
   end;
   if Event.What and P^.EventMask <> 0 then P^.HandleEvent(Event);
 end;

 function ContainsMouse(P: PGView): Boolean; far;
 begin
   ContainsMouse := (P^.State and sfVisible <> 0) and
     P^.MouseInView(Event.Where);
 end;

{$ifdef Windows}
  procedure CheckWnd;
  var
    P, W: PGView;
  begin
    W := GetView(Event.Wnd);
    P := W;
    while (P <> nil) and (P <> @Self) do
      P := P^.GOwner;
    If P <> nil		{ Target Wnd is a child }
    then begin
      Event.Wnd := 0;
      W^.HandleEvent(Event);
    end;
  end;
{$endif Windows}

Begin
  {$ifdef Windows}
  If Event.Wnd <> 0
  then CheckWnd else
  {$endif Windows}
  If Event.What = evPositionalCtx
  then begin
    Phase := phFocused;
    DoHandleEvent(FirstThat(@ContainsMouse));
  end
  else begin
    TGView.HandleEvent(Event);
    If Event.What and FocusedEvents <> 0 then
    begin
      Phase := phPreProcess;
      ForEach(@DoHandleEvent);
      Phase := phFocused;
      DoHandleEvent(Current);
      Phase := phPostProcess;
      ForEach(@DoHandleEvent);
    end else
    begin
      Phase := phFocused;
      if (Event.What and PositionalEvents <> 0) then
	DoHandleEvent(FirstThat(@ContainsMouse)) else
	ForEach(@DoHandleEvent);
    end;
  end
End;

function TGGroup.IndexOf(P: PGView): Integer; assembler;
asm
	LES     DI,Self
	LES     DI,ES:[DI].TGGroup.Last
        MOV     AX,ES
	OR      AX,DI
	JE      @@3
        MOV     CX,DI
        MOV     BX,ES
        XOR     AX,AX
@@1:    INC     AX
        LES     DI,ES:[DI].TGView.GNext
	MOV     DX,ES
        CMP     DI,P.Word[0]
        JNE     @@2
        CMP     DX,P.Word[2]
        JE      @@3
@@2:    CMP     DI,CX
        JNE     @@1
        CMP     DX,BX
        JNE     @@1
	XOR     AX,AX
@@3:
end;

function TGGroup.Insert(P: PGView): pointer;
Begin
  Insert := InsertBefore(P, First);
End;

function TGGroup.InsertBefore(P, Target: PGView): pointer;
var
  SaveState: Word;
Begin
  if (P <> nil) and (P^.GOwner = nil) and
    ((Target = nil) or (Target^.GOwner = @Self)) then
  begin
    if P^.Options and ofCenterX <> 0 then
      P^.Origin.X := (Size.X - P^.Size.X) div 2;
    if P^.Options and ofCenterY <> 0 then
      P^.Origin.Y := (Size.Y - P^.Size.Y) div 2;
    SaveState := P^.State;
    P^.Hide;
    InsertView(P, Target);
    if SaveState and sfVisible <> 0 then P^.Show;
    if State and sfActive <> 0 then
      P^.SetState(sfActive, True);
  end;
  InsertBefore := P
End;

procedure TGGroup.InsertView(P, Target: PGView);
Begin
  { for to remain foreground }
  If P^.Options and ofHoldFirst = 0 then
  If (Target <> nil) and (Target^.Options and ofHoldFirst <> 0) {and (Target^.GOwner <> nil) and
     (Target^.GOwner^.GOwner = nil)} then
    While (Target <> nil) and (Target^.Options and ofHoldFirst <>0) do
      Target := Target^.NextView;
  { -- end -- }
  P^.GOwner := @Self;
  P^.Owner := PGroup(@Self);
  if Target <> nil then
  begin
    Target := Target^.Prev;
    P^.GNext := Target^.GNext;
    Target^.GNext := P;
  end else
  begin
    if Last = nil then P^.GNext := P else
    begin
      P^.GNext := Last^.GNext;
      Last^.GNext := P;
    end;
    Last := P;
  end;
End;

procedure TGGroup.Lock;
Begin
  Inc (LockFlag);
End;

procedure TGGroup.PutSubViewPtr;
var Index: Word;
Begin
  If P = nil then Index := 0
  else Index := IndexOf(P);
  S.Write(Index, SizeOf(Word));
End;

procedure TGGroup.ReDraw;
var
  Flag: Boolean;
  AVis: PVis;
Begin
  AVis := GetVisibility;
  If AVis <> nil
  then begin
  {$ifndef Windows}
    Flag:=False;
    If (CursorNum<>mcHourGlass) and (State and sfDragging = 0) then
      SetCurrentCursor (mcHourGlass)
    Else Flag:=True;
  {$endif}
    DrawClipped(AVis, @Self);
  {$ifndef Windows}
    If not Flag then SetCurrentCursor (mcNoCursor);
  {$endif}
  end;
End;

procedure TGGroup.RemoveView(P: PGView); assembler;
asm
	PUSH    DS
	LDS     SI,Self
        LES     DI,P
        LDS     SI,DS:[SI].TGGroup.Last
        PUSH    BP
        MOV     AX,DS
        OR      AX,SI
	JE      @@7
        MOV     AX,SI
        MOV     DX,DS
        MOV     BP,ES
@@1:    MOV     BX,WORD PTR DS:[SI].TGView.GNext[0]
	MOV     CX,WORD PTR DS:[SI].TGView.GNext[2]
	CMP     CX,BP
        JE      @@5
@@2:    CMP     CX,DX
        JE      @@4
@@3:    MOV     SI,BX
        MOV     DS,CX
        JMP     @@1
@@4:    CMP     BX,AX
        JNE     @@3
        JMP     @@7
@@5:    CMP     BX,DI
        JNE     @@2
        MOV     BX,WORD PTR ES:[DI].TGView.GNext[0]
        MOV     CX,WORD PTR ES:[DI].TGView.GNext[2]
	MOV     DS:WORD PTR [SI].TGView.GNext[0],BX
	MOV     DS:WORD PTR [SI].TGView.GNext[2],CX
        CMP     DX,BP
        JNE     @@7
        CMP     AX,DI
        JNE     @@7
        CMP     CX,BP
        JNE     @@6
        CMP     BX,DI
        JNE     @@6
        XOR     SI,SI
        MOV     DS,SI
@@6:    POP     BP
        PUSH    BP
        LES     DI,Self
        MOV     WORD PTR ES:[DI].TGView.Last[0],SI
        MOV     WORD PTR ES:[DI].TGView.Last[2],DS
@@7:    POP     BP
        POP     DS
end;

procedure TGGroup.ResetCurrent;
begin
  SetCurrent(FirstMatch(sfVisible, ofSelectable), NormalSelect);
end;

procedure TGGroup.SelectNext;
var P: PGView;
Begin
  P := FindNext(Forwards);
  if P <> nil then P^.Select;
End;

procedure TGGroup.SetCurrent(P: PGView; Mode: SelectMode);

 procedure SelectView(P: PGView; Enable: Boolean);
 begin
   if P <> nil then P^.SetState(sfSelected, Enable);
 end;

 procedure FocusView(P: PGView; Enable: Boolean);
 begin
   if (State and sfFocused <> 0) and (P <> nil) then
     P^.SetState(sfFocused, Enable);
 end;

var OldCur: PGView;

Begin
  if Current <> P then
  begin
    {Lock;}
    OldCur := Current;
    FocusView(Current, False);
    if Mode <> EnterSelect then SelectView(Current, False);
    if Mode <> LeaveSelect then SelectView(P, True);
    FocusView(P, True);
    Current := P;
    {Unlock;}
  end;
End;

procedure TGGroup.SetData;
type Bytes = array[0..65534] of Byte;

var I: Word;
    V: PGView;
Begin
  I := 0;
  if Last <> nil then
  begin
    V := Last;
    repeat
      V^.SetData(Bytes(Rec)[I]);
      Inc(I, V^.DataSize);
      V := V^.Prev;
    until V = Last;
  end;
End;

procedure TGGroup.SetState;

 procedure DoSetState(P: PGView); far;
 begin
   P^.SetState(AState, Enable);
 end;

 procedure DoExpose(P: PGView); far;
 begin
   if P^.State and sfVisible <> 0 then P^.SetState(sfExposed, Enable);
 end;

begin
  TGView.SetState(AState, Enable);
  case AState of
    sfActive, sfDragging:
      begin
{        Lock;}
	ForEach(@DoSetState);
{	Unlock;}
      end;
    sfFocused:
      if Current <> nil then Current^.SetState(sfFocused, Enable);
    sfExposed:
      begin
        ForEach(@DoExpose);
           {if not Enable then FreeBuffer;}
      end;
  end;
End;

procedure TGGroup.Store;
var Count: Integer;
    OwnerSave: PGGroup;

 procedure DoPut(P: PGView); far;
 begin
   S.Put(P);
 end;

Begin
  TGView.Store(S);
  S.Write (StandardFont, SizeOf (StandardFont));
  OwnerSave := OwnerGroup;
  OwnerGroup := @Self;
  Count := IndexOf(Last);
  S.Write(Count, SizeOf(Word));
  ForEach(@DoPut);
  PutSubViewPtr(S, Current);
  OwnerGroup := OwnerSave;
End;

procedure TGGroup.Unlock;
Begin
  If Lockflag <> 0 then Begin
    Dec (LockFlag);
    If LockFlag = 0 then DrawView;
  End;
End;

function TGGroup.Valid;

 function IsInValid(P: PGView): Boolean; far;
 Begin
   IsInValid := not P^.Valid(Command);
 End;

Begin
  Valid := True;
  If Command = cmReleasedFocus then Begin
    If (Current <> nil) and (Current^.Options and ofValidate <> 0) then
      Valid := Current^.Valid(Command);
  End
  Else if Command <> cmHeyYou then Valid := FirstThat(@IsInvalid) = nil;
End;

(**************************** TDragRect object ******************************)

constructor TDragRect.Init(var Bounds: TRect);
begin
  TGView.Init(Bounds);
  Options := Options and not ofBuffer;
  State := State or sfTransparent
end;

procedure TDragRect.Draw;
var I: Byte;
Begin
  SetColor(White);
  SetWriteMode(XORPut);
  For I := 0 to 1 do
    Rectangle(I, I, Size.X - I - 1, Size.Y - I - 1);
  SetWriteMode(NormalPut);
End;

procedure TDragRect.HideDrawClipped(Clip: PVRect; VisOwner: PGView);
begin
  DrawClipped(Unraw(Clip), VisOwner)
  {inherited HideDrawClipped(Clip, VisOwner)}
end;

procedure TDragRect.Locate(var Bounds: TRect);
var
  R: TRect;
begin
  If GetState(sfTransparent)
  then inherited Locate(Bounds)
  else begin
    GetBounds(R);
    If not Bounds.Equals(R)
    then begin
      Hide;
      ChangeBounds(Bounds);
      Show
    end
  end
end;

(**************************** TWindow object *******************************)

Constructor TWindow.Init;
Begin
  TGGroup.Init(Bounds);
  Title := NewStr(ATitle);
  Number := ANumber;
  Flags := wfMove + wfGrow + wfClose + wfZoom +
    wfShowNumber + wfShowTitle + wfBackground;
  Options := Options or (ofSelectable+ofTopSelect+ofTileable+ofFirstClick);
  GrowMode := gfGrowAll + gfGrowRel;
  GetBounds(ZoomRect);
  Palette := wpWhiteWindow;
  InitFrame;
  If Frame<>nil Then Insert (Frame);
End;

constructor TWindow.Load;
Begin
  TGGroup.Load (S);
  S.Read(Flags, SizeOf(Word) + SizeOf(TRect) + 2 * SizeOf(Integer));
  GetSubViewPtr (S, Frame);
  Title:=S.ReadStr;
  S.Read (ScrBBck, SizeOf (ScrBBck));
  If ScrBBck<>nil then GetSubViewPtr (S, ScrBBck);
End;

destructor TWindow.Done;
Begin
  DisposeStr (Title);
  TGGroup.Done;
End;

procedure TWindow.Close;
Begin
  If Flags and wfHideClose <> 0
  then Hide
  else if Valid(cmClose) then Free
End;

procedure TWindow.GetClientRect(var R: TRect);
Begin
  GetExtent(R);
  If Frame <> nil then Begin
    If Flags and wfModal = 0 then
      R.Assign(4, 3 + Frame^.TitleSize, Size.X - 4, Size.Y - 4)
    Else R.Assign(6, 4 + Frame^.TitleSize, Size.X - 6, Size.Y - 6);
    If Flags and wfShowTitle = 0 then Dec(R.A.Y, Frame^.TitleSize - 1);
  End
End;

function TWindow.GetPalette;
Const P: Array [wpWhiteWindow..wpCyanWindow] Of String [Length (CWhiteWindow)] =
	   (CWhiteWindow,CGrayWindow,CCyanWindow);
Begin
  GetPalette:=@P[Palette];
End;

function TWindow.GetTitle;
var S: TTitleStr;
Begin
  If Title <> nil then Begin
    S:=Title^;
    If Length (S)>MaxSize then S:=Copy (S,0,MaxSize);
  End
  Else S := '';
  GetTitle := S;
End;

procedure TWindow.HandleEvent;
var Limits: TRect;
    Min, Max: TPoint;
Begin
  TGGroup.HandleEvent(Event);
  if (Event.What = evCommand) then
    case Event.Command of
      cmResize:
	If Flags and (wfMove + wfGrow) <> 0 then Begin
          GOwner^.GetExtent(Limits);
          SizeLimits(Min, Max);
          DragView(Event, DragMode or (Flags and (wfMove + wfGrow)),
            Limits, Min, Max, rmDnRi);
          ClearEvent(Event);
        End;
      cmClose:
	If (Flags and wfClose <> 0) and
	  ((Event.InfoPtr = nil) or (Event.InfoPtr = @Self)) then
	Begin
	  ClearEvent(Event);
	  If State and sfModal = 0 then Close
          Else Begin
            Event.What := evCommand;
            Event.Command := cmCancel;
            PutEvent(Event);
            ClearEvent(Event);
          End;
        End;
      cmZoom:
        If (Flags and wfZoom <> 0) and
          ((Event.InfoPtr = nil) or (Event.InfoPtr = @Self)) then
        begin
          Zoom;
          ClearEvent(Event);
        end;
    end
  else if Event.What = evKeyDown then
    case Event.KeyCode of
      kbTab:
	begin
	  FocusNext(False);
          ClearEvent(Event);
        end;
      kbShiftTab:
        begin
          FocusNext(True);
          ClearEvent(Event);
        end;
    end
  else if (Event.What = evBroadcast) and (Event.Command = cmSelectWindowNum)
	 and (Event.InfoInt = Number) and (Options and ofSelectable <> 0) then
  begin
    Select;
    ClearEvent(Event);
  end
  else If (Event.What = evBroadCast) and (Event.Command = cmHeyYou) and
          (Event.InfoPtr <> @Self) and GetState(sfVisible) then ClearEvent(Event);
End;

Procedure TWindow.InitFrame;
Var R:TRect;
Begin
  GetExtent (R);
  Frame:=New (PFrame, Init (R));
End;

function TWindow.AmLastWindow;
var G: PGGroup;
    H: Boolean;

 function Test(P: PGView): Boolean; far;
 Begin
   Test := Message(P, evBroadCast, cmHeyYou, @Self)<>nil;
 End;

Begin
  G := GOwner;
  If G <> nil then Begin
    While G^.GOwner <> nil do G := G^.GOwner;
    AmLastWindow := G^.FirstThat(@Test)=nil;
  End
  Else AmLastWindow := true;
End;

procedure TWindow.SetState;
var WindowCommands: TCommandSet;
Begin
  If AState = sfVisible then Begin
    If Enable then Number := GetWindowNumber(Number)
              else FreeWindowNumber(Number);
  End;

  TGGroup.SetState(AState, Enable);
  If AState = sfSelected then
    SetState(sfActive, Enable);
  If ((AState = sfSelected) or ((AState = sfExposed) and
    (State and sfSelected <> 0))){ and AmLastWindow} then { gendert Mi. !!!}
  Begin
    WindowCommands := WindowCmds;
    if Flags and wfGrow + wfMove <> 0 then
      WindowCommands := WindowCommands + [cmResize];
    if Flags and wfClose <> 0 then
      WindowCommands := WindowCommands + [cmClose];
    if Flags and wfZoom <> 0 then
      WindowCommands := WindowCommands + [cmZoom];
    if Enable then EnableCommands(WindowCommands)
    else DisableCommands(WindowCommands);
  end;
End;

procedure TWindow.SizeLimits;
Begin
  TGView.SizeLimits (Min,Max);
  Min := GMinWinSize;
End;

function TWindow.StandardScrollBar;
var R: TRect;
    S: PScrollBar;
Begin
  If ScrBBck=nil then Begin
    R.Assign (Size.X-20, Size.Y-20, Size.X-4, Size.Y-4);
    ScrBBck:=New (PScrollbarBack, Init (R));
    Insert (ScrBBck);
    ScrBBck^.GrowMode:=gfGrowAll;
  End;
  GetExtent(R);
  If AOptions and sbVertical = 0 then
    R.Assign (R.A.X+3, R.B.Y-21, R.B.X-20, R.B.Y-3)
  else R.Assign (R.B.X-21, R.A.Y+22, R.B.X-3, R.B.Y-20);
  S := New (PScrollBar, Init(R));
  Insert (S);
  S^.Flags := AOptions;
  If AOptions and sbHandleKeyboard <> 0
  then S^.Options := S^.Options or ofPostProcess;
  StandardScrollBar := S;
End;

procedure TWindow.Store;
Begin
  TGGroup.Store (S);
  S.Write(Flags, SizeOf(Word) + SizeOf(TRect) + 2 * SizeOf(Integer));
  PutSubViewPtr (S, Frame);
  S.WriteStr (Title);
  S.Write (ScrBBck, SizeOf (ScrBBck));
  If ScrBBck<>nil then PutSubViewPtr (S, ScrBBck);
End;

function TWindow.Valid(Command: Word): Boolean;
begin
  Valid := (Command <> cmHeyYou) and inherited Valid(Command)
end;

procedure TWindow.Zoom;
var R: TRect;
    Max, Min: TPoint;
Begin
  SizeLimits(Min, Max);
  If Longint(Size) <> Longint(Max) then Begin
    GetBounds(ZoomRect);
    Longint(R.A) := 0;
    R.B := Max;
    Locate(R);
  End
  Else Locate(ZoomRect);
End;

(*********************** GVViews registration procedure *********************)

procedure RegisterGVViews;
Begin
  {RegisterType (RView);}
  RegisterType (RGView);
  RegisterType (RFrame);
  RegisterType (RBackground);
  RegisterType (RScrollBar);
  RegisterType (RScroller);
  RegisterType (RListViewer);
  RegisterType (RGGroup);
  RegisterType (RWindow);
End;

Begin
{$ifndef Windows}
  CopyRight;
{$endif}
  PositionalEvents := PositionalEvents or evPositionalCtx;
{$ifndef Windows}
  WinRes.SetHelpCtxDelta(hc)
{$endif}
End.
