{$IFNDEF VER60}
{$A+,B+,F-,G+,I-,O+,P+,Q-,R-,S-,T-,V-,X+,Y-}
{$ELSE}
{$A+,B+,F-,G+,I-,O+,R-,S-,V-,X+}
{$ENDIF}
unit bmpcx;
{****************************************************************************
 * Author           : Stefan Goehler, Germany                               *
 * Version          : official 1.1                                          *
 *******                                                                    *
 * my mail-adress   : stefan.goehler@gmx.de                                 *
 * my homepage      : http://sourcenet.home.pages.de                        *
 ****** HISTORY *************************************************************
 * Version 1.1  *improved error-management                                  *
 *              +added procedures infobmp, infopcx                          *
 *               (published with grafx1.3c)                                 *
 *              +picture output divertable via grafx (changeable procedure  *
 *               pointer                                                    *
 ****************************************************************************}
interface
uses graphics,gr_vars;

  function loadbmp(px,py : integer;name: string) : byte;
  function loadpcx(px,py : integer;name: string) : byte;
  function info_bmp(name: string;var image_info : timage_info) : byte;
  function info_pcx(name: string;var image_info : timage_info) : byte;

implementation
var
  p           : pointer;
  f           : file;
  nr,maxread  : word;
  i           : word;

type
  pcxh = record
    id,version                  : byte;
    compressed                  : boolean;
    bpp                         : byte;
    minx,miny,sizex,sizey,dpix,dpiy : word;
    pal16                       : array[0..47] of byte;
    reserved,bitplanes          : byte;
    bytesperline,paltype        : word;
    reserved2                   : array[0..57] of byte;
  end;

procedure readblock;
begin
  blockread(f,p^,maxread,nr);
  dec(nr);
end;


function loadpcx(px,py : integer;name: string) : byte;
{
0 : file loaded
1 : file not found
2 : incorrect fileformat
3 : unexpected end of file
4 : not enough memory
}
var
  i,y,mempos : word;
  h          : pcxh;
  linep      : pointer;
  count      : byte;

begin
  loadpcx := image_filenotfound;
  {$I-}
  filemode := 64;
  assign(f,name);
  reset(f,1);
  {$I+}
  if ioresult <> 0 then exit;
  blockread(f,h,sizeof(h),i);

  if (h.id <> $0A)or(h.version < 5)or(h.bpp <> 8)or(not h.compressed) then begin
    loadpcx := image_falseformat;
    close(f);
    exit;
  end;
  if i < sizeof(h) then begin
    loadpcx := image_falseend;
    close(f);
    exit;
  end;

  seek(f,filesize(f)-768);
  blockread(f,pal^,sizeof(pal^));
{  for i:= 0 to 255 do begin
   pal^[i].r:=pal^[i].r shr 2;
   pal^[i].g:=pal^[i].g shr 2;
   pal^[i].b:=pal^[i].b shr 2;
  end;}
  shiftpal;
  setpal;
  seek(f,sizeof(h));
  getmem(linep,h.sizex+1);
  maxread := 64000;
  getmem(p,succ(maxread));
  mempos := ofs(p^);
  readblock;
{ vx := 0;}
  for y := 0 to h.sizey do begin
    asm
           db 66h;xor dx,dx
           db 66h;xor si,si
           mov si,mempos
@lp1     : cmp si,nr
           jna @notatend1
           push dx
           call readblock
           pop dx
           {xor si,si}
           mov si,word ptr p
@notatend1:mov es,word ptr p[2]
           mov bx,es:[si]
           cmp bl,$BF
           jna @putpixel
           and bl,$3F
          { jz @noline}
           cmp si,nr
           jne @notatend
           push dx;push bx
           call readblock
           pop bx;pop dx
           mov es,word ptr p[2]
{           mov si,65535}
           mov si,word ptr p
           dec si
           mov bh,es:[si+1]
@notatend: mov al,bh
           mov ah,al
           xor bh,bh
           mov cx,ax
           db 66h;shl ax,16
           mov ax,cx
           les di,linep
           add di,dx
           mov cx,bx
           shr cl,2
           jz @below4
           db 0F3h,66h,0ABh{rep stosd}
@below4  : mov cl,bl
           and cl,11b
           jz @zero
           mov es:[di],ax
           and cl,1b
           jz @zero
           mov es:[di+2],al
@zero    : add dx,bx
           add si,2
@noline  : jmp @end
@putpixel: les di,linep
{          add di,dx
           mov es:[di],bl}
           inc si
           DB $26,$67,$88,$1C,$17{mov es:[edi+edx],bl}
           inc dx
@end     : cmp dx,h.sizex
           jna @lp1
           mov mempos,si
end;
{
                     repeat
                           if mempos>nr then begin
                              readblock;
                              mempos:=0;
                           end;
                           if mem[seg(p^):ofs(p^)+mempos]>$BF then begin
                              count:= mem[seg(p^):ofs(p^)+mempos]and $3F;
                              if count>0 then begin
                                 if mempos=nr then begin
                                    readblock;
                                    mempos:=65535;
                                 end;
  filldword(mem[seg(linep^):ofs(linep^)+vx],count,mem[seg(p^):ofs(p^)+mempos+1]);
                                 inc(vx,count);
                                 inc(mempos,2);
                              end;
                           end else begin
             mem[seg(linep^):ofs(linep^)+vx]:=mem[seg(p^):ofs(p^)+mempos];
                               inc(vx);
                               inc(mempos);
                           end;
                     until vx>h.sizex;
 vx := 0;}
    image_line(px,py+y,h.sizex,linep);
  end;

  close(f);
  freemem(p,succ(maxread));
  freemem(linep,h.sizex+1);
  loadpcx := image_noerror;
end;

function info_pcx(name: string;var image_info : timage_info) : byte;
var
  h          : pcxh;
begin
  infopcx := image_filenotfound;
  {$I-}
  filemode := 64;
  assign(f,name);
  reset(f,1);
  {$I+}
  if ioresult <> 0 then exit;
  blockread(f,h,sizeof(h),i);

  if (h.id <> $0A)or(h.version < 5) then begin
    infopcx := image_falseformat;
    close(f);
    exit;
  end;
  if i < sizeof(h) then begin
    infopcx := image_falseend;
    close(f);
    exit;
  end;
  with image_info do begin
    size.x       := h.sizex;
    size.y       := h.sizey;
    colordepth   := h.bpp;
    transparency := false;
    compressed   := h.compressed;
    trans_color  := 0;
    memsize      := longint(size.x)*size.y+1024+imagedatasize;
    disksize     := filesize(f);
    version      := 1;
  end;
  close(f);
  infopcx := image_noerror;
end;

type
  bmph = record
    id         : array[0..1] of char;
    chunksize  : longint;
    reserved   : longint;
    imagestart : longint;
    unknown1   : longint;{40?}
    sizex      : longint;
    sizey      : longint;
    unknown2   : array[0..1] of byte;{0=1?}
    bpp        : byte;
    unknown3   : byte;
    compressed : boolean;
    unknown4   : array[0..2] of byte;
    imagesize  : longint;
    unknown5   : array[0..7] of byte;
    usedcolors : word;
    unknown6   : array[0..5] of byte;{3=1?}
  end;
var
  h          : bmph;

function info_bmp(name: string;var image_info : timage_info) : byte;
begin
  infobmp := image_filenotfound;
  {$I-}
  filemode := 64;
  assign(f,name);
  reset(f,1);
  blockread(f,h,sizeof(h));
  {$I+}
  if ioresult <> 0 then exit;

  if (h.id[0] <> 'B')or(h.id[1] <> 'M') then begin
    infobmp := image_falseformat;
    close(f);
    exit;
  end;
  with image_info do begin
    size.x       := h.sizex;
    size.y       := h.sizey;
    colordepth   := h.bpp;
    transparency := false;
    compressed   := h.compressed;
    trans_color  := 0;
    memsize      := longint(size.x)*size.y+1024+imagedatasize;
    disksize     := filesize(f);
    version      := 1;
  end;
  close(f);
  infobmp := image_noerror;
end;

function loadbmp(px,py : integer;name: string) : byte;
{
0 : file loaded
1 : file not found
2 : icorrect fileformat
3 : unexpected end of file
}
type
  bmppaltype = array[0..255] of record
    b,g,r,dummy : byte;
  end;

var
  y,mempos : word;
  lineread : word;
  bmppal   :^bmppaltype;
  readmax  : word;

begin
  loadbmp := image_filenotfound;
  {$I-}
  filemode := 64;
  assign(f,name);
  reset(f,1);
  {$I+}
  if ioresult <> 0 then exit;
  blockread(f,h,sizeof(h),i);

  if (h.id[0] <> 'B')or(h.id[1] <> 'M')or(h.bpp <> 8)or(h.compressed) then begin
    loadbmp := image_falseformat;
    close(f);
    exit;
  end;
  if i < sizeof(h) then begin
    loadbmp := image_falseend;
    close(f);
    exit;
  end;

  new(bmppal);
  blockread(f,bmppal^,sizeof(bmppal^));
  for i:= 0 to 255 do begin
    pal^[i].r:=bmppal^[i].r shr 2;
    pal^[i].g:=bmppal^[i].g shr 2;
    pal^[i].b:=bmppal^[i].b shr 2;
  end;
  dispose(bmppal);
  setpal;
  seek(f,sizeof(h));
  if h.sizex mod 4 <> 0 then i := (4-((h.sizex) mod 4)) else i := 0;
  lineread := h.sizex+i;

  maxread := 64000;
  readmax := (maxread div lineread)*lineread;
  getmem(p,succ(readmax));
  mempos := readmax;

  seek(f,h.imagestart);
  dec(h.sizey);
  for y := h.sizey downto 0 do begin
    if mempos = readmax then begin
      blockread(f,p^,readmax,mempos);
      mempos := 0;
    end;
    image_line(px,py+y,h.sizex,ptr(seg(p^),ofs(p^)+mempos));
    inc(mempos,lineread);
  end;

  close(f);
  freemem(p,succ(readmax));
  loadbmp := image_noerror;
end;



begin
end.