{$IFNDEF VER60}
{$A+,B+,D-,F-,G+,I-,L-,O+,P+,Q-,R-,S-,T-,V-,X+,Y-}
{$ELSE}
{$A+,B+,D-,F-,G+,I-,L-,O+,R-,S-,V-,X+}
{$ENDIF}
unit gr_ati;

interface
uses gr_vars;

  procedure enableext_ati;
  function  detect_ati : boolean;
  procedure setbank2_ati(bank : word);
  procedure setbank_ati(bank : word);
  procedure decbank_ati;
  procedure incbank_ati;

implementation

const
  ATI_18800   = $31;
  ATI_18800_1 = $32;
  ATI_28800_4 = $34;

var
  ATI_Mach   : boolean;
  ATI_Mach64 : boolean;

procedure setbank2_ati(bank : word);
var
  x : word;
begin
(*  if card.chipnum = $31{V3} then
  modinx(card.ioadr,$B2,$1E,bank shl 1)
  else begin
    x := (bank and 15)*$22;          {Roll bank nbr into bit 0}
    wrinx(card.ioadr,$B2,hi(x) or lo(x));
  end;*)
  if ATI_Mach then modinx(card.IOadr,$AE,$F,(bank shr 4)*5);
  if card.chipnum = ATI_18800 then modinx(card.IOadr,$B2,$1E,bank shl 1)
  else begin
    x:=(bank and 15)*$22;          {Roll bank nbr into bit 0}
    wrinx(card.IOadr,$B2,hi(x) or lo(x));
  end;
  if ATI_Mach then modinx(card.IOadr,$AE,$F,(bank shr 4)*5);
end;

procedure setbank_ati(bank : word);
var
  x : word;
begin
  if bank <> lastbank then begin
    if ATI_Mach then modinx(card.IOadr,$AE,$F,(bank shr 4)*5);
    if card.chipnum = ATI_18800 then modinx(card.IOadr,$B2,$1E,bank shl 1)
    else begin
      x:=(bank and 15)*$22;          {Roll bank nbr into bit 0}
      wrinx(card.IOadr,$B2,hi(x) or lo(x));
    end;
    if ATI_Mach then modinx(card.IOadr,$AE,$F,(bank shr 4)*5);
    lastbank := bank;
  end;
end;

procedure decbank_ati;
var
  x : word;
begin
  asm pusha end;
  dec(lastbank);
  if ATI_Mach then modinx(card.IOadr,$AE,$F,(lastbank shr 4)*5);
  if card.chipnum = ATI_18800 then modinx(card.IOadr,$B2,$1E,lastbank shl 1)
  else begin
    x:=(lastbank and 15)*$22;          {Roll bank nbr into bit 0}
    wrinx(card.IOadr,$B2,hi(x) or lo(x));
  end;
  if ATI_Mach then modinx(card.IOadr,$AE,$F,(lastbank shr 4)*5);
  asm popa end;
end;

procedure incbank_ati;
var
  x : word;
begin
  asm pusha end;
  inc(lastbank);
  if ATI_Mach then modinx(card.IOadr,$AE,$F,(lastbank shr 4)*5);
  if card.chipnum = ATI_18800 then modinx(card.IOadr,$B2,$1E,lastbank shl 1)
  else begin
    x:=(lastbank and 15)*$22;          {Roll bank nbr into bit 0}
    wrinx(card.IOadr,$B2,hi(x) or lo(x));
  end;
  if ATI_Mach then modinx(card.IOadr,$AE,$F,(lastbank shr 4)*5);
  asm popa end;
end;

function getbios(offs,lnn:word) : string;
var
  s : string;
begin
  s[0] := chr(lnn);
  move(ptr(getrmselector($C000),offs)^,s[1],lnn);
  getbios := s;
end;

procedure enableext_ati;
begin
(*  if card.chipnum > $31 then setinx(card.ioadr,$BE,8);    {enable RWbanks}
  if card.chipnum >= $34 then setinx(card.ioadr,$B6,1);    {enable display >256K}
  if card.chipnum >= $31 then
  clrinx(card.ioadr,$B3,$10);  {enable display >256K}*)
{                if cv.version>=ATI_M64_GX then
                begin
                  setinx(cv.IOadr,$B0,8);
                  clrreg($6AEC,7);
                end;}
		if card.chipnum >= ATI_28800_4 then
		  setinx(card.IOadr,$B6,1);    {enable display >256K}
                if card.chipnum >= ATI_18800_1 then
                  clrinx(card.IOadr,$B3,$10);  {enable display >256K}
		if card.chipnum > ATI_18800 then
		  setinx(card.IOAdr,$BE,8);    {enable RWbanks}

end;

function detect_ati : boolean;
var
  found : boolean;
function makestr(w : longint) : String;
{convert integer to string}
var
  c : string[5];
begin
  str(w,c);
  makestr := c;
end;

begin
  detect_ati := true;
  ATI_Mach   := false;
  ATI_Mach64 := false;
  if (getbios($31,9)='761295520') then
  begin
    card.ioadr := memw[getrmselector($C000):$10];
    card.chipnum := mem[getrmselector($C000):$43];
    card.speedups.banking := true;
    case card.chipnum of
      $31 : card.chipname := 'V3 18800';
      $32 : card.chipname := 'V4/V5 18800';
  $33,$34 : card.chipname := 'VGA Wonder 28800';
  $35,$36 : card.chipname := 'VGA Wonder XL 28800';
 $61..$63 : begin;card.chipname:='Mach 32';ATI_Mach:=true;end;
 $20..$4F : begin;card.chipname := 'Mach 64';ATI_Mach:=true;ATI_Mach64:=true;end;
      else  begin
        card.chipname := 'unknown (ID='+makestr(lo(card.chipnum))+')';
        card.speedups.banking := false;
      end;
    end;
  end else detect_ati := false;
end;


end.